/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFileSystemPolicyRequest extends EfsRequest implements
        ToCopyableBuilder<PutFileSystemPolicyRequest.Builder, PutFileSystemPolicyRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(PutFileSystemPolicyRequest::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileSystemId").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(PutFileSystemPolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<Boolean> BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BypassPolicyLockoutSafetyCheck")
            .getter(getter(PutFileSystemPolicyRequest::bypassPolicyLockoutSafetyCheck))
            .setter(setter(Builder::bypassPolicyLockoutSafetyCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassPolicyLockoutSafetyCheck")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            POLICY_FIELD, BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD));

    private final String fileSystemId;

    private final String policy;

    private final Boolean bypassPolicyLockoutSafetyCheck;

    private PutFileSystemPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.policy = builder.policy;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
    }

    /**
     * <p>
     * The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.
     * </p>
     * 
     * @return The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition. EFS file
     * system policies have a 20,000 character limit. To find out more about the elements that make up a file system
     * policy, see <a href=
     * "https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies"
     * >EFS Resource-based Policies</a>.
     * </p>
     * 
     * @return The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition. EFS
     *         file system policies have a 20,000 character limit. To find out more about the elements that make up a
     *         file system policy, see <a href=
     *         "https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies"
     *         >EFS Resource-based Policies</a>.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * (Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The
     * policy lockout safety check determines whether the policy in the request will prevent the principal making the
     * request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system. Set
     * <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the principal
     * that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system.
     * The default value is False.
     * </p>
     * 
     * @return (Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check.
     *         The policy lockout safety check determines whether the policy in the request will prevent the principal
     *         making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the
     *         file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to
     *         prevent the principal that is making the request from making a subsequent
     *         <code>PutFileSystemPolicy</code> request on the file system. The default value is False.
     */
    public final Boolean bypassPolicyLockoutSafetyCheck() {
        return bypassPolicyLockoutSafetyCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(bypassPolicyLockoutSafetyCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFileSystemPolicyRequest)) {
            return false;
        }
        PutFileSystemPolicyRequest other = (PutFileSystemPolicyRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(policy(), other.policy())
                && Objects.equals(bypassPolicyLockoutSafetyCheck(), other.bypassPolicyLockoutSafetyCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFileSystemPolicyRequest").add("FileSystemId", fileSystemId()).add("Policy", policy())
                .add("BypassPolicyLockoutSafetyCheck", bypassPolicyLockoutSafetyCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "BypassPolicyLockoutSafetyCheck":
            return Optional.ofNullable(clazz.cast(bypassPolicyLockoutSafetyCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFileSystemPolicyRequest, T> g) {
        return obj -> g.apply((PutFileSystemPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutFileSystemPolicyRequest> {
        /**
         * <p>
         * The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition. EFS file
         * system policies have a 20,000 character limit. To find out more about the elements that make up a file system
         * policy, see <a href=
         * "https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies"
         * >EFS Resource-based Policies</a>.
         * </p>
         * 
         * @param policy
         *        The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition.
         *        EFS file system policies have a 20,000 character limit. To find out more about the elements that make
         *        up a file system policy, see <a href=
         *        "https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies"
         *        >EFS Resource-based Policies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * (Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The
         * policy lockout safety check determines whether the policy in the request will prevent the principal making
         * the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file
         * system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent
         * the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on
         * the file system. The default value is False.
         * </p>
         * 
         * @param bypassPolicyLockoutSafetyCheck
         *        (Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety
         *        check. The policy lockout safety check determines whether the policy in the request will prevent the
         *        principal making the request will be locked out from making future <code>PutFileSystemPolicy</code>
         *        requests on the file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only
         *        when you intend to prevent the principal that is making the request from making a subsequent
         *        <code>PutFileSystemPolicy</code> request on the file system. The default value is False.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private String fileSystemId;

        private String policy;

        private Boolean bypassPolicyLockoutSafetyCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFileSystemPolicyRequest model) {
            super(model);
            fileSystemId(model.fileSystemId);
            policy(model.policy);
            bypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFileSystemPolicyRequest build() {
            return new PutFileSystemPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
