/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Required if the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist. Specifies the POSIX IDs
 * and permissions to apply to the access point's <code>RootDirectory</code> &gt; <code>Path</code>. If the access point
 * root directory does not exist, EFS creates it with these settings when a client connects to the access point. When
 * specifying <code>CreationInfo</code>, you must include values for all properties.
 * </p>
 * <p>
 * Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions for
 * the directory. If you do not provide this information, Amazon EFS does not create the root directory. If the root
 * directory does not exist, attempts to mount using the access point will fail.
 * </p>
 * <important>
 * <p>
 * If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> does not exist, attempts
 * to mount the file system using the access point will fail.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreationInfo implements SdkPojo, Serializable, ToCopyableBuilder<CreationInfo.Builder, CreationInfo> {
    private static final SdkField<Long> OWNER_UID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("OwnerUid")
            .getter(getter(CreationInfo::ownerUid)).setter(setter(Builder::ownerUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerUid").build()).build();

    private static final SdkField<Long> OWNER_GID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("OwnerGid")
            .getter(getter(CreationInfo::ownerGid)).setter(setter(Builder::ownerGid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerGid").build()).build();

    private static final SdkField<String> PERMISSIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Permissions").getter(getter(CreationInfo::permissions)).setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_UID_FIELD,
            OWNER_GID_FIELD, PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long ownerUid;

    private final Long ownerGid;

    private final String permissions;

    private CreationInfo(BuilderImpl builder) {
        this.ownerUid = builder.ownerUid;
        this.ownerGid = builder.ownerGid;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * Specifies the POSIX user ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32
     * (4294967295).
     * </p>
     * 
     * @return Specifies the POSIX user ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32
     *         (4294967295).
     */
    public final Long ownerUid() {
        return ownerUid;
    }

    /**
     * <p>
     * Specifies the POSIX group ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32
     * (4294967295).
     * </p>
     * 
     * @return Specifies the POSIX group ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32
     *         (4294967295).
     */
    public final Long ownerGid() {
        return ownerGid;
    }

    /**
     * <p>
     * Specifies the POSIX permissions to apply to the <code>RootDirectory</code>, in the format of an octal number
     * representing the file's mode bits.
     * </p>
     * 
     * @return Specifies the POSIX permissions to apply to the <code>RootDirectory</code>, in the format of an octal
     *         number representing the file's mode bits.
     */
    public final String permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerUid());
        hashCode = 31 * hashCode + Objects.hashCode(ownerGid());
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreationInfo)) {
            return false;
        }
        CreationInfo other = (CreationInfo) obj;
        return Objects.equals(ownerUid(), other.ownerUid()) && Objects.equals(ownerGid(), other.ownerGid())
                && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreationInfo").add("OwnerUid", ownerUid()).add("OwnerGid", ownerGid())
                .add("Permissions", permissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerUid":
            return Optional.ofNullable(clazz.cast(ownerUid()));
        case "OwnerGid":
            return Optional.ofNullable(clazz.cast(ownerGid()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreationInfo, T> g) {
        return obj -> g.apply((CreationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreationInfo> {
        /**
         * <p>
         * Specifies the POSIX user ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32
         * (4294967295).
         * </p>
         * 
         * @param ownerUid
         *        Specifies the POSIX user ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32
         *        (4294967295).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerUid(Long ownerUid);

        /**
         * <p>
         * Specifies the POSIX group ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32
         * (4294967295).
         * </p>
         * 
         * @param ownerGid
         *        Specifies the POSIX group ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32
         *        (4294967295).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerGid(Long ownerGid);

        /**
         * <p>
         * Specifies the POSIX permissions to apply to the <code>RootDirectory</code>, in the format of an octal number
         * representing the file's mode bits.
         * </p>
         * 
         * @param permissions
         *        Specifies the POSIX permissions to apply to the <code>RootDirectory</code>, in the format of an octal
         *        number representing the file's mode bits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(String permissions);
    }

    static final class BuilderImpl implements Builder {
        private Long ownerUid;

        private Long ownerGid;

        private String permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreationInfo model) {
            ownerUid(model.ownerUid);
            ownerGid(model.ownerGid);
            permissions(model.permissions);
        }

        public final Long getOwnerUid() {
            return ownerUid;
        }

        @Override
        public final Builder ownerUid(Long ownerUid) {
            this.ownerUid = ownerUid;
            return this;
        }

        public final void setOwnerUid(Long ownerUid) {
            this.ownerUid = ownerUid;
        }

        public final Long getOwnerGid() {
            return ownerGid;
        }

        @Override
        public final Builder ownerGid(Long ownerGid) {
            this.ownerGid = ownerGid;
            return this;
        }

        public final void setOwnerGid(Long ownerGid) {
            this.ownerGid = ownerGid;
        }

        public final String getPermissions() {
            return permissions;
        }

        @Override
        public final Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        public final void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        @Override
        public CreationInfo build() {
            return new CreationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
