/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountPreferencesRequest extends EfsRequest implements
        ToCopyableBuilder<PutAccountPreferencesRequest.Builder, PutAccountPreferencesRequest> {
    private static final SdkField<String> RESOURCE_ID_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdType").getter(getter(PutAccountPreferencesRequest::resourceIdTypeAsString))
            .setter(setter(Builder::resourceIdType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_TYPE_FIELD));

    private final String resourceIdType;

    private PutAccountPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdType = builder.resourceIdType;
    }

    /**
     * <p>
     * Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon
     * Web Services Region, either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).
     * </p>
     * <note>
     * <p>
     * Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>
     * . Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount
     * target resources.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceIdType}
     * will return {@link ResourceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceIdTypeAsString}.
     * </p>
     * 
     * @return Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the
     *         current Amazon Web Services Region, either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code>
     *         (8 characters).</p> <note>
     *         <p>
     *         Starting in October, 2021, you will receive an error when setting the account preference to
     *         <code>SHORT_ID</code>. Contact Amazon Web Services support if you receive an error and need to use short
     *         IDs for file system and mount target resources.
     *         </p>
     * @see ResourceIdType
     */
    public final ResourceIdType resourceIdType() {
        return ResourceIdType.fromValue(resourceIdType);
    }

    /**
     * <p>
     * Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon
     * Web Services Region, either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).
     * </p>
     * <note>
     * <p>
     * Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>
     * . Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount
     * target resources.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceIdType}
     * will return {@link ResourceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceIdTypeAsString}.
     * </p>
     * 
     * @return Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the
     *         current Amazon Web Services Region, either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code>
     *         (8 characters).</p> <note>
     *         <p>
     *         Starting in October, 2021, you will receive an error when setting the account preference to
     *         <code>SHORT_ID</code>. Contact Amazon Web Services support if you receive an error and need to use short
     *         IDs for file system and mount target resources.
     *         </p>
     * @see ResourceIdType
     */
    public final String resourceIdTypeAsString() {
        return resourceIdType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountPreferencesRequest)) {
            return false;
        }
        PutAccountPreferencesRequest other = (PutAccountPreferencesRequest) obj;
        return Objects.equals(resourceIdTypeAsString(), other.resourceIdTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccountPreferencesRequest").add("ResourceIdType", resourceIdTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdType":
            return Optional.ofNullable(clazz.cast(resourceIdTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountPreferencesRequest, T> g) {
        return obj -> g.apply((PutAccountPreferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountPreferencesRequest> {
        /**
         * <p>
         * Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current
         * Amazon Web Services Region, either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8
         * characters).
         * </p>
         * <note>
         * <p>
         * Starting in October, 2021, you will receive an error when setting the account preference to
         * <code>SHORT_ID</code>. Contact Amazon Web Services support if you receive an error and need to use short IDs
         * for file system and mount target resources.
         * </p>
         * </note>
         * 
         * @param resourceIdType
         *        Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the
         *        current Amazon Web Services Region, either <code>LONG_ID</code> (17 characters), or
         *        <code>SHORT_ID</code> (8 characters).</p> <note>
         *        <p>
         *        Starting in October, 2021, you will receive an error when setting the account preference to
         *        <code>SHORT_ID</code>. Contact Amazon Web Services support if you receive an error and need to use
         *        short IDs for file system and mount target resources.
         *        </p>
         * @see ResourceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceIdType
         */
        Builder resourceIdType(String resourceIdType);

        /**
         * <p>
         * Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current
         * Amazon Web Services Region, either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8
         * characters).
         * </p>
         * <note>
         * <p>
         * Starting in October, 2021, you will receive an error when setting the account preference to
         * <code>SHORT_ID</code>. Contact Amazon Web Services support if you receive an error and need to use short IDs
         * for file system and mount target resources.
         * </p>
         * </note>
         * 
         * @param resourceIdType
         *        Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the
         *        current Amazon Web Services Region, either <code>LONG_ID</code> (17 characters), or
         *        <code>SHORT_ID</code> (8 characters).</p> <note>
         *        <p>
         *        Starting in October, 2021, you will receive an error when setting the account preference to
         *        <code>SHORT_ID</code>. Contact Amazon Web Services support if you receive an error and need to use
         *        short IDs for file system and mount target resources.
         *        </p>
         * @see ResourceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceIdType
         */
        Builder resourceIdType(ResourceIdType resourceIdType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private String resourceIdType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountPreferencesRequest model) {
            super(model);
            resourceIdType(model.resourceIdType);
        }

        public final String getResourceIdType() {
            return resourceIdType;
        }

        public final void setResourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
        }

        @Override
        @Transient
        public final Builder resourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceIdType(ResourceIdType resourceIdType) {
            this.resourceIdType(resourceIdType == null ? null : resourceIdType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountPreferencesRequest build() {
            return new PutAccountPreferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
