/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceIdPreference implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceIdPreference.Builder, ResourceIdPreference> {
    private static final SdkField<String> RESOURCE_ID_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdType").getter(getter(ResourceIdPreference::resourceIdTypeAsString))
            .setter(setter(Builder::resourceIdType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdType").build()).build();

    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(ResourceIdPreference::resourcesAsStrings))
            .setter(setter(Builder::resourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_TYPE_FIELD,
            RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceIdType;

    private final List<String> resources;

    private ResourceIdPreference(BuilderImpl builder) {
        this.resourceIdType = builder.resourceIdType;
        this.resources = builder.resources;
    }

    /**
     * Returns the value of the ResourceIdType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceIdType}
     * will return {@link ResourceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceIdTypeAsString}.
     * </p>
     * 
     * @return The value of the ResourceIdType property for this object.
     * @see ResourceIdType
     */
    public final ResourceIdType resourceIdType() {
        return ResourceIdType.fromValue(resourceIdType);
    }

    /**
     * Returns the value of the ResourceIdType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceIdType}
     * will return {@link ResourceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceIdTypeAsString}.
     * </p>
     * 
     * @return The value of the ResourceIdType property for this object.
     * @see ResourceIdType
     */
    public final String resourceIdTypeAsString() {
        return resourceIdType;
    }

    /**
     * Returns the value of the Resources property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Resources property for this object.
     */
    public final List<Resource> resources() {
        return ResourcesCopier.copyStringToEnum(resources);
    }

    /**
     * Returns true if the Resources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Resources property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Resources property for this object.
     */
    public final List<String> resourcesAsStrings() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resourcesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdPreference)) {
            return false;
        }
        ResourceIdPreference other = (ResourceIdPreference) obj;
        return Objects.equals(resourceIdTypeAsString(), other.resourceIdTypeAsString()) && hasResources() == other.hasResources()
                && Objects.equals(resourcesAsStrings(), other.resourcesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceIdPreference").add("ResourceIdType", resourceIdTypeAsString())
                .add("Resources", hasResources() ? resourcesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdType":
            return Optional.ofNullable(clazz.cast(resourceIdTypeAsString()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resourcesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdPreference, T> g) {
        return obj -> g.apply((ResourceIdPreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceIdPreference> {
        /**
         * Sets the value of the ResourceIdType property for this object.
         *
         * @param resourceIdType
         *        The new value for the ResourceIdType property for this object.
         * @see ResourceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceIdType
         */
        Builder resourceIdType(String resourceIdType);

        /**
         * Sets the value of the ResourceIdType property for this object.
         *
         * @param resourceIdType
         *        The new value for the ResourceIdType property for this object.
         * @see ResourceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceIdType
         */
        Builder resourceIdType(ResourceIdType resourceIdType);

        /**
         * Sets the value of the Resources property for this object.
         *
         * @param resources
         *        The new value for the Resources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesWithStrings(Collection<String> resources);

        /**
         * Sets the value of the Resources property for this object.
         *
         * @param resources
         *        The new value for the Resources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesWithStrings(String... resources);

        /**
         * Sets the value of the Resources property for this object.
         *
         * @param resources
         *        The new value for the Resources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * Sets the value of the Resources property for this object.
         *
         * @param resources
         *        The new value for the Resources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);
    }

    static final class BuilderImpl implements Builder {
        private String resourceIdType;

        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdPreference model) {
            resourceIdType(model.resourceIdType);
            resourcesWithStrings(model.resources);
        }

        public final String getResourceIdType() {
            return resourceIdType;
        }

        public final void setResourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
        }

        @Override
        @Transient
        public final Builder resourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceIdType(ResourceIdType resourceIdType) {
            this.resourceIdType(resourceIdType == null ? null : resourceIdType.toString());
            return this;
        }

        public final Collection<String> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
        }

        @Override
        @Transient
        public final Builder resourcesWithStrings(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourcesWithStrings(String... resources) {
            resourcesWithStrings(Arrays.asList(resources));
            return this;
        }

        @Override
        @Transient
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourcesCopier.copyEnumToString(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        public ResourceIdPreference build() {
            return new ResourceIdPreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
