/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the destination file system in the replication configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Destination implements SdkPojo, Serializable, ToCopyableBuilder<Destination.Builder, Destination> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Destination::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(Destination::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Destination::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<Instant> LAST_REPLICATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastReplicatedTimestamp").getter(getter(Destination::lastReplicatedTimestamp))
            .setter(setter(Builder::lastReplicatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastReplicatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            FILE_SYSTEM_ID_FIELD, REGION_FIELD, LAST_REPLICATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String fileSystemId;

    private final String region;

    private final Instant lastReplicatedTimestamp;

    private Destination(BuilderImpl builder) {
        this.status = builder.status;
        this.fileSystemId = builder.fileSystemId;
        this.region = builder.region;
        this.lastReplicatedTimestamp = builder.lastReplicatedTimestamp;
    }

    /**
     * <p>
     * Describes the status of the destination Amazon EFS file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes the status of the destination Amazon EFS file system.
     * @see ReplicationStatus
     */
    public final ReplicationStatus status() {
        return ReplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * Describes the status of the destination Amazon EFS file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes the status of the destination Amazon EFS file system.
     * @see ReplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the destination Amazon EFS file system.
     * </p>
     * 
     * @return The ID of the destination Amazon EFS file system.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which the destination file system is located.
     * </p>
     * 
     * @return The Amazon Web Services Region in which the destination file system is located.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The time when the most recent sync successfully completed on the destination file system. Any changes to data on
     * the source file system that occurred prior to this time were successfully replicated to the destination file
     * system. Any changes that occurred after this time might not be fully replicated.
     * </p>
     * 
     * @return The time when the most recent sync successfully completed on the destination file system. Any changes to
     *         data on the source file system that occurred prior to this time were successfully replicated to the
     *         destination file system. Any changes that occurred after this time might not be fully replicated.
     */
    public final Instant lastReplicatedTimestamp() {
        return lastReplicatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(lastReplicatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(region(), other.region())
                && Objects.equals(lastReplicatedTimestamp(), other.lastReplicatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Destination").add("Status", statusAsString()).add("FileSystemId", fileSystemId())
                .add("Region", region()).add("LastReplicatedTimestamp", lastReplicatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "LastReplicatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastReplicatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * Describes the status of the destination Amazon EFS file system.
         * </p>
         * 
         * @param status
         *        Describes the status of the destination Amazon EFS file system.
         * @see ReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Describes the status of the destination Amazon EFS file system.
         * </p>
         * 
         * @param status
         *        Describes the status of the destination Amazon EFS file system.
         * @see ReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationStatus
         */
        Builder status(ReplicationStatus status);

        /**
         * <p>
         * The ID of the destination Amazon EFS file system.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the destination Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The Amazon Web Services Region in which the destination file system is located.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region in which the destination file system is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The time when the most recent sync successfully completed on the destination file system. Any changes to data
         * on the source file system that occurred prior to this time were successfully replicated to the destination
         * file system. Any changes that occurred after this time might not be fully replicated.
         * </p>
         * 
         * @param lastReplicatedTimestamp
         *        The time when the most recent sync successfully completed on the destination file system. Any changes
         *        to data on the source file system that occurred prior to this time were successfully replicated to the
         *        destination file system. Any changes that occurred after this time might not be fully replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastReplicatedTimestamp(Instant lastReplicatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String fileSystemId;

        private String region;

        private Instant lastReplicatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            status(model.status);
            fileSystemId(model.fileSystemId);
            region(model.region);
            lastReplicatedTimestamp(model.lastReplicatedTimestamp);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ReplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Instant getLastReplicatedTimestamp() {
            return lastReplicatedTimestamp;
        }

        public final void setLastReplicatedTimestamp(Instant lastReplicatedTimestamp) {
            this.lastReplicatedTimestamp = lastReplicatedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastReplicatedTimestamp(Instant lastReplicatedTimestamp) {
            this.lastReplicatedTimestamp = lastReplicatedTimestamp;
            return this;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
