/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a description of an EFS file system access point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessPointResponse extends EfsResponse implements
        ToCopyableBuilder<CreateAccessPointResponse.Builder, CreateAccessPointResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateAccessPointResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateAccessPointResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAccessPointResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPointId").getter(getter(CreateAccessPointResponse::accessPointId))
            .setter(setter(Builder::accessPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointId").build()).build();

    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPointArn").getter(getter(CreateAccessPointResponse::accessPointArn))
            .setter(setter(Builder::accessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(CreateAccessPointResponse::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<PosixUser> POSIX_USER_FIELD = SdkField.<PosixUser> builder(MarshallingType.SDK_POJO)
            .memberName("PosixUser").getter(getter(CreateAccessPointResponse::posixUser)).setter(setter(Builder::posixUser))
            .constructor(PosixUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixUser").build()).build();

    private static final SdkField<RootDirectory> ROOT_DIRECTORY_FIELD = SdkField
            .<RootDirectory> builder(MarshallingType.SDK_POJO).memberName("RootDirectory")
            .getter(getter(CreateAccessPointResponse::rootDirectory)).setter(setter(Builder::rootDirectory))
            .constructor(RootDirectory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDirectory").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(CreateAccessPointResponse::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifeCycleState").getter(getter(CreateAccessPointResponse::lifeCycleStateAsString))
            .setter(setter(Builder::lifeCycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NAME_FIELD, TAGS_FIELD, ACCESS_POINT_ID_FIELD, ACCESS_POINT_ARN_FIELD, FILE_SYSTEM_ID_FIELD, POSIX_USER_FIELD,
            ROOT_DIRECTORY_FIELD, OWNER_ID_FIELD, LIFE_CYCLE_STATE_FIELD));

    private final String clientToken;

    private final String name;

    private final List<Tag> tags;

    private final String accessPointId;

    private final String accessPointArn;

    private final String fileSystemId;

    private final PosixUser posixUser;

    private final RootDirectory rootDirectory;

    private final String ownerId;

    private final String lifeCycleState;

    private CreateAccessPointResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.tags = builder.tags;
        this.accessPointId = builder.accessPointId;
        this.accessPointArn = builder.accessPointArn;
        this.fileSystemId = builder.fileSystemId;
        this.posixUser = builder.posixUser;
        this.rootDirectory = builder.rootDirectory;
        this.ownerId = builder.ownerId;
        this.lifeCycleState = builder.lifeCycleState;
    }

    /**
     * <p>
     * The opaque string specified in the request to ensure idempotent creation.
     * </p>
     * 
     * @return The opaque string specified in the request to ensure idempotent creation.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the access point. This is the value of the <code>Name</code> tag.
     * </p>
     * 
     * @return The name of the access point. This is the value of the <code>Name</code> tag.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the access point, presented as an array of Tag objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the access point, presented as an array of Tag objects.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the access point, assigned by Amazon EFS.
     * </p>
     * 
     * @return The ID of the access point, assigned by Amazon EFS.
     */
    public final String accessPointId() {
        return accessPointId;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) associated with the access point.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) associated with the access point.
     */
    public final String accessPointArn() {
        return accessPointArn;
    }

    /**
     * <p>
     * The ID of the EFS file system that the access point applies to.
     * </p>
     * 
     * @return The ID of the EFS file system that the access point applies to.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is
     * used for all file operations by NFS clients using the access point.
     * </p>
     * 
     * @return The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point
     *         that is used for all file operations by NFS clients using the access point.
     */
    public final PosixUser posixUser() {
        return posixUser;
    }

    /**
     * <p>
     * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients
     * using the access point.
     * </p>
     * 
     * @return The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS
     *         clients using the access point.
     */
    public final RootDirectory rootDirectory() {
        return rootDirectory;
    }

    /**
     * <p>
     * Identified the Amazon Web Services account that owns the access point resource.
     * </p>
     * 
     * @return Identified the Amazon Web Services account that owns the access point resource.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Identifies the lifecycle phase of the access point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return Identifies the lifecycle phase of the access point.
     * @see LifeCycleState
     */
    public final LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(lifeCycleState);
    }

    /**
     * <p>
     * Identifies the lifecycle phase of the access point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return Identifies the lifecycle phase of the access point.
     * @see LifeCycleState
     */
    public final String lifeCycleStateAsString() {
        return lifeCycleState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accessPointId());
        hashCode = 31 * hashCode + Objects.hashCode(accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(posixUser());
        hashCode = 31 * hashCode + Objects.hashCode(rootDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPointResponse)) {
            return false;
        }
        CreateAccessPointResponse other = (CreateAccessPointResponse) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(accessPointId(), other.accessPointId())
                && Objects.equals(accessPointArn(), other.accessPointArn())
                && Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(posixUser(), other.posixUser())
                && Objects.equals(rootDirectory(), other.rootDirectory()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(lifeCycleStateAsString(), other.lifeCycleStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessPointResponse").add("ClientToken", clientToken()).add("Name", name())
                .add("Tags", hasTags() ? tags() : null).add("AccessPointId", accessPointId())
                .add("AccessPointArn", accessPointArn()).add("FileSystemId", fileSystemId()).add("PosixUser", posixUser())
                .add("RootDirectory", rootDirectory()).add("OwnerId", ownerId()).add("LifeCycleState", lifeCycleStateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AccessPointId":
            return Optional.ofNullable(clazz.cast(accessPointId()));
        case "AccessPointArn":
            return Optional.ofNullable(clazz.cast(accessPointArn()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "PosixUser":
            return Optional.ofNullable(clazz.cast(posixUser()));
        case "RootDirectory":
            return Optional.ofNullable(clazz.cast(rootDirectory()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "LifeCycleState":
            return Optional.ofNullable(clazz.cast(lifeCycleStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPointResponse, T> g) {
        return obj -> g.apply((CreateAccessPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessPointResponse> {
        /**
         * <p>
         * The opaque string specified in the request to ensure idempotent creation.
         * </p>
         * 
         * @param clientToken
         *        The opaque string specified in the request to ensure idempotent creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the access point. This is the value of the <code>Name</code> tag.
         * </p>
         * 
         * @param name
         *        The name of the access point. This is the value of the <code>Name</code> tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The tags associated with the access point, presented as an array of Tag objects.
         * </p>
         * 
         * @param tags
         *        The tags associated with the access point, presented as an array of Tag objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the access point, presented as an array of Tag objects.
         * </p>
         * 
         * @param tags
         *        The tags associated with the access point, presented as an array of Tag objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the access point, presented as an array of Tag objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the access point, assigned by Amazon EFS.
         * </p>
         * 
         * @param accessPointId
         *        The ID of the access point, assigned by Amazon EFS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointId(String accessPointId);

        /**
         * <p>
         * The unique Amazon Resource Name (ARN) associated with the access point.
         * </p>
         * 
         * @param accessPointArn
         *        The unique Amazon Resource Name (ARN) associated with the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointArn(String accessPointArn);

        /**
         * <p>
         * The ID of the EFS file system that the access point applies to.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the EFS file system that the access point applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is
         * used for all file operations by NFS clients using the access point.
         * </p>
         * 
         * @param posixUser
         *        The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point
         *        that is used for all file operations by NFS clients using the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder posixUser(PosixUser posixUser);

        /**
         * <p>
         * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is
         * used for all file operations by NFS clients using the access point.
         * </p>
         * This is a convenience that creates an instance of the {@link PosixUser.Builder} avoiding the need to create
         * one manually via {@link PosixUser#builder()}.
         *
         * When the {@link Consumer} completes, {@link PosixUser.Builder#build()} is called immediately and its result
         * is passed to {@link #posixUser(PosixUser)}.
         * 
         * @param posixUser
         *        a consumer that will call methods on {@link PosixUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #posixUser(PosixUser)
         */
        default Builder posixUser(Consumer<PosixUser.Builder> posixUser) {
            return posixUser(PosixUser.builder().applyMutation(posixUser).build());
        }

        /**
         * <p>
         * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS
         * clients using the access point.
         * </p>
         * 
         * @param rootDirectory
         *        The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS
         *        clients using the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDirectory(RootDirectory rootDirectory);

        /**
         * <p>
         * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS
         * clients using the access point.
         * </p>
         * This is a convenience that creates an instance of the {@link RootDirectory.Builder} avoiding the need to
         * create one manually via {@link RootDirectory#builder()}.
         *
         * When the {@link Consumer} completes, {@link RootDirectory.Builder#build()} is called immediately and its
         * result is passed to {@link #rootDirectory(RootDirectory)}.
         * 
         * @param rootDirectory
         *        a consumer that will call methods on {@link RootDirectory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootDirectory(RootDirectory)
         */
        default Builder rootDirectory(Consumer<RootDirectory.Builder> rootDirectory) {
            return rootDirectory(RootDirectory.builder().applyMutation(rootDirectory).build());
        }

        /**
         * <p>
         * Identified the Amazon Web Services account that owns the access point resource.
         * </p>
         * 
         * @param ownerId
         *        Identified the Amazon Web Services account that owns the access point resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Identifies the lifecycle phase of the access point.
         * </p>
         * 
         * @param lifeCycleState
         *        Identifies the lifecycle phase of the access point.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(String lifeCycleState);

        /**
         * <p>
         * Identifies the lifecycle phase of the access point.
         * </p>
         * 
         * @param lifeCycleState
         *        Identifies the lifecycle phase of the access point.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(LifeCycleState lifeCycleState);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private String clientToken;

        private String name;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String accessPointId;

        private String accessPointArn;

        private String fileSystemId;

        private PosixUser posixUser;

        private RootDirectory rootDirectory;

        private String ownerId;

        private String lifeCycleState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPointResponse model) {
            super(model);
            clientToken(model.clientToken);
            name(model.name);
            tags(model.tags);
            accessPointId(model.accessPointId);
            accessPointArn(model.accessPointArn);
            fileSystemId(model.fileSystemId);
            posixUser(model.posixUser);
            rootDirectory(model.rootDirectory);
            ownerId(model.ownerId);
            lifeCycleState(model.lifeCycleState);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAccessPointId() {
            return accessPointId;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        @Override
        @Transient
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final String getAccessPointArn() {
            return accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        @Transient
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final PosixUser.Builder getPosixUser() {
            return posixUser != null ? posixUser.toBuilder() : null;
        }

        public final void setPosixUser(PosixUser.BuilderImpl posixUser) {
            this.posixUser = posixUser != null ? posixUser.build() : null;
        }

        @Override
        @Transient
        public final Builder posixUser(PosixUser posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        public final RootDirectory.Builder getRootDirectory() {
            return rootDirectory != null ? rootDirectory.toBuilder() : null;
        }

        public final void setRootDirectory(RootDirectory.BuilderImpl rootDirectory) {
            this.rootDirectory = rootDirectory != null ? rootDirectory.build() : null;
        }

        @Override
        @Transient
        public final Builder rootDirectory(RootDirectory rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getLifeCycleState() {
            return lifeCycleState;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        @Override
        @Transient
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        @Transient
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        @Override
        public CreateAccessPointResponse build() {
            return new CreateAccessPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
