/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteReplicationConfigurationRequest extends EfsRequest implements
        ToCopyableBuilder<DeleteReplicationConfigurationRequest.Builder, DeleteReplicationConfigurationRequest> {
    private static final SdkField<String> SOURCE_FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFileSystemId").getter(getter(DeleteReplicationConfigurationRequest::sourceFileSystemId))
            .setter(setter(Builder::sourceFileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SourceFileSystemId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FILE_SYSTEM_ID_FIELD));

    private final String sourceFileSystemId;

    private DeleteReplicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceFileSystemId = builder.sourceFileSystemId;
    }

    /**
     * <p>
     * The ID of the source file system in the replication configuration.
     * </p>
     * 
     * @return The ID of the source file system in the replication configuration.
     */
    public final String sourceFileSystemId() {
        return sourceFileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileSystemId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteReplicationConfigurationRequest)) {
            return false;
        }
        DeleteReplicationConfigurationRequest other = (DeleteReplicationConfigurationRequest) obj;
        return Objects.equals(sourceFileSystemId(), other.sourceFileSystemId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteReplicationConfigurationRequest").add("SourceFileSystemId", sourceFileSystemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceFileSystemId":
            return Optional.ofNullable(clazz.cast(sourceFileSystemId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteReplicationConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteReplicationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteReplicationConfigurationRequest> {
        /**
         * <p>
         * The ID of the source file system in the replication configuration.
         * </p>
         * 
         * @param sourceFileSystemId
         *        The ID of the source file system in the replication configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFileSystemId(String sourceFileSystemId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private String sourceFileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteReplicationConfigurationRequest model) {
            super(model);
            sourceFileSystemId(model.sourceFileSystemId);
        }

        public final String getSourceFileSystemId() {
            return sourceFileSystemId;
        }

        public final void setSourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
        }

        @Override
        @Transient
        public final Builder sourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteReplicationConfigurationRequest build() {
            return new DeleteReplicationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
