/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationConfigurationRequest extends EfsRequest implements
        ToCopyableBuilder<CreateReplicationConfigurationRequest.Builder, CreateReplicationConfigurationRequest> {
    private static final SdkField<String> SOURCE_FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFileSystemId").getter(getter(CreateReplicationConfigurationRequest::sourceFileSystemId))
            .setter(setter(Builder::sourceFileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SourceFileSystemId").build()).build();

    private static final SdkField<List<DestinationToCreate>> DESTINATIONS_FIELD = SdkField
            .<List<DestinationToCreate>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(CreateReplicationConfigurationRequest::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DestinationToCreate> builder(MarshallingType.SDK_POJO)
                                            .constructor(DestinationToCreate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FILE_SYSTEM_ID_FIELD,
            DESTINATIONS_FIELD));

    private final String sourceFileSystemId;

    private final List<DestinationToCreate> destinations;

    private CreateReplicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceFileSystemId = builder.sourceFileSystemId;
        this.destinations = builder.destinations;
    }

    /**
     * <p>
     * Specifies the Amazon EFS file system that you want to replicate. This file system cannot already be a source or
     * destination file system in another replication configuration.
     * </p>
     * 
     * @return Specifies the Amazon EFS file system that you want to replicate. This file system cannot already be a
     *         source or destination file system in another replication configuration.
     */
    public final String sourceFileSystemId() {
        return sourceFileSystemId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of destination configuration objects. Only one destination configuration object is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return An array of destination configuration objects. Only one destination configuration object is supported.
     */
    public final List<DestinationToCreate> destinations() {
        return destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationConfigurationRequest)) {
            return false;
        }
        CreateReplicationConfigurationRequest other = (CreateReplicationConfigurationRequest) obj;
        return Objects.equals(sourceFileSystemId(), other.sourceFileSystemId()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReplicationConfigurationRequest").add("SourceFileSystemId", sourceFileSystemId())
                .add("Destinations", hasDestinations() ? destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceFileSystemId":
            return Optional.ofNullable(clazz.cast(sourceFileSystemId()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationConfigurationRequest, T> g) {
        return obj -> g.apply((CreateReplicationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReplicationConfigurationRequest> {
        /**
         * <p>
         * Specifies the Amazon EFS file system that you want to replicate. This file system cannot already be a source
         * or destination file system in another replication configuration.
         * </p>
         * 
         * @param sourceFileSystemId
         *        Specifies the Amazon EFS file system that you want to replicate. This file system cannot already be a
         *        source or destination file system in another replication configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFileSystemId(String sourceFileSystemId);

        /**
         * <p>
         * An array of destination configuration objects. Only one destination configuration object is supported.
         * </p>
         * 
         * @param destinations
         *        An array of destination configuration objects. Only one destination configuration object is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<DestinationToCreate> destinations);

        /**
         * <p>
         * An array of destination configuration objects. Only one destination configuration object is supported.
         * </p>
         * 
         * @param destinations
         *        An array of destination configuration objects. Only one destination configuration object is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(DestinationToCreate... destinations);

        /**
         * <p>
         * An array of destination configuration objects. Only one destination configuration object is supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DestinationToCreate>.Builder} avoiding the
         * need to create one manually via {@link List<DestinationToCreate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DestinationToCreate>.Builder#build()} is called immediately
         * and its result is passed to {@link #destinations(List<DestinationToCreate>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on {@link List<DestinationToCreate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(List<DestinationToCreate>)
         */
        Builder destinations(Consumer<DestinationToCreate.Builder>... destinations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private String sourceFileSystemId;

        private List<DestinationToCreate> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationConfigurationRequest model) {
            super(model);
            sourceFileSystemId(model.sourceFileSystemId);
            destinations(model.destinations);
        }

        public final String getSourceFileSystemId() {
            return sourceFileSystemId;
        }

        public final void setSourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
        }

        @Override
        @Transient
        public final Builder sourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
            return this;
        }

        public final List<DestinationToCreate.Builder> getDestinations() {
            List<DestinationToCreate.Builder> result = DestinationsToCreateCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<DestinationToCreate.BuilderImpl> destinations) {
            this.destinations = DestinationsToCreateCopier.copyFromBuilder(destinations);
        }

        @Override
        @Transient
        public final Builder destinations(Collection<DestinationToCreate> destinations) {
            this.destinations = DestinationsToCreateCopier.copy(destinations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinations(DestinationToCreate... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinations(Consumer<DestinationToCreate.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> DestinationToCreate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationConfigurationRequest build() {
            return new CreateReplicationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
