/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the destination file system to create in the replication configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationToCreate implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationToCreate.Builder, DestinationToCreate> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(DestinationToCreate::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneName").getter(getter(DestinationToCreate::availabilityZoneName))
            .setter(setter(Builder::availabilityZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneName").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DestinationToCreate::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            AVAILABILITY_ZONE_NAME_FIELD, KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String availabilityZoneName;

    private final String kmsKeyId;

    private DestinationToCreate(BuilderImpl builder) {
        this.region = builder.region;
        this.availabilityZoneName = builder.availabilityZoneName;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * To create a file system that uses regional storage, specify the Amazon Web Services Region in which to create the
     * destination file system.
     * </p>
     * 
     * @return To create a file system that uses regional storage, specify the Amazon Web Services Region in which to
     *         create the destination file system.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * To create a file system that uses One Zone storage, specify the name of the Availability Zone in which to create
     * the destination file system.
     * </p>
     * 
     * @return To create a file system that uses One Zone storage, specify the name of the Availability Zone in which to
     *         create the destination file system.
     */
    public final String availabilityZoneName() {
        return availabilityZoneName;
    }

    /**
     * <p>
     * Specifies the KMS key you want to use to encrypt the destination file system. If you do not specify a KMS key,
     * EFS uses your default KMS key for Amazon EFS, <code>/aws/elasticfilesystem</code>. This ID can be in one of the
     * following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN - An Amazon Resource Name (ARN) for the key, for example
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias ARN - An ARN for a key alias, for example
     * <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the KMS key you want to use to encrypt the destination file system. If you do not specify a KMS
     *         key, EFS uses your default KMS key for Amazon EFS, <code>/aws/elasticfilesystem</code>. This ID can be in
     *         one of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN - An Amazon Resource Name (ARN) for the key, for example
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias ARN - An ARN for a key alias, for example
     *         <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
     *         </p>
     *         </li>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationToCreate)) {
            return false;
        }
        DestinationToCreate other = (DestinationToCreate) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(availabilityZoneName(), other.availabilityZoneName())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationToCreate").add("Region", region())
                .add("AvailabilityZoneName", availabilityZoneName()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "AvailabilityZoneName":
            return Optional.ofNullable(clazz.cast(availabilityZoneName()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationToCreate, T> g) {
        return obj -> g.apply((DestinationToCreate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationToCreate> {
        /**
         * <p>
         * To create a file system that uses regional storage, specify the Amazon Web Services Region in which to create
         * the destination file system.
         * </p>
         * 
         * @param region
         *        To create a file system that uses regional storage, specify the Amazon Web Services Region in which to
         *        create the destination file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * To create a file system that uses One Zone storage, specify the name of the Availability Zone in which to
         * create the destination file system.
         * </p>
         * 
         * @param availabilityZoneName
         *        To create a file system that uses One Zone storage, specify the name of the Availability Zone in which
         *        to create the destination file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneName(String availabilityZoneName);

        /**
         * <p>
         * Specifies the KMS key you want to use to encrypt the destination file system. If you do not specify a KMS
         * key, EFS uses your default KMS key for Amazon EFS, <code>/aws/elasticfilesystem</code>. This ID can be in one
         * of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN - An Amazon Resource Name (ARN) for the key, for example
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias ARN - An ARN for a key alias, for example
         * <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        Specifies the KMS key you want to use to encrypt the destination file system. If you do not specify a
         *        KMS key, EFS uses your default KMS key for Amazon EFS, <code>/aws/elasticfilesystem</code>. This ID
         *        can be in one of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN - An Amazon Resource Name (ARN) for the key, for example
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias ARN - An ARN for a key alias, for example
         *        <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String availabilityZoneName;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationToCreate model) {
            region(model.region);
            availabilityZoneName(model.availabilityZoneName);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAvailabilityZoneName() {
            return availabilityZoneName;
        }

        public final void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        @Override
        public final Builder availabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public DestinationToCreate build() {
            return new DestinationToCreate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
