/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountPreferencesResponse extends EfsResponse implements
        ToCopyableBuilder<DescribeAccountPreferencesResponse.Builder, DescribeAccountPreferencesResponse> {
    private static final SdkField<ResourceIdPreference> RESOURCE_ID_PREFERENCE_FIELD = SdkField
            .<ResourceIdPreference> builder(MarshallingType.SDK_POJO).memberName("ResourceIdPreference")
            .getter(getter(DescribeAccountPreferencesResponse::resourceIdPreference))
            .setter(setter(Builder::resourceIdPreference)).constructor(ResourceIdPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdPreference").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAccountPreferencesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_PREFERENCE_FIELD,
            NEXT_TOKEN_FIELD));

    private final ResourceIdPreference resourceIdPreference;

    private final String nextToken;

    private DescribeAccountPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdPreference = builder.resourceIdPreference;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the ResourceIdPreference property for this object.
     * 
     * @return The value of the ResourceIdPreference property for this object.
     */
    public final ResourceIdPreference resourceIdPreference() {
        return resourceIdPreference;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdPreference());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountPreferencesResponse)) {
            return false;
        }
        DescribeAccountPreferencesResponse other = (DescribeAccountPreferencesResponse) obj;
        return Objects.equals(resourceIdPreference(), other.resourceIdPreference())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountPreferencesResponse").add("ResourceIdPreference", resourceIdPreference())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdPreference":
            return Optional.ofNullable(clazz.cast(resourceIdPreference()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountPreferencesResponse, T> g) {
        return obj -> g.apply((DescribeAccountPreferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccountPreferencesResponse> {
        /**
         * Sets the value of the ResourceIdPreference property for this object.
         *
         * @param resourceIdPreference
         *        The new value for the ResourceIdPreference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdPreference(ResourceIdPreference resourceIdPreference);

        /**
         * Sets the value of the ResourceIdPreference property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceIdPreference.Builder} avoiding the need
         * to create one manually via {@link ResourceIdPreference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceIdPreference.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceIdPreference(ResourceIdPreference)}.
         * 
         * @param resourceIdPreference
         *        a consumer that will call methods on {@link ResourceIdPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdPreference(ResourceIdPreference)
         */
        default Builder resourceIdPreference(Consumer<ResourceIdPreference.Builder> resourceIdPreference) {
            return resourceIdPreference(ResourceIdPreference.builder().applyMutation(resourceIdPreference).build());
        }

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private ResourceIdPreference resourceIdPreference;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountPreferencesResponse model) {
            super(model);
            resourceIdPreference(model.resourceIdPreference);
            nextToken(model.nextToken);
        }

        public final ResourceIdPreference.Builder getResourceIdPreference() {
            return resourceIdPreference != null ? resourceIdPreference.toBuilder() : null;
        }

        public final void setResourceIdPreference(ResourceIdPreference.BuilderImpl resourceIdPreference) {
            this.resourceIdPreference = resourceIdPreference != null ? resourceIdPreference.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceIdPreference(ResourceIdPreference resourceIdPreference) {
            this.resourceIdPreference = resourceIdPreference;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAccountPreferencesResponse build() {
            return new DescribeAccountPreferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
