/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLifecycleConfigurationResponse extends EfsResponse implements
        ToCopyableBuilder<DescribeLifecycleConfigurationResponse.Builder, DescribeLifecycleConfigurationResponse> {
    private static final SdkField<List<LifecyclePolicy>> LIFECYCLE_POLICIES_FIELD = SdkField
            .<List<LifecyclePolicy>> builder(MarshallingType.LIST)
            .memberName("LifecyclePolicies")
            .getter(getter(DescribeLifecycleConfigurationResponse::lifecyclePolicies))
            .setter(setter(Builder::lifecyclePolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecyclePolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_POLICIES_FIELD));

    private final List<LifecyclePolicy> lifecyclePolicies;

    private DescribeLifecycleConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicies = builder.lifecyclePolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecyclePolicies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLifecyclePolicies() {
        return lifecyclePolicies != null && !(lifecyclePolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of lifecycle management policies. EFS supports a maximum of one policy per file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecyclePolicies} method.
     * </p>
     * 
     * @return An array of lifecycle management policies. EFS supports a maximum of one policy per file system.
     */
    public final List<LifecyclePolicy> lifecyclePolicies() {
        return lifecyclePolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecyclePolicies() ? lifecyclePolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleConfigurationResponse)) {
            return false;
        }
        DescribeLifecycleConfigurationResponse other = (DescribeLifecycleConfigurationResponse) obj;
        return hasLifecyclePolicies() == other.hasLifecyclePolicies()
                && Objects.equals(lifecyclePolicies(), other.lifecyclePolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLifecycleConfigurationResponse")
                .add("LifecyclePolicies", hasLifecyclePolicies() ? lifecyclePolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecyclePolicies":
            return Optional.ofNullable(clazz.cast(lifecyclePolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLifecycleConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeLifecycleConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLifecycleConfigurationResponse> {
        /**
         * <p>
         * An array of lifecycle management policies. EFS supports a maximum of one policy per file system.
         * </p>
         * 
         * @param lifecyclePolicies
         *        An array of lifecycle management policies. EFS supports a maximum of one policy per file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicies(Collection<LifecyclePolicy> lifecyclePolicies);

        /**
         * <p>
         * An array of lifecycle management policies. EFS supports a maximum of one policy per file system.
         * </p>
         * 
         * @param lifecyclePolicies
         *        An array of lifecycle management policies. EFS supports a maximum of one policy per file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicies(LifecyclePolicy... lifecyclePolicies);

        /**
         * <p>
         * An array of lifecycle management policies. EFS supports a maximum of one policy per file system.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<LifecyclePolicy>.Builder} avoiding
         * the need to create one manually via {@link List<LifecyclePolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LifecyclePolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #lifecyclePolicies(List<LifecyclePolicy>)}.
         * 
         * @param lifecyclePolicies
         *        a consumer that will call methods on {@link List<LifecyclePolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecyclePolicies(List<LifecyclePolicy>)
         */
        Builder lifecyclePolicies(Consumer<LifecyclePolicy.Builder>... lifecyclePolicies);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private List<LifecyclePolicy> lifecyclePolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleConfigurationResponse model) {
            super(model);
            lifecyclePolicies(model.lifecyclePolicies);
        }

        public final List<LifecyclePolicy.Builder> getLifecyclePolicies() {
            List<LifecyclePolicy.Builder> result = LifecyclePoliciesCopier.copyToBuilder(this.lifecyclePolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecyclePolicies(Collection<LifecyclePolicy.BuilderImpl> lifecyclePolicies) {
            this.lifecyclePolicies = LifecyclePoliciesCopier.copyFromBuilder(lifecyclePolicies);
        }

        @Override
        public final Builder lifecyclePolicies(Collection<LifecyclePolicy> lifecyclePolicies) {
            this.lifecyclePolicies = LifecyclePoliciesCopier.copy(lifecyclePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicies(LifecyclePolicy... lifecyclePolicies) {
            lifecyclePolicies(Arrays.asList(lifecyclePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicies(Consumer<LifecyclePolicy.Builder>... lifecyclePolicies) {
            lifecyclePolicies(Stream.of(lifecyclePolicies).map(c -> LifecyclePolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeLifecycleConfigurationResponse build() {
            return new DescribeLifecycleConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
