/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.TransitionToIARules;
import software.amazon.awssdk.services.efs.model.TransitionToPrimaryStorageClassRules;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicy> {
    private static final SdkField<String> TRANSITION_TO_IA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitionToIA").getter(LifecyclePolicy.getter(LifecyclePolicy::transitionToIAAsString)).setter(LifecyclePolicy.setter(Builder::transitionToIA)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitionToIA").build()}).build();
    private static final SdkField<String> TRANSITION_TO_PRIMARY_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitionToPrimaryStorageClass").getter(LifecyclePolicy.getter(LifecyclePolicy::transitionToPrimaryStorageClassAsString)).setter(LifecyclePolicy.setter(Builder::transitionToPrimaryStorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitionToPrimaryStorageClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSITION_TO_IA_FIELD, TRANSITION_TO_PRIMARY_STORAGE_CLASS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitionToIA;
    private final String transitionToPrimaryStorageClass;

    private LifecyclePolicy(BuilderImpl builder) {
        this.transitionToIA = builder.transitionToIA;
        this.transitionToPrimaryStorageClass = builder.transitionToPrimaryStorageClass;
    }

    public final TransitionToIARules transitionToIA() {
        return TransitionToIARules.fromValue(this.transitionToIA);
    }

    public final String transitionToIAAsString() {
        return this.transitionToIA;
    }

    public final TransitionToPrimaryStorageClassRules transitionToPrimaryStorageClass() {
        return TransitionToPrimaryStorageClassRules.fromValue(this.transitionToPrimaryStorageClass);
    }

    public final String transitionToPrimaryStorageClassAsString() {
        return this.transitionToPrimaryStorageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitionToIAAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitionToPrimaryStorageClassAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicy)) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy)obj;
        return Objects.equals(this.transitionToIAAsString(), other.transitionToIAAsString()) && Objects.equals(this.transitionToPrimaryStorageClassAsString(), other.transitionToPrimaryStorageClassAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicy").add("TransitionToIA", (Object)this.transitionToIAAsString()).add("TransitionToPrimaryStorageClass", (Object)this.transitionToPrimaryStorageClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitionToIA": {
                return Optional.ofNullable(clazz.cast(this.transitionToIAAsString()));
            }
            case "TransitionToPrimaryStorageClass": {
                return Optional.ofNullable(clazz.cast(this.transitionToPrimaryStorageClassAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicy, T> g) {
        return obj -> g.apply((LifecyclePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitionToIA;
        private String transitionToPrimaryStorageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicy model) {
            this.transitionToIA(model.transitionToIA);
            this.transitionToPrimaryStorageClass(model.transitionToPrimaryStorageClass);
        }

        public final String getTransitionToIA() {
            return this.transitionToIA;
        }

        public final void setTransitionToIA(String transitionToIA) {
            this.transitionToIA = transitionToIA;
        }

        @Override
        @Transient
        public final Builder transitionToIA(String transitionToIA) {
            this.transitionToIA = transitionToIA;
            return this;
        }

        @Override
        @Transient
        public final Builder transitionToIA(TransitionToIARules transitionToIA) {
            this.transitionToIA(transitionToIA == null ? null : transitionToIA.toString());
            return this;
        }

        public final String getTransitionToPrimaryStorageClass() {
            return this.transitionToPrimaryStorageClass;
        }

        public final void setTransitionToPrimaryStorageClass(String transitionToPrimaryStorageClass) {
            this.transitionToPrimaryStorageClass = transitionToPrimaryStorageClass;
        }

        @Override
        @Transient
        public final Builder transitionToPrimaryStorageClass(String transitionToPrimaryStorageClass) {
            this.transitionToPrimaryStorageClass = transitionToPrimaryStorageClass;
            return this;
        }

        @Override
        @Transient
        public final Builder transitionToPrimaryStorageClass(TransitionToPrimaryStorageClassRules transitionToPrimaryStorageClass) {
            this.transitionToPrimaryStorageClass(transitionToPrimaryStorageClass == null ? null : transitionToPrimaryStorageClass.toString());
            return this;
        }

        public LifecyclePolicy build() {
            return new LifecyclePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicy> {
        public Builder transitionToIA(String var1);

        public Builder transitionToIA(TransitionToIARules var1);

        public Builder transitionToPrimaryStorageClass(String var1);

        public Builder transitionToPrimaryStorageClass(TransitionToPrimaryStorageClassRules var1);
    }
}

