/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.efs.model.AccessPointAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.AccessPointLimitExceededException;
import software.amazon.awssdk.services.efs.model.AccessPointNotFoundException;
import software.amazon.awssdk.services.efs.model.AvailabilityZonesMismatchException;
import software.amazon.awssdk.services.efs.model.BadRequestException;
import software.amazon.awssdk.services.efs.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.efs.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.efs.model.CreateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.CreateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.CreateMountTargetRequest;
import software.amazon.awssdk.services.efs.model.CreateMountTargetResponse;
import software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationRequest;
import software.amazon.awssdk.services.efs.model.CreateReplicationConfigurationResponse;
import software.amazon.awssdk.services.efs.model.CreateTagsRequest;
import software.amazon.awssdk.services.efs.model.CreateTagsResponse;
import software.amazon.awssdk.services.efs.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.efs.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemRequest;
import software.amazon.awssdk.services.efs.model.DeleteFileSystemResponse;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetRequest;
import software.amazon.awssdk.services.efs.model.DeleteMountTargetResponse;
import software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationRequest;
import software.amazon.awssdk.services.efs.model.DeleteReplicationConfigurationResponse;
import software.amazon.awssdk.services.efs.model.DeleteTagsRequest;
import software.amazon.awssdk.services.efs.model.DeleteTagsResponse;
import software.amazon.awssdk.services.efs.model.DependencyTimeoutException;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse;
import software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesRequest;
import software.amazon.awssdk.services.efs.model.DescribeAccountPreferencesResponse;
import software.amazon.awssdk.services.efs.model.DescribeBackupPolicyRequest;
import software.amazon.awssdk.services.efs.model.DescribeBackupPolicyResponse;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest;
import software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse;
import software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationRequest;
import software.amazon.awssdk.services.efs.model.DescribeLifecycleConfigurationResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse;
import software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsRequest;
import software.amazon.awssdk.services.efs.model.DescribeReplicationConfigurationsResponse;
import software.amazon.awssdk.services.efs.model.DescribeTagsRequest;
import software.amazon.awssdk.services.efs.model.DescribeTagsResponse;
import software.amazon.awssdk.services.efs.model.EfsException;
import software.amazon.awssdk.services.efs.model.FileSystemAlreadyExistsException;
import software.amazon.awssdk.services.efs.model.FileSystemInUseException;
import software.amazon.awssdk.services.efs.model.FileSystemLimitExceededException;
import software.amazon.awssdk.services.efs.model.FileSystemNotFoundException;
import software.amazon.awssdk.services.efs.model.IncorrectFileSystemLifeCycleStateException;
import software.amazon.awssdk.services.efs.model.IncorrectMountTargetStateException;
import software.amazon.awssdk.services.efs.model.InsufficientThroughputCapacityException;
import software.amazon.awssdk.services.efs.model.InternalServerErrorException;
import software.amazon.awssdk.services.efs.model.InvalidPolicyException;
import software.amazon.awssdk.services.efs.model.IpAddressInUseException;
import software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.efs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsRequest;
import software.amazon.awssdk.services.efs.model.ModifyMountTargetSecurityGroupsResponse;
import software.amazon.awssdk.services.efs.model.MountTargetConflictException;
import software.amazon.awssdk.services.efs.model.MountTargetNotFoundException;
import software.amazon.awssdk.services.efs.model.NetworkInterfaceLimitExceededException;
import software.amazon.awssdk.services.efs.model.NoFreeAddressesInSubnetException;
import software.amazon.awssdk.services.efs.model.PolicyNotFoundException;
import software.amazon.awssdk.services.efs.model.PutAccountPreferencesRequest;
import software.amazon.awssdk.services.efs.model.PutAccountPreferencesResponse;
import software.amazon.awssdk.services.efs.model.PutBackupPolicyRequest;
import software.amazon.awssdk.services.efs.model.PutBackupPolicyResponse;
import software.amazon.awssdk.services.efs.model.PutFileSystemPolicyRequest;
import software.amazon.awssdk.services.efs.model.PutFileSystemPolicyResponse;
import software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationRequest;
import software.amazon.awssdk.services.efs.model.PutLifecycleConfigurationResponse;
import software.amazon.awssdk.services.efs.model.ReplicationNotFoundException;
import software.amazon.awssdk.services.efs.model.SecurityGroupLimitExceededException;
import software.amazon.awssdk.services.efs.model.SecurityGroupNotFoundException;
import software.amazon.awssdk.services.efs.model.SubnetNotFoundException;
import software.amazon.awssdk.services.efs.model.TagResourceRequest;
import software.amazon.awssdk.services.efs.model.TagResourceResponse;
import software.amazon.awssdk.services.efs.model.ThrottlingException;
import software.amazon.awssdk.services.efs.model.ThroughputLimitExceededException;
import software.amazon.awssdk.services.efs.model.TooManyRequestsException;
import software.amazon.awssdk.services.efs.model.UnsupportedAvailabilityZoneException;
import software.amazon.awssdk.services.efs.model.UntagResourceRequest;
import software.amazon.awssdk.services.efs.model.UntagResourceResponse;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemRequest;
import software.amazon.awssdk.services.efs.model.UpdateFileSystemResponse;
import software.amazon.awssdk.services.efs.model.ValidationException;
import software.amazon.awssdk.services.efs.paginators.DescribeAccessPointsIterable;
import software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable;
import software.amazon.awssdk.services.efs.paginators.DescribeTagsIterable;
import software.amazon.awssdk.services.efs.paginators.ListTagsForResourceIterable;

/**
 * Service client for accessing EFS. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Elastic File System</fullname>
 * <p>
 * Amazon Elastic File System (Amazon EFS) provides simple, scalable file storage for use with Amazon EC2 Linux and Mac
 * instances in the Amazon Web Services Cloud. With Amazon EFS, storage capacity is elastic, growing and shrinking
 * automatically as you add and remove files, so that your applications have the storage they need, when they need it.
 * For more information, see the <a href="https://docs.aws.amazon.com/efs/latest/ug/api-reference.html">Amazon Elastic
 * File System API Reference</a> and the <a href="https://docs.aws.amazon.com/efs/latest/ug/whatisefs.html">Amazon
 * Elastic File System User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EfsClient extends SdkClient {
    String SERVICE_NAME = "elasticfilesystem";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "elasticfilesystem";

    /**
     * Create a {@link EfsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EfsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EfsClient}.
     */
    static EfsClientBuilder builder() {
        return new DefaultEfsClientBuilder();
    }

    /**
     * <p>
     * Creates an EFS access point. An access point is an application-specific view into an EFS file system that applies
     * an operating system user and group, and a file system path, to any file system request made through the access
     * point. The operating system user and group override any identity information provided by the NFS client. The file
     * system path is exposed as the access point's root directory. Applications using the access point can only access
     * data in the application's own directory and any subdirectories. To learn more, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Mounting a file system using EFS access
     * points</a>.
     * </p>
     * <note>
     * <p>
     * If multiple requests to create access points on the same file system are sent in quick succession, and the file
     * system is near the limit of 1000 access points, you may experience a throttling response for these requests. This
     * is to ensure that the file system does not exceed the stated access point limit.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:CreateAccessPoint</code> action.
     * </p>
     *
     * @param createAccessPointRequest
     * @return Result of the CreateAccessPoint operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws AccessPointAlreadyExistsException
     *         Returned if the access point that you are trying to create already exists, with the creation token you
     *         provided in the request.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointLimitExceededException
     *         Returned if the Amazon Web Services account has already created the maximum number of access points
     *         allowed per file system. For more informaton, see <a href=
     *         "https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region"
     *         >https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region</a>.
     * @throws ThrottlingException
     *         Returned when the <code>CreateAccessPoint</code> API action is called too quickly and the number of
     *         Access Points on the file system is nearing the <a href=
     *         "https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region">limit
     *         of 120</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessPointResponse createAccessPoint(CreateAccessPointRequest createAccessPointRequest)
            throws BadRequestException, AccessPointAlreadyExistsException, IncorrectFileSystemLifeCycleStateException,
            InternalServerErrorException, FileSystemNotFoundException, AccessPointLimitExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an EFS access point. An access point is an application-specific view into an EFS file system that applies
     * an operating system user and group, and a file system path, to any file system request made through the access
     * point. The operating system user and group override any identity information provided by the NFS client. The file
     * system path is exposed as the access point's root directory. Applications using the access point can only access
     * data in the application's own directory and any subdirectories. To learn more, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Mounting a file system using EFS access
     * points</a>.
     * </p>
     * <note>
     * <p>
     * If multiple requests to create access points on the same file system are sent in quick succession, and the file
     * system is near the limit of 1000 access points, you may experience a throttling response for these requests. This
     * is to ensure that the file system does not exceed the stated access point limit.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:CreateAccessPoint</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessPointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAccessPointRequest#builder()}
     * </p>
     *
     * @param createAccessPointRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccessPointRequest.Builder} to create a request.
     * @return Result of the CreateAccessPoint operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws AccessPointAlreadyExistsException
     *         Returned if the access point that you are trying to create already exists, with the creation token you
     *         provided in the request.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointLimitExceededException
     *         Returned if the Amazon Web Services account has already created the maximum number of access points
     *         allowed per file system. For more informaton, see <a href=
     *         "https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region"
     *         >https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region</a>.
     * @throws ThrottlingException
     *         Returned when the <code>CreateAccessPoint</code> API action is called too quickly and the number of
     *         Access Points on the file system is nearing the <a href=
     *         "https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region">limit
     *         of 120</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessPointResponse createAccessPoint(Consumer<CreateAccessPointRequest.Builder> createAccessPointRequest)
            throws BadRequestException, AccessPointAlreadyExistsException, IncorrectFileSystemLifeCycleStateException,
            InternalServerErrorException, FileSystemNotFoundException, AccessPointLimitExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, EfsException {
        return createAccessPoint(CreateAccessPointRequest.builder().applyMutation(createAccessPointRequest).build());
    }

    /**
     * <p>
     * Creates a new, empty file system. The operation requires a creation token in the request that Amazon EFS uses to
     * ensure idempotent creation (calling the operation with same creation token has no effect). If a file system does
     * not currently exist that is owned by the caller's Amazon Web Services account with the specified creation token,
     * this operation does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new, empty file system. The file system will have an Amazon EFS assigned ID, and an initial lifecycle
     * state <code>creating</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returns with the description of the created file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Otherwise, this operation returns a <code>FileSystemAlreadyExists</code> error with the ID of the existing file
     * system.
     * </p>
     * <note>
     * <p>
     * For basic use cases, you can use a randomly generated UUID for the creation token.
     * </p>
     * </note>
     * <p>
     * The idempotent operation allows you to retry a <code>CreateFileSystem</code> call without risk of creating an
     * extra file system. This can happen when an initial call fails in a way that leaves it uncertain whether or not a
     * file system was actually created. An example might be that a transport level timeout occurred or your connection
     * was reset. As long as you use the same creation token, if the initial call had succeeded in creating a file
     * system, the client can learn of its existence from the <code>FileSystemAlreadyExists</code> error.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/creating-using-create-fs.html#creating-using-create-fs-part1"
     * >Creating a file system</a> in the <i>Amazon EFS User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The <code>CreateFileSystem</code> call returns while the file system's lifecycle state is still
     * <code>creating</code>. You can check the file system creation status by calling the <a>DescribeFileSystems</a>
     * operation, which among other things returns the file system state.
     * </p>
     * </note>
     * <p>
     * This operation accepts an optional <code>PerformanceMode</code> parameter that you choose for your file system.
     * We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the
     * <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second
     * with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed
     * after the file system has been created. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes.html">Amazon EFS performance
     * modes</a>.
     * </p>
     * <p>
     * You can set the throughput mode for the file system using the <code>ThroughputMode</code> parameter.
     * </p>
     * <p>
     * After the file system is fully created, Amazon EFS sets its lifecycle state to <code>available</code>, at which
     * point you can create one or more mount targets for the file system in your VPC. For more information, see
     * <a>CreateMountTarget</a>. You mount your Amazon EFS file system on an EC2 instances in your VPC by using the
     * mount target. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html">Amazon EFS: How it Works</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:CreateFileSystem</code> action.
     * </p>
     *
     * @param createFileSystemRequest
     * @return Result of the CreateFileSystem operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemAlreadyExistsException
     *         Returned if the file system you are trying to create already exists, with the creation token you
     *         provided.
     * @throws FileSystemLimitExceededException
     *         Returned if the Amazon Web Services account has already created the maximum number of file systems
     *         allowed per account.
     * @throws InsufficientThroughputCapacityException
     *         Returned if there's not enough capacity to provision additional throughput. This value might be returned
     *         when you try to create a file system in provisioned throughput mode, when you attempt to increase the
     *         provisioned throughput of an existing file system, or when you attempt to change an existing file system
     *         from Bursting Throughput to Provisioned Throughput mode. Try again later.
     * @throws ThroughputLimitExceededException
     *         Returned if the throughput mode or amount of provisioned throughput can't be changed because the
     *         throughput limit of 1024 MiB/s has been reached.
     * @throws UnsupportedAvailabilityZoneException
     *         Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFileSystemResponse createFileSystem(CreateFileSystemRequest createFileSystemRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemAlreadyExistsException,
            FileSystemLimitExceededException, InsufficientThroughputCapacityException, ThroughputLimitExceededException,
            UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new, empty file system. The operation requires a creation token in the request that Amazon EFS uses to
     * ensure idempotent creation (calling the operation with same creation token has no effect). If a file system does
     * not currently exist that is owned by the caller's Amazon Web Services account with the specified creation token,
     * this operation does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new, empty file system. The file system will have an Amazon EFS assigned ID, and an initial lifecycle
     * state <code>creating</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Returns with the description of the created file system.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Otherwise, this operation returns a <code>FileSystemAlreadyExists</code> error with the ID of the existing file
     * system.
     * </p>
     * <note>
     * <p>
     * For basic use cases, you can use a randomly generated UUID for the creation token.
     * </p>
     * </note>
     * <p>
     * The idempotent operation allows you to retry a <code>CreateFileSystem</code> call without risk of creating an
     * extra file system. This can happen when an initial call fails in a way that leaves it uncertain whether or not a
     * file system was actually created. An example might be that a transport level timeout occurred or your connection
     * was reset. As long as you use the same creation token, if the initial call had succeeded in creating a file
     * system, the client can learn of its existence from the <code>FileSystemAlreadyExists</code> error.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/creating-using-create-fs.html#creating-using-create-fs-part1"
     * >Creating a file system</a> in the <i>Amazon EFS User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The <code>CreateFileSystem</code> call returns while the file system's lifecycle state is still
     * <code>creating</code>. You can check the file system creation status by calling the <a>DescribeFileSystems</a>
     * operation, which among other things returns the file system state.
     * </p>
     * </note>
     * <p>
     * This operation accepts an optional <code>PerformanceMode</code> parameter that you choose for your file system.
     * We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the
     * <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second
     * with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed
     * after the file system has been created. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes.html">Amazon EFS performance
     * modes</a>.
     * </p>
     * <p>
     * You can set the throughput mode for the file system using the <code>ThroughputMode</code> parameter.
     * </p>
     * <p>
     * After the file system is fully created, Amazon EFS sets its lifecycle state to <code>available</code>, at which
     * point you can create one or more mount targets for the file system in your VPC. For more information, see
     * <a>CreateMountTarget</a>. You mount your Amazon EFS file system on an EC2 instances in your VPC by using the
     * mount target. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html">Amazon EFS: How it Works</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:CreateFileSystem</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFileSystemRequest.Builder} avoiding the need
     * to create one manually via {@link CreateFileSystemRequest#builder()}
     * </p>
     *
     * @param createFileSystemRequest
     *        A {@link Consumer} that will call methods on {@link CreateFileSystemRequest.Builder} to create a request.
     * @return Result of the CreateFileSystem operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemAlreadyExistsException
     *         Returned if the file system you are trying to create already exists, with the creation token you
     *         provided.
     * @throws FileSystemLimitExceededException
     *         Returned if the Amazon Web Services account has already created the maximum number of file systems
     *         allowed per account.
     * @throws InsufficientThroughputCapacityException
     *         Returned if there's not enough capacity to provision additional throughput. This value might be returned
     *         when you try to create a file system in provisioned throughput mode, when you attempt to increase the
     *         provisioned throughput of an existing file system, or when you attempt to change an existing file system
     *         from Bursting Throughput to Provisioned Throughput mode. Try again later.
     * @throws ThroughputLimitExceededException
     *         Returned if the throughput mode or amount of provisioned throughput can't be changed because the
     *         throughput limit of 1024 MiB/s has been reached.
     * @throws UnsupportedAvailabilityZoneException
     *         Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFileSystemResponse createFileSystem(Consumer<CreateFileSystemRequest.Builder> createFileSystemRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemAlreadyExistsException,
            FileSystemLimitExceededException, InsufficientThroughputCapacityException, ThroughputLimitExceededException,
            UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EfsException {
        return createFileSystem(CreateFileSystemRequest.builder().applyMutation(createFileSystemRequest).build());
    }

    /**
     * <p>
     * Creates a mount target for a file system. You can then mount the file system on EC2 instances by using the mount
     * target.
     * </p>
     * <p>
     * You can create one mount target in each Availability Zone in your VPC. All EC2 instances in a VPC within a given
     * Availability Zone share a single mount target for a given file system. If you have multiple subnets in an
     * Availability Zone, you create a mount target in one of the subnets. EC2 instances do not need to be in the same
     * subnet as the mount target in order to access their file system.
     * </p>
     * <p>
     * You can create only one mount target for an EFS file system using One Zone storage classes. You must create that
     * mount target in the same Availability Zone in which the file system is located. Use the
     * <code>AvailabilityZoneName</code> and <code>AvailabiltyZoneId</code> properties in the <a>DescribeFileSystems</a>
     * response object to get this information. Use the <code>subnetId</code> associated with the file system's
     * Availability Zone when creating the mount target.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html">Amazon EFS: How
     * it Works</a>.
     * </p>
     * <p>
     * To create a mount target for a file system, the file system's lifecycle state must be <code>available</code>. For
     * more information, see <a>DescribeFileSystems</a>.
     * </p>
     * <p>
     * In the request, provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The file system ID for which you are creating the mount target.
     * </p>
     * </li>
     * <li>
     * <p>
     * A subnet ID, which determines the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The VPC in which Amazon EFS creates the mount target
     * </p>
     * </li>
     * <li>
     * <p>
     * The Availability Zone in which Amazon EFS creates the mount target
     * </p>
     * </li>
     * <li>
     * <p>
     * The IP address range from which Amazon EFS selects the IP address of the mount target (if you don't specify an IP
     * address in the request)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * After creating the mount target, Amazon EFS returns a response that includes, a <code>MountTargetId</code> and an
     * <code>IpAddress</code>. You use this IP address when mounting the file system in an EC2 instance. You can also
     * use the mount target's DNS name when mounting the file system. The EC2 instance on which you mount the file
     * system by using the mount target can resolve the mount target's DNS name to its IP address. For more information,
     * see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html#how-it-works-implementation">How it
     * Works: Implementation Overview</a>.
     * </p>
     * <p>
     * Note that you can create mount targets for a file system in only one VPC, and there can be only one mount target
     * per Availability Zone. That is, if the file system already has one or more mount targets created for it, the
     * subnet specified in the request to add another mount target must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must belong to the same VPC as the subnets of the existing mount targets
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not be in the same Availability Zone as any of the subnets of the existing mount targets
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the request satisfies the requirements, Amazon EFS does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new mount target in the specified subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * Also creates a new network interface in the subnet as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the request provides an <code>IpAddress</code>, Amazon EFS assigns that IP address to the network interface.
     * Otherwise, Amazon EFS assigns a free address in the subnet (in the same way that the Amazon EC2
     * <code>CreateNetworkInterface</code> call does when a request does not specify a primary private IP address).
     * </p>
     * </li>
     * <li>
     * <p>
     * If the request provides <code>SecurityGroups</code>, this network interface is associated with those security
     * groups. Otherwise, it belongs to the default security group for the subnet's VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Assigns the description <code>Mount target <i>fsmt-id</i> for file system <i>fs-id</i> </code> where
     * <code> <i>fsmt-id</i> </code> is the mount target ID, and <code> <i>fs-id</i> </code> is the
     * <code>FileSystemId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sets the <code>requesterManaged</code> property of the network interface to <code>true</code>, and the
     * <code>requesterId</code> value to <code>EFS</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each Amazon EFS mount target has one corresponding requester-managed EC2 network interface. After the network
     * interface is created, Amazon EFS sets the <code>NetworkInterfaceId</code> field in the mount target's description
     * to the network interface ID, and the <code>IpAddress</code> field to its address. If network interface creation
     * fails, the entire <code>CreateMountTarget</code> operation fails.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>CreateMountTarget</code> call returns only after creating the network interface, but while the mount
     * target state is still <code>creating</code>, you can check the mount target creation status by calling the
     * <a>DescribeMountTargets</a> operation, which among other things returns the mount target state.
     * </p>
     * </note>
     * <p>
     * We recommend that you create a mount target in each of the Availability Zones. There are cost considerations for
     * using a file system in an Availability Zone through a mount target created in another Availability Zone. For more
     * information, see <a href="http://aws.amazon.com/efs/">Amazon EFS</a>. In addition, by always using a mount target
     * local to the instance's Availability Zone, you eliminate a partial failure scenario. If the Availability Zone in
     * which your mount target is created goes down, then you can't access your file system through that mount target.
     * </p>
     * <p>
     * This operation requires permissions for the following action on the file system:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elasticfilesystem:CreateMountTarget</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation also requires permissions for the following Amazon EC2 actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2:DescribeSubnets</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DescribeNetworkInterfaces</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:CreateNetworkInterface</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param createMountTargetRequest
     * @return Result of the CreateMountTarget operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws MountTargetConflictException
     *         Returned if the mount target would violate one of the specified restrictions based on the file system's
     *         existing mount targets.
     * @throws SubnetNotFoundException
     *         Returned if there is no subnet with ID <code>SubnetId</code> provided in the request.
     * @throws NoFreeAddressesInSubnetException
     *         Returned if <code>IpAddress</code> was not specified in the request and there are no free IP addresses in
     *         the subnet.
     * @throws IpAddressInUseException
     *         Returned if the request specified an <code>IpAddress</code> that is already in use in the subnet.
     * @throws NetworkInterfaceLimitExceededException
     *         The calling account has reached the limit for elastic network interfaces for the specific Amazon Web
     *         Services Region. Either delete some network interfaces or request that the account quota be raised. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html">Amazon VPC
     *         Quotas</a> in the <i>Amazon VPC User Guide</i> (see the <b>Network interfaces per Region</b> entry in the
     *         <b>Network interfaces</b> table).
     * @throws SecurityGroupLimitExceededException
     *         Returned if the size of <code>SecurityGroups</code> specified in the request is greater than five.
     * @throws SecurityGroupNotFoundException
     *         Returned if one of the specified security groups doesn't exist in the subnet's virtual private cloud
     *         (VPC).
     * @throws UnsupportedAvailabilityZoneException
     *         Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.
     * @throws AvailabilityZonesMismatchException
     *         Returned if the Availability Zone that was specified for a mount target is different from the
     *         Availability Zone that was specified for One Zone storage. For more information, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html">Regional and One Zone
     *         storage redundancy</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateMountTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateMountTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMountTargetResponse createMountTarget(CreateMountTargetRequest createMountTargetRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException,
            IncorrectFileSystemLifeCycleStateException, MountTargetConflictException, SubnetNotFoundException,
            NoFreeAddressesInSubnetException, IpAddressInUseException, NetworkInterfaceLimitExceededException,
            SecurityGroupLimitExceededException, SecurityGroupNotFoundException, UnsupportedAvailabilityZoneException,
            AvailabilityZonesMismatchException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a mount target for a file system. You can then mount the file system on EC2 instances by using the mount
     * target.
     * </p>
     * <p>
     * You can create one mount target in each Availability Zone in your VPC. All EC2 instances in a VPC within a given
     * Availability Zone share a single mount target for a given file system. If you have multiple subnets in an
     * Availability Zone, you create a mount target in one of the subnets. EC2 instances do not need to be in the same
     * subnet as the mount target in order to access their file system.
     * </p>
     * <p>
     * You can create only one mount target for an EFS file system using One Zone storage classes. You must create that
     * mount target in the same Availability Zone in which the file system is located. Use the
     * <code>AvailabilityZoneName</code> and <code>AvailabiltyZoneId</code> properties in the <a>DescribeFileSystems</a>
     * response object to get this information. Use the <code>subnetId</code> associated with the file system's
     * Availability Zone when creating the mount target.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html">Amazon EFS: How
     * it Works</a>.
     * </p>
     * <p>
     * To create a mount target for a file system, the file system's lifecycle state must be <code>available</code>. For
     * more information, see <a>DescribeFileSystems</a>.
     * </p>
     * <p>
     * In the request, provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The file system ID for which you are creating the mount target.
     * </p>
     * </li>
     * <li>
     * <p>
     * A subnet ID, which determines the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The VPC in which Amazon EFS creates the mount target
     * </p>
     * </li>
     * <li>
     * <p>
     * The Availability Zone in which Amazon EFS creates the mount target
     * </p>
     * </li>
     * <li>
     * <p>
     * The IP address range from which Amazon EFS selects the IP address of the mount target (if you don't specify an IP
     * address in the request)
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * After creating the mount target, Amazon EFS returns a response that includes, a <code>MountTargetId</code> and an
     * <code>IpAddress</code>. You use this IP address when mounting the file system in an EC2 instance. You can also
     * use the mount target's DNS name when mounting the file system. The EC2 instance on which you mount the file
     * system by using the mount target can resolve the mount target's DNS name to its IP address. For more information,
     * see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html#how-it-works-implementation">How it
     * Works: Implementation Overview</a>.
     * </p>
     * <p>
     * Note that you can create mount targets for a file system in only one VPC, and there can be only one mount target
     * per Availability Zone. That is, if the file system already has one or more mount targets created for it, the
     * subnet specified in the request to add another mount target must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must belong to the same VPC as the subnets of the existing mount targets
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not be in the same Availability Zone as any of the subnets of the existing mount targets
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the request satisfies the requirements, Amazon EFS does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a new mount target in the specified subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * Also creates a new network interface in the subnet as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the request provides an <code>IpAddress</code>, Amazon EFS assigns that IP address to the network interface.
     * Otherwise, Amazon EFS assigns a free address in the subnet (in the same way that the Amazon EC2
     * <code>CreateNetworkInterface</code> call does when a request does not specify a primary private IP address).
     * </p>
     * </li>
     * <li>
     * <p>
     * If the request provides <code>SecurityGroups</code>, this network interface is associated with those security
     * groups. Otherwise, it belongs to the default security group for the subnet's VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Assigns the description <code>Mount target <i>fsmt-id</i> for file system <i>fs-id</i> </code> where
     * <code> <i>fsmt-id</i> </code> is the mount target ID, and <code> <i>fs-id</i> </code> is the
     * <code>FileSystemId</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sets the <code>requesterManaged</code> property of the network interface to <code>true</code>, and the
     * <code>requesterId</code> value to <code>EFS</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each Amazon EFS mount target has one corresponding requester-managed EC2 network interface. After the network
     * interface is created, Amazon EFS sets the <code>NetworkInterfaceId</code> field in the mount target's description
     * to the network interface ID, and the <code>IpAddress</code> field to its address. If network interface creation
     * fails, the entire <code>CreateMountTarget</code> operation fails.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>CreateMountTarget</code> call returns only after creating the network interface, but while the mount
     * target state is still <code>creating</code>, you can check the mount target creation status by calling the
     * <a>DescribeMountTargets</a> operation, which among other things returns the mount target state.
     * </p>
     * </note>
     * <p>
     * We recommend that you create a mount target in each of the Availability Zones. There are cost considerations for
     * using a file system in an Availability Zone through a mount target created in another Availability Zone. For more
     * information, see <a href="http://aws.amazon.com/efs/">Amazon EFS</a>. In addition, by always using a mount target
     * local to the instance's Availability Zone, you eliminate a partial failure scenario. If the Availability Zone in
     * which your mount target is created goes down, then you can't access your file system through that mount target.
     * </p>
     * <p>
     * This operation requires permissions for the following action on the file system:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elasticfilesystem:CreateMountTarget</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation also requires permissions for the following Amazon EC2 actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2:DescribeSubnets</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DescribeNetworkInterfaces</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:CreateNetworkInterface</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMountTargetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMountTargetRequest#builder()}
     * </p>
     *
     * @param createMountTargetRequest
     *        A {@link Consumer} that will call methods on {@link CreateMountTargetRequest.Builder} to create a request.
     * @return Result of the CreateMountTarget operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws MountTargetConflictException
     *         Returned if the mount target would violate one of the specified restrictions based on the file system's
     *         existing mount targets.
     * @throws SubnetNotFoundException
     *         Returned if there is no subnet with ID <code>SubnetId</code> provided in the request.
     * @throws NoFreeAddressesInSubnetException
     *         Returned if <code>IpAddress</code> was not specified in the request and there are no free IP addresses in
     *         the subnet.
     * @throws IpAddressInUseException
     *         Returned if the request specified an <code>IpAddress</code> that is already in use in the subnet.
     * @throws NetworkInterfaceLimitExceededException
     *         The calling account has reached the limit for elastic network interfaces for the specific Amazon Web
     *         Services Region. Either delete some network interfaces or request that the account quota be raised. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html">Amazon VPC
     *         Quotas</a> in the <i>Amazon VPC User Guide</i> (see the <b>Network interfaces per Region</b> entry in the
     *         <b>Network interfaces</b> table).
     * @throws SecurityGroupLimitExceededException
     *         Returned if the size of <code>SecurityGroups</code> specified in the request is greater than five.
     * @throws SecurityGroupNotFoundException
     *         Returned if one of the specified security groups doesn't exist in the subnet's virtual private cloud
     *         (VPC).
     * @throws UnsupportedAvailabilityZoneException
     *         Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.
     * @throws AvailabilityZonesMismatchException
     *         Returned if the Availability Zone that was specified for a mount target is different from the
     *         Availability Zone that was specified for One Zone storage. For more information, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html">Regional and One Zone
     *         storage redundancy</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateMountTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateMountTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMountTargetResponse createMountTarget(Consumer<CreateMountTargetRequest.Builder> createMountTargetRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException,
            IncorrectFileSystemLifeCycleStateException, MountTargetConflictException, SubnetNotFoundException,
            NoFreeAddressesInSubnetException, IpAddressInUseException, NetworkInterfaceLimitExceededException,
            SecurityGroupLimitExceededException, SecurityGroupNotFoundException, UnsupportedAvailabilityZoneException,
            AvailabilityZonesMismatchException, AwsServiceException, SdkClientException, EfsException {
        return createMountTarget(CreateMountTargetRequest.builder().applyMutation(createMountTargetRequest).build());
    }

    /**
     * <p>
     * Creates a replication configuration that replicates an existing EFS file system to a new, read-only file system.
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html">Amazon EFS
     * replication</a> in the <i>Amazon EFS User Guide</i>. The replication configuration specifies the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Source file system</b> - An existing EFS file system that you want replicated. The source file system cannot
     * be a destination file system in an existing replication configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Destination file system configuration</b> - The configuration of the destination file system to which the
     * source file system will be replicated. There can only be one destination file system in a replication
     * configuration. The destination file system configuration consists of the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon Web Services Region</b> - The Amazon Web Services Region in which the destination file system is
     * created. Amazon EFS replication is available in all Amazon Web Services Regions that Amazon EFS is available in,
     * except Africa (Cape Town), Asia Pacific (Hong Kong), Asia Pacific (Jakarta), Europe (Milan), and Middle East
     * (Bahrain).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Availability Zone</b> - If you want the destination file system to use EFS One Zone availability and
     * durability, you must specify the Availability Zone to create the file system in. For more information about EFS
     * storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html"> Amazon EFS storage
     * classes</a> in the <i>Amazon EFS User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Encryption</b> - All destination file systems are created with encryption at rest enabled. You can specify the
     * Key Management Service (KMS) key that is used to encrypt the destination file system. If you don't specify a KMS
     * key, your service-managed KMS key for Amazon EFS is used.
     * </p>
     * <note>
     * <p>
     * After the file system is created, you cannot change the KMS key.
     * </p>
     * </note></li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following properties are set by default:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Performance mode</b> - The destination file system's performance mode matches that of the source file system,
     * unless the destination file system uses EFS One Zone storage. In that case, the General Purpose performance mode
     * is used. The performance mode cannot be changed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Throughput mode</b> - The destination file system uses the Bursting Throughput mode by default. After the file
     * system is created, you can modify the throughput mode.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following properties are turned off by default:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Lifecycle management</b> - EFS lifecycle management and EFS Intelligent-Tiering are not enabled on the
     * destination file system. After the destination file system is created, you can enable EFS lifecycle management
     * and EFS Intelligent-Tiering.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Automatic backups</b> - Automatic daily backups not enabled on the destination file system. After the file
     * system is created, you can change this setting.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html">Amazon EFS
     * replication</a> in the <i>Amazon EFS User Guide</i>.
     * </p>
     *
     * @param createReplicationConfigurationRequest
     * @return Result of the CreateReplicationConfiguration operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws ValidationException
     *         Returned if the Backup service is not available in the Amazon Web Services Region in which the request
     *         was made.
     * @throws ReplicationNotFoundException
     *         Returned if the specified file system does not have a replication configuration.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws UnsupportedAvailabilityZoneException
     *         Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.
     * @throws FileSystemLimitExceededException
     *         Returned if the Amazon Web Services account has already created the maximum number of file systems
     *         allowed per account.
     * @throws InsufficientThroughputCapacityException
     *         Returned if there's not enough capacity to provision additional throughput. This value might be returned
     *         when you try to create a file system in provisioned throughput mode, when you attempt to increase the
     *         provisioned throughput of an existing file system, or when you attempt to change an existing file system
     *         from Bursting Throughput to Provisioned Throughput mode. Try again later.
     * @throws ThroughputLimitExceededException
     *         Returned if the throughput mode or amount of provisioned throughput can't be changed because the
     *         throughput limit of 1024 MiB/s has been reached.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateReplicationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationConfigurationResponse createReplicationConfiguration(
            CreateReplicationConfigurationRequest createReplicationConfigurationRequest) throws BadRequestException,
            IncorrectFileSystemLifeCycleStateException, ValidationException, ReplicationNotFoundException,
            FileSystemNotFoundException, UnsupportedAvailabilityZoneException, FileSystemLimitExceededException,
            InsufficientThroughputCapacityException, ThroughputLimitExceededException, InternalServerErrorException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a replication configuration that replicates an existing EFS file system to a new, read-only file system.
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html">Amazon EFS
     * replication</a> in the <i>Amazon EFS User Guide</i>. The replication configuration specifies the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Source file system</b> - An existing EFS file system that you want replicated. The source file system cannot
     * be a destination file system in an existing replication configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Destination file system configuration</b> - The configuration of the destination file system to which the
     * source file system will be replicated. There can only be one destination file system in a replication
     * configuration. The destination file system configuration consists of the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon Web Services Region</b> - The Amazon Web Services Region in which the destination file system is
     * created. Amazon EFS replication is available in all Amazon Web Services Regions that Amazon EFS is available in,
     * except Africa (Cape Town), Asia Pacific (Hong Kong), Asia Pacific (Jakarta), Europe (Milan), and Middle East
     * (Bahrain).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Availability Zone</b> - If you want the destination file system to use EFS One Zone availability and
     * durability, you must specify the Availability Zone to create the file system in. For more information about EFS
     * storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html"> Amazon EFS storage
     * classes</a> in the <i>Amazon EFS User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Encryption</b> - All destination file systems are created with encryption at rest enabled. You can specify the
     * Key Management Service (KMS) key that is used to encrypt the destination file system. If you don't specify a KMS
     * key, your service-managed KMS key for Amazon EFS is used.
     * </p>
     * <note>
     * <p>
     * After the file system is created, you cannot change the KMS key.
     * </p>
     * </note></li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The following properties are set by default:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Performance mode</b> - The destination file system's performance mode matches that of the source file system,
     * unless the destination file system uses EFS One Zone storage. In that case, the General Purpose performance mode
     * is used. The performance mode cannot be changed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Throughput mode</b> - The destination file system uses the Bursting Throughput mode by default. After the file
     * system is created, you can modify the throughput mode.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following properties are turned off by default:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Lifecycle management</b> - EFS lifecycle management and EFS Intelligent-Tiering are not enabled on the
     * destination file system. After the destination file system is created, you can enable EFS lifecycle management
     * and EFS Intelligent-Tiering.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Automatic backups</b> - Automatic daily backups not enabled on the destination file system. After the file
     * system is created, you can change this setting.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html">Amazon EFS
     * replication</a> in the <i>Amazon EFS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param createReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateReplicationConfiguration operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws ValidationException
     *         Returned if the Backup service is not available in the Amazon Web Services Region in which the request
     *         was made.
     * @throws ReplicationNotFoundException
     *         Returned if the specified file system does not have a replication configuration.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws UnsupportedAvailabilityZoneException
     *         Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.
     * @throws FileSystemLimitExceededException
     *         Returned if the Amazon Web Services account has already created the maximum number of file systems
     *         allowed per account.
     * @throws InsufficientThroughputCapacityException
     *         Returned if there's not enough capacity to provision additional throughput. This value might be returned
     *         when you try to create a file system in provisioned throughput mode, when you attempt to increase the
     *         provisioned throughput of an existing file system, or when you attempt to change an existing file system
     *         from Bursting Throughput to Provisioned Throughput mode. Try again later.
     * @throws ThroughputLimitExceededException
     *         Returned if the throughput mode or amount of provisioned throughput can't be changed because the
     *         throughput limit of 1024 MiB/s has been reached.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateReplicationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationConfigurationResponse createReplicationConfiguration(
            Consumer<CreateReplicationConfigurationRequest.Builder> createReplicationConfigurationRequest)
            throws BadRequestException, IncorrectFileSystemLifeCycleStateException, ValidationException,
            ReplicationNotFoundException, FileSystemNotFoundException, UnsupportedAvailabilityZoneException,
            FileSystemLimitExceededException, InsufficientThroughputCapacityException, ThroughputLimitExceededException,
            InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        return createReplicationConfiguration(CreateReplicationConfigurationRequest.builder()
                .applyMutation(createReplicationConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * DEPRECATED - <code>CreateTags</code> is deprecated and not maintained. To create tags for EFS resources, use the
     * API action.
     * </p>
     * </note>
     * <p>
     * Creates or overwrites tags associated with a file system. Each tag is a key-value pair. If a tag key specified in
     * the request already exists on the file system, this operation overwrites its value with the value provided in the
     * request. If you add the <code>Name</code> tag to your file system, Amazon EFS returns it in the response to the
     * <a>DescribeFileSystems</a> operation.
     * </p>
     * <p>
     * This operation requires permission for the <code>elasticfilesystem:CreateTags</code> action.
     * </p>
     *
     * @param createTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateTags" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Use TagResource.
     */
    @Deprecated
    default CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * DEPRECATED - <code>CreateTags</code> is deprecated and not maintained. To create tags for EFS resources, use the
     * API action.
     * </p>
     * </note>
     * <p>
     * Creates or overwrites tags associated with a file system. Each tag is a key-value pair. If a tag key specified in
     * the request already exists on the file system, this operation overwrites its value with the value provided in the
     * request. If you add the <code>Name</code> tag to your file system, Amazon EFS returns it in the response to the
     * <a>DescribeFileSystems</a> operation.
     * </p>
     * <p>
     * This operation requires permission for the <code>elasticfilesystem:CreateTags</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsRequest.Builder} to create a request.
     * @return Result of the CreateTags operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateTags" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Use TagResource.
     */
    @Deprecated
    default CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified access point. After deletion is complete, new clients can no longer connect to the access
     * points. Clients connected to the access point at the time of deletion will continue to function until they
     * terminate their connection.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DeleteAccessPoint</code> action.
     * </p>
     *
     * @param deleteAccessPointRequest
     * @return Result of the DeleteAccessPoint operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessPointResponse deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest)
            throws BadRequestException, InternalServerErrorException, AccessPointNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified access point. After deletion is complete, new clients can no longer connect to the access
     * points. Clients connected to the access point at the time of deletion will continue to function until they
     * terminate their connection.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DeleteAccessPoint</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessPointRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAccessPointRequest#builder()}
     * </p>
     *
     * @param deleteAccessPointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccessPointRequest.Builder} to create a request.
     * @return Result of the DeleteAccessPoint operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteAccessPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteAccessPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessPointResponse deleteAccessPoint(Consumer<DeleteAccessPointRequest.Builder> deleteAccessPointRequest)
            throws BadRequestException, InternalServerErrorException, AccessPointNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return deleteAccessPoint(DeleteAccessPointRequest.builder().applyMutation(deleteAccessPointRequest).build());
    }

    /**
     * <p>
     * Deletes a file system, permanently severing access to its contents. Upon return, the file system no longer exists
     * and you can't access any contents of the deleted file system.
     * </p>
     * <p>
     * You need to manually delete mount targets attached to a file system before you can delete an EFS file system.
     * This step is performed for you when you use the Amazon Web Services console to delete a file system.
     * </p>
     * <note>
     * <p>
     * You cannot delete a file system that is part of an EFS Replication configuration. You need to delete the
     * replication configuration first.
     * </p>
     * </note>
     * <p>
     * You can't delete a file system that is in use. That is, if the file system has any mount targets, you must first
     * delete them. For more information, see <a>DescribeMountTargets</a> and <a>DeleteMountTarget</a>.
     * </p>
     * <note>
     * <p>
     * The <code>DeleteFileSystem</code> call returns while the file system state is still <code>deleting</code>. You
     * can check the file system deletion status by calling the <a>DescribeFileSystems</a> operation, which returns a
     * list of file systems in your account. If you pass file system ID or creation token for the deleted file system,
     * the <a>DescribeFileSystems</a> returns a <code>404 FileSystemNotFound</code> error.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DeleteFileSystem</code> action.
     * </p>
     *
     * @param deleteFileSystemRequest
     * @return Result of the DeleteFileSystem operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws FileSystemInUseException
     *         Returned if a file system has mount targets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFileSystemResponse deleteFileSystem(DeleteFileSystemRequest deleteFileSystemRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, FileSystemInUseException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a file system, permanently severing access to its contents. Upon return, the file system no longer exists
     * and you can't access any contents of the deleted file system.
     * </p>
     * <p>
     * You need to manually delete mount targets attached to a file system before you can delete an EFS file system.
     * This step is performed for you when you use the Amazon Web Services console to delete a file system.
     * </p>
     * <note>
     * <p>
     * You cannot delete a file system that is part of an EFS Replication configuration. You need to delete the
     * replication configuration first.
     * </p>
     * </note>
     * <p>
     * You can't delete a file system that is in use. That is, if the file system has any mount targets, you must first
     * delete them. For more information, see <a>DescribeMountTargets</a> and <a>DeleteMountTarget</a>.
     * </p>
     * <note>
     * <p>
     * The <code>DeleteFileSystem</code> call returns while the file system state is still <code>deleting</code>. You
     * can check the file system deletion status by calling the <a>DescribeFileSystems</a> operation, which returns a
     * list of file systems in your account. If you pass file system ID or creation token for the deleted file system,
     * the <a>DescribeFileSystems</a> returns a <code>404 FileSystemNotFound</code> error.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DeleteFileSystem</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFileSystemRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFileSystemRequest#builder()}
     * </p>
     *
     * @param deleteFileSystemRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFileSystemRequest.Builder} to create a request.
     * @return Result of the DeleteFileSystem operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws FileSystemInUseException
     *         Returned if a file system has mount targets.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFileSystemResponse deleteFileSystem(Consumer<DeleteFileSystemRequest.Builder> deleteFileSystemRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, FileSystemInUseException,
            AwsServiceException, SdkClientException, EfsException {
        return deleteFileSystem(DeleteFileSystemRequest.builder().applyMutation(deleteFileSystemRequest).build());
    }

    /**
     * <p>
     * Deletes the <code>FileSystemPolicy</code> for the specified file system. The default
     * <code>FileSystemPolicy</code> goes into effect once the existing policy is deleted. For more information about
     * the default file system policy, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/res-based-policies-efs.html">Using Resource-based Policies with
     * EFS</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DeleteFileSystemPolicy</code> action.
     * </p>
     *
     * @param deleteFileSystemPolicyRequest
     * @return Result of the DeleteFileSystemPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteFileSystemPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteFileSystemPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFileSystemPolicyResponse deleteFileSystemPolicy(DeleteFileSystemPolicyRequest deleteFileSystemPolicyRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException,
            IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <code>FileSystemPolicy</code> for the specified file system. The default
     * <code>FileSystemPolicy</code> goes into effect once the existing policy is deleted. For more information about
     * the default file system policy, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/res-based-policies-efs.html">Using Resource-based Policies with
     * EFS</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DeleteFileSystemPolicy</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFileSystemPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFileSystemPolicyRequest#builder()}
     * </p>
     *
     * @param deleteFileSystemPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFileSystemPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFileSystemPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteFileSystemPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteFileSystemPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFileSystemPolicyResponse deleteFileSystemPolicy(
            Consumer<DeleteFileSystemPolicyRequest.Builder> deleteFileSystemPolicyRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException,
            AwsServiceException, SdkClientException, EfsException {
        return deleteFileSystemPolicy(DeleteFileSystemPolicyRequest.builder().applyMutation(deleteFileSystemPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified mount target.
     * </p>
     * <p>
     * This operation forcibly breaks any mounts of the file system by using the mount target that is being deleted,
     * which might disrupt instances or applications using those mounts. To avoid applications getting cut off abruptly,
     * you might consider unmounting any mounts of the mount target, if feasible. The operation also deletes the
     * associated network interface. Uncommitted writes might be lost, but breaking a mount target using this operation
     * does not corrupt the file system itself. The file system you created remains. You can mount an EC2 instance in
     * your VPC by using another mount target.
     * </p>
     * <p>
     * This operation requires permissions for the following action on the file system:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elasticfilesystem:DeleteMountTarget</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>DeleteMountTarget</code> call returns while the mount target state is still <code>deleting</code>. You
     * can check the mount target deletion by calling the <a>DescribeMountTargets</a> operation, which returns a list of
     * mount target descriptions for the given file system.
     * </p>
     * </note>
     * <p>
     * The operation also requires permissions for the following Amazon EC2 action on the mount target's network
     * interface:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2:DeleteNetworkInterface</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteMountTargetRequest
     * @return Result of the DeleteMountTarget operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws DependencyTimeoutException
     *         The service timed out trying to fulfill the request, and the client should try the call again.
     * @throws MountTargetNotFoundException
     *         Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteMountTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteMountTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMountTargetResponse deleteMountTarget(DeleteMountTargetRequest deleteMountTargetRequest)
            throws BadRequestException, InternalServerErrorException, DependencyTimeoutException, MountTargetNotFoundException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified mount target.
     * </p>
     * <p>
     * This operation forcibly breaks any mounts of the file system by using the mount target that is being deleted,
     * which might disrupt instances or applications using those mounts. To avoid applications getting cut off abruptly,
     * you might consider unmounting any mounts of the mount target, if feasible. The operation also deletes the
     * associated network interface. Uncommitted writes might be lost, but breaking a mount target using this operation
     * does not corrupt the file system itself. The file system you created remains. You can mount an EC2 instance in
     * your VPC by using another mount target.
     * </p>
     * <p>
     * This operation requires permissions for the following action on the file system:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elasticfilesystem:DeleteMountTarget</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>DeleteMountTarget</code> call returns while the mount target state is still <code>deleting</code>. You
     * can check the mount target deletion by calling the <a>DescribeMountTargets</a> operation, which returns a list of
     * mount target descriptions for the given file system.
     * </p>
     * </note>
     * <p>
     * The operation also requires permissions for the following Amazon EC2 action on the mount target's network
     * interface:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ec2:DeleteNetworkInterface</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMountTargetRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMountTargetRequest#builder()}
     * </p>
     *
     * @param deleteMountTargetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMountTargetRequest.Builder} to create a request.
     * @return Result of the DeleteMountTarget operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws DependencyTimeoutException
     *         The service timed out trying to fulfill the request, and the client should try the call again.
     * @throws MountTargetNotFoundException
     *         Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteMountTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteMountTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMountTargetResponse deleteMountTarget(Consumer<DeleteMountTargetRequest.Builder> deleteMountTargetRequest)
            throws BadRequestException, InternalServerErrorException, DependencyTimeoutException, MountTargetNotFoundException,
            AwsServiceException, SdkClientException, EfsException {
        return deleteMountTarget(DeleteMountTargetRequest.builder().applyMutation(deleteMountTargetRequest).build());
    }

    /**
     * <p>
     * Deletes an existing replication configuration. To delete a replication configuration, you must make the request
     * from the Amazon Web Services Region in which the destination file system is located. Deleting a replication
     * configuration ends the replication process. After a replication configuration is deleted, the destination file
     * system is no longer read-only. You can write to the destination file system after its status becomes
     * <code>Writeable</code>.
     * </p>
     *
     * @param deleteReplicationConfigurationRequest
     * @return Result of the DeleteReplicationConfiguration operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws ReplicationNotFoundException
     *         Returned if the specified file system does not have a replication configuration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteReplicationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationConfigurationResponse deleteReplicationConfiguration(
            DeleteReplicationConfigurationRequest deleteReplicationConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, ReplicationNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing replication configuration. To delete a replication configuration, you must make the request
     * from the Amazon Web Services Region in which the destination file system is located. Deleting a replication
     * configuration ends the replication process. After a replication configuration is deleted, the destination file
     * system is no longer read-only. You can write to the destination file system after its status becomes
     * <code>Writeable</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteReplicationConfiguration operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws ReplicationNotFoundException
     *         Returned if the specified file system does not have a replication configuration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteReplicationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationConfigurationResponse deleteReplicationConfiguration(
            Consumer<DeleteReplicationConfigurationRequest.Builder> deleteReplicationConfigurationRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, ReplicationNotFoundException,
            AwsServiceException, SdkClientException, EfsException {
        return deleteReplicationConfiguration(DeleteReplicationConfigurationRequest.builder()
                .applyMutation(deleteReplicationConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * DEPRECATED - <code>DeleteTags</code> is deprecated and not maintained. To remove tags from EFS resources, use the
     * API action.
     * </p>
     * </note>
     * <p>
     * Deletes the specified tags from a file system. If the <code>DeleteTags</code> request includes a tag key that
     * doesn't exist, Amazon EFS ignores it and doesn't cause an error. For more information about tags and related
     * restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Tag
     * restrictions</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DeleteTags</code> action.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteTags" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Use UntagResource.
     */
    @Deprecated
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * DEPRECATED - <code>DeleteTags</code> is deprecated and not maintained. To remove tags from EFS resources, use the
     * API action.
     * </p>
     * </note>
     * <p>
     * Deletes the specified tags from a file system. If the <code>DeleteTags</code> request includes a tag key that
     * doesn't exist, Amazon EFS ignores it and doesn't cause an error. For more information about tags and related
     * restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Tag
     * restrictions</a> in the <i>Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DeleteTags</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsRequest.Builder} to create a request.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteTags" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Use UntagResource.
     */
    @Deprecated
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS access point if the <code>AccessPointId</code> is provided. If
     * you provide an EFS <code>FileSystemId</code>, it returns descriptions of all access points for that file system.
     * You can provide either an <code>AccessPointId</code> or a <code>FileSystemId</code> in the request, but not both.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.
     * </p>
     *
     * @param describeAccessPointsRequest
     * @return Result of the DescribeAccessPoints operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeAccessPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccessPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccessPointsResponse describeAccessPoints(DescribeAccessPointsRequest describeAccessPointsRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS access point if the <code>AccessPointId</code> is provided. If
     * you provide an EFS <code>FileSystemId</code>, it returns descriptions of all access points for that file system.
     * You can provide either an <code>AccessPointId</code> or a <code>FileSystemId</code> in the request, but not both.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccessPointsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccessPointsRequest#builder()}
     * </p>
     *
     * @param describeAccessPointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccessPointsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccessPoints operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeAccessPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccessPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccessPointsResponse describeAccessPoints(
            Consumer<DescribeAccessPointsRequest.Builder> describeAccessPointsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return describeAccessPoints(DescribeAccessPointsRequest.builder().applyMutation(describeAccessPointsRequest).build());
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS access point if the <code>AccessPointId</code> is provided. If
     * you provide an EFS <code>FileSystemId</code>, it returns descriptions of all access points for that file system.
     * You can provide either an <code>AccessPointId</code> or a <code>FileSystemId</code> in the request, but not both.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccessPoints(software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeAccessPointsIterable responses = client.describeAccessPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.efs.paginators.DescribeAccessPointsIterable responses = client
     *             .describeAccessPointsPaginator(request);
     *     for (software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeAccessPointsIterable responses = client.describeAccessPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccessPoints(software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccessPointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeAccessPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccessPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccessPointsIterable describeAccessPointsPaginator(DescribeAccessPointsRequest describeAccessPointsRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS access point if the <code>AccessPointId</code> is provided. If
     * you provide an EFS <code>FileSystemId</code>, it returns descriptions of all access points for that file system.
     * You can provide either an <code>AccessPointId</code> or a <code>FileSystemId</code> in the request, but not both.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccessPoints(software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeAccessPointsIterable responses = client.describeAccessPointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.efs.paginators.DescribeAccessPointsIterable responses = client
     *             .describeAccessPointsPaginator(request);
     *     for (software.amazon.awssdk.services.efs.model.DescribeAccessPointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeAccessPointsIterable responses = client.describeAccessPointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccessPoints(software.amazon.awssdk.services.efs.model.DescribeAccessPointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccessPointsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccessPointsRequest#builder()}
     * </p>
     *
     * @param describeAccessPointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccessPointsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeAccessPoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccessPoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccessPointsIterable describeAccessPointsPaginator(
            Consumer<DescribeAccessPointsRequest.Builder> describeAccessPointsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return describeAccessPointsPaginator(DescribeAccessPointsRequest.builder().applyMutation(describeAccessPointsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the account preferences settings for the Amazon Web Services account associated with the user making the
     * request, in the current Amazon Web Services Region. For more information, see <a
     * href="efs/latest/ug/manage-efs-resource-ids.html">Managing Amazon EFS resource IDs</a>.
     * </p>
     *
     * @param describeAccountPreferencesRequest
     * @return Result of the DescribeAccountPreferences operation returned by the service.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountPreferencesResponse describeAccountPreferences(
            DescribeAccountPreferencesRequest describeAccountPreferencesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the account preferences settings for the Amazon Web Services account associated with the user making the
     * request, in the current Amazon Web Services Region. For more information, see <a
     * href="efs/latest/ug/manage-efs-resource-ids.html">Managing Amazon EFS resource IDs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountPreferencesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountPreferencesRequest#builder()}
     * </p>
     *
     * @param describeAccountPreferencesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountPreferencesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccountPreferences operation returned by the service.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountPreferencesResponse describeAccountPreferences(
            Consumer<DescribeAccountPreferencesRequest.Builder> describeAccountPreferencesRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        return describeAccountPreferences(DescribeAccountPreferencesRequest.builder()
                .applyMutation(describeAccountPreferencesRequest).build());
    }

    /**
     * <p>
     * Returns the backup policy for the specified EFS file system.
     * </p>
     *
     * @param describeBackupPolicyRequest
     * @return Result of the DescribeBackupPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws PolicyNotFoundException
     *         Returned if the default file system policy is in effect for the EFS file system specified.
     * @throws ValidationException
     *         Returned if the Backup service is not available in the Amazon Web Services Region in which the request
     *         was made.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeBackupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeBackupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBackupPolicyResponse describeBackupPolicy(DescribeBackupPolicyRequest describeBackupPolicyRequest)
            throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, PolicyNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the backup policy for the specified EFS file system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBackupPolicyRequest#builder()}
     * </p>
     *
     * @param describeBackupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBackupPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBackupPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws PolicyNotFoundException
     *         Returned if the default file system policy is in effect for the EFS file system specified.
     * @throws ValidationException
     *         Returned if the Backup service is not available in the Amazon Web Services Region in which the request
     *         was made.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeBackupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeBackupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBackupPolicyResponse describeBackupPolicy(
            Consumer<DescribeBackupPolicyRequest.Builder> describeBackupPolicyRequest) throws BadRequestException,
            FileSystemNotFoundException, InternalServerErrorException, PolicyNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, EfsException {
        return describeBackupPolicy(DescribeBackupPolicyRequest.builder().applyMutation(describeBackupPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the <code>FileSystemPolicy</code> for the specified EFS file system.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystemPolicy</code> action.
     * </p>
     *
     * @param describeFileSystemPolicyRequest
     * @return Result of the DescribeFileSystemPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws PolicyNotFoundException
     *         Returned if the default file system policy is in effect for the EFS file system specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeFileSystemPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystemPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemPolicyResponse describeFileSystemPolicy(
            DescribeFileSystemPolicyRequest describeFileSystemPolicyRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, PolicyNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>FileSystemPolicy</code> for the specified EFS file system.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystemPolicy</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFileSystemPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFileSystemPolicyRequest#builder()}
     * </p>
     *
     * @param describeFileSystemPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFileSystemPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFileSystemPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws PolicyNotFoundException
     *         Returned if the default file system policy is in effect for the EFS file system specified.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeFileSystemPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystemPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemPolicyResponse describeFileSystemPolicy(
            Consumer<DescribeFileSystemPolicyRequest.Builder> describeFileSystemPolicyRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, PolicyNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return describeFileSystemPolicy(DescribeFileSystemPolicyRequest.builder().applyMutation(describeFileSystemPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS file system if either the file system <code>CreationToken</code>
     * or the <code>FileSystemId</code> is provided. Otherwise, it returns descriptions of all file systems owned by the
     * caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxItems</code> parameter to
     * limit the number of descriptions in a response. This number is automatically set to 100. If more file system
     * descriptions remain, Amazon EFS returns a <code>NextMarker</code>, an opaque token, in the response. In this
     * case, you should send a subsequent request with the <code>Marker</code> request parameter set to the value of
     * <code>NextMarker</code>.
     * </p>
     * <p>
     * To retrieve a list of your file system descriptions, this operation is used in an iterative process, where
     * <code>DescribeFileSystems</code> is called first without the <code>Marker</code> and then the operation continues
     * to call it with the <code>Marker</code> parameter set to the value of the <code>NextMarker</code> from the
     * previous response until the response has no <code>NextMarker</code>.
     * </p>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystems</code> action.
     * </p>
     *
     * @return Result of the DescribeFileSystems operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeFileSystems
     * @see #describeFileSystems(DescribeFileSystemsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystems"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemsResponse describeFileSystems() throws BadRequestException, InternalServerErrorException,
            FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return describeFileSystems(DescribeFileSystemsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS file system if either the file system <code>CreationToken</code>
     * or the <code>FileSystemId</code> is provided. Otherwise, it returns descriptions of all file systems owned by the
     * caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxItems</code> parameter to
     * limit the number of descriptions in a response. This number is automatically set to 100. If more file system
     * descriptions remain, Amazon EFS returns a <code>NextMarker</code>, an opaque token, in the response. In this
     * case, you should send a subsequent request with the <code>Marker</code> request parameter set to the value of
     * <code>NextMarker</code>.
     * </p>
     * <p>
     * To retrieve a list of your file system descriptions, this operation is used in an iterative process, where
     * <code>DescribeFileSystems</code> is called first without the <code>Marker</code> and then the operation continues
     * to call it with the <code>Marker</code> parameter set to the value of the <code>NextMarker</code> from the
     * previous response until the response has no <code>NextMarker</code>.
     * </p>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystems</code> action.
     * </p>
     *
     * @param describeFileSystemsRequest
     * @return Result of the DescribeFileSystems operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystems"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemsResponse describeFileSystems(DescribeFileSystemsRequest describeFileSystemsRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS file system if either the file system <code>CreationToken</code>
     * or the <code>FileSystemId</code> is provided. Otherwise, it returns descriptions of all file systems owned by the
     * caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxItems</code> parameter to
     * limit the number of descriptions in a response. This number is automatically set to 100. If more file system
     * descriptions remain, Amazon EFS returns a <code>NextMarker</code>, an opaque token, in the response. In this
     * case, you should send a subsequent request with the <code>Marker</code> request parameter set to the value of
     * <code>NextMarker</code>.
     * </p>
     * <p>
     * To retrieve a list of your file system descriptions, this operation is used in an iterative process, where
     * <code>DescribeFileSystems</code> is called first without the <code>Marker</code> and then the operation continues
     * to call it with the <code>Marker</code> parameter set to the value of the <code>NextMarker</code> from the
     * previous response until the response has no <code>NextMarker</code>.
     * </p>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystems</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFileSystemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFileSystemsRequest#builder()}
     * </p>
     *
     * @param describeFileSystemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFileSystemsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFileSystems operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystems"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemsResponse describeFileSystems(
            Consumer<DescribeFileSystemsRequest.Builder> describeFileSystemsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return describeFileSystems(DescribeFileSystemsRequest.builder().applyMutation(describeFileSystemsRequest).build());
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS file system if either the file system <code>CreationToken</code>
     * or the <code>FileSystemId</code> is provided. Otherwise, it returns descriptions of all file systems owned by the
     * caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxItems</code> parameter to
     * limit the number of descriptions in a response. This number is automatically set to 100. If more file system
     * descriptions remain, Amazon EFS returns a <code>NextMarker</code>, an opaque token, in the response. In this
     * case, you should send a subsequent request with the <code>Marker</code> request parameter set to the value of
     * <code>NextMarker</code>.
     * </p>
     * <p>
     * To retrieve a list of your file system descriptions, this operation is used in an iterative process, where
     * <code>DescribeFileSystems</code> is called first without the <code>Marker</code> and then the operation continues
     * to call it with the <code>Marker</code> parameter set to the value of the <code>NextMarker</code> from the
     * previous response until the response has no <code>NextMarker</code>.
     * </p>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystems</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFileSystems(software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable responses = client.describeFileSystemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable responses = client
     *             .describeFileSystemsPaginator(request);
     *     for (software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable responses = client.describeFileSystemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFileSystems(software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeFileSystems
     * @see #describeFileSystemsPaginator(DescribeFileSystemsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystems"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemsIterable describeFileSystemsPaginator() throws BadRequestException, InternalServerErrorException,
            FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return describeFileSystemsPaginator(DescribeFileSystemsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS file system if either the file system <code>CreationToken</code>
     * or the <code>FileSystemId</code> is provided. Otherwise, it returns descriptions of all file systems owned by the
     * caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxItems</code> parameter to
     * limit the number of descriptions in a response. This number is automatically set to 100. If more file system
     * descriptions remain, Amazon EFS returns a <code>NextMarker</code>, an opaque token, in the response. In this
     * case, you should send a subsequent request with the <code>Marker</code> request parameter set to the value of
     * <code>NextMarker</code>.
     * </p>
     * <p>
     * To retrieve a list of your file system descriptions, this operation is used in an iterative process, where
     * <code>DescribeFileSystems</code> is called first without the <code>Marker</code> and then the operation continues
     * to call it with the <code>Marker</code> parameter set to the value of the <code>NextMarker</code> from the
     * previous response until the response has no <code>NextMarker</code>.
     * </p>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystems</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFileSystems(software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable responses = client.describeFileSystemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable responses = client
     *             .describeFileSystemsPaginator(request);
     *     for (software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable responses = client.describeFileSystemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFileSystems(software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest)} operation.</b>
     * </p>
     *
     * @param describeFileSystemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystems"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemsIterable describeFileSystemsPaginator(DescribeFileSystemsRequest describeFileSystemsRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of a specific Amazon EFS file system if either the file system <code>CreationToken</code>
     * or the <code>FileSystemId</code> is provided. Otherwise, it returns descriptions of all file systems owned by the
     * caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     * </p>
     * <p>
     * When retrieving all file system descriptions, you can optionally specify the <code>MaxItems</code> parameter to
     * limit the number of descriptions in a response. This number is automatically set to 100. If more file system
     * descriptions remain, Amazon EFS returns a <code>NextMarker</code>, an opaque token, in the response. In this
     * case, you should send a subsequent request with the <code>Marker</code> request parameter set to the value of
     * <code>NextMarker</code>.
     * </p>
     * <p>
     * To retrieve a list of your file system descriptions, this operation is used in an iterative process, where
     * <code>DescribeFileSystems</code> is called first without the <code>Marker</code> and then the operation continues
     * to call it with the <code>Marker</code> parameter set to the value of the <code>NextMarker</code> from the
     * previous response until the response has no <code>NextMarker</code>.
     * </p>
     * <p>
     * The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of
     * file systems returned across the responses of a multi-call iteration is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystems</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeFileSystems(software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable responses = client.describeFileSystemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable responses = client
     *             .describeFileSystemsPaginator(request);
     *     for (software.amazon.awssdk.services.efs.model.DescribeFileSystemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeFileSystemsIterable responses = client.describeFileSystemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFileSystems(software.amazon.awssdk.services.efs.model.DescribeFileSystemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFileSystemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFileSystemsRequest#builder()}
     * </p>
     *
     * @param describeFileSystemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFileSystemsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeFileSystems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystems"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFileSystemsIterable describeFileSystemsPaginator(
            Consumer<DescribeFileSystemsRequest.Builder> describeFileSystemsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return describeFileSystemsPaginator(DescribeFileSystemsRequest.builder().applyMutation(describeFileSystemsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the current <code>LifecycleConfiguration</code> object for the specified Amazon EFS file system. EFS
     * lifecycle management uses the <code>LifecycleConfiguration</code> object to identify which files to move to the
     * EFS Infrequent Access (IA) storage class. For a file system without a <code>LifecycleConfiguration</code> object,
     * the call returns an empty array in the response.
     * </p>
     * <p>
     * When EFS Intelligent-Tiering is enabled, <code>TransitionToPrimaryStorageClass</code> has a value of
     * <code>AFTER_1_ACCESS</code>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeLifecycleConfiguration</code>
     * operation.
     * </p>
     *
     * @param describeLifecycleConfigurationRequest
     * @return Result of the DescribeLifecycleConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeLifecycleConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeLifecycleConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleConfigurationResponse describeLifecycleConfiguration(
            DescribeLifecycleConfigurationRequest describeLifecycleConfigurationRequest) throws InternalServerErrorException,
            BadRequestException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current <code>LifecycleConfiguration</code> object for the specified Amazon EFS file system. EFS
     * lifecycle management uses the <code>LifecycleConfiguration</code> object to identify which files to move to the
     * EFS Infrequent Access (IA) storage class. For a file system without a <code>LifecycleConfiguration</code> object,
     * the call returns an empty array in the response.
     * </p>
     * <p>
     * When EFS Intelligent-Tiering is enabled, <code>TransitionToPrimaryStorageClass</code> has a value of
     * <code>AFTER_1_ACCESS</code>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeLifecycleConfiguration</code>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLifecycleConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeLifecycleConfigurationRequest#builder()}
     * </p>
     *
     * @param describeLifecycleConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLifecycleConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeLifecycleConfiguration operation returned by the service.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeLifecycleConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeLifecycleConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleConfigurationResponse describeLifecycleConfiguration(
            Consumer<DescribeLifecycleConfigurationRequest.Builder> describeLifecycleConfigurationRequest)
            throws InternalServerErrorException, BadRequestException, FileSystemNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return describeLifecycleConfiguration(DescribeLifecycleConfigurationRequest.builder()
                .applyMutation(describeLifecycleConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the security groups currently in effect for a mount target. This operation requires that the network
     * interface of the mount target has been created and the lifecycle state of the mount target is not
     * <code>deleted</code>.
     * </p>
     * <p>
     * This operation requires permissions for the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elasticfilesystem:DescribeMountTargetSecurityGroups</code> action on the mount target's file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DescribeNetworkInterfaceAttribute</code> action on the mount target's network interface.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeMountTargetSecurityGroupsRequest
     * @return Result of the DescribeMountTargetSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws MountTargetNotFoundException
     *         Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services
     *         account.
     * @throws IncorrectMountTargetStateException
     *         Returned if the mount target is not in the correct state for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeMountTargetSecurityGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeMountTargetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroups(
            DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) throws BadRequestException,
            InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException, AwsServiceException,
            SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the security groups currently in effect for a mount target. This operation requires that the network
     * interface of the mount target has been created and the lifecycle state of the mount target is not
     * <code>deleted</code>.
     * </p>
     * <p>
     * This operation requires permissions for the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elasticfilesystem:DescribeMountTargetSecurityGroups</code> action on the mount target's file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:DescribeNetworkInterfaceAttribute</code> action on the mount target's network interface.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMountTargetSecurityGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMountTargetSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeMountTargetSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMountTargetSecurityGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeMountTargetSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws MountTargetNotFoundException
     *         Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services
     *         account.
     * @throws IncorrectMountTargetStateException
     *         Returned if the mount target is not in the correct state for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeMountTargetSecurityGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeMountTargetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMountTargetSecurityGroupsResponse describeMountTargetSecurityGroups(
            Consumer<DescribeMountTargetSecurityGroupsRequest.Builder> describeMountTargetSecurityGroupsRequest)
            throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException,
            IncorrectMountTargetStateException, AwsServiceException, SdkClientException, EfsException {
        return describeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest.builder()
                .applyMutation(describeMountTargetSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the descriptions of all the current mount targets, or a specific mount target, for a file system. When
     * requesting all of the current mount targets, the order of mount targets returned in the response is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeMountTargets</code> action, on either
     * the file system ID that you specify in <code>FileSystemId</code>, or on the file system of the mount target that
     * you specify in <code>MountTargetId</code>.
     * </p>
     *
     * @param describeMountTargetsRequest
     * @return Result of the DescribeMountTargets operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws MountTargetNotFoundException
     *         Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services
     *         account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeMountTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeMountTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMountTargetsResponse describeMountTargets(DescribeMountTargetsRequest describeMountTargetsRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, MountTargetNotFoundException,
            AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the descriptions of all the current mount targets, or a specific mount target, for a file system. When
     * requesting all of the current mount targets, the order of mount targets returned in the response is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeMountTargets</code> action, on either
     * the file system ID that you specify in <code>FileSystemId</code>, or on the file system of the mount target that
     * you specify in <code>MountTargetId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMountTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMountTargetsRequest#builder()}
     * </p>
     *
     * @param describeMountTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMountTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeMountTargets operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws MountTargetNotFoundException
     *         Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services
     *         account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeMountTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeMountTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMountTargetsResponse describeMountTargets(
            Consumer<DescribeMountTargetsRequest.Builder> describeMountTargetsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, MountTargetNotFoundException,
            AccessPointNotFoundException, AwsServiceException, SdkClientException, EfsException {
        return describeMountTargets(DescribeMountTargetsRequest.builder().applyMutation(describeMountTargetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the replication configuration for a specific file system. If a file system is not specified, all of the
     * replication configurations for the Amazon Web Services account in an Amazon Web Services Region are retrieved.
     * </p>
     *
     * @param describeReplicationConfigurationsRequest
     * @return Result of the DescribeReplicationConfigurations operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws ReplicationNotFoundException
     *         Returned if the specified file system does not have a replication configuration.
     * @throws ValidationException
     *         Returned if the Backup service is not available in the Amazon Web Services Region in which the request
     *         was made.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeReplicationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeReplicationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationsResponse describeReplicationConfigurations(
            DescribeReplicationConfigurationsRequest describeReplicationConfigurationsRequest) throws BadRequestException,
            FileSystemNotFoundException, InternalServerErrorException, ReplicationNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the replication configuration for a specific file system. If a file system is not specified, all of the
     * replication configurations for the Amazon Web Services account in an Amazon Web Services Region are retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeReplicationConfigurations operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws ReplicationNotFoundException
     *         Returned if the specified file system does not have a replication configuration.
     * @throws ValidationException
     *         Returned if the Backup service is not available in the Amazon Web Services Region in which the request
     *         was made.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeReplicationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeReplicationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationsResponse describeReplicationConfigurations(
            Consumer<DescribeReplicationConfigurationsRequest.Builder> describeReplicationConfigurationsRequest)
            throws BadRequestException, FileSystemNotFoundException, InternalServerErrorException, ReplicationNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, EfsException {
        return describeReplicationConfigurations(DescribeReplicationConfigurationsRequest.builder()
                .applyMutation(describeReplicationConfigurationsRequest).build());
    }

    /**
     * <note>
     * <p>
     * DEPRECATED - The <code>DescribeTags</code> action is deprecated and not maintained. To view tags associated with
     * EFS resources, use the <code>ListTagsForResource</code> API action.
     * </p>
     * </note>
     * <p>
     * Returns the tags associated with a file system. The order of tags returned in the response of one
     * <code>DescribeTags</code> call and the order of tags returned across the responses of a multiple-call iteration
     * (when using pagination) is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeTags</code> action.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Use ListTagsForResource.
     */
    @Deprecated
    default DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * DEPRECATED - The <code>DescribeTags</code> action is deprecated and not maintained. To view tags associated with
     * EFS resources, use the <code>ListTagsForResource</code> API action.
     * </p>
     * </note>
     * <p>
     * Returns the tags associated with a file system. The order of tags returned in the response of one
     * <code>DescribeTags</code> call and the order of tags returned across the responses of a multiple-call iteration
     * (when using pagination) is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeTags</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagsRequest.Builder} to create a request.
     * @return Result of the DescribeTags operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Use ListTagsForResource.
     */
    @Deprecated
    default DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <note>
     * <p>
     * DEPRECATED - The <code>DescribeTags</code> action is deprecated and not maintained. To view tags associated with
     * EFS resources, use the <code>ListTagsForResource</code> API action.
     * </p>
     * </note>
     * <p>
     * Returns the tags associated with a file system. The order of tags returned in the response of one
     * <code>DescribeTags</code> call and the order of tags returned across the responses of a multiple-call iteration
     * (when using pagination) is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeTags</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.efs.model.DescribeTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.efs.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     *     for (software.amazon.awssdk.services.efs.model.DescribeTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.efs.model.DescribeTagsRequest)} operation.</b>
     * </p>
     *
     * @param describeTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Use ListTagsForResource.
     */
    @Deprecated
    default DescribeTagsIterable describeTagsPaginator(DescribeTagsRequest describeTagsRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * DEPRECATED - The <code>DescribeTags</code> action is deprecated and not maintained. To view tags associated with
     * EFS resources, use the <code>ListTagsForResource</code> API action.
     * </p>
     * </note>
     * <p>
     * Returns the tags associated with a file system. The order of tags returned in the response of one
     * <code>DescribeTags</code> call and the order of tags returned across the responses of a multiple-call iteration
     * (when using pagination) is unspecified.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeTags</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.efs.model.DescribeTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.efs.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     *     for (software.amazon.awssdk.services.efs.model.DescribeTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.DescribeTagsIterable responses = client.describeTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.efs.model.DescribeTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Use ListTagsForResource.
     */
    @Deprecated
    default DescribeTagsIterable describeTagsPaginator(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return describeTagsPaginator(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve
     * the tags for.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve
     * the tags for.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve
     * the tags for.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.efs.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.efs.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest)} operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve
     * the tags for.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.efs.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.efs.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.efs.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.efs.model.ListTagsForResourceRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the set of security groups in effect for a mount target.
     * </p>
     * <p>
     * When you create a mount target, Amazon EFS also creates a new network interface. For more information, see
     * <a>CreateMountTarget</a>. This operation replaces the security groups in effect for the network interface
     * associated with a mount target, with the <code>SecurityGroups</code> provided in the request. This operation
     * requires that the network interface of the mount target has been created and the lifecycle state of the mount
     * target is not <code>deleted</code>.
     * </p>
     * <p>
     * The operation requires permissions for the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elasticfilesystem:ModifyMountTargetSecurityGroups</code> action on the mount target's file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:ModifyNetworkInterfaceAttribute</code> action on the mount target's network interface.
     * </p>
     * </li>
     * </ul>
     *
     * @param modifyMountTargetSecurityGroupsRequest
     * @return Result of the ModifyMountTargetSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws MountTargetNotFoundException
     *         Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services
     *         account.
     * @throws IncorrectMountTargetStateException
     *         Returned if the mount target is not in the correct state for the operation.
     * @throws SecurityGroupLimitExceededException
     *         Returned if the size of <code>SecurityGroups</code> specified in the request is greater than five.
     * @throws SecurityGroupNotFoundException
     *         Returned if one of the specified security groups doesn't exist in the subnet's virtual private cloud
     *         (VPC).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.ModifyMountTargetSecurityGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ModifyMountTargetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroups(
            ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) throws BadRequestException,
            InternalServerErrorException, MountTargetNotFoundException, IncorrectMountTargetStateException,
            SecurityGroupLimitExceededException, SecurityGroupNotFoundException, AwsServiceException, SdkClientException,
            EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the set of security groups in effect for a mount target.
     * </p>
     * <p>
     * When you create a mount target, Amazon EFS also creates a new network interface. For more information, see
     * <a>CreateMountTarget</a>. This operation replaces the security groups in effect for the network interface
     * associated with a mount target, with the <code>SecurityGroups</code> provided in the request. This operation
     * requires that the network interface of the mount target has been created and the lifecycle state of the mount
     * target is not <code>deleted</code>.
     * </p>
     * <p>
     * The operation requires permissions for the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>elasticfilesystem:ModifyMountTargetSecurityGroups</code> action on the mount target's file system.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:ModifyNetworkInterfaceAttribute</code> action on the mount target's network interface.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyMountTargetSecurityGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyMountTargetSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param modifyMountTargetSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ModifyMountTargetSecurityGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the ModifyMountTargetSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws MountTargetNotFoundException
     *         Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services
     *         account.
     * @throws IncorrectMountTargetStateException
     *         Returned if the mount target is not in the correct state for the operation.
     * @throws SecurityGroupLimitExceededException
     *         Returned if the size of <code>SecurityGroups</code> specified in the request is greater than five.
     * @throws SecurityGroupNotFoundException
     *         Returned if one of the specified security groups doesn't exist in the subnet's virtual private cloud
     *         (VPC).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.ModifyMountTargetSecurityGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ModifyMountTargetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyMountTargetSecurityGroupsResponse modifyMountTargetSecurityGroups(
            Consumer<ModifyMountTargetSecurityGroupsRequest.Builder> modifyMountTargetSecurityGroupsRequest)
            throws BadRequestException, InternalServerErrorException, MountTargetNotFoundException,
            IncorrectMountTargetStateException, SecurityGroupLimitExceededException, SecurityGroupNotFoundException,
            AwsServiceException, SdkClientException, EfsException {
        return modifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest.builder()
                .applyMutation(modifyMountTargetSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Use this operation to set the account preference in the current Amazon Web Services Region to use long 17
     * character (63 bit) or short 8 character (32 bit) resource IDs for new EFS file system and mount target resources.
     * All existing resource IDs are not affected by any changes you make. You can set the ID preference during the
     * opt-in period as EFS transitions to long resource IDs. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/manage-efs-resource-ids.html">Managing Amazon EFS resource
     * IDs</a>.
     * </p>
     * <note>
     * <p>
     * Starting in October, 2021, you will receive an error if you try to set the account preference to use the short 8
     * character format resource ID. Contact Amazon Web Services support if you receive an error and must use short IDs
     * for file system and mount target resources.
     * </p>
     * </note>
     *
     * @param putAccountPreferencesRequest
     * @return Result of the PutAccountPreferences operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.PutAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAccountPreferencesResponse putAccountPreferences(PutAccountPreferencesRequest putAccountPreferencesRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to set the account preference in the current Amazon Web Services Region to use long 17
     * character (63 bit) or short 8 character (32 bit) resource IDs for new EFS file system and mount target resources.
     * All existing resource IDs are not affected by any changes you make. You can set the ID preference during the
     * opt-in period as EFS transitions to long resource IDs. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/manage-efs-resource-ids.html">Managing Amazon EFS resource
     * IDs</a>.
     * </p>
     * <note>
     * <p>
     * Starting in October, 2021, you will receive an error if you try to set the account preference to use the short 8
     * character format resource ID. Contact Amazon Web Services support if you receive an error and must use short IDs
     * for file system and mount target resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountPreferencesRequest.Builder} avoiding the
     * need to create one manually via {@link PutAccountPreferencesRequest#builder()}
     * </p>
     *
     * @param putAccountPreferencesRequest
     *        A {@link Consumer} that will call methods on {@link PutAccountPreferencesRequest.Builder} to create a
     *        request.
     * @return Result of the PutAccountPreferences operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.PutAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAccountPreferencesResponse putAccountPreferences(
            Consumer<PutAccountPreferencesRequest.Builder> putAccountPreferencesRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, EfsException {
        return putAccountPreferences(PutAccountPreferencesRequest.builder().applyMutation(putAccountPreferencesRequest).build());
    }

    /**
     * <p>
     * Updates the file system's backup policy. Use this action to start or stop automatic backups of the file system.
     * </p>
     *
     * @param putBackupPolicyRequest
     * @return Result of the PutBackupPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws ValidationException
     *         Returned if the Backup service is not available in the Amazon Web Services Region in which the request
     *         was made.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.PutBackupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutBackupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupPolicyResponse putBackupPolicy(PutBackupPolicyRequest putBackupPolicyRequest) throws BadRequestException,
            FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException, InternalServerErrorException,
            ValidationException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the file system's backup policy. Use this action to start or stop automatic backups of the file system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBackupPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutBackupPolicyRequest#builder()}
     * </p>
     *
     * @param putBackupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutBackupPolicyRequest.Builder} to create a request.
     * @return Result of the PutBackupPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws ValidationException
     *         Returned if the Backup service is not available in the Amazon Web Services Region in which the request
     *         was made.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.PutBackupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutBackupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupPolicyResponse putBackupPolicy(Consumer<PutBackupPolicyRequest.Builder> putBackupPolicyRequest)
            throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException,
            InternalServerErrorException, ValidationException, AwsServiceException, SdkClientException, EfsException {
        return putBackupPolicy(PutBackupPolicyRequest.builder().applyMutation(putBackupPolicyRequest).build());
    }

    /**
     * <p>
     * Applies an Amazon EFS <code>FileSystemPolicy</code> to an Amazon EFS file system. A file system policy is an IAM
     * resource-based policy and can contain multiple policy statements. A file system always has exactly one file
     * system policy, which can be the default policy or an explicit policy set or updated using this API operation. EFS
     * file system policies have a 20,000 character limit. When an explicit policy is set, it overrides the default
     * policy. For more information about the default file system policy, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html#default-filesystempolicy">Default
     * EFS File System Policy</a>.
     * </p>
     * <note>
     * <p>
     * EFS file system policies have a 20,000 character limit.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:PutFileSystemPolicy</code> action.
     * </p>
     *
     * @param putFileSystemPolicyRequest
     * @return Result of the PutFileSystemPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws InvalidPolicyException
     *         Returned if the <code>FileSystemPolicy</code> is malformed or contains an error such as a parameter value
     *         that is not valid or a missing required parameter. Returned in the case of a policy lockout safety check
     *         error.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.PutFileSystemPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutFileSystemPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutFileSystemPolicyResponse putFileSystemPolicy(PutFileSystemPolicyRequest putFileSystemPolicyRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, InvalidPolicyException,
            IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies an Amazon EFS <code>FileSystemPolicy</code> to an Amazon EFS file system. A file system policy is an IAM
     * resource-based policy and can contain multiple policy statements. A file system always has exactly one file
     * system policy, which can be the default policy or an explicit policy set or updated using this API operation. EFS
     * file system policies have a 20,000 character limit. When an explicit policy is set, it overrides the default
     * policy. For more information about the default file system policy, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html#default-filesystempolicy">Default
     * EFS File System Policy</a>.
     * </p>
     * <note>
     * <p>
     * EFS file system policies have a 20,000 character limit.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:PutFileSystemPolicy</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFileSystemPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutFileSystemPolicyRequest#builder()}
     * </p>
     *
     * @param putFileSystemPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutFileSystemPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutFileSystemPolicy operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws InvalidPolicyException
     *         Returned if the <code>FileSystemPolicy</code> is malformed or contains an error such as a parameter value
     *         that is not valid or a missing required parameter. Returned in the case of a policy lockout safety check
     *         error.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.PutFileSystemPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutFileSystemPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutFileSystemPolicyResponse putFileSystemPolicy(
            Consumer<PutFileSystemPolicyRequest.Builder> putFileSystemPolicyRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, InvalidPolicyException,
            IncorrectFileSystemLifeCycleStateException, AwsServiceException, SdkClientException, EfsException {
        return putFileSystemPolicy(PutFileSystemPolicyRequest.builder().applyMutation(putFileSystemPolicyRequest).build());
    }

    /**
     * <p>
     * Use this action to manage EFS lifecycle management and EFS Intelligent-Tiering. A
     * <code>LifecycleConfiguration</code> consists of one or more <code>LifecyclePolicy</code> objects that define the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EFS Lifecycle management</b> - When Amazon EFS automatically transitions files in a file system into the
     * lower-cost EFS Infrequent Access (IA) storage class.
     * </p>
     * <p>
     * To enable EFS Lifecycle management, set the value of <code>TransitionToIA</code> to one of the available options.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EFS Intelligent-Tiering</b> - When Amazon EFS automatically transitions files from IA back into the file
     * system's primary storage class (EFS Standard or EFS One Zone Standard).
     * </p>
     * <p>
     * To enable EFS Intelligent-Tiering, set the value of <code>TransitionToPrimaryStorageClass</code> to
     * <code>AFTER_1_ACCESS</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html">EFS
     * Lifecycle Management</a>.
     * </p>
     * <p>
     * Each Amazon EFS file system supports one lifecycle configuration, which applies to all files in the file system.
     * If a <code>LifecycleConfiguration</code> object already exists for the specified file system, a
     * <code>PutLifecycleConfiguration</code> call modifies the existing configuration. A
     * <code>PutLifecycleConfiguration</code> call with an empty <code>LifecyclePolicies</code> array in the request
     * body deletes any existing <code>LifecycleConfiguration</code> and turns off lifecycle management and EFS
     * Intelligent-Tiering for the file system.
     * </p>
     * <p>
     * In the request, specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The ID for the file system for which you are enabling, disabling, or modifying lifecycle management and EFS
     * Intelligent-Tiering.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>LifecyclePolicies</code> array of <code>LifecyclePolicy</code> objects that define when files are moved
     * into IA storage, and when they are moved back to Standard storage.
     * </p>
     * <note>
     * <p>
     * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only have a single transition, so the
     * <code>LifecyclePolicies</code> array needs to be structured with separate <code>LifecyclePolicy</code> objects.
     * See the example requests in the following section for more information.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:PutLifecycleConfiguration</code> operation.
     * </p>
     * <p>
     * To apply a <code>LifecycleConfiguration</code> object to an encrypted file system, you need the same Key
     * Management Service permissions as when you created the encrypted file system.
     * </p>
     *
     * @param putLifecycleConfigurationRequest
     * @return Result of the PutLifecycleConfiguration operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.PutLifecycleConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutLifecycleConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutLifecycleConfigurationResponse putLifecycleConfiguration(
            PutLifecycleConfigurationRequest putLifecycleConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException,
            AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this action to manage EFS lifecycle management and EFS Intelligent-Tiering. A
     * <code>LifecycleConfiguration</code> consists of one or more <code>LifecyclePolicy</code> objects that define the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>EFS Lifecycle management</b> - When Amazon EFS automatically transitions files in a file system into the
     * lower-cost EFS Infrequent Access (IA) storage class.
     * </p>
     * <p>
     * To enable EFS Lifecycle management, set the value of <code>TransitionToIA</code> to one of the available options.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EFS Intelligent-Tiering</b> - When Amazon EFS automatically transitions files from IA back into the file
     * system's primary storage class (EFS Standard or EFS One Zone Standard).
     * </p>
     * <p>
     * To enable EFS Intelligent-Tiering, set the value of <code>TransitionToPrimaryStorageClass</code> to
     * <code>AFTER_1_ACCESS</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html">EFS
     * Lifecycle Management</a>.
     * </p>
     * <p>
     * Each Amazon EFS file system supports one lifecycle configuration, which applies to all files in the file system.
     * If a <code>LifecycleConfiguration</code> object already exists for the specified file system, a
     * <code>PutLifecycleConfiguration</code> call modifies the existing configuration. A
     * <code>PutLifecycleConfiguration</code> call with an empty <code>LifecyclePolicies</code> array in the request
     * body deletes any existing <code>LifecycleConfiguration</code> and turns off lifecycle management and EFS
     * Intelligent-Tiering for the file system.
     * </p>
     * <p>
     * In the request, specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The ID for the file system for which you are enabling, disabling, or modifying lifecycle management and EFS
     * Intelligent-Tiering.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>LifecyclePolicies</code> array of <code>LifecyclePolicy</code> objects that define when files are moved
     * into IA storage, and when they are moved back to Standard storage.
     * </p>
     * <note>
     * <p>
     * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only have a single transition, so the
     * <code>LifecyclePolicies</code> array needs to be structured with separate <code>LifecyclePolicy</code> objects.
     * See the example requests in the following section for more information.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:PutLifecycleConfiguration</code> operation.
     * </p>
     * <p>
     * To apply a <code>LifecycleConfiguration</code> object to an encrypted file system, you need the same Key
     * Management Service permissions as when you created the encrypted file system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLifecycleConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutLifecycleConfigurationRequest#builder()}
     * </p>
     *
     * @param putLifecycleConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutLifecycleConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the PutLifecycleConfiguration operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.PutLifecycleConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutLifecycleConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutLifecycleConfigurationResponse putLifecycleConfiguration(
            Consumer<PutLifecycleConfigurationRequest.Builder> putLifecycleConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException,
            AwsServiceException, SdkClientException, EfsException {
        return putLifecycleConfiguration(PutLifecycleConfigurationRequest.builder()
                .applyMutation(putLifecycleConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a tag for an EFS resource. You can create tags for EFS file systems and access points using this API
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:TagResource</code> action.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a tag for an EFS resource. You can create tags for EFS file systems and access points using this API
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:TagResource</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an EFS resource. You can remove tags from EFS file systems and access points using this API
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:UntagResource</code> action.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException, AwsServiceException,
            SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an EFS resource. You can remove tags from EFS file systems and access points using this API
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>elasticfilesystem:UntagResource</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws AccessPointNotFoundException
     *         Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, InternalServerErrorException, FileSystemNotFoundException, AccessPointNotFoundException,
            AwsServiceException, SdkClientException, EfsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the throughput mode or the amount of provisioned throughput of an existing file system.
     * </p>
     *
     * @param updateFileSystemRequest
     * @return Result of the UpdateFileSystem operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws InsufficientThroughputCapacityException
     *         Returned if there's not enough capacity to provision additional throughput. This value might be returned
     *         when you try to create a file system in provisioned throughput mode, when you attempt to increase the
     *         provisioned throughput of an existing file system, or when you attempt to change an existing file system
     *         from Bursting Throughput to Provisioned Throughput mode. Try again later.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws ThroughputLimitExceededException
     *         Returned if the throughput mode or amount of provisioned throughput can't be changed because the
     *         throughput limit of 1024 MiB/s has been reached.
     * @throws TooManyRequestsException
     *         Returned if you don’t wait at least 24 hours before either changing the throughput mode, or decreasing
     *         the Provisioned Throughput value.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.UpdateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/UpdateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFileSystemResponse updateFileSystem(UpdateFileSystemRequest updateFileSystemRequest)
            throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException,
            InsufficientThroughputCapacityException, InternalServerErrorException, ThroughputLimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, EfsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the throughput mode or the amount of provisioned throughput of an existing file system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFileSystemRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFileSystemRequest#builder()}
     * </p>
     *
     * @param updateFileSystemRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFileSystemRequest.Builder} to create a request.
     * @return Result of the UpdateFileSystem operation returned by the service.
     * @throws BadRequestException
     *         Returned if the request is malformed or contains an error such as an invalid parameter value or a missing
     *         required parameter.
     * @throws FileSystemNotFoundException
     *         Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web
     *         Services account.
     * @throws IncorrectFileSystemLifeCycleStateException
     *         Returned if the file system's lifecycle state is not "available".
     * @throws InsufficientThroughputCapacityException
     *         Returned if there's not enough capacity to provision additional throughput. This value might be returned
     *         when you try to create a file system in provisioned throughput mode, when you attempt to increase the
     *         provisioned throughput of an existing file system, or when you attempt to change an existing file system
     *         from Bursting Throughput to Provisioned Throughput mode. Try again later.
     * @throws InternalServerErrorException
     *         Returned if an error occurred on the server side.
     * @throws ThroughputLimitExceededException
     *         Returned if the throughput mode or amount of provisioned throughput can't be changed because the
     *         throughput limit of 1024 MiB/s has been reached.
     * @throws TooManyRequestsException
     *         Returned if you don’t wait at least 24 hours before either changing the throughput mode, or decreasing
     *         the Provisioned Throughput value.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EfsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EfsClient.UpdateFileSystem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/UpdateFileSystem"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFileSystemResponse updateFileSystem(Consumer<UpdateFileSystemRequest.Builder> updateFileSystemRequest)
            throws BadRequestException, FileSystemNotFoundException, IncorrectFileSystemLifeCycleStateException,
            InsufficientThroughputCapacityException, InternalServerErrorException, ThroughputLimitExceededException,
            TooManyRequestsException, AwsServiceException, SdkClientException, EfsException {
        return updateFileSystem(UpdateFileSystemRequest.builder().applyMutation(updateFileSystemRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
