/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMountTargetsResponse extends EfsResponse implements
        ToCopyableBuilder<DescribeMountTargetsResponse.Builder, DescribeMountTargetsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMountTargetsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<MountTargetDescription>> MOUNT_TARGETS_FIELD = SdkField
            .<List<MountTargetDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeMountTargetsResponse::mountTargets))
            .setter(setter(Builder::mountTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MountTargetDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(MountTargetDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMountTargetsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            MOUNT_TARGETS_FIELD, NEXT_MARKER_FIELD));

    private final String marker;

    private final List<MountTargetDescription> mountTargets;

    private final String nextMarker;

    private DescribeMountTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.mountTargets = builder.mountTargets;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * If the request included the <code>Marker</code>, the response returns that value in this field.
     * </p>
     * 
     * @return If the request included the <code>Marker</code>, the response returns that value in this field.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
     */
    public List<MountTargetDescription> mountTargets() {
        return mountTargets;
    }

    /**
     * <p>
     * If a value is present, there are more mount targets to return. In a subsequent request, you can provide
     * <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
     * </p>
     * 
     * @return If a value is present, there are more mount targets to return. In a subsequent request, you can provide
     *         <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(mountTargets());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsResponse)) {
            return false;
        }
        DescribeMountTargetsResponse other = (DescribeMountTargetsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(mountTargets(), other.mountTargets())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMountTargetsResponse").add("Marker", marker()).add("MountTargets", mountTargets())
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MountTargets":
            return Optional.ofNullable(clazz.cast(mountTargets()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMountTargetsResponse, T> g) {
        return obj -> g.apply((DescribeMountTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMountTargetsResponse> {
        /**
         * <p>
         * If the request included the <code>Marker</code>, the response returns that value in this field.
         * </p>
         * 
         * @param marker
         *        If the request included the <code>Marker</code>, the response returns that value in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * </p>
         * 
         * @param mountTargets
         *        Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargets(Collection<MountTargetDescription> mountTargets);

        /**
         * <p>
         * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * </p>
         * 
         * @param mountTargets
         *        Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargets(MountTargetDescription... mountTargets);

        /**
         * <p>
         * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MountTargetDescription>.Builder} avoiding
         * the need to create one manually via {@link List<MountTargetDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MountTargetDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #mountTargets(List<MountTargetDescription>)}.
         * 
         * @param mountTargets
         *        a consumer that will call methods on {@link List<MountTargetDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountTargets(List<MountTargetDescription>)
         */
        Builder mountTargets(Consumer<MountTargetDescription.Builder>... mountTargets);

        /**
         * <p>
         * If a value is present, there are more mount targets to return. In a subsequent request, you can provide
         * <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
         * </p>
         * 
         * @param nextMarker
         *        If a value is present, there are more mount targets to return. In a subsequent request, you can
         *        provide <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<MountTargetDescription> mountTargets = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsResponse model) {
            super(model);
            marker(model.marker);
            mountTargets(model.mountTargets);
            nextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<MountTargetDescription.Builder> getMountTargets() {
            return mountTargets != null ? mountTargets.stream().map(MountTargetDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mountTargets(Collection<MountTargetDescription> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copy(mountTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountTargets(MountTargetDescription... mountTargets) {
            mountTargets(Arrays.asList(mountTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountTargets(Consumer<MountTargetDescription.Builder>... mountTargets) {
            mountTargets(Stream.of(mountTargets).map(c -> MountTargetDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMountTargets(Collection<MountTargetDescription.BuilderImpl> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copyFromBuilder(mountTargets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeMountTargetsResponse build() {
            return new DescribeMountTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
