/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFileSystemsResponse extends EfsResponse implements
        ToCopyableBuilder<DescribeFileSystemsResponse.Builder, DescribeFileSystemsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeFileSystemsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<FileSystemDescription>> FILE_SYSTEMS_FIELD = SdkField
            .<List<FileSystemDescription>> builder(MarshallingType.LIST)
            .memberName("FileSystems")
            .getter(getter(DescribeFileSystemsResponse::fileSystems))
            .setter(setter(Builder::fileSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(DescribeFileSystemsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            FILE_SYSTEMS_FIELD, NEXT_MARKER_FIELD));

    private final String marker;

    private final List<FileSystemDescription> fileSystems;

    private final String nextMarker;

    private DescribeFileSystemsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.fileSystems = builder.fileSystems;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * Present if provided by caller in the request (String).
     * </p>
     * 
     * @return Present if provided by caller in the request (String).
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileSystems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileSystems() {
        return fileSystems != null && !(fileSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of file system descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileSystems} method.
     * </p>
     * 
     * @return An array of file system descriptions.
     */
    public final List<FileSystemDescription> fileSystems() {
        return fileSystems;
    }

    /**
     * <p>
     * Present if there are more file systems than returned in the response (String). You can use the
     * <code>NextMarker</code> in the subsequent request to fetch the descriptions.
     * </p>
     * 
     * @return Present if there are more file systems than returned in the response (String). You can use the
     *         <code>NextMarker</code> in the subsequent request to fetch the descriptions.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystems() ? fileSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResponse)) {
            return false;
        }
        DescribeFileSystemsResponse other = (DescribeFileSystemsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasFileSystems() == other.hasFileSystems()
                && Objects.equals(fileSystems(), other.fileSystems()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFileSystemsResponse").add("Marker", marker())
                .add("FileSystems", hasFileSystems() ? fileSystems() : null).add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "FileSystems":
            return Optional.ofNullable(clazz.cast(fileSystems()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemsResponse, T> g) {
        return obj -> g.apply((DescribeFileSystemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFileSystemsResponse> {
        /**
         * <p>
         * Present if provided by caller in the request (String).
         * </p>
         * 
         * @param marker
         *        Present if provided by caller in the request (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * An array of file system descriptions.
         * </p>
         * 
         * @param fileSystems
         *        An array of file system descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystems(Collection<FileSystemDescription> fileSystems);

        /**
         * <p>
         * An array of file system descriptions.
         * </p>
         * 
         * @param fileSystems
         *        An array of file system descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystems(FileSystemDescription... fileSystems);

        /**
         * <p>
         * An array of file system descriptions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.efs.model.FileSystemDescription.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.efs.model.FileSystemDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.efs.model.FileSystemDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #fileSystems(List<FileSystemDescription>)}.
         * 
         * @param fileSystems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.efs.model.FileSystemDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystems(java.util.Collection<FileSystemDescription>)
         */
        Builder fileSystems(Consumer<FileSystemDescription.Builder>... fileSystems);

        /**
         * <p>
         * Present if there are more file systems than returned in the response (String). You can use the
         * <code>NextMarker</code> in the subsequent request to fetch the descriptions.
         * </p>
         * 
         * @param nextMarker
         *        Present if there are more file systems than returned in the response (String). You can use the
         *        <code>NextMarker</code> in the subsequent request to fetch the descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<FileSystemDescription> fileSystems = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsResponse model) {
            super(model);
            marker(model.marker);
            fileSystems(model.fileSystems);
            nextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<FileSystemDescription.Builder> getFileSystems() {
            List<FileSystemDescription.Builder> result = FileSystemDescriptionsCopier.copyToBuilder(this.fileSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystems(Collection<FileSystemDescription.BuilderImpl> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copyFromBuilder(fileSystems);
        }

        @Override
        public final Builder fileSystems(Collection<FileSystemDescription> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copy(fileSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(FileSystemDescription... fileSystems) {
            fileSystems(Arrays.asList(fileSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(Consumer<FileSystemDescription.Builder>... fileSystems) {
            fileSystems(Stream.of(fileSystems).map(c -> FileSystemDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public DescribeFileSystemsResponse build() {
            return new DescribeFileSystemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
