/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the replication configuration for a specific file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationConfigurationDescription.Builder, ReplicationConfigurationDescription> {
    private static final SdkField<String> SOURCE_FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFileSystemId").getter(getter(ReplicationConfigurationDescription::sourceFileSystemId))
            .setter(setter(Builder::sourceFileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemId").build())
            .build();

    private static final SdkField<String> SOURCE_FILE_SYSTEM_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFileSystemRegion").getter(getter(ReplicationConfigurationDescription::sourceFileSystemRegion))
            .setter(setter(Builder::sourceFileSystemRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemRegion").build())
            .build();

    private static final SdkField<String> SOURCE_FILE_SYSTEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFileSystemArn").getter(getter(ReplicationConfigurationDescription::sourceFileSystemArn))
            .setter(setter(Builder::sourceFileSystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileSystemArn").build())
            .build();

    private static final SdkField<String> ORIGINAL_SOURCE_FILE_SYSTEM_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OriginalSourceFileSystemArn")
            .getter(getter(ReplicationConfigurationDescription::originalSourceFileSystemArn))
            .setter(setter(Builder::originalSourceFileSystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalSourceFileSystemArn")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ReplicationConfigurationDescription::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<List<Destination>> DESTINATIONS_FIELD = SdkField
            .<List<Destination>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(ReplicationConfigurationDescription::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Destination> builder(MarshallingType.SDK_POJO)
                                            .constructor(Destination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FILE_SYSTEM_ID_FIELD,
            SOURCE_FILE_SYSTEM_REGION_FIELD, SOURCE_FILE_SYSTEM_ARN_FIELD, ORIGINAL_SOURCE_FILE_SYSTEM_ARN_FIELD,
            CREATION_TIME_FIELD, DESTINATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceFileSystemId;

    private final String sourceFileSystemRegion;

    private final String sourceFileSystemArn;

    private final String originalSourceFileSystemArn;

    private final Instant creationTime;

    private final List<Destination> destinations;

    private ReplicationConfigurationDescription(BuilderImpl builder) {
        this.sourceFileSystemId = builder.sourceFileSystemId;
        this.sourceFileSystemRegion = builder.sourceFileSystemRegion;
        this.sourceFileSystemArn = builder.sourceFileSystemArn;
        this.originalSourceFileSystemArn = builder.originalSourceFileSystemArn;
        this.creationTime = builder.creationTime;
        this.destinations = builder.destinations;
    }

    /**
     * <p>
     * The ID of the source Amazon EFS file system that is being replicated.
     * </p>
     * 
     * @return The ID of the source Amazon EFS file system that is being replicated.
     */
    public final String sourceFileSystemId() {
        return sourceFileSystemId;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which the source EFS file system is located.
     * </p>
     * 
     * @return The Amazon Web Services Region in which the source EFS file system is located.
     */
    public final String sourceFileSystemRegion() {
        return sourceFileSystemRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the current source file system in the replication configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the current source file system in the replication configuration.
     */
    public final String sourceFileSystemArn() {
        return sourceFileSystemArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the original source EFS file system in the replication configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the original source EFS file system in the replication configuration.
     */
    public final String originalSourceFileSystemArn() {
        return originalSourceFileSystemArn;
    }

    /**
     * <p>
     * Describes when the replication configuration was created.
     * </p>
     * 
     * @return Describes when the replication configuration was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of destination objects. Only one destination object is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return An array of destination objects. Only one destination object is supported.
     */
    public final List<Destination> destinations() {
        return destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileSystemRegion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(originalSourceFileSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfigurationDescription)) {
            return false;
        }
        ReplicationConfigurationDescription other = (ReplicationConfigurationDescription) obj;
        return Objects.equals(sourceFileSystemId(), other.sourceFileSystemId())
                && Objects.equals(sourceFileSystemRegion(), other.sourceFileSystemRegion())
                && Objects.equals(sourceFileSystemArn(), other.sourceFileSystemArn())
                && Objects.equals(originalSourceFileSystemArn(), other.originalSourceFileSystemArn())
                && Objects.equals(creationTime(), other.creationTime()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationConfigurationDescription").add("SourceFileSystemId", sourceFileSystemId())
                .add("SourceFileSystemRegion", sourceFileSystemRegion()).add("SourceFileSystemArn", sourceFileSystemArn())
                .add("OriginalSourceFileSystemArn", originalSourceFileSystemArn()).add("CreationTime", creationTime())
                .add("Destinations", hasDestinations() ? destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceFileSystemId":
            return Optional.ofNullable(clazz.cast(sourceFileSystemId()));
        case "SourceFileSystemRegion":
            return Optional.ofNullable(clazz.cast(sourceFileSystemRegion()));
        case "SourceFileSystemArn":
            return Optional.ofNullable(clazz.cast(sourceFileSystemArn()));
        case "OriginalSourceFileSystemArn":
            return Optional.ofNullable(clazz.cast(originalSourceFileSystemArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationConfigurationDescription, T> g) {
        return obj -> g.apply((ReplicationConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationConfigurationDescription> {
        /**
         * <p>
         * The ID of the source Amazon EFS file system that is being replicated.
         * </p>
         * 
         * @param sourceFileSystemId
         *        The ID of the source Amazon EFS file system that is being replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFileSystemId(String sourceFileSystemId);

        /**
         * <p>
         * The Amazon Web Services Region in which the source EFS file system is located.
         * </p>
         * 
         * @param sourceFileSystemRegion
         *        The Amazon Web Services Region in which the source EFS file system is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFileSystemRegion(String sourceFileSystemRegion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the current source file system in the replication configuration.
         * </p>
         * 
         * @param sourceFileSystemArn
         *        The Amazon Resource Name (ARN) of the current source file system in the replication configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFileSystemArn(String sourceFileSystemArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the original source EFS file system in the replication configuration.
         * </p>
         * 
         * @param originalSourceFileSystemArn
         *        The Amazon Resource Name (ARN) of the original source EFS file system in the replication
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalSourceFileSystemArn(String originalSourceFileSystemArn);

        /**
         * <p>
         * Describes when the replication configuration was created.
         * </p>
         * 
         * @param creationTime
         *        Describes when the replication configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * An array of destination objects. Only one destination object is supported.
         * </p>
         * 
         * @param destinations
         *        An array of destination objects. Only one destination object is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<Destination> destinations);

        /**
         * <p>
         * An array of destination objects. Only one destination object is supported.
         * </p>
         * 
         * @param destinations
         *        An array of destination objects. Only one destination object is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Destination... destinations);

        /**
         * <p>
         * An array of destination objects. Only one destination object is supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.efs.model.Destination.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.efs.model.Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.efs.model.Destination.Builder#build()} is called immediately and its
         * result is passed to {@link #destinations(List<Destination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.efs.model.Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<Destination>)
         */
        Builder destinations(Consumer<Destination.Builder>... destinations);
    }

    static final class BuilderImpl implements Builder {
        private String sourceFileSystemId;

        private String sourceFileSystemRegion;

        private String sourceFileSystemArn;

        private String originalSourceFileSystemArn;

        private Instant creationTime;

        private List<Destination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfigurationDescription model) {
            sourceFileSystemId(model.sourceFileSystemId);
            sourceFileSystemRegion(model.sourceFileSystemRegion);
            sourceFileSystemArn(model.sourceFileSystemArn);
            originalSourceFileSystemArn(model.originalSourceFileSystemArn);
            creationTime(model.creationTime);
            destinations(model.destinations);
        }

        public final String getSourceFileSystemId() {
            return sourceFileSystemId;
        }

        public final void setSourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
        }

        @Override
        public final Builder sourceFileSystemId(String sourceFileSystemId) {
            this.sourceFileSystemId = sourceFileSystemId;
            return this;
        }

        public final String getSourceFileSystemRegion() {
            return sourceFileSystemRegion;
        }

        public final void setSourceFileSystemRegion(String sourceFileSystemRegion) {
            this.sourceFileSystemRegion = sourceFileSystemRegion;
        }

        @Override
        public final Builder sourceFileSystemRegion(String sourceFileSystemRegion) {
            this.sourceFileSystemRegion = sourceFileSystemRegion;
            return this;
        }

        public final String getSourceFileSystemArn() {
            return sourceFileSystemArn;
        }

        public final void setSourceFileSystemArn(String sourceFileSystemArn) {
            this.sourceFileSystemArn = sourceFileSystemArn;
        }

        @Override
        public final Builder sourceFileSystemArn(String sourceFileSystemArn) {
            this.sourceFileSystemArn = sourceFileSystemArn;
            return this;
        }

        public final String getOriginalSourceFileSystemArn() {
            return originalSourceFileSystemArn;
        }

        public final void setOriginalSourceFileSystemArn(String originalSourceFileSystemArn) {
            this.originalSourceFileSystemArn = originalSourceFileSystemArn;
        }

        @Override
        public final Builder originalSourceFileSystemArn(String originalSourceFileSystemArn) {
            this.originalSourceFileSystemArn = originalSourceFileSystemArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Destination.Builder> getDestinations() {
            List<Destination.Builder> result = DestinationsCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<Destination.BuilderImpl> destinations) {
            this.destinations = DestinationsCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Destination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<Destination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> Destination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReplicationConfigurationDescription build() {
            return new ReplicationConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
