/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFileSystemsResponse extends EfsResponse implements
        ToCopyableBuilder<DescribeFileSystemsResponse.Builder, DescribeFileSystemsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFileSystemsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<FileSystemDescription>> FILE_SYSTEMS_FIELD = SdkField
            .<List<FileSystemDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeFileSystemsResponse::fileSystems))
            .setter(setter(Builder::fileSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFileSystemsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            FILE_SYSTEMS_FIELD, NEXT_MARKER_FIELD));

    private final String marker;

    private final List<FileSystemDescription> fileSystems;

    private final String nextMarker;

    private DescribeFileSystemsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.fileSystems = builder.fileSystems;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * Present if provided by caller in the request (String).
     * </p>
     * 
     * @return Present if provided by caller in the request (String).
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Array of file system descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of file system descriptions.
     */
    public List<FileSystemDescription> fileSystems() {
        return fileSystems;
    }

    /**
     * <p>
     * Present if there are more file systems than returned in the response (String). You can use the
     * <code>NextMarker</code> in the subsequent request to fetch the descriptions.
     * </p>
     * 
     * @return Present if there are more file systems than returned in the response (String). You can use the
     *         <code>NextMarker</code> in the subsequent request to fetch the descriptions.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystems());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResponse)) {
            return false;
        }
        DescribeFileSystemsResponse other = (DescribeFileSystemsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(fileSystems(), other.fileSystems())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeFileSystemsResponse").add("Marker", marker()).add("FileSystems", fileSystems())
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "FileSystems":
            return Optional.ofNullable(clazz.cast(fileSystems()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemsResponse, T> g) {
        return obj -> g.apply((DescribeFileSystemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFileSystemsResponse> {
        /**
         * <p>
         * Present if provided by caller in the request (String).
         * </p>
         * 
         * @param marker
         *        Present if provided by caller in the request (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Array of file system descriptions.
         * </p>
         * 
         * @param fileSystems
         *        Array of file system descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystems(Collection<FileSystemDescription> fileSystems);

        /**
         * <p>
         * Array of file system descriptions.
         * </p>
         * 
         * @param fileSystems
         *        Array of file system descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystems(FileSystemDescription... fileSystems);

        /**
         * <p>
         * Array of file system descriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FileSystemDescription>.Builder} avoiding
         * the need to create one manually via {@link List<FileSystemDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileSystemDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #fileSystems(List<FileSystemDescription>)}.
         * 
         * @param fileSystems
         *        a consumer that will call methods on {@link List<FileSystemDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystems(List<FileSystemDescription>)
         */
        Builder fileSystems(Consumer<FileSystemDescription.Builder>... fileSystems);

        /**
         * <p>
         * Present if there are more file systems than returned in the response (String). You can use the
         * <code>NextMarker</code> in the subsequent request to fetch the descriptions.
         * </p>
         * 
         * @param nextMarker
         *        Present if there are more file systems than returned in the response (String). You can use the
         *        <code>NextMarker</code> in the subsequent request to fetch the descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<FileSystemDescription> fileSystems = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsResponse model) {
            super(model);
            marker(model.marker);
            fileSystems(model.fileSystems);
            nextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<FileSystemDescription.Builder> getFileSystems() {
            return fileSystems != null ? fileSystems.stream().map(FileSystemDescription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder fileSystems(Collection<FileSystemDescription> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copy(fileSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(FileSystemDescription... fileSystems) {
            fileSystems(Arrays.asList(fileSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(Consumer<FileSystemDescription.Builder>... fileSystems) {
            fileSystems(Stream.of(fileSystems).map(c -> FileSystemDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystems(Collection<FileSystemDescription.BuilderImpl> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copyFromBuilder(fileSystems);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeFileSystemsResponse build() {
            return new DescribeFileSystemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
