/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFileSystemsRequest extends EfsRequest implements
        ToCopyableBuilder<DescribeFileSystemsRequest.Builder, DescribeFileSystemsRequest> {
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(DescribeFileSystemsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeFileSystemsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<String> CREATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationToken").getter(getter(DescribeFileSystemsRequest::creationToken))
            .setter(setter(Builder::creationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CreationToken").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(DescribeFileSystemsRequest::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FileSystemId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ITEMS_FIELD, MARKER_FIELD,
            CREATION_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxItems;

    private final String marker;

    private final String creationToken;

    private final String fileSystemId;

    private DescribeFileSystemsRequest(BuilderImpl builder) {
        super(builder);
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
    }

    /**
     * <p>
     * (Optional) Specifies the maximum number of file systems to return in the response (integer). This number is
     * automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems.
     * </p>
     * 
     * @return (Optional) Specifies the maximum number of file systems to return in the response (integer). This number
     *         is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file
     *         systems.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String).
     * If present, specifies to continue the list from where the returning call had left off.
     * </p>
     * 
     * @return (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation
     *         (String). If present, specifies to continue the list from where the returning call had left off.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * (Optional) Restricts the list to the file system with this creation token (String). You specify a creation token
     * when you create an Amazon EFS file system.
     * </p>
     * 
     * @return (Optional) Restricts the list to the file system with this creation token (String). You specify a
     *         creation token when you create an Amazon EFS file system.
     */
    public final String creationToken() {
        return creationToken;
    }

    /**
     * <p>
     * (Optional) ID of the file system whose description you want to retrieve (String).
     * </p>
     * 
     * @return (Optional) ID of the file system whose description you want to retrieve (String).
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsRequest)) {
            return false;
        }
        DescribeFileSystemsRequest other = (DescribeFileSystemsRequest) obj;
        return Objects.equals(maxItems(), other.maxItems()) && Objects.equals(marker(), other.marker())
                && Objects.equals(creationToken(), other.creationToken()) && Objects.equals(fileSystemId(), other.fileSystemId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFileSystemsRequest").add("MaxItems", maxItems()).add("Marker", marker())
                .add("CreationToken", creationToken()).add("FileSystemId", fileSystemId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "CreationToken":
            return Optional.ofNullable(clazz.cast(creationToken()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("CreationToken", CREATION_TOKEN_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemsRequest, T> g) {
        return obj -> g.apply((DescribeFileSystemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFileSystemsRequest> {
        /**
         * <p>
         * (Optional) Specifies the maximum number of file systems to return in the response (integer). This number is
         * automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems.
         * </p>
         * 
         * @param maxItems
         *        (Optional) Specifies the maximum number of file systems to return in the response (integer). This
         *        number is automatically set to 100. The response is paginated at 100 per page if you have more than
         *        100 file systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation
         * (String). If present, specifies to continue the list from where the returning call had left off.
         * </p>
         * 
         * @param marker
         *        (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation
         *        (String). If present, specifies to continue the list from where the returning call had left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * (Optional) Restricts the list to the file system with this creation token (String). You specify a creation
         * token when you create an Amazon EFS file system.
         * </p>
         * 
         * @param creationToken
         *        (Optional) Restricts the list to the file system with this creation token (String). You specify a
         *        creation token when you create an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationToken(String creationToken);

        /**
         * <p>
         * (Optional) ID of the file system whose description you want to retrieve (String).
         * </p>
         * 
         * @param fileSystemId
         *        (Optional) ID of the file system whose description you want to retrieve (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private Integer maxItems;

        private String marker;

        private String creationToken;

        private String fileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsRequest model) {
            super(model);
            maxItems(model.maxItems);
            marker(model.marker);
            creationToken(model.creationToken);
            fileSystemId(model.fileSystemId);
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getCreationToken() {
            return creationToken;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFileSystemsRequest build() {
            return new DescribeFileSystemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
