/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBackupPolicyRequest extends EfsRequest implements
        ToCopyableBuilder<PutBackupPolicyRequest.Builder, PutBackupPolicyRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(PutBackupPolicyRequest::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileSystemId").build()).build();

    private static final SdkField<BackupPolicy> BACKUP_POLICY_FIELD = SdkField.<BackupPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("BackupPolicy").getter(getter(PutBackupPolicyRequest::backupPolicy))
            .setter(setter(Builder::backupPolicy)).constructor(BackupPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            BACKUP_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileSystemId;

    private final BackupPolicy backupPolicy;

    private PutBackupPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.backupPolicy = builder.backupPolicy;
    }

    /**
     * <p>
     * Specifies which EFS file system to update the backup policy for.
     * </p>
     * 
     * @return Specifies which EFS file system to update the backup policy for.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The backup policy included in the <code>PutBackupPolicy</code> request.
     * </p>
     * 
     * @return The backup policy included in the <code>PutBackupPolicy</code> request.
     */
    public final BackupPolicy backupPolicy() {
        return backupPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(backupPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBackupPolicyRequest)) {
            return false;
        }
        PutBackupPolicyRequest other = (PutBackupPolicyRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(backupPolicy(), other.backupPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutBackupPolicyRequest").add("FileSystemId", fileSystemId()).add("BackupPolicy", backupPolicy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "BackupPolicy":
            return Optional.ofNullable(clazz.cast(backupPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("BackupPolicy", BACKUP_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutBackupPolicyRequest, T> g) {
        return obj -> g.apply((PutBackupPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutBackupPolicyRequest> {
        /**
         * <p>
         * Specifies which EFS file system to update the backup policy for.
         * </p>
         * 
         * @param fileSystemId
         *        Specifies which EFS file system to update the backup policy for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The backup policy included in the <code>PutBackupPolicy</code> request.
         * </p>
         * 
         * @param backupPolicy
         *        The backup policy included in the <code>PutBackupPolicy</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPolicy(BackupPolicy backupPolicy);

        /**
         * <p>
         * The backup policy included in the <code>PutBackupPolicy</code> request.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackupPolicy.Builder} avoiding the need
         * to create one manually via {@link BackupPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackupPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #backupPolicy(BackupPolicy)}.
         * 
         * @param backupPolicy
         *        a consumer that will call methods on {@link BackupPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPolicy(BackupPolicy)
         */
        default Builder backupPolicy(Consumer<BackupPolicy.Builder> backupPolicy) {
            return backupPolicy(BackupPolicy.builder().applyMutation(backupPolicy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private String fileSystemId;

        private BackupPolicy backupPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBackupPolicyRequest model) {
            super(model);
            fileSystemId(model.fileSystemId);
            backupPolicy(model.backupPolicy);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final BackupPolicy.Builder getBackupPolicy() {
            return backupPolicy != null ? backupPolicy.toBuilder() : null;
        }

        public final void setBackupPolicy(BackupPolicy.BuilderImpl backupPolicy) {
            this.backupPolicy = backupPolicy != null ? backupPolicy.build() : null;
        }

        @Override
        public final Builder backupPolicy(BackupPolicy backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBackupPolicyRequest build() {
            return new PutBackupPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
