/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessPointRequest extends EfsRequest implements
        ToCopyableBuilder<CreateAccessPointRequest.Builder, CreateAccessPointRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateAccessPointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAccessPointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(CreateAccessPointRequest::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<PosixUser> POSIX_USER_FIELD = SdkField.<PosixUser> builder(MarshallingType.SDK_POJO)
            .memberName("PosixUser").getter(getter(CreateAccessPointRequest::posixUser)).setter(setter(Builder::posixUser))
            .constructor(PosixUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixUser").build()).build();

    private static final SdkField<RootDirectory> ROOT_DIRECTORY_FIELD = SdkField
            .<RootDirectory> builder(MarshallingType.SDK_POJO).memberName("RootDirectory")
            .getter(getter(CreateAccessPointRequest::rootDirectory)).setter(setter(Builder::rootDirectory))
            .constructor(RootDirectory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            TAGS_FIELD, FILE_SYSTEM_ID_FIELD, POSIX_USER_FIELD, ROOT_DIRECTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final List<Tag> tags;

    private final String fileSystemId;

    private final PosixUser posixUser;

    private final RootDirectory rootDirectory;

    private CreateAccessPointRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.fileSystemId = builder.fileSystemId;
        this.posixUser = builder.posixUser;
        this.rootDirectory = builder.rootDirectory;
    }

    /**
     * <p>
     * A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.
     * </p>
     * 
     * @return A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more
     * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
     * Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For
     *         more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
     *         Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the EFS file system that the access point provides access to.
     * </p>
     * 
     * @return The ID of the EFS file system that the access point provides access to.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The operating system user and group applied to all file system requests made using the access point.
     * </p>
     * 
     * @return The operating system user and group applied to all file system requests made using the access point.
     */
    public final PosixUser posixUser() {
        return posixUser;
    }

    /**
     * <p>
     * Specifies the directory on the EFS file system that the access point exposes as the root directory of your file
     * system to NFS clients using the access point. The clients using the access point can only access the root
     * directory and below. If the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist, Amazon
     * EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point. When
     * specifying a <code>RootDirectory</code>, you must provide the <code>Path</code>, and the
     * <code>CreationInfo</code>.
     * </p>
     * <p>
     * Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions
     * for the directory. If you do not provide this information, Amazon EFS does not create the root directory. If the
     * root directory does not exist, attempts to mount using the access point will fail.
     * </p>
     * 
     * @return Specifies the directory on the EFS file system that the access point exposes as the root directory of
     *         your file system to NFS clients using the access point. The clients using the access point can only
     *         access the root directory and below. If the <code>RootDirectory</code> &gt; <code>Path</code> specified
     *         does not exist, Amazon EFS creates it and applies the <code>CreationInfo</code> settings when a client
     *         connects to an access point. When specifying a <code>RootDirectory</code>, you must provide the
     *         <code>Path</code>, and the <code>CreationInfo</code>.</p>
     *         <p>
     *         Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and
     *         permissions for the directory. If you do not provide this information, Amazon EFS does not create the
     *         root directory. If the root directory does not exist, attempts to mount using the access point will fail.
     */
    public final RootDirectory rootDirectory() {
        return rootDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(posixUser());
        hashCode = 31 * hashCode + Objects.hashCode(rootDirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPointRequest)) {
            return false;
        }
        CreateAccessPointRequest other = (CreateAccessPointRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(posixUser(), other.posixUser()) && Objects.equals(rootDirectory(), other.rootDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessPointRequest").add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).add("FileSystemId", fileSystemId()).add("PosixUser", posixUser())
                .add("RootDirectory", rootDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "PosixUser":
            return Optional.ofNullable(clazz.cast(posixUser()));
        case "RootDirectory":
            return Optional.ofNullable(clazz.cast(rootDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("PosixUser", POSIX_USER_FIELD);
        map.put("RootDirectory", ROOT_DIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPointRequest, T> g) {
        return obj -> g.apply((CreateAccessPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessPointRequest> {
        /**
         * <p>
         * A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.
         * </p>
         * 
         * @param clientToken
         *        A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon
         * Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon
         * Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon
         * Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.efs.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.efs.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.efs.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.efs.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the EFS file system that the access point provides access to.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the EFS file system that the access point provides access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The operating system user and group applied to all file system requests made using the access point.
         * </p>
         * 
         * @param posixUser
         *        The operating system user and group applied to all file system requests made using the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder posixUser(PosixUser posixUser);

        /**
         * <p>
         * The operating system user and group applied to all file system requests made using the access point.
         * </p>
         * This is a convenience method that creates an instance of the {@link PosixUser.Builder} avoiding the need to
         * create one manually via {@link PosixUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PosixUser.Builder#build()} is called immediately and its result
         * is passed to {@link #posixUser(PosixUser)}.
         * 
         * @param posixUser
         *        a consumer that will call methods on {@link PosixUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #posixUser(PosixUser)
         */
        default Builder posixUser(Consumer<PosixUser.Builder> posixUser) {
            return posixUser(PosixUser.builder().applyMutation(posixUser).build());
        }

        /**
         * <p>
         * Specifies the directory on the EFS file system that the access point exposes as the root directory of your
         * file system to NFS clients using the access point. The clients using the access point can only access the
         * root directory and below. If the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist,
         * Amazon EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access
         * point. When specifying a <code>RootDirectory</code>, you must provide the <code>Path</code>, and the
         * <code>CreationInfo</code>.
         * </p>
         * <p>
         * Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and
         * permissions for the directory. If you do not provide this information, Amazon EFS does not create the root
         * directory. If the root directory does not exist, attempts to mount using the access point will fail.
         * </p>
         * 
         * @param rootDirectory
         *        Specifies the directory on the EFS file system that the access point exposes as the root directory of
         *        your file system to NFS clients using the access point. The clients using the access point can only
         *        access the root directory and below. If the <code>RootDirectory</code> &gt; <code>Path</code>
         *        specified does not exist, Amazon EFS creates it and applies the <code>CreationInfo</code> settings
         *        when a client connects to an access point. When specifying a <code>RootDirectory</code>, you must
         *        provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>
         *        <p>
         *        Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and
         *        permissions for the directory. If you do not provide this information, Amazon EFS does not create the
         *        root directory. If the root directory does not exist, attempts to mount using the access point will
         *        fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDirectory(RootDirectory rootDirectory);

        /**
         * <p>
         * Specifies the directory on the EFS file system that the access point exposes as the root directory of your
         * file system to NFS clients using the access point. The clients using the access point can only access the
         * root directory and below. If the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist,
         * Amazon EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access
         * point. When specifying a <code>RootDirectory</code>, you must provide the <code>Path</code>, and the
         * <code>CreationInfo</code>.
         * </p>
         * <p>
         * Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and
         * permissions for the directory. If you do not provide this information, Amazon EFS does not create the root
         * directory. If the root directory does not exist, attempts to mount using the access point will fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link RootDirectory.Builder} avoiding the need
         * to create one manually via {@link RootDirectory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RootDirectory.Builder#build()} is called immediately and its
         * result is passed to {@link #rootDirectory(RootDirectory)}.
         * 
         * @param rootDirectory
         *        a consumer that will call methods on {@link RootDirectory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootDirectory(RootDirectory)
         */
        default Builder rootDirectory(Consumer<RootDirectory.Builder> rootDirectory) {
            return rootDirectory(RootDirectory.builder().applyMutation(rootDirectory).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String fileSystemId;

        private PosixUser posixUser;

        private RootDirectory rootDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPointRequest model) {
            super(model);
            clientToken(model.clientToken);
            tags(model.tags);
            fileSystemId(model.fileSystemId);
            posixUser(model.posixUser);
            rootDirectory(model.rootDirectory);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final PosixUser.Builder getPosixUser() {
            return posixUser != null ? posixUser.toBuilder() : null;
        }

        public final void setPosixUser(PosixUser.BuilderImpl posixUser) {
            this.posixUser = posixUser != null ? posixUser.build() : null;
        }

        @Override
        public final Builder posixUser(PosixUser posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        public final RootDirectory.Builder getRootDirectory() {
            return rootDirectory != null ? rootDirectory.toBuilder() : null;
        }

        public final void setRootDirectory(RootDirectory.BuilderImpl rootDirectory) {
            this.rootDirectory = rootDirectory != null ? rootDirectory.build() : null;
        }

        @Override
        public final Builder rootDirectory(RootDirectory rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessPointRequest build() {
            return new CreateAccessPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
