/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the protection on a file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemProtectionResponse extends EfsResponse implements
        ToCopyableBuilder<UpdateFileSystemProtectionResponse.Builder, UpdateFileSystemProtectionResponse> {
    private static final SdkField<String> REPLICATION_OVERWRITE_PROTECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationOverwriteProtection")
            .getter(getter(UpdateFileSystemProtectionResponse::replicationOverwriteProtectionAsString))
            .setter(setter(Builder::replicationOverwriteProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationOverwriteProtection")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REPLICATION_OVERWRITE_PROTECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replicationOverwriteProtection;

    private UpdateFileSystemProtectionResponse(BuilderImpl builder) {
        super(builder);
        this.replicationOverwriteProtection = builder.replicationOverwriteProtection;
    }

    /**
     * <p>
     * The status of the file system's replication overwrite protection.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – The file system cannot be used as the destination file system in a replication
     * configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The file system can be used as the destination file system in a replication
     * configuration. The file system is read-only and can only be modified by EFS replication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REPLICATING</code> – The file system is being used as the destination file system in a replication
     * configuration. The file system is read-only and is modified only by EFS replication.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the replication configuration is deleted, the file system's replication overwrite protection is re-enabled,
     * the file system becomes writeable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationOverwriteProtection} will return {@link ReplicationOverwriteProtection#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #replicationOverwriteProtectionAsString}.
     * </p>
     * 
     * @return The status of the file system's replication overwrite protection.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The file system cannot be used as the destination file system in a replication
     *         configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code> by
     *         default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The file system can be used as the destination file system in a replication
     *         configuration. The file system is read-only and can only be modified by EFS replication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REPLICATING</code> – The file system is being used as the destination file system in a replication
     *         configuration. The file system is read-only and is modified only by EFS replication.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the replication configuration is deleted, the file system's replication overwrite protection is
     *         re-enabled, the file system becomes writeable.
     * @see ReplicationOverwriteProtection
     */
    public final ReplicationOverwriteProtection replicationOverwriteProtection() {
        return ReplicationOverwriteProtection.fromValue(replicationOverwriteProtection);
    }

    /**
     * <p>
     * The status of the file system's replication overwrite protection.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – The file system cannot be used as the destination file system in a replication
     * configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The file system can be used as the destination file system in a replication
     * configuration. The file system is read-only and can only be modified by EFS replication.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REPLICATING</code> – The file system is being used as the destination file system in a replication
     * configuration. The file system is read-only and is modified only by EFS replication.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the replication configuration is deleted, the file system's replication overwrite protection is re-enabled,
     * the file system becomes writeable.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #replicationOverwriteProtection} will return {@link ReplicationOverwriteProtection#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #replicationOverwriteProtectionAsString}.
     * </p>
     * 
     * @return The status of the file system's replication overwrite protection.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The file system cannot be used as the destination file system in a replication
     *         configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code> by
     *         default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The file system can be used as the destination file system in a replication
     *         configuration. The file system is read-only and can only be modified by EFS replication.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REPLICATING</code> – The file system is being used as the destination file system in a replication
     *         configuration. The file system is read-only and is modified only by EFS replication.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the replication configuration is deleted, the file system's replication overwrite protection is
     *         re-enabled, the file system becomes writeable.
     * @see ReplicationOverwriteProtection
     */
    public final String replicationOverwriteProtectionAsString() {
        return replicationOverwriteProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationOverwriteProtectionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemProtectionResponse)) {
            return false;
        }
        UpdateFileSystemProtectionResponse other = (UpdateFileSystemProtectionResponse) obj;
        return Objects.equals(replicationOverwriteProtectionAsString(), other.replicationOverwriteProtectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFileSystemProtectionResponse")
                .add("ReplicationOverwriteProtection", replicationOverwriteProtectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationOverwriteProtection":
            return Optional.ofNullable(clazz.cast(replicationOverwriteProtectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationOverwriteProtection", REPLICATION_OVERWRITE_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemProtectionResponse, T> g) {
        return obj -> g.apply((UpdateFileSystemProtectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFileSystemProtectionResponse> {
        /**
         * <p>
         * The status of the file system's replication overwrite protection.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – The file system cannot be used as the destination file system in a replication
         * configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code> by
         * default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The file system can be used as the destination file system in a replication
         * configuration. The file system is read-only and can only be modified by EFS replication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REPLICATING</code> – The file system is being used as the destination file system in a replication
         * configuration. The file system is read-only and is modified only by EFS replication.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the replication configuration is deleted, the file system's replication overwrite protection is
         * re-enabled, the file system becomes writeable.
         * </p>
         * 
         * @param replicationOverwriteProtection
         *        The status of the file system's replication overwrite protection.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The file system cannot be used as the destination file system in a replication
         *        configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code>
         *        by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The file system can be used as the destination file system in a replication
         *        configuration. The file system is read-only and can only be modified by EFS replication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REPLICATING</code> – The file system is being used as the destination file system in a
         *        replication configuration. The file system is read-only and is modified only by EFS replication.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the replication configuration is deleted, the file system's replication overwrite protection is
         *        re-enabled, the file system becomes writeable.
         * @see ReplicationOverwriteProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationOverwriteProtection
         */
        Builder replicationOverwriteProtection(String replicationOverwriteProtection);

        /**
         * <p>
         * The status of the file system's replication overwrite protection.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – The file system cannot be used as the destination file system in a replication
         * configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code> by
         * default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The file system can be used as the destination file system in a replication
         * configuration. The file system is read-only and can only be modified by EFS replication.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REPLICATING</code> – The file system is being used as the destination file system in a replication
         * configuration. The file system is read-only and is modified only by EFS replication.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the replication configuration is deleted, the file system's replication overwrite protection is
         * re-enabled, the file system becomes writeable.
         * </p>
         * 
         * @param replicationOverwriteProtection
         *        The status of the file system's replication overwrite protection.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The file system cannot be used as the destination file system in a replication
         *        configuration. The file system is writeable. Replication overwrite protection is <code>ENABLED</code>
         *        by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The file system can be used as the destination file system in a replication
         *        configuration. The file system is read-only and can only be modified by EFS replication.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REPLICATING</code> – The file system is being used as the destination file system in a
         *        replication configuration. The file system is read-only and is modified only by EFS replication.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the replication configuration is deleted, the file system's replication overwrite protection is
         *        re-enabled, the file system becomes writeable.
         * @see ReplicationOverwriteProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationOverwriteProtection
         */
        Builder replicationOverwriteProtection(ReplicationOverwriteProtection replicationOverwriteProtection);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private String replicationOverwriteProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemProtectionResponse model) {
            super(model);
            replicationOverwriteProtection(model.replicationOverwriteProtection);
        }

        public final String getReplicationOverwriteProtection() {
            return replicationOverwriteProtection;
        }

        public final void setReplicationOverwriteProtection(String replicationOverwriteProtection) {
            this.replicationOverwriteProtection = replicationOverwriteProtection;
        }

        @Override
        public final Builder replicationOverwriteProtection(String replicationOverwriteProtection) {
            this.replicationOverwriteProtection = replicationOverwriteProtection;
            return this;
        }

        @Override
        public final Builder replicationOverwriteProtection(ReplicationOverwriteProtection replicationOverwriteProtection) {
            this.replicationOverwriteProtection(replicationOverwriteProtection == null ? null : replicationOverwriteProtection
                    .toString());
            return this;
        }

        @Override
        public UpdateFileSystemProtectionResponse build() {
            return new UpdateFileSystemProtectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
