/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyMountTargetSecurityGroupsRequest extends EfsRequest implements
        ToCopyableBuilder<ModifyMountTargetSecurityGroupsRequest.Builder, ModifyMountTargetSecurityGroupsRequest> {
    private static final SdkField<String> MOUNT_TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyMountTargetSecurityGroupsRequest::mountTargetId)).setter(setter(Builder::mountTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MountTargetId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyMountTargetSecurityGroupsRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOUNT_TARGET_ID_FIELD,
            SECURITY_GROUPS_FIELD));

    private final String mountTargetId;

    private final List<String> securityGroups;

    private ModifyMountTargetSecurityGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.mountTargetId = builder.mountTargetId;
        this.securityGroups = builder.securityGroups;
    }

    /**
     * <p>
     * ID of the mount target whose security groups you want to modify.
     * </p>
     * 
     * @return ID of the mount target whose security groups you want to modify.
     */
    public String mountTargetId() {
        return mountTargetId;
    }

    /**
     * <p>
     * Array of up to five VPC security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of up to five VPC security group IDs.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mountTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyMountTargetSecurityGroupsRequest)) {
            return false;
        }
        ModifyMountTargetSecurityGroupsRequest other = (ModifyMountTargetSecurityGroupsRequest) obj;
        return Objects.equals(mountTargetId(), other.mountTargetId()) && Objects.equals(securityGroups(), other.securityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyMountTargetSecurityGroupsRequest").add("MountTargetId", mountTargetId())
                .add("SecurityGroups", securityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MountTargetId":
            return Optional.ofNullable(clazz.cast(mountTargetId()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyMountTargetSecurityGroupsRequest, T> g) {
        return obj -> g.apply((ModifyMountTargetSecurityGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyMountTargetSecurityGroupsRequest> {
        /**
         * <p>
         * ID of the mount target whose security groups you want to modify.
         * </p>
         * 
         * @param mountTargetId
         *        ID of the mount target whose security groups you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargetId(String mountTargetId);

        /**
         * <p>
         * Array of up to five VPC security group IDs.
         * </p>
         * 
         * @param securityGroups
         *        Array of up to five VPC security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * Array of up to five VPC security group IDs.
         * </p>
         * 
         * @param securityGroups
         *        Array of up to five VPC security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private String mountTargetId;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyMountTargetSecurityGroupsRequest model) {
            super(model);
            mountTargetId(model.mountTargetId);
            securityGroups(model.securityGroups);
        }

        public final String getMountTargetId() {
            return mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyMountTargetSecurityGroupsRequest build() {
            return new ModifyMountTargetSecurityGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
