/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicy implements SdkPojo, Serializable, ToCopyableBuilder<LifecyclePolicy.Builder, LifecyclePolicy> {
    private static final SdkField<String> TRANSITION_TO_IA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LifecyclePolicy::transitionToIAAsString)).setter(setter(Builder::transitionToIA))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitionToIA").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSITION_TO_IA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitionToIA;

    private LifecyclePolicy(BuilderImpl builder) {
        this.transitionToIA = builder.transitionToIA;
    }

    /**
     * <p>
     * A value that describes the period of time that a file is not accessed, after which it transitions to the IA
     * storage class. Metadata operations such as listing the contents of a directory don't count as file access events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transitionToIA}
     * will return {@link TransitionToIARules#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #transitionToIAAsString}.
     * </p>
     * 
     * @return A value that describes the period of time that a file is not accessed, after which it transitions to the
     *         IA storage class. Metadata operations such as listing the contents of a directory don't count as file
     *         access events.
     * @see TransitionToIARules
     */
    public TransitionToIARules transitionToIA() {
        return TransitionToIARules.fromValue(transitionToIA);
    }

    /**
     * <p>
     * A value that describes the period of time that a file is not accessed, after which it transitions to the IA
     * storage class. Metadata operations such as listing the contents of a directory don't count as file access events.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transitionToIA}
     * will return {@link TransitionToIARules#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #transitionToIAAsString}.
     * </p>
     * 
     * @return A value that describes the period of time that a file is not accessed, after which it transitions to the
     *         IA storage class. Metadata operations such as listing the contents of a directory don't count as file
     *         access events.
     * @see TransitionToIARules
     */
    public String transitionToIAAsString() {
        return transitionToIA;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitionToIAAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicy)) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy) obj;
        return Objects.equals(transitionToIAAsString(), other.transitionToIAAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LifecyclePolicy").add("TransitionToIA", transitionToIAAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitionToIA":
            return Optional.ofNullable(clazz.cast(transitionToIAAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicy, T> g) {
        return obj -> g.apply((LifecyclePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicy> {
        /**
         * <p>
         * A value that describes the period of time that a file is not accessed, after which it transitions to the IA
         * storage class. Metadata operations such as listing the contents of a directory don't count as file access
         * events.
         * </p>
         * 
         * @param transitionToIA
         *        A value that describes the period of time that a file is not accessed, after which it transitions to
         *        the IA storage class. Metadata operations such as listing the contents of a directory don't count as
         *        file access events.
         * @see TransitionToIARules
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitionToIARules
         */
        Builder transitionToIA(String transitionToIA);

        /**
         * <p>
         * A value that describes the period of time that a file is not accessed, after which it transitions to the IA
         * storage class. Metadata operations such as listing the contents of a directory don't count as file access
         * events.
         * </p>
         * 
         * @param transitionToIA
         *        A value that describes the period of time that a file is not accessed, after which it transitions to
         *        the IA storage class. Metadata operations such as listing the contents of a directory don't count as
         *        file access events.
         * @see TransitionToIARules
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitionToIARules
         */
        Builder transitionToIA(TransitionToIARules transitionToIA);
    }

    static final class BuilderImpl implements Builder {
        private String transitionToIA;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicy model) {
            transitionToIA(model.transitionToIA);
        }

        public final String getTransitionToIAAsString() {
            return transitionToIA;
        }

        @Override
        public final Builder transitionToIA(String transitionToIA) {
            this.transitionToIA = transitionToIA;
            return this;
        }

        @Override
        public final Builder transitionToIA(TransitionToIARules transitionToIA) {
            this.transitionToIA(transitionToIA.toString());
            return this;
        }

        public final void setTransitionToIA(String transitionToIA) {
            this.transitionToIA = transitionToIA;
        }

        @Override
        public LifecyclePolicy build() {
            return new LifecyclePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
