/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemRequest extends EfsRequest implements
        ToCopyableBuilder<UpdateFileSystemRequest.Builder, UpdateFileSystemRequest> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemRequest::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileSystemId").build()).build();

    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemRequest::throughputModeAsString)).setter(setter(Builder::throughputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputMode").build()).build();

    private static final SdkField<Double> PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(UpdateFileSystemRequest::provisionedThroughputInMibps))
            .setter(setter(Builder::provisionedThroughputInMibps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputInMibps")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD,
            THROUGHPUT_MODE_FIELD, PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD));

    private final String fileSystemId;

    private final String throughputMode;

    private final Double provisionedThroughputInMibps;

    private UpdateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
        this.throughputMode = builder.throughputMode;
        this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
    }

    /**
     * <p>
     * The ID of the file system that you want to update.
     * </p>
     * 
     * @return The ID of the file system that you want to update.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * (Optional) The throughput mode that you want your file system to use. If you're not updating your throughput
     * mode, you don't need to provide this value in your request. If you are changing the <code>ThroughputMode</code>
     * to <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughputInMibps</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return (Optional) The throughput mode that you want your file system to use. If you're not updating your
     *         throughput mode, you don't need to provide this value in your request. If you are changing the
     *         <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
     *         <code>ProvisionedThroughputInMibps</code>.
     * @see ThroughputMode
     */
    public ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(throughputMode);
    }

    /**
     * <p>
     * (Optional) The throughput mode that you want your file system to use. If you're not updating your throughput
     * mode, you don't need to provide this value in your request. If you are changing the <code>ThroughputMode</code>
     * to <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughputInMibps</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return (Optional) The throughput mode that you want your file system to use. If you're not updating your
     *         throughput mode, you don't need to provide this value in your request. If you are changing the
     *         <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
     *         <code>ProvisionedThroughputInMibps</code>.
     * @see ThroughputMode
     */
    public String throughputModeAsString() {
        return throughputMode;
    }

    /**
     * <p>
     * (Optional) The amount of throughput, in MiB/s, that you want to provision for your file system. Valid values are
     * 1-1024. Required if <code>ThroughputMode</code> is changed to <code>provisioned</code> on update. If you're not
     * updating the amount of provisioned throughput for your file system, you don't need to provide this value in your
     * request.
     * </p>
     * 
     * @return (Optional) The amount of throughput, in MiB/s, that you want to provision for your file system. Valid
     *         values are 1-1024. Required if <code>ThroughputMode</code> is changed to <code>provisioned</code> on
     *         update. If you're not updating the amount of provisioned throughput for your file system, you don't need
     *         to provide this value in your request.
     */
    public Double provisionedThroughputInMibps() {
        return provisionedThroughputInMibps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputInMibps());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemRequest)) {
            return false;
        }
        UpdateFileSystemRequest other = (UpdateFileSystemRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(throughputModeAsString(), other.throughputModeAsString())
                && Objects.equals(provisionedThroughputInMibps(), other.provisionedThroughputInMibps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFileSystemRequest").add("FileSystemId", fileSystemId())
                .add("ThroughputMode", throughputModeAsString())
                .add("ProvisionedThroughputInMibps", provisionedThroughputInMibps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "ThroughputMode":
            return Optional.ofNullable(clazz.cast(throughputModeAsString()));
        case "ProvisionedThroughputInMibps":
            return Optional.ofNullable(clazz.cast(provisionedThroughputInMibps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemRequest, T> g) {
        return obj -> g.apply((UpdateFileSystemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFileSystemRequest> {
        /**
         * <p>
         * The ID of the file system that you want to update.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * (Optional) The throughput mode that you want your file system to use. If you're not updating your throughput
         * mode, you don't need to provide this value in your request. If you are changing the
         * <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
         * <code>ProvisionedThroughputInMibps</code>.
         * </p>
         * 
         * @param throughputMode
         *        (Optional) The throughput mode that you want your file system to use. If you're not updating your
         *        throughput mode, you don't need to provide this value in your request. If you are changing the
         *        <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
         *        <code>ProvisionedThroughputInMibps</code>.
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(String throughputMode);

        /**
         * <p>
         * (Optional) The throughput mode that you want your file system to use. If you're not updating your throughput
         * mode, you don't need to provide this value in your request. If you are changing the
         * <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
         * <code>ProvisionedThroughputInMibps</code>.
         * </p>
         * 
         * @param throughputMode
         *        (Optional) The throughput mode that you want your file system to use. If you're not updating your
         *        throughput mode, you don't need to provide this value in your request. If you are changing the
         *        <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
         *        <code>ProvisionedThroughputInMibps</code>.
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(ThroughputMode throughputMode);

        /**
         * <p>
         * (Optional) The amount of throughput, in MiB/s, that you want to provision for your file system. Valid values
         * are 1-1024. Required if <code>ThroughputMode</code> is changed to <code>provisioned</code> on update. If
         * you're not updating the amount of provisioned throughput for your file system, you don't need to provide this
         * value in your request.
         * </p>
         * 
         * @param provisionedThroughputInMibps
         *        (Optional) The amount of throughput, in MiB/s, that you want to provision for your file system. Valid
         *        values are 1-1024. Required if <code>ThroughputMode</code> is changed to <code>provisioned</code> on
         *        update. If you're not updating the amount of provisioned throughput for your file system, you don't
         *        need to provide this value in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private String fileSystemId;

        private String throughputMode;

        private Double provisionedThroughputInMibps;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemRequest model) {
            super(model);
            fileSystemId(model.fileSystemId);
            throughputMode(model.throughputMode);
            provisionedThroughputInMibps(model.provisionedThroughputInMibps);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getThroughputModeAsString() {
            return throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode.toString());
            return this;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        public final Double getProvisionedThroughputInMibps() {
            return provisionedThroughputInMibps;
        }

        @Override
        public final Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        public final void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFileSystemRequest build() {
            return new UpdateFileSystemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
