/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an identity provider for authentication credentials.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Identity implements SdkPojo, Serializable, ToCopyableBuilder<Identity.Builder, Identity> {
    private static final SdkField<OIDC> OIDC_FIELD = SdkField.<OIDC> builder(MarshallingType.SDK_POJO)
            .getter(getter(Identity::oidc)).setter(setter(Builder::oidc)).constructor(OIDC::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oidc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OIDC_FIELD));

    private static final long serialVersionUID = 1L;

    private final OIDC oidc;

    private Identity(BuilderImpl builder) {
        this.oidc = builder.oidc;
    }

    /**
     * <p>
     * The <a href="https://openid.net/connect/">OpenID Connect</a> identity provider information for the cluster.
     * </p>
     * 
     * @return The <a href="https://openid.net/connect/">OpenID Connect</a> identity provider information for the
     *         cluster.
     */
    public OIDC oidc() {
        return oidc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oidc());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity) obj;
        return Objects.equals(oidc(), other.oidc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Identity").add("Oidc", oidc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oidc":
            return Optional.ofNullable(clazz.cast(oidc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Identity, T> g) {
        return obj -> g.apply((Identity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Identity> {
        /**
         * <p>
         * The <a href="https://openid.net/connect/">OpenID Connect</a> identity provider information for the cluster.
         * </p>
         * 
         * @param oidc
         *        The <a href="https://openid.net/connect/">OpenID Connect</a> identity provider information for the
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidc(OIDC oidc);

        /**
         * <p>
         * The <a href="https://openid.net/connect/">OpenID Connect</a> identity provider information for the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link OIDC.Builder} avoiding the need to create one
         * manually via {@link OIDC#builder()}.
         *
         * When the {@link Consumer} completes, {@link OIDC.Builder#build()} is called immediately and its result is
         * passed to {@link #oidc(OIDC)}.
         * 
         * @param oidc
         *        a consumer that will call methods on {@link OIDC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidc(OIDC)
         */
        default Builder oidc(Consumer<OIDC.Builder> oidc) {
            return oidc(OIDC.builder().applyMutation(oidc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OIDC oidc;

        private BuilderImpl() {
        }

        private BuilderImpl(Identity model) {
            oidc(model.oidc);
        }

        public final OIDC.Builder getOidc() {
            return oidc != null ? oidc.toBuilder() : null;
        }

        @Override
        public final Builder oidc(OIDC oidc) {
            this.oidc = oidc;
            return this;
        }

        public final void setOidc(OIDC.BuilderImpl oidc) {
            this.oidc = oidc != null ? oidc.build() : null;
        }

        @Override
        public Identity build() {
            return new Identity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
