/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum NodegroupIssueCode {
    AUTO_SCALING_GROUP_NOT_FOUND("AutoScalingGroupNotFound"),

    AUTO_SCALING_GROUP_INVALID_CONFIGURATION("AutoScalingGroupInvalidConfiguration"),

    EC2_SECURITY_GROUP_NOT_FOUND("Ec2SecurityGroupNotFound"),

    EC2_SECURITY_GROUP_DELETION_FAILURE("Ec2SecurityGroupDeletionFailure"),

    EC2_LAUNCH_TEMPLATE_NOT_FOUND("Ec2LaunchTemplateNotFound"),

    EC2_LAUNCH_TEMPLATE_VERSION_MISMATCH("Ec2LaunchTemplateVersionMismatch"),

    EC2_SUBNET_NOT_FOUND("Ec2SubnetNotFound"),

    EC2_SUBNET_INVALID_CONFIGURATION("Ec2SubnetInvalidConfiguration"),

    IAM_INSTANCE_PROFILE_NOT_FOUND("IamInstanceProfileNotFound"),

    IAM_LIMIT_EXCEEDED("IamLimitExceeded"),

    IAM_NODE_ROLE_NOT_FOUND("IamNodeRoleNotFound"),

    NODE_CREATION_FAILURE("NodeCreationFailure"),

    ASG_INSTANCE_LAUNCH_FAILURES("AsgInstanceLaunchFailures"),

    INSTANCE_LIMIT_EXCEEDED("InstanceLimitExceeded"),

    INSUFFICIENT_FREE_ADDRESSES("InsufficientFreeAddresses"),

    ACCESS_DENIED("AccessDenied"),

    INTERNAL_FAILURE("InternalFailure"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NodegroupIssueCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return NodegroupIssueCode corresponding to the value
     */
    public static NodegroupIssueCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NodegroupIssueCode.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link NodegroupIssueCode}s
     */
    public static Set<NodegroupIssueCode> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
