/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAddonRequest extends EksRequest implements
        ToCopyableBuilder<CreateAddonRequest.Builder, CreateAddonRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(CreateAddonRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonName").getter(getter(CreateAddonRequest::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()).build();

    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonVersion").getter(getter(CreateAddonRequest::addonVersion)).setter(setter(Builder::addonVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccountRoleArn").getter(getter(CreateAddonRequest::serviceAccountRoleArn))
            .setter(setter(Builder::serviceAccountRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountRoleArn").build())
            .build();

    private static final SdkField<String> RESOLVE_CONFLICTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolveConflicts").getter(getter(CreateAddonRequest::resolveConflictsAsString))
            .setter(setter(Builder::resolveConflicts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolveConflicts").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateAddonRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAddonRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            ADDON_NAME_FIELD, ADDON_VERSION_FIELD, SERVICE_ACCOUNT_ROLE_ARN_FIELD, RESOLVE_CONFLICTS_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));

    private final String clusterName;

    private final String addonName;

    private final String addonVersion;

    private final String serviceAccountRoleArn;

    private final String resolveConflicts;

    private final String clientRequestToken;

    private final Map<String, String> tags;

    private CreateAddonRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.addonName = builder.addonName;
        this.addonVersion = builder.addonVersion;
        this.serviceAccountRoleArn = builder.serviceAccountRoleArn;
        this.resolveConflicts = builder.resolveConflicts;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the cluster to create the add-on for.
     * </p>
     * 
     * @return The name of the cluster to create the add-on for.
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the add-on. The name must match one of the names returned by <a
     * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.
     * </p>
     * 
     * @return The name of the add-on. The name must match one of the names returned by <a
     *         href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code>
     *         </a>.
     */
    public String addonName() {
        return addonName;
    }

    /**
     * <p>
     * The version of the add-on. The version must match one of the versions returned by <a
     * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     * <code>DescribeAddonVersions</code> </a>.
     * </p>
     * 
     * @return The version of the add-on. The version must match one of the versions returned by <a
     *         href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     *         <code>DescribeAddonVersions</code> </a>.
     */
    public String addonVersion() {
        return addonVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be
     * assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on
     * uses the permissions assigned to the node IAM role. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the
     * <i>Amazon EKS User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM
     * roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role
     *         must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role,
     *         then the add-on uses the permissions assigned to the node IAM role. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM
     *         role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>
     *         <p>
     *         To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your
     *         cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html"
     *         >Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.
     *         </p>
     */
    public String serviceAccountRoleArn() {
        return serviceAccountRoleArn;
    }

    /**
     * <p>
     * How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolveConflicts}
     * will return {@link ResolveConflicts#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolveConflictsAsString}.
     * </p>
     * 
     * @return How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
     * @see ResolveConflicts
     */
    public ResolveConflicts resolveConflicts() {
        return ResolveConflicts.fromValue(resolveConflicts);
    }

    /**
     * <p>
     * How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolveConflicts}
     * will return {@link ResolveConflicts#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolveConflictsAsString}.
     * </p>
     * 
     * @return How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
     * @see ResolveConflicts
     */
    public String resolveConflictsAsString() {
        return resolveConflicts;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key
     * and an optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of
     *         a key and an optional value, both of which you define.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(resolveConflictsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAddonRequest)) {
            return false;
        }
        CreateAddonRequest other = (CreateAddonRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(addonName(), other.addonName())
                && Objects.equals(addonVersion(), other.addonVersion())
                && Objects.equals(serviceAccountRoleArn(), other.serviceAccountRoleArn())
                && Objects.equals(resolveConflictsAsString(), other.resolveConflictsAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAddonRequest").add("ClusterName", clusterName()).add("AddonName", addonName())
                .add("AddonVersion", addonVersion()).add("ServiceAccountRoleArn", serviceAccountRoleArn())
                .add("ResolveConflicts", resolveConflictsAsString()).add("ClientRequestToken", clientRequestToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "addonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "addonVersion":
            return Optional.ofNullable(clazz.cast(addonVersion()));
        case "serviceAccountRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccountRoleArn()));
        case "resolveConflicts":
            return Optional.ofNullable(clazz.cast(resolveConflictsAsString()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAddonRequest, T> g) {
        return obj -> g.apply((CreateAddonRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAddonRequest> {
        /**
         * <p>
         * The name of the cluster to create the add-on for.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster to create the add-on for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the add-on. The name must match one of the names returned by <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.
         * </p>
         * 
         * @param addonName
         *        The name of the add-on. The name must match one of the names returned by <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html">
         *        <code>ListAddons</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * The version of the add-on. The version must match one of the versions returned by <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         * <code>DescribeAddonVersions</code> </a>.
         * </p>
         * 
         * @param addonVersion
         *        The version of the add-on. The version must match one of the versions returned by <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         *        <code>DescribeAddonVersions</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersion(String addonVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must
         * be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the
         * add-on uses the permissions assigned to the node IAM role. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in
         * the <i>Amazon EKS User Guide</i>.
         * </p>
         * <note>
         * <p>
         * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your
         * cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling
         * IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * </note>
         * 
         * @param serviceAccountRoleArn
         *        The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The
         *        role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM
         *        role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM
         *        role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>
         *        <p>
         *        To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your
         *        cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html"
         *        >Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountRoleArn(String serviceAccountRoleArn);

        /**
         * <p>
         * How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
         * </p>
         * 
         * @param resolveConflicts
         *        How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
         * @see ResolveConflicts
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolveConflicts
         */
        Builder resolveConflicts(String resolveConflicts);

        /**
         * <p>
         * How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
         * </p>
         * 
         * @param resolveConflicts
         *        How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.
         * @see ResolveConflicts
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolveConflicts
         */
        Builder resolveConflicts(ResolveConflicts resolveConflicts);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a
         * key and an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        The metadata to apply to the cluster to assist with categorization and organization. Each tag consists
         *        of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String addonName;

        private String addonVersion;

        private String serviceAccountRoleArn;

        private String resolveConflicts;

        private String clientRequestToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAddonRequest model) {
            super(model);
            clusterName(model.clusterName);
            addonName(model.addonName);
            addonVersion(model.addonVersion);
            serviceAccountRoleArn(model.serviceAccountRoleArn);
            resolveConflicts(model.resolveConflicts);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getAddonName() {
            return addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        public final String getAddonVersion() {
            return addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        public final String getServiceAccountRoleArn() {
            return serviceAccountRoleArn;
        }

        @Override
        public final Builder serviceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
            return this;
        }

        public final void setServiceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
        }

        public final String getResolveConflicts() {
            return resolveConflicts;
        }

        @Override
        public final Builder resolveConflicts(String resolveConflicts) {
            this.resolveConflicts = resolveConflicts;
            return this;
        }

        @Override
        public final Builder resolveConflicts(ResolveConflicts resolveConflicts) {
            this.resolveConflicts(resolveConflicts == null ? null : resolveConflicts.toString());
            return this;
        }

        public final void setResolveConflicts(String resolveConflicts) {
            this.resolveConflicts = resolveConflicts;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAddonRequest build() {
            return new CreateAddonRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
