/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigRequest;
import software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigResponse;
import software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigRequest;
import software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigResponse;
import software.amazon.awssdk.services.eks.model.BadRequestException;
import software.amazon.awssdk.services.eks.model.ClientException;
import software.amazon.awssdk.services.eks.model.CreateAddonRequest;
import software.amazon.awssdk.services.eks.model.CreateAddonResponse;
import software.amazon.awssdk.services.eks.model.CreateClusterRequest;
import software.amazon.awssdk.services.eks.model.CreateClusterResponse;
import software.amazon.awssdk.services.eks.model.CreateFargateProfileRequest;
import software.amazon.awssdk.services.eks.model.CreateFargateProfileResponse;
import software.amazon.awssdk.services.eks.model.CreateNodegroupRequest;
import software.amazon.awssdk.services.eks.model.CreateNodegroupResponse;
import software.amazon.awssdk.services.eks.model.DeleteAddonRequest;
import software.amazon.awssdk.services.eks.model.DeleteAddonResponse;
import software.amazon.awssdk.services.eks.model.DeleteClusterRequest;
import software.amazon.awssdk.services.eks.model.DeleteClusterResponse;
import software.amazon.awssdk.services.eks.model.DeleteFargateProfileRequest;
import software.amazon.awssdk.services.eks.model.DeleteFargateProfileResponse;
import software.amazon.awssdk.services.eks.model.DeleteNodegroupRequest;
import software.amazon.awssdk.services.eks.model.DeleteNodegroupResponse;
import software.amazon.awssdk.services.eks.model.DescribeAddonRequest;
import software.amazon.awssdk.services.eks.model.DescribeAddonResponse;
import software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest;
import software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse;
import software.amazon.awssdk.services.eks.model.DescribeClusterRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterResponse;
import software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest;
import software.amazon.awssdk.services.eks.model.DescribeFargateProfileResponse;
import software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigRequest;
import software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigResponse;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest;
import software.amazon.awssdk.services.eks.model.DescribeNodegroupResponse;
import software.amazon.awssdk.services.eks.model.DescribeUpdateRequest;
import software.amazon.awssdk.services.eks.model.DescribeUpdateResponse;
import software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigRequest;
import software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigResponse;
import software.amazon.awssdk.services.eks.model.EksException;
import software.amazon.awssdk.services.eks.model.InvalidParameterException;
import software.amazon.awssdk.services.eks.model.InvalidRequestException;
import software.amazon.awssdk.services.eks.model.ListAddonsRequest;
import software.amazon.awssdk.services.eks.model.ListAddonsResponse;
import software.amazon.awssdk.services.eks.model.ListClustersRequest;
import software.amazon.awssdk.services.eks.model.ListClustersResponse;
import software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest;
import software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse;
import software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest;
import software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse;
import software.amazon.awssdk.services.eks.model.ListNodegroupsRequest;
import software.amazon.awssdk.services.eks.model.ListNodegroupsResponse;
import software.amazon.awssdk.services.eks.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.eks.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.eks.model.ListUpdatesRequest;
import software.amazon.awssdk.services.eks.model.ListUpdatesResponse;
import software.amazon.awssdk.services.eks.model.NotFoundException;
import software.amazon.awssdk.services.eks.model.ResourceInUseException;
import software.amazon.awssdk.services.eks.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.eks.model.ResourceNotFoundException;
import software.amazon.awssdk.services.eks.model.ServerException;
import software.amazon.awssdk.services.eks.model.ServiceUnavailableException;
import software.amazon.awssdk.services.eks.model.TagResourceRequest;
import software.amazon.awssdk.services.eks.model.TagResourceResponse;
import software.amazon.awssdk.services.eks.model.UnsupportedAvailabilityZoneException;
import software.amazon.awssdk.services.eks.model.UntagResourceRequest;
import software.amazon.awssdk.services.eks.model.UntagResourceResponse;
import software.amazon.awssdk.services.eks.model.UpdateAddonRequest;
import software.amazon.awssdk.services.eks.model.UpdateAddonResponse;
import software.amazon.awssdk.services.eks.model.UpdateClusterConfigRequest;
import software.amazon.awssdk.services.eks.model.UpdateClusterConfigResponse;
import software.amazon.awssdk.services.eks.model.UpdateClusterVersionRequest;
import software.amazon.awssdk.services.eks.model.UpdateClusterVersionResponse;
import software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigRequest;
import software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigResponse;
import software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionRequest;
import software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionResponse;
import software.amazon.awssdk.services.eks.paginators.DescribeAddonVersionsIterable;
import software.amazon.awssdk.services.eks.paginators.ListAddonsIterable;
import software.amazon.awssdk.services.eks.paginators.ListClustersIterable;
import software.amazon.awssdk.services.eks.paginators.ListFargateProfilesIterable;
import software.amazon.awssdk.services.eks.paginators.ListIdentityProviderConfigsIterable;
import software.amazon.awssdk.services.eks.paginators.ListNodegroupsIterable;
import software.amazon.awssdk.services.eks.paginators.ListUpdatesIterable;
import software.amazon.awssdk.services.eks.waiters.EksWaiter;

/**
 * Service client for accessing Amazon EKS. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Elastic Kubernetes Service (Amazon EKS) is a managed service that makes it easy for you to run Kubernetes on
 * AWS without needing to stand up or maintain your own Kubernetes control plane. Kubernetes is an open-source system
 * for automating the deployment, scaling, and management of containerized applications.
 * </p>
 * <p>
 * Amazon EKS runs up-to-date versions of the open-source Kubernetes software, so you can use all the existing plugins
 * and tooling from the Kubernetes community. Applications running on Amazon EKS are fully compatible with applications
 * running on any standard Kubernetes environment, whether running in on-premises data centers or public clouds. This
 * means that you can easily migrate any standard Kubernetes application to Amazon EKS without any code modification
 * required.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EksClient extends SdkClient {
    String SERVICE_NAME = "eks";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "eks";

    /**
     * Create a {@link EksClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EksClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EksClient}.
     */
    static EksClientBuilder builder() {
        return new DefaultEksClientBuilder();
    }

    /**
     * <p>
     * Associate encryption configuration to an existing cluster.
     * </p>
     * <p>
     * You can use this API to enable encryption on existing clusters which do not have encryption already enabled. This
     * allows you to implement a defense-in-depth security strategy without migrating applications to new EKS clusters.
     * </p>
     *
     * @param associateEncryptionConfigRequest
     * @return Result of the AssociateEncryptionConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.AssociateEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateEncryptionConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateEncryptionConfigResponse associateEncryptionConfig(
            AssociateEncryptionConfigRequest associateEncryptionConfigRequest) throws InvalidParameterException, ClientException,
            ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate encryption configuration to an existing cluster.
     * </p>
     * <p>
     * You can use this API to enable encryption on existing clusters which do not have encryption already enabled. This
     * allows you to implement a defense-in-depth security strategy without migrating applications to new EKS clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEncryptionConfigRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param associateEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link AssociateEncryptionConfigRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateEncryptionConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.AssociateEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateEncryptionConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateEncryptionConfigResponse associateEncryptionConfig(
            Consumer<AssociateEncryptionConfigRequest.Builder> associateEncryptionConfigRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceInUseException,
            ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        return associateEncryptionConfig(AssociateEncryptionConfigRequest.builder()
                .applyMutation(associateEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Associate an identity provider configuration to a cluster.
     * </p>
     * <p>
     * If you want to authenticate identities using an identity provider, you can create an identity provider
     * configuration and associate it to your cluster. After configuring authentication to your cluster you can create
     * Kubernetes <code>roles</code> and <code>clusterroles</code> to assign permissions to the roles, and then bind the
     * roles to the identities using Kubernetes <code>rolebindings</code> and <code>clusterrolebindings</code>. For more
     * information see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC
     * Authorization</a> in the Kubernetes documentation.
     * </p>
     *
     * @param associateIdentityProviderConfigRequest
     * @return Result of the AssociateIdentityProviderConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.AssociateIdentityProviderConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateIdentityProviderConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIdentityProviderConfigResponse associateIdentityProviderConfig(
            AssociateIdentityProviderConfigRequest associateIdentityProviderConfigRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate an identity provider configuration to a cluster.
     * </p>
     * <p>
     * If you want to authenticate identities using an identity provider, you can create an identity provider
     * configuration and associate it to your cluster. After configuring authentication to your cluster you can create
     * Kubernetes <code>roles</code> and <code>clusterroles</code> to assign permissions to the roles, and then bind the
     * roles to the identities using Kubernetes <code>rolebindings</code> and <code>clusterrolebindings</code>. For more
     * information see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC
     * Authorization</a> in the Kubernetes documentation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIdentityProviderConfigRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateIdentityProviderConfigRequest#builder()}
     * </p>
     *
     * @param associateIdentityProviderConfigRequest
     *        A {@link Consumer} that will call methods on {@link AssociateIdentityProviderConfigRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateIdentityProviderConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.AssociateIdentityProviderConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateIdentityProviderConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIdentityProviderConfigResponse associateIdentityProviderConfig(
            Consumer<AssociateIdentityProviderConfigRequest.Builder> associateIdentityProviderConfigRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceInUseException,
            ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        return associateIdentityProviderConfig(AssociateIdentityProviderConfigRequest.builder()
                .applyMutation(associateIdentityProviderConfigRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon EKS add-on.
     * </p>
     * <p>
     * Amazon EKS add-ons help to automate the provisioning and lifecycle management of common operational software for
     * Amazon EKS clusters. Amazon EKS add-ons can only be used with Amazon EKS clusters running version 1.18 with
     * platform version <code>eks.3</code> or later because add-ons rely on the Server-side Apply Kubernetes feature,
     * which is only available in Kubernetes 1.18 and later.
     * </p>
     *
     * @param createAddonRequest
     * @return Result of the CreateAddon operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.CreateAddon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateAddon" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAddonResponse createAddon(CreateAddonRequest createAddonRequest) throws InvalidParameterException,
            InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ClientException, ServerException,
            AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon EKS add-on.
     * </p>
     * <p>
     * Amazon EKS add-ons help to automate the provisioning and lifecycle management of common operational software for
     * Amazon EKS clusters. Amazon EKS add-ons can only be used with Amazon EKS clusters running version 1.18 with
     * platform version <code>eks.3</code> or later because add-ons rely on the Server-side Apply Kubernetes feature,
     * which is only available in Kubernetes 1.18 and later.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddonRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAddonRequest#builder()}
     * </p>
     *
     * @param createAddonRequest
     *        A {@link Consumer} that will call methods on {@link CreateAddonRequest.Builder} to create a request.
     * @return Result of the CreateAddon operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.CreateAddon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateAddon" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAddonResponse createAddon(Consumer<CreateAddonRequest.Builder> createAddonRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException, ResourceInUseException,
            ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        return createAddon(CreateAddonRequest.builder().applyMutation(createAddonRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon EKS control plane.
     * </p>
     * <p>
     * The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as
     * <code>etcd</code> and the API server. The control plane runs in an account managed by AWS, and the Kubernetes API
     * is exposed via the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single-tenant and
     * unique and runs on its own set of Amazon EC2 instances.
     * </p>
     * <p>
     * The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load
     * Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to
     * provide connectivity from the control plane instances to the nodes (for example, to support
     * <code>kubectl exec</code>, <code>logs</code>, and <code>proxy</code> data flows).
     * </p>
     * <p>
     * Amazon EKS nodes run in your AWS account and connect to your cluster's control plane via the Kubernetes API
     * server endpoint and a certificate file that is created for your cluster.
     * </p>
     * <p>
     * Cluster creation typically takes several minutes. After you create an Amazon EKS cluster, you must configure your
     * Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information,
     * see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html">Managing Cluster
     * Authentication</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">Launching
     * Amazon EKS nodes</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     *
     * @param createClusterRequest
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceLimitExceededException
     *         You have encountered a service limit on the specified resource.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws UnsupportedAvailabilityZoneException
     *         At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon
     *         EKS. The exception output specifies the supported Availability Zones for your account, from which you can
     *         choose subnets for your cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ResourceInUseException,
            ResourceLimitExceededException, InvalidParameterException, ClientException, ServerException,
            ServiceUnavailableException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException,
            EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon EKS control plane.
     * </p>
     * <p>
     * The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as
     * <code>etcd</code> and the API server. The control plane runs in an account managed by AWS, and the Kubernetes API
     * is exposed via the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single-tenant and
     * unique and runs on its own set of Amazon EC2 instances.
     * </p>
     * <p>
     * The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load
     * Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to
     * provide connectivity from the control plane instances to the nodes (for example, to support
     * <code>kubectl exec</code>, <code>logs</code>, and <code>proxy</code> data flows).
     * </p>
     * <p>
     * Amazon EKS nodes run in your AWS account and connect to your cluster's control plane via the Kubernetes API
     * server endpoint and a certificate file that is created for your cluster.
     * </p>
     * <p>
     * Cluster creation typically takes several minutes. After you create an Amazon EKS cluster, you must configure your
     * Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information,
     * see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html">Managing Cluster
     * Authentication</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">Launching
     * Amazon EKS nodes</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterRequest.Builder} to create a request.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceLimitExceededException
     *         You have encountered a service limit on the specified resource.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws UnsupportedAvailabilityZoneException
     *         At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon
     *         EKS. The exception output specifies the supported Availability Zones for your account, from which you can
     *         choose subnets for your cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest)
            throws ResourceInUseException, ResourceLimitExceededException, InvalidParameterException, ClientException,
            ServerException, ServiceUnavailableException, UnsupportedAvailabilityZoneException, AwsServiceException,
            SdkClientException, EksException {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates an AWS Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a
     * cluster to be able to run pods on Fargate.
     * </p>
     * <p>
     * The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on
     * which Fargate profile. This declaration is done through the profile’s selectors. Each profile can have up to five
     * selectors that contain a namespace and labels. A namespace is required for every selector. The label field
     * consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a
     * to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate.
     * </p>
     * <p>
     * When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled
     * with the profile. This role is added to the cluster's Kubernetes <a
     * href="https://kubernetes.io/docs/admin/authorization/rbac/">Role Based Access Control</a> (RBAC) for
     * authorization so that the <code>kubelet</code> that is running on the Fargate infrastructure can register with
     * your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM
     * permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more
     * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution
     * Role</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and
     * then delete the original after the updated profile has finished creating.
     * </p>
     * <p>
     * If any Fargate profiles in a cluster are in the <code>DELETING</code> status, you must wait for that Fargate
     * profile to finish deleting before you can create any other profiles in that cluster.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html">AWS
     * Fargate Profile</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     *
     * @param createFargateProfileRequest
     * @return Result of the CreateFargateProfile operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceLimitExceededException
     *         You have encountered a service limit on the specified resource.
     * @throws UnsupportedAvailabilityZoneException
     *         At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon
     *         EKS. The exception output specifies the supported Availability Zones for your account, from which you can
     *         choose subnets for your cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.CreateFargateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateFargateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFargateProfileResponse createFargateProfile(CreateFargateProfileRequest createFargateProfileRequest)
            throws InvalidParameterException, InvalidRequestException, ClientException, ServerException,
            ResourceLimitExceededException, UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException,
            EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a
     * cluster to be able to run pods on Fargate.
     * </p>
     * <p>
     * The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on
     * which Fargate profile. This declaration is done through the profile’s selectors. Each profile can have up to five
     * selectors that contain a namespace and labels. A namespace is required for every selector. The label field
     * consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a
     * to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate.
     * </p>
     * <p>
     * When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled
     * with the profile. This role is added to the cluster's Kubernetes <a
     * href="https://kubernetes.io/docs/admin/authorization/rbac/">Role Based Access Control</a> (RBAC) for
     * authorization so that the <code>kubelet</code> that is running on the Fargate infrastructure can register with
     * your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM
     * permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more
     * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution
     * Role</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and
     * then delete the original after the updated profile has finished creating.
     * </p>
     * <p>
     * If any Fargate profiles in a cluster are in the <code>DELETING</code> status, you must wait for that Fargate
     * profile to finish deleting before you can create any other profiles in that cluster.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html">AWS
     * Fargate Profile</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFargateProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFargateProfileRequest#builder()}
     * </p>
     *
     * @param createFargateProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateFargateProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFargateProfile operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceLimitExceededException
     *         You have encountered a service limit on the specified resource.
     * @throws UnsupportedAvailabilityZoneException
     *         At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon
     *         EKS. The exception output specifies the supported Availability Zones for your account, from which you can
     *         choose subnets for your cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.CreateFargateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateFargateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFargateProfileResponse createFargateProfile(
            Consumer<CreateFargateProfileRequest.Builder> createFargateProfileRequest) throws InvalidParameterException,
            InvalidRequestException, ClientException, ServerException, ResourceLimitExceededException,
            UnsupportedAvailabilityZoneException, AwsServiceException, SdkClientException, EksException {
        return createFargateProfile(CreateFargateProfileRequest.builder().applyMutation(createFargateProfileRequest).build());
    }

    /**
     * <p>
     * Creates a managed node group for an Amazon EKS cluster. You can only create a node group for your cluster that is
     * equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release
     * version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch
     * template. For more information about using launch templates, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>.
     * </p>
     * <p>
     * An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are
     * managed by AWS for an Amazon EKS cluster. Each node group uses a version of the Amazon EKS optimized Amazon Linux
     * 2 AMI. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html">Managed Node Groups</a> in the
     * <i>Amazon EKS User Guide</i>.
     * </p>
     *
     * @param createNodegroupRequest
     * @return Result of the CreateNodegroup operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceLimitExceededException
     *         You have encountered a service limit on the specified resource.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.CreateNodegroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateNodegroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNodegroupResponse createNodegroup(CreateNodegroupRequest createNodegroupRequest) throws ResourceInUseException,
            ResourceLimitExceededException, InvalidRequestException, InvalidParameterException, ClientException, ServerException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a managed node group for an Amazon EKS cluster. You can only create a node group for your cluster that is
     * equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release
     * version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch
     * template. For more information about using launch templates, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>.
     * </p>
     * <p>
     * An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are
     * managed by AWS for an Amazon EKS cluster. Each node group uses a version of the Amazon EKS optimized Amazon Linux
     * 2 AMI. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html">Managed Node Groups</a> in the
     * <i>Amazon EKS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNodegroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateNodegroupRequest#builder()}
     * </p>
     *
     * @param createNodegroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateNodegroupRequest.Builder} to create a request.
     * @return Result of the CreateNodegroup operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceLimitExceededException
     *         You have encountered a service limit on the specified resource.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.CreateNodegroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateNodegroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateNodegroupResponse createNodegroup(Consumer<CreateNodegroupRequest.Builder> createNodegroupRequest)
            throws ResourceInUseException, ResourceLimitExceededException, InvalidRequestException, InvalidParameterException,
            ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return createNodegroup(CreateNodegroupRequest.builder().applyMutation(createNodegroupRequest).build());
    }

    /**
     * <p>
     * Delete an Amazon EKS add-on.
     * </p>
     * <p>
     * When you remove the add-on, it will also be deleted from the cluster. You can always manually start an add-on on
     * the cluster using the Kubernetes API.
     * </p>
     *
     * @param deleteAddonRequest
     * @return Result of the DeleteAddon operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DeleteAddon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteAddon" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAddonResponse deleteAddon(DeleteAddonRequest deleteAddonRequest) throws InvalidParameterException,
            InvalidRequestException, ResourceNotFoundException, ClientException, ServerException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an Amazon EKS add-on.
     * </p>
     * <p>
     * When you remove the add-on, it will also be deleted from the cluster. You can always manually start an add-on on
     * the cluster using the Kubernetes API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAddonRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAddonRequest#builder()}
     * </p>
     *
     * @param deleteAddonRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAddonRequest.Builder} to create a request.
     * @return Result of the DeleteAddon operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DeleteAddon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteAddon" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAddonResponse deleteAddon(Consumer<DeleteAddonRequest.Builder> deleteAddonRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException, ClientException,
            ServerException, AwsServiceException, SdkClientException, EksException {
        return deleteAddon(DeleteAddonRequest.builder().applyMutation(deleteAddonRequest).build());
    }

    /**
     * <p>
     * Deletes the Amazon EKS cluster control plane.
     * </p>
     * <p>
     * If you have active services in your cluster that are associated with a load balancer, you must delete those
     * services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have
     * orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html">Deleting a Cluster</a> in the
     * <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more
     * information, see <a>DeleteNodegroup</a> and <a>DeleteFargateProfile</a>.
     * </p>
     *
     * @param deleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ResourceInUseException,
            ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Amazon EKS cluster control plane.
     * </p>
     * <p>
     * If you have active services in your cluster that are associated with a load balancer, you must delete those
     * services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have
     * orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html">Deleting a Cluster</a> in the
     * <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more
     * information, see <a>DeleteNodegroup</a> and <a>DeleteFargateProfile</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterRequest.Builder} to create a request.
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest)
            throws ResourceInUseException, ResourceNotFoundException, ClientException, ServerException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes an AWS Fargate profile.
     * </p>
     * <p>
     * When you delete a Fargate profile, any pods running on Fargate that were created with the profile are deleted. If
     * those pods match another Fargate profile, then they are scheduled on Fargate with that profile. If they no longer
     * match any Fargate profiles, then they are not scheduled on Fargate and they may remain in a pending state.
     * </p>
     * <p>
     * Only one Fargate profile in a cluster can be in the <code>DELETING</code> status at a time. You must wait for a
     * Fargate profile to finish deleting before you can delete any other profiles in that cluster.
     * </p>
     *
     * @param deleteFargateProfileRequest
     * @return Result of the DeleteFargateProfile operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DeleteFargateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteFargateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFargateProfileResponse deleteFargateProfile(DeleteFargateProfileRequest deleteFargateProfileRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Fargate profile.
     * </p>
     * <p>
     * When you delete a Fargate profile, any pods running on Fargate that were created with the profile are deleted. If
     * those pods match another Fargate profile, then they are scheduled on Fargate with that profile. If they no longer
     * match any Fargate profiles, then they are not scheduled on Fargate and they may remain in a pending state.
     * </p>
     * <p>
     * Only one Fargate profile in a cluster can be in the <code>DELETING</code> status at a time. You must wait for a
     * Fargate profile to finish deleting before you can delete any other profiles in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFargateProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFargateProfileRequest#builder()}
     * </p>
     *
     * @param deleteFargateProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFargateProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFargateProfile operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DeleteFargateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteFargateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFargateProfileResponse deleteFargateProfile(
            Consumer<DeleteFargateProfileRequest.Builder> deleteFargateProfileRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return deleteFargateProfile(DeleteFargateProfileRequest.builder().applyMutation(deleteFargateProfileRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon EKS node group for a cluster.
     * </p>
     *
     * @param deleteNodegroupRequest
     * @return Result of the DeleteNodegroup operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DeleteNodegroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteNodegroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNodegroupResponse deleteNodegroup(DeleteNodegroupRequest deleteNodegroupRequest) throws ResourceInUseException,
            ResourceNotFoundException, InvalidParameterException, ClientException, ServerException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon EKS node group for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNodegroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNodegroupRequest#builder()}
     * </p>
     *
     * @param deleteNodegroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNodegroupRequest.Builder} to create a request.
     * @return Result of the DeleteNodegroup operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DeleteNodegroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteNodegroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteNodegroupResponse deleteNodegroup(Consumer<DeleteNodegroupRequest.Builder> deleteNodegroupRequest)
            throws ResourceInUseException, ResourceNotFoundException, InvalidParameterException, ClientException,
            ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return deleteNodegroup(DeleteNodegroupRequest.builder().applyMutation(deleteNodegroupRequest).build());
    }

    /**
     * <p>
     * Describes an Amazon EKS add-on.
     * </p>
     *
     * @param describeAddonRequest
     * @return Result of the DescribeAddon operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeAddon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddon" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAddonResponse describeAddon(DescribeAddonRequest describeAddonRequest) throws InvalidParameterException,
            InvalidRequestException, ResourceNotFoundException, ClientException, ServerException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an Amazon EKS add-on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAddonRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAddonRequest#builder()}
     * </p>
     *
     * @param describeAddonRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAddonRequest.Builder} to create a request.
     * @return Result of the DescribeAddon operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeAddon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddon" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAddonResponse describeAddon(Consumer<DescribeAddonRequest.Builder> describeAddonRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException, ClientException,
            ServerException, AwsServiceException, SdkClientException, EksException {
        return describeAddon(DescribeAddonRequest.builder().applyMutation(describeAddonRequest).build());
    }

    /**
     * <p>
     * Describes the Kubernetes versions that the add-on can be used with.
     * </p>
     *
     * @param describeAddonVersionsRequest
     * @return Result of the DescribeAddonVersions operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeAddonVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAddonVersionsResponse describeAddonVersions(DescribeAddonVersionsRequest describeAddonVersionsRequest)
            throws ServerException, ResourceNotFoundException, InvalidParameterException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Kubernetes versions that the add-on can be used with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAddonVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAddonVersionsRequest#builder()}
     * </p>
     *
     * @param describeAddonVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAddonVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAddonVersions operation returned by the service.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeAddonVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAddonVersionsResponse describeAddonVersions(
            Consumer<DescribeAddonVersionsRequest.Builder> describeAddonVersionsRequest) throws ServerException,
            ResourceNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EksException {
        return describeAddonVersions(DescribeAddonVersionsRequest.builder().applyMutation(describeAddonVersionsRequest).build());
    }

    /**
     * <p>
     * Describes the Kubernetes versions that the add-on can be used with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAddonVersions(software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.DescribeAddonVersionsIterable responses = client.describeAddonVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.DescribeAddonVersionsIterable responses = client
     *             .describeAddonVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.DescribeAddonVersionsIterable responses = client.describeAddonVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAddonVersions(software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAddonVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeAddonVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAddonVersionsIterable describeAddonVersionsPaginator(DescribeAddonVersionsRequest describeAddonVersionsRequest)
            throws ServerException, ResourceNotFoundException, InvalidParameterException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Kubernetes versions that the add-on can be used with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAddonVersions(software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.DescribeAddonVersionsIterable responses = client.describeAddonVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.DescribeAddonVersionsIterable responses = client
     *             .describeAddonVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.DescribeAddonVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.DescribeAddonVersionsIterable responses = client.describeAddonVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAddonVersions(software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAddonVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAddonVersionsRequest#builder()}
     * </p>
     *
     * @param describeAddonVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAddonVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeAddonVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAddonVersionsIterable describeAddonVersionsPaginator(
            Consumer<DescribeAddonVersionsRequest.Builder> describeAddonVersionsRequest) throws ServerException,
            ResourceNotFoundException, InvalidParameterException, AwsServiceException, SdkClientException, EksException {
        return describeAddonVersionsPaginator(DescribeAddonVersionsRequest.builder().applyMutation(describeAddonVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns descriptive information about an Amazon EKS cluster.
     * </p>
     * <p>
     * The API server endpoint and certificate authority data returned by this operation are required for
     * <code>kubelet</code> and <code>kubectl</code> to communicate with your Kubernetes API server. For more
     * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html">Create a
     * kubeconfig for Amazon EKS</a>.
     * </p>
     * <note>
     * <p>
     * The API server endpoint and certificate authority data aren't available until the cluster reaches the
     * <code>ACTIVE</code> state.
     * </p>
     * </note>
     *
     * @param describeClusterRequest
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest)
            throws ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptive information about an Amazon EKS cluster.
     * </p>
     * <p>
     * The API server endpoint and certificate authority data returned by this operation are required for
     * <code>kubelet</code> and <code>kubectl</code> to communicate with your Kubernetes API server. For more
     * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html">Create a
     * kubeconfig for Amazon EKS</a>.
     * </p>
     * <note>
     * <p>
     * The API server endpoint and certificate authority data aren't available until the cluster reaches the
     * <code>ACTIVE</code> state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterRequest.Builder} to create a request.
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest)
            throws ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, EksException {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     * <p>
     * Returns descriptive information about an AWS Fargate profile.
     * </p>
     *
     * @param describeFargateProfileRequest
     * @return Result of the DescribeFargateProfile operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeFargateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeFargateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFargateProfileResponse describeFargateProfile(DescribeFargateProfileRequest describeFargateProfileRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptive information about an AWS Fargate profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFargateProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFargateProfileRequest#builder()}
     * </p>
     *
     * @param describeFargateProfileRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFargateProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFargateProfile operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeFargateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeFargateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFargateProfileResponse describeFargateProfile(
            Consumer<DescribeFargateProfileRequest.Builder> describeFargateProfileRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return describeFargateProfile(DescribeFargateProfileRequest.builder().applyMutation(describeFargateProfileRequest)
                .build());
    }

    /**
     * <p>
     * Returns descriptive information about an identity provider configuration.
     * </p>
     *
     * @param describeIdentityProviderConfigRequest
     * @return Result of the DescribeIdentityProviderConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeIdentityProviderConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeIdentityProviderConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIdentityProviderConfigResponse describeIdentityProviderConfig(
            DescribeIdentityProviderConfigRequest describeIdentityProviderConfigRequest) throws InvalidParameterException,
            ResourceNotFoundException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptive information about an identity provider configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIdentityProviderConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeIdentityProviderConfigRequest#builder()}
     * </p>
     *
     * @param describeIdentityProviderConfigRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIdentityProviderConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeIdentityProviderConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeIdentityProviderConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeIdentityProviderConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeIdentityProviderConfigResponse describeIdentityProviderConfig(
            Consumer<DescribeIdentityProviderConfigRequest.Builder> describeIdentityProviderConfigRequest)
            throws InvalidParameterException, ResourceNotFoundException, ClientException, ServerException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return describeIdentityProviderConfig(DescribeIdentityProviderConfigRequest.builder()
                .applyMutation(describeIdentityProviderConfigRequest).build());
    }

    /**
     * <p>
     * Returns descriptive information about an Amazon EKS node group.
     * </p>
     *
     * @param describeNodegroupRequest
     * @return Result of the DescribeNodegroup operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeNodegroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeNodegroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeNodegroupResponse describeNodegroup(DescribeNodegroupRequest describeNodegroupRequest)
            throws InvalidParameterException, ResourceNotFoundException, ClientException, ServerException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptive information about an Amazon EKS node group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNodegroupRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeNodegroupRequest#builder()}
     * </p>
     *
     * @param describeNodegroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNodegroupRequest.Builder} to create a request.
     * @return Result of the DescribeNodegroup operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeNodegroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeNodegroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeNodegroupResponse describeNodegroup(Consumer<DescribeNodegroupRequest.Builder> describeNodegroupRequest)
            throws InvalidParameterException, ResourceNotFoundException, ClientException, ServerException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return describeNodegroup(DescribeNodegroupRequest.builder().applyMutation(describeNodegroupRequest).build());
    }

    /**
     * <p>
     * Returns descriptive information about an update against your Amazon EKS cluster or associated managed node group.
     * </p>
     * <p>
     * When the status of the update is <code>Succeeded</code>, the update is complete. If an update fails, the status
     * is <code>Failed</code>, and an error detail explains the reason for the failure.
     * </p>
     *
     * @param describeUpdateRequest
     * @return Result of the DescribeUpdate operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeUpdate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeUpdate" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUpdateResponse describeUpdate(DescribeUpdateRequest describeUpdateRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptive information about an update against your Amazon EKS cluster or associated managed node group.
     * </p>
     * <p>
     * When the status of the update is <code>Succeeded</code>, the update is complete. If an update fails, the status
     * is <code>Failed</code>, and an error detail explains the reason for the failure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUpdateRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUpdateRequest#builder()}
     * </p>
     *
     * @param describeUpdateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUpdateRequest.Builder} to create a request.
     * @return Result of the DescribeUpdate operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DescribeUpdate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeUpdate" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUpdateResponse describeUpdate(Consumer<DescribeUpdateRequest.Builder> describeUpdateRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, EksException {
        return describeUpdate(DescribeUpdateRequest.builder().applyMutation(describeUpdateRequest).build());
    }

    /**
     * <p>
     * Disassociates an identity provider configuration from a cluster. If you disassociate an identity provider from
     * your cluster, users included in the provider can no longer access the cluster. However, you can still access the
     * cluster with AWS IAM users.
     * </p>
     *
     * @param disassociateIdentityProviderConfigRequest
     * @return Result of the DisassociateIdentityProviderConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DisassociateIdentityProviderConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DisassociateIdentityProviderConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIdentityProviderConfigResponse disassociateIdentityProviderConfig(
            DisassociateIdentityProviderConfigRequest disassociateIdentityProviderConfigRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceInUseException,
            ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an identity provider configuration from a cluster. If you disassociate an identity provider from
     * your cluster, users included in the provider can no longer access the cluster. However, you can still access the
     * cluster with AWS IAM users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateIdentityProviderConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateIdentityProviderConfigRequest#builder()}
     * </p>
     *
     * @param disassociateIdentityProviderConfigRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateIdentityProviderConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateIdentityProviderConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.DisassociateIdentityProviderConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DisassociateIdentityProviderConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIdentityProviderConfigResponse disassociateIdentityProviderConfig(
            Consumer<DisassociateIdentityProviderConfigRequest.Builder> disassociateIdentityProviderConfigRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceInUseException,
            ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        return disassociateIdentityProviderConfig(DisassociateIdentityProviderConfigRequest.builder()
                .applyMutation(disassociateIdentityProviderConfigRequest).build());
    }

    /**
     * <p>
     * Lists the available add-ons.
     * </p>
     *
     * @param listAddonsRequest
     * @return Result of the ListAddons operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListAddons
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAddons" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAddonsResponse listAddons(ListAddonsRequest listAddonsRequest) throws InvalidParameterException,
            InvalidRequestException, ClientException, ResourceNotFoundException, ServerException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available add-ons.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAddonsRequest#builder()}
     * </p>
     *
     * @param listAddonsRequest
     *        A {@link Consumer} that will call methods on {@link ListAddonsRequest.Builder} to create a request.
     * @return Result of the ListAddons operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListAddons
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAddons" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAddonsResponse listAddons(Consumer<ListAddonsRequest.Builder> listAddonsRequest)
            throws InvalidParameterException, InvalidRequestException, ClientException, ResourceNotFoundException,
            ServerException, AwsServiceException, SdkClientException, EksException {
        return listAddons(ListAddonsRequest.builder().applyMutation(listAddonsRequest).build());
    }

    /**
     * <p>
     * Lists the available add-ons.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAddons(software.amazon.awssdk.services.eks.model.ListAddonsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListAddonsIterable responses = client.listAddonsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListAddonsIterable responses = client.listAddonsPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListAddonsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListAddonsIterable responses = client.listAddonsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddons(software.amazon.awssdk.services.eks.model.ListAddonsRequest)} operation.</b>
     * </p>
     *
     * @param listAddonsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListAddons
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAddons" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAddonsIterable listAddonsPaginator(ListAddonsRequest listAddonsRequest) throws InvalidParameterException,
            InvalidRequestException, ClientException, ResourceNotFoundException, ServerException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available add-ons.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAddons(software.amazon.awssdk.services.eks.model.ListAddonsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListAddonsIterable responses = client.listAddonsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListAddonsIterable responses = client.listAddonsPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListAddonsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListAddonsIterable responses = client.listAddonsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAddons(software.amazon.awssdk.services.eks.model.ListAddonsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAddonsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAddonsRequest#builder()}
     * </p>
     *
     * @param listAddonsRequest
     *        A {@link Consumer} that will call methods on {@link ListAddonsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListAddons
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAddons" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAddonsIterable listAddonsPaginator(Consumer<ListAddonsRequest.Builder> listAddonsRequest)
            throws InvalidParameterException, InvalidRequestException, ClientException, ResourceNotFoundException,
            ServerException, AwsServiceException, SdkClientException, EksException {
        return listAddonsPaginator(ListAddonsRequest.builder().applyMutation(listAddonsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon EKS clusters in your AWS account in the specified Region.
     * </p>
     *
     * @return Result of the ListClusters operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListClusters
     * @see #listClusters(ListClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters() throws InvalidParameterException, ClientException, ServerException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return listClusters(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Amazon EKS clusters in your AWS account in the specified Region.
     * </p>
     *
     * @param listClustersRequest
     * @return Result of the ListClusters operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InvalidParameterException,
            ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon EKS clusters in your AWS account in the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on {@link ListClustersRequest.Builder} to create a request.
     * @return Result of the ListClusters operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, EksException {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon EKS clusters in your AWS account in the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.eks.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.eks.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListClusters
     * @see #listClustersPaginator(ListClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator() throws InvalidParameterException, ClientException, ServerException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        return listClustersPaginator(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Amazon EKS clusters in your AWS account in the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.eks.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.eks.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws InvalidParameterException,
            ClientException, ServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon EKS clusters in your AWS account in the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.eks.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.eks.model.ListClustersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on {@link ListClustersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, EksException {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Lists the AWS Fargate profiles associated with the specified cluster in your AWS account in the specified Region.
     * </p>
     *
     * @param listFargateProfilesRequest
     * @return Result of the ListFargateProfiles operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListFargateProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFargateProfilesResponse listFargateProfiles(ListFargateProfilesRequest listFargateProfilesRequest)
            throws InvalidParameterException, ResourceNotFoundException, ClientException, ServerException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS Fargate profiles associated with the specified cluster in your AWS account in the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFargateProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFargateProfilesRequest#builder()}
     * </p>
     *
     * @param listFargateProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListFargateProfilesRequest.Builder} to create a
     *        request.
     * @return Result of the ListFargateProfiles operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListFargateProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFargateProfilesResponse listFargateProfiles(
            Consumer<ListFargateProfilesRequest.Builder> listFargateProfilesRequest) throws InvalidParameterException,
            ResourceNotFoundException, ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        return listFargateProfiles(ListFargateProfilesRequest.builder().applyMutation(listFargateProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the AWS Fargate profiles associated with the specified cluster in your AWS account in the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFargateProfiles(software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListFargateProfilesIterable responses = client.listFargateProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListFargateProfilesIterable responses = client
     *             .listFargateProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListFargateProfilesIterable responses = client.listFargateProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFargateProfiles(software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest)} operation.</b>
     * </p>
     *
     * @param listFargateProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListFargateProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFargateProfilesIterable listFargateProfilesPaginator(ListFargateProfilesRequest listFargateProfilesRequest)
            throws InvalidParameterException, ResourceNotFoundException, ClientException, ServerException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS Fargate profiles associated with the specified cluster in your AWS account in the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFargateProfiles(software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListFargateProfilesIterable responses = client.listFargateProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListFargateProfilesIterable responses = client
     *             .listFargateProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListFargateProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListFargateProfilesIterable responses = client.listFargateProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFargateProfiles(software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFargateProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListFargateProfilesRequest#builder()}
     * </p>
     *
     * @param listFargateProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListFargateProfilesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListFargateProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFargateProfilesIterable listFargateProfilesPaginator(
            Consumer<ListFargateProfilesRequest.Builder> listFargateProfilesRequest) throws InvalidParameterException,
            ResourceNotFoundException, ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        return listFargateProfilesPaginator(ListFargateProfilesRequest.builder().applyMutation(listFargateProfilesRequest)
                .build());
    }

    /**
     * <p>
     * A list of identity provider configurations.
     * </p>
     *
     * @param listIdentityProviderConfigsRequest
     * @return Result of the ListIdentityProviderConfigs operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListIdentityProviderConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListIdentityProviderConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProviderConfigsResponse listIdentityProviderConfigs(
            ListIdentityProviderConfigsRequest listIdentityProviderConfigsRequest) throws InvalidParameterException,
            ClientException, ServerException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of identity provider configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProviderConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListIdentityProviderConfigsRequest#builder()}
     * </p>
     *
     * @param listIdentityProviderConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityProviderConfigsRequest.Builder} to create
     *        a request.
     * @return Result of the ListIdentityProviderConfigs operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListIdentityProviderConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListIdentityProviderConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProviderConfigsResponse listIdentityProviderConfigs(
            Consumer<ListIdentityProviderConfigsRequest.Builder> listIdentityProviderConfigsRequest)
            throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return listIdentityProviderConfigs(ListIdentityProviderConfigsRequest.builder()
                .applyMutation(listIdentityProviderConfigsRequest).build());
    }

    /**
     * <p>
     * A list of identity provider configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIdentityProviderConfigs(software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListIdentityProviderConfigsIterable responses = client.listIdentityProviderConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListIdentityProviderConfigsIterable responses = client
     *             .listIdentityProviderConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListIdentityProviderConfigsIterable responses = client.listIdentityProviderConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviderConfigs(software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityProviderConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListIdentityProviderConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListIdentityProviderConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProviderConfigsIterable listIdentityProviderConfigsPaginator(
            ListIdentityProviderConfigsRequest listIdentityProviderConfigsRequest) throws InvalidParameterException,
            ClientException, ServerException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of identity provider configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIdentityProviderConfigs(software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListIdentityProviderConfigsIterable responses = client.listIdentityProviderConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListIdentityProviderConfigsIterable responses = client
     *             .listIdentityProviderConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListIdentityProviderConfigsIterable responses = client.listIdentityProviderConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviderConfigs(software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProviderConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListIdentityProviderConfigsRequest#builder()}
     * </p>
     *
     * @param listIdentityProviderConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityProviderConfigsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListIdentityProviderConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListIdentityProviderConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProviderConfigsIterable listIdentityProviderConfigsPaginator(
            Consumer<ListIdentityProviderConfigsRequest.Builder> listIdentityProviderConfigsRequest)
            throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return listIdentityProviderConfigsPaginator(ListIdentityProviderConfigsRequest.builder()
                .applyMutation(listIdentityProviderConfigsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon EKS managed node groups associated with the specified cluster in your AWS account in the
     * specified Region. Self-managed node groups are not listed.
     * </p>
     *
     * @param listNodegroupsRequest
     * @return Result of the ListNodegroups operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListNodegroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodegroupsResponse listNodegroups(ListNodegroupsRequest listNodegroupsRequest) throws InvalidParameterException,
            ClientException, ServerException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon EKS managed node groups associated with the specified cluster in your AWS account in the
     * specified Region. Self-managed node groups are not listed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodegroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodegroupsRequest#builder()}
     * </p>
     *
     * @param listNodegroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListNodegroupsRequest.Builder} to create a request.
     * @return Result of the ListNodegroups operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListNodegroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodegroupsResponse listNodegroups(Consumer<ListNodegroupsRequest.Builder> listNodegroupsRequest)
            throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return listNodegroups(ListNodegroupsRequest.builder().applyMutation(listNodegroupsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon EKS managed node groups associated with the specified cluster in your AWS account in the
     * specified Region. Self-managed node groups are not listed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listNodegroups(software.amazon.awssdk.services.eks.model.ListNodegroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListNodegroupsIterable responses = client.listNodegroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListNodegroupsIterable responses = client.listNodegroupsPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListNodegroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListNodegroupsIterable responses = client.listNodegroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodegroups(software.amazon.awssdk.services.eks.model.ListNodegroupsRequest)} operation.</b>
     * </p>
     *
     * @param listNodegroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListNodegroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodegroupsIterable listNodegroupsPaginator(ListNodegroupsRequest listNodegroupsRequest)
            throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon EKS managed node groups associated with the specified cluster in your AWS account in the
     * specified Region. Self-managed node groups are not listed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listNodegroups(software.amazon.awssdk.services.eks.model.ListNodegroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListNodegroupsIterable responses = client.listNodegroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListNodegroupsIterable responses = client.listNodegroupsPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListNodegroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListNodegroupsIterable responses = client.listNodegroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodegroups(software.amazon.awssdk.services.eks.model.ListNodegroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodegroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodegroupsRequest#builder()}
     * </p>
     *
     * @param listNodegroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListNodegroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ServiceUnavailableException
     *         The service is unavailable. Back off and retry the operation.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListNodegroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodegroupsIterable listNodegroupsPaginator(Consumer<ListNodegroupsRequest.Builder> listNodegroupsRequest)
            throws InvalidParameterException, ClientException, ServerException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        return listNodegroupsPaginator(ListNodegroupsRequest.builder().applyMutation(listNodegroupsRequest).build());
    }

    /**
     * <p>
     * List the tags for an Amazon EKS resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning will depend on the
     *         API, and will be documented in the error message.
     * @throws NotFoundException
     *         A service resource associated with the request could not be found. Clients should not retry such
     *         requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for an Amazon EKS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning will depend on the
     *         API, and will be documented in the error message.
     * @throws NotFoundException
     *         A service resource associated with the request could not be found. Clients should not retry such
     *         requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            NotFoundException, AwsServiceException, SdkClientException, EksException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the updates associated with an Amazon EKS cluster or managed node group in your AWS account, in the
     * specified Region.
     * </p>
     *
     * @param listUpdatesRequest
     * @return Result of the ListUpdates operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUpdatesResponse listUpdates(ListUpdatesRequest listUpdatesRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the updates associated with an Amazon EKS cluster or managed node group in your AWS account, in the
     * specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUpdatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListUpdatesRequest#builder()}
     * </p>
     *
     * @param listUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link ListUpdatesRequest.Builder} to create a request.
     * @return Result of the ListUpdates operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUpdatesResponse listUpdates(Consumer<ListUpdatesRequest.Builder> listUpdatesRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, EksException {
        return listUpdates(ListUpdatesRequest.builder().applyMutation(listUpdatesRequest).build());
    }

    /**
     * <p>
     * Lists the updates associated with an Amazon EKS cluster or managed node group in your AWS account, in the
     * specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUpdates(software.amazon.awssdk.services.eks.model.ListUpdatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListUpdatesIterable responses = client.listUpdatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListUpdatesIterable responses = client.listUpdatesPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListUpdatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListUpdatesIterable responses = client.listUpdatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUpdates(software.amazon.awssdk.services.eks.model.ListUpdatesRequest)} operation.</b>
     * </p>
     *
     * @param listUpdatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUpdatesIterable listUpdatesPaginator(ListUpdatesRequest listUpdatesRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the updates associated with an Amazon EKS cluster or managed node group in your AWS account, in the
     * specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUpdates(software.amazon.awssdk.services.eks.model.ListUpdatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListUpdatesIterable responses = client.listUpdatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.eks.paginators.ListUpdatesIterable responses = client.listUpdatesPaginator(request);
     *     for (software.amazon.awssdk.services.eks.model.ListUpdatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.eks.paginators.ListUpdatesIterable responses = client.listUpdatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUpdates(software.amazon.awssdk.services.eks.model.ListUpdatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUpdatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListUpdatesRequest#builder()}
     * </p>
     *
     * @param listUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link ListUpdatesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.ListUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUpdatesIterable listUpdatesPaginator(Consumer<ListUpdatesRequest.Builder> listUpdatesRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, EksException {
        return listUpdatesPaginator(ListUpdatesRequest.builder().applyMutation(listUpdatesRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags
     * associated with that resource are deleted as well. Tags that you create for Amazon EKS resources do not propagate
     * to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that
     * tag does not automatically propagate to the subnets and nodes associated with the cluster.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning will depend on the
     *         API, and will be documented in the error message.
     * @throws NotFoundException
     *         A service resource associated with the request could not be found. Clients should not retry such
     *         requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, NotFoundException,
            AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags
     * associated with that resource are deleted as well. Tags that you create for Amazon EKS resources do not propagate
     * to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that
     * tag does not automatically propagate to the subnets and nodes associated with the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning will depend on the
     *         API, and will be documented in the error message.
     * @throws NotFoundException
     *         A service resource associated with the request could not be found. Clients should not retry such
     *         requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            NotFoundException, AwsServiceException, SdkClientException, EksException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning will depend on the
     *         API, and will be documented in the error message.
     * @throws NotFoundException
     *         A service resource associated with the request could not be found. Clients should not retry such
     *         requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            NotFoundException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         This exception is thrown if the request contains a semantic error. The precise meaning will depend on the
     *         API, and will be documented in the error message.
     * @throws NotFoundException
     *         A service resource associated with the request could not be found. Clients should not retry such
     *         requests.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, NotFoundException, AwsServiceException, SdkClientException, EksException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon EKS add-on.
     * </p>
     *
     * @param updateAddonRequest
     * @return Result of the UpdateAddon operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateAddon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateAddon" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAddonResponse updateAddon(UpdateAddonRequest updateAddonRequest) throws InvalidParameterException,
            InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ClientException, ServerException,
            AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon EKS add-on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAddonRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAddonRequest#builder()}
     * </p>
     *
     * @param updateAddonRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAddonRequest.Builder} to create a request.
     * @return Result of the UpdateAddon operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateAddon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateAddon" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAddonResponse updateAddon(Consumer<UpdateAddonRequest.Builder> updateAddonRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException, ResourceInUseException,
            ClientException, ServerException, AwsServiceException, SdkClientException, EksException {
        return updateAddon(UpdateAddonRequest.builder().applyMutation(updateAddonRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response
     * output includes an update ID that you can use to track the status of your cluster update with the
     * <a>DescribeUpdate</a> API operation.
     * </p>
     * <p>
     * You can use this API operation to enable or disable exporting the Kubernetes control plane logs for your cluster
     * to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more
     * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS
     * Cluster Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <note>
     * <p>
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
     * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.
     * </p>
     * </note>
     * <p>
     * You can also use this API operation to enable or disable public and private access to your cluster's Kubernetes
     * API server endpoint. By default, public access is enabled, and private access is disabled. For more information,
     * see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint
     * Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <important>
     * <p>
     * You can't update the subnets or security group IDs for an existing cluster.
     * </p>
     * </important>
     * <p>
     * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster
     * status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is
     * complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>
     * .
     * </p>
     *
     * @param updateClusterConfigRequest
     * @return Result of the UpdateClusterConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateClusterConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterConfigResponse updateClusterConfig(UpdateClusterConfigRequest updateClusterConfigRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceInUseException,
            ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response
     * output includes an update ID that you can use to track the status of your cluster update with the
     * <a>DescribeUpdate</a> API operation.
     * </p>
     * <p>
     * You can use this API operation to enable or disable exporting the Kubernetes control plane logs for your cluster
     * to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more
     * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS
     * Cluster Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <note>
     * <p>
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
     * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.
     * </p>
     * </note>
     * <p>
     * You can also use this API operation to enable or disable public and private access to your cluster's Kubernetes
     * API server endpoint. By default, public access is enabled, and private access is disabled. For more information,
     * see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint
     * Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <important>
     * <p>
     * You can't update the subnets or security group IDs for an existing cluster.
     * </p>
     * </important>
     * <p>
     * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster
     * status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is
     * complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>
     * .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateClusterConfigRequest#builder()}
     * </p>
     *
     * @param updateClusterConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateClusterConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateClusterConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateClusterConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterConfigResponse updateClusterConfig(
            Consumer<UpdateClusterConfigRequest.Builder> updateClusterConfigRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, EksException {
        return updateClusterConfig(UpdateClusterConfigRequest.builder().applyMutation(updateClusterConfigRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the
     * update. The response output includes an update ID that you can use to track the status of your cluster update
     * with the <a>DescribeUpdate</a> API operation.
     * </p>
     * <p>
     * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster
     * status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is
     * complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>
     * .
     * </p>
     * <p>
     * If your cluster has managed node groups attached to it, all of your node groups’ Kubernetes versions must match
     * the cluster’s Kubernetes version in order to update the cluster to a new Kubernetes version.
     * </p>
     *
     * @param updateClusterVersionRequest
     * @return Result of the UpdateClusterVersion operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateClusterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterVersionResponse updateClusterVersion(UpdateClusterVersionRequest updateClusterVersionRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceInUseException,
            ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the
     * update. The response output includes an update ID that you can use to track the status of your cluster update
     * with the <a>DescribeUpdate</a> API operation.
     * </p>
     * <p>
     * Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster
     * status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is
     * complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>
     * .
     * </p>
     * <p>
     * If your cluster has managed node groups attached to it, all of your node groups’ Kubernetes versions must match
     * the cluster’s Kubernetes version in order to update the cluster to a new Kubernetes version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateClusterVersionRequest#builder()}
     * </p>
     *
     * @param updateClusterVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateClusterVersionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateClusterVersion operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateClusterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterVersionResponse updateClusterVersion(
            Consumer<UpdateClusterVersionRequest.Builder> updateClusterVersionRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, EksException {
        return updateClusterVersion(UpdateClusterVersionRequest.builder().applyMutation(updateClusterVersionRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update.
     * The response output includes an update ID that you can use to track the status of your node group update with the
     * <a>DescribeUpdate</a> API operation. Currently you can update the Kubernetes labels for a node group or the
     * scaling configuration.
     * </p>
     *
     * @param updateNodegroupConfigRequest
     * @return Result of the UpdateNodegroupConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateNodegroupConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateNodegroupConfigResponse updateNodegroupConfig(UpdateNodegroupConfigRequest updateNodegroupConfigRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceInUseException,
            ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update.
     * The response output includes an update ID that you can use to track the status of your node group update with the
     * <a>DescribeUpdate</a> API operation. Currently you can update the Kubernetes labels for a node group or the
     * scaling configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNodegroupConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNodegroupConfigRequest#builder()}
     * </p>
     *
     * @param updateNodegroupConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNodegroupConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateNodegroupConfig operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateNodegroupConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateNodegroupConfigResponse updateNodegroupConfig(
            Consumer<UpdateNodegroupConfigRequest.Builder> updateNodegroupConfigRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, EksException {
        return updateNodegroupConfig(UpdateNodegroupConfigRequest.builder().applyMutation(updateNodegroupConfigRequest).build());
    }

    /**
     * <p>
     * Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.
     * </p>
     * <p>
     * You can update a node group using a launch template only if the node group was originally deployed with a launch
     * template. If you need to update a custom AMI in a node group that was deployed with a launch template, then
     * update your custom AMI, specify the new ID in a new version of the launch template, and then update the node
     * group to the new version of the launch template.
     * </p>
     * <p>
     * If you update without a launch template, then you can update to the latest available AMI version of a node
     * group's current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the
     * latest AMI version of your cluster's current Kubernetes version by specifying your cluster's Kubernetes version
     * in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon
     * Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * You cannot roll back a node group to an earlier Kubernetes version or AMI version.
     * </p>
     * <p>
     * When a node in a managed node group is terminated due to a scaling action or update, the pods in that node are
     * drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can
     * <code>force</code> the update if Amazon EKS is unable to drain the nodes as a result of a pod disruption budget
     * issue.
     * </p>
     *
     * @param updateNodegroupVersionRequest
     * @return Result of the UpdateNodegroupVersion operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateNodegroupVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateNodegroupVersionResponse updateNodegroupVersion(UpdateNodegroupVersionRequest updateNodegroupVersionRequest)
            throws InvalidParameterException, ClientException, ServerException, ResourceInUseException,
            ResourceNotFoundException, InvalidRequestException, AwsServiceException, SdkClientException, EksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.
     * </p>
     * <p>
     * You can update a node group using a launch template only if the node group was originally deployed with a launch
     * template. If you need to update a custom AMI in a node group that was deployed with a launch template, then
     * update your custom AMI, specify the new ID in a new version of the launch template, and then update the node
     * group to the new version of the launch template.
     * </p>
     * <p>
     * If you update without a launch template, then you can update to the latest available AMI version of a node
     * group's current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the
     * latest AMI version of your cluster's current Kubernetes version by specifying your cluster's Kubernetes version
     * in the request. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon
     * Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * You cannot roll back a node group to an earlier Kubernetes version or AMI version.
     * </p>
     * <p>
     * When a node in a managed node group is terminated due to a scaling action or update, the pods in that node are
     * drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can
     * <code>force</code> the update if Amazon EKS is unable to drain the nodes as a result of a pod disruption budget
     * issue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNodegroupVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNodegroupVersionRequest#builder()}
     * </p>
     *
     * @param updateNodegroupVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNodegroupVersionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateNodegroupVersion operation returned by the service.
     * @throws InvalidParameterException
     *         The specified parameter is invalid. Review the available parameters for the API request.
     * @throws ClientException
     *         These errors are usually caused by a client action. Actions can include using an action or resource on
     *         behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier
     *         that is not valid.
     * @throws ServerException
     *         These errors are usually caused by a server-side issue.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>.
     *         You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node
     *         groups are Region-specific.
     * @throws InvalidRequestException
     *         The request is invalid given the state of the cluster. Check the state of the cluster and the associated
     *         operations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EksClient.UpdateNodegroupVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateNodegroupVersionResponse updateNodegroupVersion(
            Consumer<UpdateNodegroupVersionRequest.Builder> updateNodegroupVersionRequest) throws InvalidParameterException,
            ClientException, ServerException, ResourceInUseException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, EksException {
        return updateNodegroupVersion(UpdateNodegroupVersionRequest.builder().applyMutation(updateNodegroupVersionRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    /**
     * Create an instance of {@link EksWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link EksWaiter}
     */
    default EksWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
