/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNodegroupRequest extends EksRequest implements
        ToCopyableBuilder<CreateNodegroupRequest.Builder, CreateNodegroupRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(CreateNodegroupRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodegroupName").getter(getter(CreateNodegroupRequest::nodegroupName))
            .setter(setter(Builder::nodegroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroupName").build()).build();

    private static final SdkField<NodegroupScalingConfig> SCALING_CONFIG_FIELD = SdkField
            .<NodegroupScalingConfig> builder(MarshallingType.SDK_POJO).memberName("scalingConfig")
            .getter(getter(CreateNodegroupRequest::scalingConfig)).setter(setter(Builder::scalingConfig))
            .constructor(NodegroupScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfig").build()).build();

    private static final SdkField<Integer> DISK_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("diskSize").getter(getter(CreateNodegroupRequest::diskSize)).setter(setter(Builder::diskSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSize").build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(CreateNodegroupRequest::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceTypes")
            .getter(getter(CreateNodegroupRequest::instanceTypes))
            .setter(setter(Builder::instanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AMI_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amiType").getter(getter(CreateNodegroupRequest::amiTypeAsString)).setter(setter(Builder::amiType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiType").build()).build();

    private static final SdkField<RemoteAccessConfig> REMOTE_ACCESS_FIELD = SdkField
            .<RemoteAccessConfig> builder(MarshallingType.SDK_POJO).memberName("remoteAccess")
            .getter(getter(CreateNodegroupRequest::remoteAccess)).setter(setter(Builder::remoteAccess))
            .constructor(RemoteAccessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccess").build()).build();

    private static final SdkField<String> NODE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeRole").getter(getter(CreateNodegroupRequest::nodeRole)).setter(setter(Builder::nodeRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRole").build()).build();

    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("labels")
            .getter(getter(CreateNodegroupRequest::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Taint>> TAINTS_FIELD = SdkField
            .<List<Taint>> builder(MarshallingType.LIST)
            .memberName("taints")
            .getter(getter(CreateNodegroupRequest::taints))
            .setter(setter(Builder::taints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Taint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Taint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateNodegroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateNodegroupRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("launchTemplate")
            .getter(getter(CreateNodegroupRequest::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()).build();

    private static final SdkField<NodegroupUpdateConfig> UPDATE_CONFIG_FIELD = SdkField
            .<NodegroupUpdateConfig> builder(MarshallingType.SDK_POJO).memberName("updateConfig")
            .getter(getter(CreateNodegroupRequest::updateConfig)).setter(setter(Builder::updateConfig))
            .constructor(NodegroupUpdateConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateConfig").build()).build();

    private static final SdkField<String> CAPACITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capacityType").getter(getter(CreateNodegroupRequest::capacityTypeAsString))
            .setter(setter(Builder::capacityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityType").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CreateNodegroupRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseVersion").getter(getter(CreateNodegroupRequest::releaseVersion))
            .setter(setter(Builder::releaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODEGROUP_NAME_FIELD, SCALING_CONFIG_FIELD, DISK_SIZE_FIELD, SUBNETS_FIELD, INSTANCE_TYPES_FIELD, AMI_TYPE_FIELD,
            REMOTE_ACCESS_FIELD, NODE_ROLE_FIELD, LABELS_FIELD, TAINTS_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD,
            LAUNCH_TEMPLATE_FIELD, UPDATE_CONFIG_FIELD, CAPACITY_TYPE_FIELD, VERSION_FIELD, RELEASE_VERSION_FIELD));

    private final String clusterName;

    private final String nodegroupName;

    private final NodegroupScalingConfig scalingConfig;

    private final Integer diskSize;

    private final List<String> subnets;

    private final List<String> instanceTypes;

    private final String amiType;

    private final RemoteAccessConfig remoteAccess;

    private final String nodeRole;

    private final Map<String, String> labels;

    private final List<Taint> taints;

    private final Map<String, String> tags;

    private final String clientRequestToken;

    private final LaunchTemplateSpecification launchTemplate;

    private final NodegroupUpdateConfig updateConfig;

    private final String capacityType;

    private final String version;

    private final String releaseVersion;

    private CreateNodegroupRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodegroupName = builder.nodegroupName;
        this.scalingConfig = builder.scalingConfig;
        this.diskSize = builder.diskSize;
        this.subnets = builder.subnets;
        this.instanceTypes = builder.instanceTypes;
        this.amiType = builder.amiType;
        this.remoteAccess = builder.remoteAccess;
        this.nodeRole = builder.nodeRole;
        this.labels = builder.labels;
        this.taints = builder.taints;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
        this.launchTemplate = builder.launchTemplate;
        this.updateConfig = builder.updateConfig;
        this.capacityType = builder.capacityType;
        this.version = builder.version;
        this.releaseVersion = builder.releaseVersion;
    }

    /**
     * <p>
     * The name of the cluster to create the node group in.
     * </p>
     * 
     * @return The name of the cluster to create the node group in.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The unique name to give your node group.
     * </p>
     * 
     * @return The unique name to give your node group.
     */
    public final String nodegroupName() {
        return nodegroupName;
    }

    /**
     * <p>
     * The scaling configuration details for the Auto Scaling group that is created for your node group.
     * </p>
     * 
     * @return The scaling configuration details for the Auto Scaling group that is created for your node group.
     */
    public final NodegroupScalingConfig scalingConfig() {
        return scalingConfig;
    }

    /**
     * <p>
     * The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If you specify
     * <code>launchTemplate</code>, then don't specify <code>diskSize</code>, or the node group deployment will fail.
     * For more information about using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * 
     * @return The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If you
     *         specify <code>launchTemplate</code>, then don't specify <code>diskSize</code>, or the node group
     *         deployment will fail. For more information about using launch templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     */
    public final Integer diskSize() {
        return diskSize;
    }

    /**
     * Returns true if the Subnets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnets to use for the Auto Scaling group that is created for your node group. If you specify
     * <code>launchTemplate</code>, then don't specify <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">
     * <code>SubnetId</code> </a> in your launch template, or the node group deployment will fail. For more information
     * about using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The subnets to use for the Auto Scaling group that is created for your node group. If you specify
     *         <code>launchTemplate</code>, then don't specify <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">
     *         <code>SubnetId</code> </a> in your launch template, or the node group deployment will fail. For more
     *         information about using launch templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * Returns true if the InstanceTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstanceTypes() {
        return instanceTypes != null && !(instanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify
     * <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter. If you specify <code>launchTemplate</code>,
     * then you can specify zero or one instance type in your launch template <i>or</i> you can specify 0-20 instance
     * types for <code>instanceTypes</code>. If however, you specify an instance type in your launch template <i>and</i>
     * specify any <code>instanceTypes</code>, the node group deployment will fail. If you don't specify an instance
     * type in a launch template or for <code>instanceTypes</code>, then <code>t3.medium</code> is used, by default. If
     * you specify <code>Spot</code> for <code>capacityType</code>, then we recommend specifying multiple values for
     * <code>instanceTypes</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types"
     * >Managed node group capacity types</a> and <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify
     *         <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter. If you specify
     *         <code>launchTemplate</code>, then you can specify zero or one instance type in your launch template
     *         <i>or</i> you can specify 0-20 instance types for <code>instanceTypes</code>. If however, you specify an
     *         instance type in your launch template <i>and</i> specify any <code>instanceTypes</code>, the node group
     *         deployment will fail. If you don't specify an instance type in a launch template or for
     *         <code>instanceTypes</code>, then <code>t3.medium</code> is used, by default. If you specify
     *         <code>Spot</code> for <code>capacityType</code>, then we recommend specifying multiple values for
     *         <code>instanceTypes</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types"
     *         >Managed node group capacity types</a> and <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the <i>Amazon EKS User Guide</i>.
     */
    public final List<String> instanceTypes() {
        return instanceTypes;
    }

    /**
     * <p>
     * The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type. Non-GPU
     * instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the <code>AL2_ARM_64</code>
     * AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify <code>launchTemplate</code>,
     * and your launch template uses a custom AMI, then don't specify <code>amiType</code>, or the node group deployment
     * will fail. For more information about using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amiType} will
     * return {@link AMITypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #amiTypeAsString}.
     * </p>
     * 
     * @return The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type.
     *         Non-GPU instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the
     *         <code>AL2_ARM_64</code> AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you
     *         specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
     *         <code>amiType</code>, or the node group deployment will fail. For more information about using launch
     *         templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     * @see AMITypes
     */
    public final AMITypes amiType() {
        return AMITypes.fromValue(amiType);
    }

    /**
     * <p>
     * The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type. Non-GPU
     * instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the <code>AL2_ARM_64</code>
     * AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify <code>launchTemplate</code>,
     * and your launch template uses a custom AMI, then don't specify <code>amiType</code>, or the node group deployment
     * will fail. For more information about using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amiType} will
     * return {@link AMITypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #amiTypeAsString}.
     * </p>
     * 
     * @return The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type.
     *         Non-GPU instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the
     *         <code>AL2_ARM_64</code> AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you
     *         specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
     *         <code>amiType</code>, or the node group deployment will fail. For more information about using launch
     *         templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     * @see AMITypes
     */
    public final String amiTypeAsString() {
        return amiType;
    }

    /**
     * <p>
     * The remote access (SSH) configuration to use with your node group. If you specify <code>launchTemplate</code>,
     * then don't specify <code>remoteAccess</code>, or the node group deployment will fail. For more information about
     * using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * 
     * @return The remote access (SSH) configuration to use with your node group. If you specify
     *         <code>launchTemplate</code>, then don't specify <code>remoteAccess</code>, or the node group deployment
     *         will fail. For more information about using launch templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     */
    public final RemoteAccessConfig remoteAccess() {
        return remoteAccess;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node
     * <code>kubelet</code> daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for
     * these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register
     * them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more
     * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">Amazon EKS
     * node IAM role</a> in the <i> <i>Amazon EKS User Guide</i> </i>. If you specify <code>launchTemplate</code>, then
     * don't specify <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html">
     * <code>IamInstanceProfile</code> </a> in your launch template, or the node group deployment will fail. For more
     * information about using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker
     *         node <code>kubelet</code> daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive
     *         permissions for these API calls through an IAM instance profile and associated policies. Before you can
     *         launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when
     *         they are launched. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">Amazon EKS node IAM
     *         role</a> in the <i> <i>Amazon EKS User Guide</i> </i>. If you specify <code>launchTemplate</code>, then
     *         don't specify <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html">
     *         <code>IamInstanceProfile</code> </a> in your launch template, or the node group deployment will fail. For
     *         more information about using launch templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     */
    public final String nodeRole() {
        return nodeRole;
    }

    /**
     * Returns true if the Labels property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Kubernetes labels to be applied to the nodes in the node group when they are created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Kubernetes labels to be applied to the nodes in the node group when they are created.
     */
    public final Map<String, String> labels() {
        return labels;
    }

    /**
     * Returns true if the Taints property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTaints() {
        return taints != null && !(taints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Kubernetes taints to be applied to the nodes in the node group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTaints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Kubernetes taints to be applied to the nodes in the node group.
     */
    public final List<Taint> taints() {
        return taints;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata to apply to the node group to assist with categorization and organization. Each tag consists of a
     * key and an optional value, both of which you define. Node group tags do not propagate to any other resources
     * associated with the node group, such as the Amazon EC2 instances or subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata to apply to the node group to assist with categorization and organization. Each tag consists
     *         of a key and an optional value, both of which you define. Node group tags do not propagate to any other
     *         resources associated with the node group, such as the Amazon EC2 instances or subnets.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * An object representing a node group's launch template specification. If specified, then do not specify
     * <code>instanceTypes</code>, <code>diskSize</code>, or <code>remoteAccess</code> and make sure that the launch
     * template meets the requirements in <code>launchTemplateSpecification</code>.
     * </p>
     * 
     * @return An object representing a node group's launch template specification. If specified, then do not specify
     *         <code>instanceTypes</code>, <code>diskSize</code>, or <code>remoteAccess</code> and make sure that the
     *         launch template meets the requirements in <code>launchTemplateSpecification</code>.
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * The node group update configuration.
     * </p>
     * 
     * @return The node group update configuration.
     */
    public final NodegroupUpdateConfig updateConfig() {
        return updateConfig;
    }

    /**
     * <p>
     * The capacity type for your node group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #capacityType} will
     * return {@link CapacityTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #capacityTypeAsString}.
     * </p>
     * 
     * @return The capacity type for your node group.
     * @see CapacityTypes
     */
    public final CapacityTypes capacityType() {
        return CapacityTypes.fromValue(capacityType);
    }

    /**
     * <p>
     * The capacity type for your node group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #capacityType} will
     * return {@link CapacityTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #capacityTypeAsString}.
     * </p>
     * 
     * @return The capacity type for your node group.
     * @see CapacityTypes
     */
    public final String capacityTypeAsString() {
        return capacityType;
    }

    /**
     * <p>
     * The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used,
     * and this is the only accepted specified value. If you specify <code>launchTemplate</code>, and your launch
     * template uses a custom AMI, then don't specify <code>version</code>, or the node group deployment will fail. For
     * more information about using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * 
     * @return The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster
     *         is used, and this is the only accepted specified value. If you specify <code>launchTemplate</code>, and
     *         your launch template uses a custom AMI, then don't specify <code>version</code>, or the node group
     *         deployment will fail. For more information about using launch templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI
     * version for the node group's current Kubernetes version is used. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon
     * Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>. If you specify <code>launchTemplate</code>, and
     * your launch template uses a custom AMI, then don't specify <code>releaseVersion</code>, or the node group
     * deployment will fail. For more information about using launch templates with Amazon EKS, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the
     * Amazon EKS User Guide.
     * </p>
     * 
     * @return The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest
     *         available AMI version for the node group's current Kubernetes version is used. For more information, see
     *         <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS
     *         optimized Amazon Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>. If you specify
     *         <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
     *         <code>releaseVersion</code>, or the node group deployment will fail. For more information about using
     *         launch templates with Amazon EKS, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>
     *         in the Amazon EKS User Guide.
     */
    public final String releaseVersion() {
        return releaseVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(diskSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypes() ? instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(amiTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccess());
        hashCode = 31 * hashCode + Objects.hashCode(nodeRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTaints() ? taints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(updateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(capacityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(releaseVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodegroupRequest)) {
            return false;
        }
        CreateNodegroupRequest other = (CreateNodegroupRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(nodegroupName(), other.nodegroupName())
                && Objects.equals(scalingConfig(), other.scalingConfig()) && Objects.equals(diskSize(), other.diskSize())
                && hasSubnets() == other.hasSubnets() && Objects.equals(subnets(), other.subnets())
                && hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(instanceTypes(), other.instanceTypes())
                && Objects.equals(amiTypeAsString(), other.amiTypeAsString())
                && Objects.equals(remoteAccess(), other.remoteAccess()) && Objects.equals(nodeRole(), other.nodeRole())
                && hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && hasTaints() == other.hasTaints() && Objects.equals(taints(), other.taints()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(updateConfig(), other.updateConfig())
                && Objects.equals(capacityTypeAsString(), other.capacityTypeAsString())
                && Objects.equals(version(), other.version()) && Objects.equals(releaseVersion(), other.releaseVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNodegroupRequest").add("ClusterName", clusterName()).add("NodegroupName", nodegroupName())
                .add("ScalingConfig", scalingConfig()).add("DiskSize", diskSize())
                .add("Subnets", hasSubnets() ? subnets() : null)
                .add("InstanceTypes", hasInstanceTypes() ? instanceTypes() : null).add("AmiType", amiTypeAsString())
                .add("RemoteAccess", remoteAccess()).add("NodeRole", nodeRole()).add("Labels", hasLabels() ? labels() : null)
                .add("Taints", hasTaints() ? taints() : null).add("Tags", hasTags() ? tags() : null)
                .add("ClientRequestToken", clientRequestToken()).add("LaunchTemplate", launchTemplate())
                .add("UpdateConfig", updateConfig()).add("CapacityType", capacityTypeAsString()).add("Version", version())
                .add("ReleaseVersion", releaseVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "nodegroupName":
            return Optional.ofNullable(clazz.cast(nodegroupName()));
        case "scalingConfig":
            return Optional.ofNullable(clazz.cast(scalingConfig()));
        case "diskSize":
            return Optional.ofNullable(clazz.cast(diskSize()));
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "instanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypes()));
        case "amiType":
            return Optional.ofNullable(clazz.cast(amiTypeAsString()));
        case "remoteAccess":
            return Optional.ofNullable(clazz.cast(remoteAccess()));
        case "nodeRole":
            return Optional.ofNullable(clazz.cast(nodeRole()));
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "taints":
            return Optional.ofNullable(clazz.cast(taints()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "launchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "updateConfig":
            return Optional.ofNullable(clazz.cast(updateConfig()));
        case "capacityType":
            return Optional.ofNullable(clazz.cast(capacityTypeAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "releaseVersion":
            return Optional.ofNullable(clazz.cast(releaseVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNodegroupRequest, T> g) {
        return obj -> g.apply((CreateNodegroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNodegroupRequest> {
        /**
         * <p>
         * The name of the cluster to create the node group in.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster to create the node group in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The unique name to give your node group.
         * </p>
         * 
         * @param nodegroupName
         *        The unique name to give your node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupName(String nodegroupName);

        /**
         * <p>
         * The scaling configuration details for the Auto Scaling group that is created for your node group.
         * </p>
         * 
         * @param scalingConfig
         *        The scaling configuration details for the Auto Scaling group that is created for your node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfig(NodegroupScalingConfig scalingConfig);

        /**
         * <p>
         * The scaling configuration details for the Auto Scaling group that is created for your node group.
         * </p>
         * This is a convenience that creates an instance of the {@link NodegroupScalingConfig.Builder} avoiding the
         * need to create one manually via {@link NodegroupScalingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodegroupScalingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfig(NodegroupScalingConfig)}.
         * 
         * @param scalingConfig
         *        a consumer that will call methods on {@link NodegroupScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfig(NodegroupScalingConfig)
         */
        default Builder scalingConfig(Consumer<NodegroupScalingConfig.Builder> scalingConfig) {
            return scalingConfig(NodegroupScalingConfig.builder().applyMutation(scalingConfig).build());
        }

        /**
         * <p>
         * The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If you
         * specify <code>launchTemplate</code>, then don't specify <code>diskSize</code>, or the node group deployment
         * will fail. For more information about using launch templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param diskSize
         *        The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If
         *        you specify <code>launchTemplate</code>, then don't specify <code>diskSize</code>, or the node group
         *        deployment will fail. For more information about using launch templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSize(Integer diskSize);

        /**
         * <p>
         * The subnets to use for the Auto Scaling group that is created for your node group. If you specify
         * <code>launchTemplate</code>, then don't specify <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">
         * <code>SubnetId</code> </a> in your launch template, or the node group deployment will fail. For more
         * information about using launch templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param subnets
         *        The subnets to use for the Auto Scaling group that is created for your node group. If you specify
         *        <code>launchTemplate</code>, then don't specify <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">
         *        <code>SubnetId</code> </a> in your launch template, or the node group deployment will fail. For more
         *        information about using launch templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The subnets to use for the Auto Scaling group that is created for your node group. If you specify
         * <code>launchTemplate</code>, then don't specify <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">
         * <code>SubnetId</code> </a> in your launch template, or the node group deployment will fail. For more
         * information about using launch templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param subnets
         *        The subnets to use for the Auto Scaling group that is created for your node group. If you specify
         *        <code>launchTemplate</code>, then don't specify <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">
         *        <code>SubnetId</code> </a> in your launch template, or the node group deployment will fail. For more
         *        information about using launch templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify
         * <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter. If you specify
         * <code>launchTemplate</code>, then you can specify zero or one instance type in your launch template <i>or</i>
         * you can specify 0-20 instance types for <code>instanceTypes</code>. If however, you specify an instance type
         * in your launch template <i>and</i> specify any <code>instanceTypes</code>, the node group deployment will
         * fail. If you don't specify an instance type in a launch template or for <code>instanceTypes</code>, then
         * <code>t3.medium</code> is used, by default. If you specify <code>Spot</code> for <code>capacityType</code>,
         * then we recommend specifying multiple values for <code>instanceTypes</code>. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types"
         * >Managed node group capacity types</a> and <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param instanceTypes
         *        Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify
         *        <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter. If you specify
         *        <code>launchTemplate</code>, then you can specify zero or one instance type in your launch template
         *        <i>or</i> you can specify 0-20 instance types for <code>instanceTypes</code>. If however, you specify
         *        an instance type in your launch template <i>and</i> specify any <code>instanceTypes</code>, the node
         *        group deployment will fail. If you don't specify an instance type in a launch template or for
         *        <code>instanceTypes</code>, then <code>t3.medium</code> is used, by default. If you specify
         *        <code>Spot</code> for <code>capacityType</code>, then we recommend specifying multiple values for
         *        <code>instanceTypes</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types"
         *        >Managed node group capacity types</a> and <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<String> instanceTypes);

        /**
         * <p>
         * Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify
         * <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter. If you specify
         * <code>launchTemplate</code>, then you can specify zero or one instance type in your launch template <i>or</i>
         * you can specify 0-20 instance types for <code>instanceTypes</code>. If however, you specify an instance type
         * in your launch template <i>and</i> specify any <code>instanceTypes</code>, the node group deployment will
         * fail. If you don't specify an instance type in a launch template or for <code>instanceTypes</code>, then
         * <code>t3.medium</code> is used, by default. If you specify <code>Spot</code> for <code>capacityType</code>,
         * then we recommend specifying multiple values for <code>instanceTypes</code>. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types"
         * >Managed node group capacity types</a> and <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param instanceTypes
         *        Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify
         *        <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter. If you specify
         *        <code>launchTemplate</code>, then you can specify zero or one instance type in your launch template
         *        <i>or</i> you can specify 0-20 instance types for <code>instanceTypes</code>. If however, you specify
         *        an instance type in your launch template <i>and</i> specify any <code>instanceTypes</code>, the node
         *        group deployment will fail. If you don't specify an instance type in a launch template or for
         *        <code>instanceTypes</code>, then <code>t3.medium</code> is used, by default. If you specify
         *        <code>Spot</code> for <code>capacityType</code>, then we recommend specifying multiple values for
         *        <code>instanceTypes</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types"
         *        >Managed node group capacity types</a> and <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(String... instanceTypes);

        /**
         * <p>
         * The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type.
         * Non-GPU instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the
         * <code>AL2_ARM_64</code> AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify
         * <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         * <code>amiType</code>, or the node group deployment will fail. For more information about using launch
         * templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param amiType
         *        The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI
         *        type. Non-GPU instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the
         *        <code>AL2_ARM_64</code> AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you
         *        specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         *        <code>amiType</code>, or the node group deployment will fail. For more information about using launch
         *        templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @see AMITypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AMITypes
         */
        Builder amiType(String amiType);

        /**
         * <p>
         * The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type.
         * Non-GPU instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the
         * <code>AL2_ARM_64</code> AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify
         * <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         * <code>amiType</code>, or the node group deployment will fail. For more information about using launch
         * templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param amiType
         *        The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI
         *        type. Non-GPU instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the
         *        <code>AL2_ARM_64</code> AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you
         *        specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         *        <code>amiType</code>, or the node group deployment will fail. For more information about using launch
         *        templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @see AMITypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AMITypes
         */
        Builder amiType(AMITypes amiType);

        /**
         * <p>
         * The remote access (SSH) configuration to use with your node group. If you specify <code>launchTemplate</code>
         * , then don't specify <code>remoteAccess</code>, or the node group deployment will fail. For more information
         * about using launch templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param remoteAccess
         *        The remote access (SSH) configuration to use with your node group. If you specify
         *        <code>launchTemplate</code>, then don't specify <code>remoteAccess</code>, or the node group
         *        deployment will fail. For more information about using launch templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccess(RemoteAccessConfig remoteAccess);

        /**
         * <p>
         * The remote access (SSH) configuration to use with your node group. If you specify <code>launchTemplate</code>
         * , then don't specify <code>remoteAccess</code>, or the node group deployment will fail. For more information
         * about using launch templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * This is a convenience that creates an instance of the {@link RemoteAccessConfig.Builder} avoiding the need to
         * create one manually via {@link RemoteAccessConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RemoteAccessConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #remoteAccess(RemoteAccessConfig)}.
         * 
         * @param remoteAccess
         *        a consumer that will call methods on {@link RemoteAccessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteAccess(RemoteAccessConfig)
         */
        default Builder remoteAccess(Consumer<RemoteAccessConfig.Builder> remoteAccess) {
            return remoteAccess(RemoteAccessConfig.builder().applyMutation(remoteAccess).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node
         * <code>kubelet</code> daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions
         * for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and
         * register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">Amazon EKS node IAM
         * role</a> in the <i> <i>Amazon EKS User Guide</i> </i>. If you specify <code>launchTemplate</code>, then don't
         * specify <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html">
         * <code>IamInstanceProfile</code> </a> in your launch template, or the node group deployment will fail. For
         * more information about using launch templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param nodeRole
         *        The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS
         *        worker node <code>kubelet</code> daemon makes calls to Amazon Web Services APIs on your behalf. Nodes
         *        receive permissions for these API calls through an IAM instance profile and associated policies.
         *        Before you can launch nodes and register them into a cluster, you must create an IAM role for those
         *        nodes to use when they are launched. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">Amazon EKS node IAM
         *        role</a> in the <i> <i>Amazon EKS User Guide</i> </i>. If you specify <code>launchTemplate</code>,
         *        then don't specify <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html">
         *        <code>IamInstanceProfile</code> </a> in your launch template, or the node group deployment will fail.
         *        For more information about using launch templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRole(String nodeRole);

        /**
         * <p>
         * The Kubernetes labels to be applied to the nodes in the node group when they are created.
         * </p>
         * 
         * @param labels
         *        The Kubernetes labels to be applied to the nodes in the node group when they are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Map<String, String> labels);

        /**
         * <p>
         * The Kubernetes taints to be applied to the nodes in the node group.
         * </p>
         * 
         * @param taints
         *        The Kubernetes taints to be applied to the nodes in the node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taints(Collection<Taint> taints);

        /**
         * <p>
         * The Kubernetes taints to be applied to the nodes in the node group.
         * </p>
         * 
         * @param taints
         *        The Kubernetes taints to be applied to the nodes in the node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taints(Taint... taints);

        /**
         * <p>
         * The Kubernetes taints to be applied to the nodes in the node group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Taint>.Builder} avoiding the need to create
         * one manually via {@link List<Taint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Taint>.Builder#build()} is called immediately and its result
         * is passed to {@link #taints(List<Taint>)}.
         * 
         * @param taints
         *        a consumer that will call methods on {@link List<Taint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taints(List<Taint>)
         */
        Builder taints(Consumer<Taint.Builder>... taints);

        /**
         * <p>
         * The metadata to apply to the node group to assist with categorization and organization. Each tag consists of
         * a key and an optional value, both of which you define. Node group tags do not propagate to any other
         * resources associated with the node group, such as the Amazon EC2 instances or subnets.
         * </p>
         * 
         * @param tags
         *        The metadata to apply to the node group to assist with categorization and organization. Each tag
         *        consists of a key and an optional value, both of which you define. Node group tags do not propagate to
         *        any other resources associated with the node group, such as the Amazon EC2 instances or subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * An object representing a node group's launch template specification. If specified, then do not specify
         * <code>instanceTypes</code>, <code>diskSize</code>, or <code>remoteAccess</code> and make sure that the launch
         * template meets the requirements in <code>launchTemplateSpecification</code>.
         * </p>
         * 
         * @param launchTemplate
         *        An object representing a node group's launch template specification. If specified, then do not specify
         *        <code>instanceTypes</code>, <code>diskSize</code>, or <code>remoteAccess</code> and make sure that the
         *        launch template meets the requirements in <code>launchTemplateSpecification</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * An object representing a node group's launch template specification. If specified, then do not specify
         * <code>instanceTypes</code>, <code>diskSize</code>, or <code>remoteAccess</code> and make sure that the launch
         * template meets the requirements in <code>launchTemplateSpecification</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateSpecification.Builder} avoiding
         * the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * The node group update configuration.
         * </p>
         * 
         * @param updateConfig
         *        The node group update configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateConfig(NodegroupUpdateConfig updateConfig);

        /**
         * <p>
         * The node group update configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link NodegroupUpdateConfig.Builder} avoiding the need
         * to create one manually via {@link NodegroupUpdateConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodegroupUpdateConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #updateConfig(NodegroupUpdateConfig)}.
         * 
         * @param updateConfig
         *        a consumer that will call methods on {@link NodegroupUpdateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateConfig(NodegroupUpdateConfig)
         */
        default Builder updateConfig(Consumer<NodegroupUpdateConfig.Builder> updateConfig) {
            return updateConfig(NodegroupUpdateConfig.builder().applyMutation(updateConfig).build());
        }

        /**
         * <p>
         * The capacity type for your node group.
         * </p>
         * 
         * @param capacityType
         *        The capacity type for your node group.
         * @see CapacityTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityTypes
         */
        Builder capacityType(String capacityType);

        /**
         * <p>
         * The capacity type for your node group.
         * </p>
         * 
         * @param capacityType
         *        The capacity type for your node group.
         * @see CapacityTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityTypes
         */
        Builder capacityType(CapacityTypes capacityType);

        /**
         * <p>
         * The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is
         * used, and this is the only accepted specified value. If you specify <code>launchTemplate</code>, and your
         * launch template uses a custom AMI, then don't specify <code>version</code>, or the node group deployment will
         * fail. For more information about using launch templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param version
         *        The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the
         *        cluster is used, and this is the only accepted specified value. If you specify
         *        <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         *        <code>version</code>, or the node group deployment will fail. For more information about using launch
         *        templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available
         * AMI version for the node group's current Kubernetes version is used. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized
         * Amazon Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>. If you specify
         * <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         * <code>releaseVersion</code>, or the node group deployment will fail. For more information about using launch
         * templates with Amazon EKS, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in
         * the Amazon EKS User Guide.
         * </p>
         * 
         * @param releaseVersion
         *        The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest
         *        available AMI version for the node group's current Kubernetes version is used. For more information,
         *        see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS
         *        optimized Amazon Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>. If you specify
         *        <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify
         *        <code>releaseVersion</code>, or the node group deployment will fail. For more information about using
         *        launch templates with Amazon EKS, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the Amazon EKS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseVersion(String releaseVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String nodegroupName;

        private NodegroupScalingConfig scalingConfig;

        private Integer diskSize;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private String amiType;

        private RemoteAccessConfig remoteAccess;

        private String nodeRole;

        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private List<Taint> taints = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientRequestToken;

        private LaunchTemplateSpecification launchTemplate;

        private NodegroupUpdateConfig updateConfig;

        private String capacityType;

        private String version;

        private String releaseVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodegroupRequest model) {
            super(model);
            clusterName(model.clusterName);
            nodegroupName(model.nodegroupName);
            scalingConfig(model.scalingConfig);
            diskSize(model.diskSize);
            subnets(model.subnets);
            instanceTypes(model.instanceTypes);
            amiType(model.amiType);
            remoteAccess(model.remoteAccess);
            nodeRole(model.nodeRole);
            labels(model.labels);
            taints(model.taints);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
            launchTemplate(model.launchTemplate);
            updateConfig(model.updateConfig);
            capacityType(model.capacityType);
            version(model.version);
            releaseVersion(model.releaseVersion);
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getNodegroupName() {
            return nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        public final NodegroupScalingConfig.Builder getScalingConfig() {
            return scalingConfig != null ? scalingConfig.toBuilder() : null;
        }

        @Override
        public final Builder scalingConfig(NodegroupScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final void setScalingConfig(NodegroupScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        public final Integer getDiskSize() {
            return diskSize;
        }

        @Override
        public final Builder diskSize(Integer diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public final void setDiskSize(Integer diskSize) {
            this.diskSize = diskSize;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<String> getInstanceTypes() {
            if (instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        public final String getAmiType() {
            return amiType;
        }

        @Override
        public final Builder amiType(String amiType) {
            this.amiType = amiType;
            return this;
        }

        @Override
        public final Builder amiType(AMITypes amiType) {
            this.amiType(amiType == null ? null : amiType.toString());
            return this;
        }

        public final void setAmiType(String amiType) {
            this.amiType = amiType;
        }

        public final RemoteAccessConfig.Builder getRemoteAccess() {
            return remoteAccess != null ? remoteAccess.toBuilder() : null;
        }

        @Override
        public final Builder remoteAccess(RemoteAccessConfig remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        public final void setRemoteAccess(RemoteAccessConfig.BuilderImpl remoteAccess) {
            this.remoteAccess = remoteAccess != null ? remoteAccess.build() : null;
        }

        public final String getNodeRole() {
            return nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        public final Map<String, String> getLabels() {
            if (labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return labels;
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
            return this;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
        }

        public final List<Taint.Builder> getTaints() {
            List<Taint.Builder> result = _taintsListCopier.copyToBuilder(this.taints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder taints(Collection<Taint> taints) {
            this.taints = _taintsListCopier.copy(taints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taints(Taint... taints) {
            taints(Arrays.asList(taints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taints(Consumer<Taint.Builder>... taints) {
            taints(Stream.of(taints).map(c -> Taint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTaints(Collection<Taint.BuilderImpl> taints) {
            this.taints = _taintsListCopier.copyFromBuilder(taints);
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public final NodegroupUpdateConfig.Builder getUpdateConfig() {
            return updateConfig != null ? updateConfig.toBuilder() : null;
        }

        @Override
        public final Builder updateConfig(NodegroupUpdateConfig updateConfig) {
            this.updateConfig = updateConfig;
            return this;
        }

        public final void setUpdateConfig(NodegroupUpdateConfig.BuilderImpl updateConfig) {
            this.updateConfig = updateConfig != null ? updateConfig.build() : null;
        }

        public final String getCapacityType() {
            return capacityType;
        }

        @Override
        public final Builder capacityType(String capacityType) {
            this.capacityType = capacityType;
            return this;
        }

        @Override
        public final Builder capacityType(CapacityTypes capacityType) {
            this.capacityType(capacityType == null ? null : capacityType.toString());
            return this;
        }

        public final void setCapacityType(String capacityType) {
            this.capacityType = capacityType;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getReleaseVersion() {
            return releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodegroupRequest build() {
            return new CreateNodegroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
