/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the configuration for an OpenID Connect (OIDC) identity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OidcIdentityProviderConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OidcIdentityProviderConfig.Builder, OidcIdentityProviderConfig> {
    private static final SdkField<String> IDENTITY_PROVIDER_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("identityProviderConfigName")
            .getter(getter(OidcIdentityProviderConfig::identityProviderConfigName))
            .setter(setter(Builder::identityProviderConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfigName").build())
            .build();

    private static final SdkField<String> IDENTITY_PROVIDER_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderConfigArn").getter(getter(OidcIdentityProviderConfig::identityProviderConfigArn))
            .setter(setter(Builder::identityProviderConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderConfigArn").build())
            .build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(OidcIdentityProviderConfig::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> ISSUER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("issuerUrl").getter(getter(OidcIdentityProviderConfig::issuerUrl)).setter(setter(Builder::issuerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerUrl").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(OidcIdentityProviderConfig::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> USERNAME_CLAIM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usernameClaim").getter(getter(OidcIdentityProviderConfig::usernameClaim))
            .setter(setter(Builder::usernameClaim))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernameClaim").build()).build();

    private static final SdkField<String> USERNAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usernamePrefix").getter(getter(OidcIdentityProviderConfig::usernamePrefix))
            .setter(setter(Builder::usernamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernamePrefix").build()).build();

    private static final SdkField<String> GROUPS_CLAIM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupsClaim").getter(getter(OidcIdentityProviderConfig::groupsClaim))
            .setter(setter(Builder::groupsClaim))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupsClaim").build()).build();

    private static final SdkField<String> GROUPS_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupsPrefix").getter(getter(OidcIdentityProviderConfig::groupsPrefix))
            .setter(setter(Builder::groupsPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupsPrefix").build()).build();

    private static final SdkField<Map<String, String>> REQUIRED_CLAIMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("requiredClaims")
            .getter(getter(OidcIdentityProviderConfig::requiredClaims))
            .setter(setter(Builder::requiredClaims))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredClaims").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(OidcIdentityProviderConfig::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(OidcIdentityProviderConfig::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IDENTITY_PROVIDER_CONFIG_NAME_FIELD, IDENTITY_PROVIDER_CONFIG_ARN_FIELD, CLUSTER_NAME_FIELD, ISSUER_URL_FIELD,
            CLIENT_ID_FIELD, USERNAME_CLAIM_FIELD, USERNAME_PREFIX_FIELD, GROUPS_CLAIM_FIELD, GROUPS_PREFIX_FIELD,
            REQUIRED_CLAIMS_FIELD, TAGS_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identityProviderConfigName;

    private final String identityProviderConfigArn;

    private final String clusterName;

    private final String issuerUrl;

    private final String clientId;

    private final String usernameClaim;

    private final String usernamePrefix;

    private final String groupsClaim;

    private final String groupsPrefix;

    private final Map<String, String> requiredClaims;

    private final Map<String, String> tags;

    private final String status;

    private OidcIdentityProviderConfig(BuilderImpl builder) {
        this.identityProviderConfigName = builder.identityProviderConfigName;
        this.identityProviderConfigArn = builder.identityProviderConfigArn;
        this.clusterName = builder.clusterName;
        this.issuerUrl = builder.issuerUrl;
        this.clientId = builder.clientId;
        this.usernameClaim = builder.usernameClaim;
        this.usernamePrefix = builder.usernamePrefix;
        this.groupsClaim = builder.groupsClaim;
        this.groupsPrefix = builder.groupsPrefix;
        this.requiredClaims = builder.requiredClaims;
        this.tags = builder.tags;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return The name of the configuration.
     */
    public final String identityProviderConfigName() {
        return identityProviderConfigName;
    }

    /**
     * <p>
     * The ARN of the configuration.
     * </p>
     * 
     * @return The ARN of the configuration.
     */
    public final String identityProviderConfigArn() {
        return identityProviderConfigArn;
    }

    /**
     * <p>
     * The cluster that the configuration is associated to.
     * </p>
     * 
     * @return The cluster that the configuration is associated to.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The URL of the OIDC identity provider that allows the API server to discover public signing keys for verifying
     * tokens.
     * </p>
     * 
     * @return The URL of the OIDC identity provider that allows the API server to discover public signing keys for
     *         verifying tokens.
     */
    public final String issuerUrl() {
        return issuerUrl;
    }

    /**
     * <p>
     * This is also known as <i>audience</i>. The ID of the client application that makes authentication requests to the
     * OIDC identity provider.
     * </p>
     * 
     * @return This is also known as <i>audience</i>. The ID of the client application that makes authentication
     *         requests to the OIDC identity provider.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The JSON Web token (JWT) claim that is used as the username.
     * </p>
     * 
     * @return The JSON Web token (JWT) claim that is used as the username.
     */
    public final String usernameClaim() {
        return usernameClaim;
    }

    /**
     * <p>
     * The prefix that is prepended to username claims to prevent clashes with existing names. The prefix can't contain
     * <code>system:</code>
     * </p>
     * 
     * @return The prefix that is prepended to username claims to prevent clashes with existing names. The prefix can't
     *         contain <code>system:</code>
     */
    public final String usernamePrefix() {
        return usernamePrefix;
    }

    /**
     * <p>
     * The JSON web token (JWT) claim that the provider uses to return your groups.
     * </p>
     * 
     * @return The JSON web token (JWT) claim that the provider uses to return your groups.
     */
    public final String groupsClaim() {
        return groupsClaim;
    }

    /**
     * <p>
     * The prefix that is prepended to group claims to prevent clashes with existing names (such as <code>system:</code>
     * groups). For example, the value<code> oidc:</code> creates group names like <code>oidc:engineering</code> and
     * <code>oidc:infra</code>. The prefix can't contain <code>system:</code>
     * </p>
     * 
     * @return The prefix that is prepended to group claims to prevent clashes with existing names (such as
     *         <code>system:</code> groups). For example, the value<code> oidc:</code> creates group names like
     *         <code>oidc:engineering</code> and <code>oidc:infra</code>. The prefix can't contain <code>system:</code>
     */
    public final String groupsPrefix() {
        return groupsPrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredClaims property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequiredClaims() {
        return requiredClaims != null && !(requiredClaims instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be
     * present in the token with a matching value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredClaims} method.
     * </p>
     * 
     * @return The key-value pairs that describe required claims in the identity token. If set, each claim is verified
     *         to be present in the token with a matching value.
     */
    public final Map<String, String> requiredClaims() {
        return requiredClaims;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata to apply to the provider configuration to assist with categorization and organization. Each tag
     * consists of a key and an optional value. You define both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata to apply to the provider configuration to assist with categorization and organization. Each
     *         tag consists of a key and an optional value. You define both.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The status of the OIDC identity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfigStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the OIDC identity provider.
     * @see ConfigStatus
     */
    public final ConfigStatus status() {
        return ConfigStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the OIDC identity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfigStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the OIDC identity provider.
     * @see ConfigStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(issuerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(usernameClaim());
        hashCode = 31 * hashCode + Objects.hashCode(usernamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(groupsClaim());
        hashCode = 31 * hashCode + Objects.hashCode(groupsPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiredClaims() ? requiredClaims() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcIdentityProviderConfig)) {
            return false;
        }
        OidcIdentityProviderConfig other = (OidcIdentityProviderConfig) obj;
        return Objects.equals(identityProviderConfigName(), other.identityProviderConfigName())
                && Objects.equals(identityProviderConfigArn(), other.identityProviderConfigArn())
                && Objects.equals(clusterName(), other.clusterName()) && Objects.equals(issuerUrl(), other.issuerUrl())
                && Objects.equals(clientId(), other.clientId()) && Objects.equals(usernameClaim(), other.usernameClaim())
                && Objects.equals(usernamePrefix(), other.usernamePrefix()) && Objects.equals(groupsClaim(), other.groupsClaim())
                && Objects.equals(groupsPrefix(), other.groupsPrefix()) && hasRequiredClaims() == other.hasRequiredClaims()
                && Objects.equals(requiredClaims(), other.requiredClaims()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OidcIdentityProviderConfig").add("IdentityProviderConfigName", identityProviderConfigName())
                .add("IdentityProviderConfigArn", identityProviderConfigArn()).add("ClusterName", clusterName())
                .add("IssuerUrl", issuerUrl()).add("ClientId", clientId()).add("UsernameClaim", usernameClaim())
                .add("UsernamePrefix", usernamePrefix()).add("GroupsClaim", groupsClaim()).add("GroupsPrefix", groupsPrefix())
                .add("RequiredClaims", hasRequiredClaims() ? requiredClaims() : null).add("Tags", hasTags() ? tags() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityProviderConfigName":
            return Optional.ofNullable(clazz.cast(identityProviderConfigName()));
        case "identityProviderConfigArn":
            return Optional.ofNullable(clazz.cast(identityProviderConfigArn()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "issuerUrl":
            return Optional.ofNullable(clazz.cast(issuerUrl()));
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "usernameClaim":
            return Optional.ofNullable(clazz.cast(usernameClaim()));
        case "usernamePrefix":
            return Optional.ofNullable(clazz.cast(usernamePrefix()));
        case "groupsClaim":
            return Optional.ofNullable(clazz.cast(groupsClaim()));
        case "groupsPrefix":
            return Optional.ofNullable(clazz.cast(groupsPrefix()));
        case "requiredClaims":
            return Optional.ofNullable(clazz.cast(requiredClaims()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OidcIdentityProviderConfig, T> g) {
        return obj -> g.apply((OidcIdentityProviderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OidcIdentityProviderConfig> {
        /**
         * <p>
         * The name of the configuration.
         * </p>
         * 
         * @param identityProviderConfigName
         *        The name of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfigName(String identityProviderConfigName);

        /**
         * <p>
         * The ARN of the configuration.
         * </p>
         * 
         * @param identityProviderConfigArn
         *        The ARN of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfigArn(String identityProviderConfigArn);

        /**
         * <p>
         * The cluster that the configuration is associated to.
         * </p>
         * 
         * @param clusterName
         *        The cluster that the configuration is associated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The URL of the OIDC identity provider that allows the API server to discover public signing keys for
         * verifying tokens.
         * </p>
         * 
         * @param issuerUrl
         *        The URL of the OIDC identity provider that allows the API server to discover public signing keys for
         *        verifying tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuerUrl(String issuerUrl);

        /**
         * <p>
         * This is also known as <i>audience</i>. The ID of the client application that makes authentication requests to
         * the OIDC identity provider.
         * </p>
         * 
         * @param clientId
         *        This is also known as <i>audience</i>. The ID of the client application that makes authentication
         *        requests to the OIDC identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The JSON Web token (JWT) claim that is used as the username.
         * </p>
         * 
         * @param usernameClaim
         *        The JSON Web token (JWT) claim that is used as the username.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernameClaim(String usernameClaim);

        /**
         * <p>
         * The prefix that is prepended to username claims to prevent clashes with existing names. The prefix can't
         * contain <code>system:</code>
         * </p>
         * 
         * @param usernamePrefix
         *        The prefix that is prepended to username claims to prevent clashes with existing names. The prefix
         *        can't contain <code>system:</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernamePrefix(String usernamePrefix);

        /**
         * <p>
         * The JSON web token (JWT) claim that the provider uses to return your groups.
         * </p>
         * 
         * @param groupsClaim
         *        The JSON web token (JWT) claim that the provider uses to return your groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupsClaim(String groupsClaim);

        /**
         * <p>
         * The prefix that is prepended to group claims to prevent clashes with existing names (such as
         * <code>system:</code> groups). For example, the value<code> oidc:</code> creates group names like
         * <code>oidc:engineering</code> and <code>oidc:infra</code>. The prefix can't contain <code>system:</code>
         * </p>
         * 
         * @param groupsPrefix
         *        The prefix that is prepended to group claims to prevent clashes with existing names (such as
         *        <code>system:</code> groups). For example, the value<code> oidc:</code> creates group names like
         *        <code>oidc:engineering</code> and <code>oidc:infra</code>. The prefix can't contain
         *        <code>system:</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupsPrefix(String groupsPrefix);

        /**
         * <p>
         * The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be
         * present in the token with a matching value.
         * </p>
         * 
         * @param requiredClaims
         *        The key-value pairs that describe required claims in the identity token. If set, each claim is
         *        verified to be present in the token with a matching value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredClaims(Map<String, String> requiredClaims);

        /**
         * <p>
         * The metadata to apply to the provider configuration to assist with categorization and organization. Each tag
         * consists of a key and an optional value. You define both.
         * </p>
         * 
         * @param tags
         *        The metadata to apply to the provider configuration to assist with categorization and organization.
         *        Each tag consists of a key and an optional value. You define both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The status of the OIDC identity provider.
         * </p>
         * 
         * @param status
         *        The status of the OIDC identity provider.
         * @see ConfigStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the OIDC identity provider.
         * </p>
         * 
         * @param status
         *        The status of the OIDC identity provider.
         * @see ConfigStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigStatus
         */
        Builder status(ConfigStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String identityProviderConfigName;

        private String identityProviderConfigArn;

        private String clusterName;

        private String issuerUrl;

        private String clientId;

        private String usernameClaim;

        private String usernamePrefix;

        private String groupsClaim;

        private String groupsPrefix;

        private Map<String, String> requiredClaims = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OidcIdentityProviderConfig model) {
            identityProviderConfigName(model.identityProviderConfigName);
            identityProviderConfigArn(model.identityProviderConfigArn);
            clusterName(model.clusterName);
            issuerUrl(model.issuerUrl);
            clientId(model.clientId);
            usernameClaim(model.usernameClaim);
            usernamePrefix(model.usernamePrefix);
            groupsClaim(model.groupsClaim);
            groupsPrefix(model.groupsPrefix);
            requiredClaims(model.requiredClaims);
            tags(model.tags);
            status(model.status);
        }

        public final String getIdentityProviderConfigName() {
            return identityProviderConfigName;
        }

        public final void setIdentityProviderConfigName(String identityProviderConfigName) {
            this.identityProviderConfigName = identityProviderConfigName;
        }

        @Override
        @Transient
        public final Builder identityProviderConfigName(String identityProviderConfigName) {
            this.identityProviderConfigName = identityProviderConfigName;
            return this;
        }

        public final String getIdentityProviderConfigArn() {
            return identityProviderConfigArn;
        }

        public final void setIdentityProviderConfigArn(String identityProviderConfigArn) {
            this.identityProviderConfigArn = identityProviderConfigArn;
        }

        @Override
        @Transient
        public final Builder identityProviderConfigArn(String identityProviderConfigArn) {
            this.identityProviderConfigArn = identityProviderConfigArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        @Transient
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getIssuerUrl() {
            return issuerUrl;
        }

        public final void setIssuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
        }

        @Override
        @Transient
        public final Builder issuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        @Transient
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getUsernameClaim() {
            return usernameClaim;
        }

        public final void setUsernameClaim(String usernameClaim) {
            this.usernameClaim = usernameClaim;
        }

        @Override
        @Transient
        public final Builder usernameClaim(String usernameClaim) {
            this.usernameClaim = usernameClaim;
            return this;
        }

        public final String getUsernamePrefix() {
            return usernamePrefix;
        }

        public final void setUsernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
        }

        @Override
        @Transient
        public final Builder usernamePrefix(String usernamePrefix) {
            this.usernamePrefix = usernamePrefix;
            return this;
        }

        public final String getGroupsClaim() {
            return groupsClaim;
        }

        public final void setGroupsClaim(String groupsClaim) {
            this.groupsClaim = groupsClaim;
        }

        @Override
        @Transient
        public final Builder groupsClaim(String groupsClaim) {
            this.groupsClaim = groupsClaim;
            return this;
        }

        public final String getGroupsPrefix() {
            return groupsPrefix;
        }

        public final void setGroupsPrefix(String groupsPrefix) {
            this.groupsPrefix = groupsPrefix;
        }

        @Override
        @Transient
        public final Builder groupsPrefix(String groupsPrefix) {
            this.groupsPrefix = groupsPrefix;
            return this;
        }

        public final Map<String, String> getRequiredClaims() {
            if (requiredClaims instanceof SdkAutoConstructMap) {
                return null;
            }
            return requiredClaims;
        }

        public final void setRequiredClaims(Map<String, String> requiredClaims) {
            this.requiredClaims = _requiredClaimsMapCopier.copy(requiredClaims);
        }

        @Override
        @Transient
        public final Builder requiredClaims(Map<String, String> requiredClaims) {
            this.requiredClaims = _requiredClaimsMapCopier.copy(requiredClaims);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ConfigStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public OidcIdentityProviderConfig build() {
            return new OidcIdentityProviderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
