/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The full description of your identity configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderConfigResponse.Builder, IdentityProviderConfigResponse> {
    private static final SdkField<OidcIdentityProviderConfig> OIDC_FIELD = SdkField
            .<OidcIdentityProviderConfig> builder(MarshallingType.SDK_POJO).memberName("oidc")
            .getter(getter(IdentityProviderConfigResponse::oidc)).setter(setter(Builder::oidc))
            .constructor(OidcIdentityProviderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oidc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OIDC_FIELD));

    private static final long serialVersionUID = 1L;

    private final OidcIdentityProviderConfig oidc;

    private IdentityProviderConfigResponse(BuilderImpl builder) {
        this.oidc = builder.oidc;
    }

    /**
     * <p>
     * An object that represents an OpenID Connect (OIDC) identity provider configuration.
     * </p>
     * 
     * @return An object that represents an OpenID Connect (OIDC) identity provider configuration.
     */
    public final OidcIdentityProviderConfig oidc() {
        return oidc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(oidc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderConfigResponse)) {
            return false;
        }
        IdentityProviderConfigResponse other = (IdentityProviderConfigResponse) obj;
        return Objects.equals(oidc(), other.oidc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProviderConfigResponse").add("Oidc", oidc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "oidc":
            return Optional.ofNullable(clazz.cast(oidc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderConfigResponse, T> g) {
        return obj -> g.apply((IdentityProviderConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderConfigResponse> {
        /**
         * <p>
         * An object that represents an OpenID Connect (OIDC) identity provider configuration.
         * </p>
         * 
         * @param oidc
         *        An object that represents an OpenID Connect (OIDC) identity provider configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidc(OidcIdentityProviderConfig oidc);

        /**
         * <p>
         * An object that represents an OpenID Connect (OIDC) identity provider configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OidcIdentityProviderConfig.Builder}
         * avoiding the need to create one manually via {@link OidcIdentityProviderConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OidcIdentityProviderConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #oidc(OidcIdentityProviderConfig)}.
         * 
         * @param oidc
         *        a consumer that will call methods on {@link OidcIdentityProviderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidc(OidcIdentityProviderConfig)
         */
        default Builder oidc(Consumer<OidcIdentityProviderConfig.Builder> oidc) {
            return oidc(OidcIdentityProviderConfig.builder().applyMutation(oidc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OidcIdentityProviderConfig oidc;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderConfigResponse model) {
            oidc(model.oidc);
        }

        public final OidcIdentityProviderConfig.Builder getOidc() {
            return oidc != null ? oidc.toBuilder() : null;
        }

        public final void setOidc(OidcIdentityProviderConfig.BuilderImpl oidc) {
            this.oidc = oidc != null ? oidc.build() : null;
        }

        @Override
        public final Builder oidc(OidcIdentityProviderConfig oidc) {
            this.oidc = oidc;
            return this;
        }

        @Override
        public IdentityProviderConfigResponse build() {
            return new IdentityProviderConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
