/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterConfigRequest extends EksRequest implements
        ToCopyableBuilder<UpdateClusterConfigRequest.Builder, UpdateClusterConfigRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateClusterConfigRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<VpcConfigRequest> RESOURCES_VPC_CONFIG_FIELD = SdkField
            .<VpcConfigRequest> builder(MarshallingType.SDK_POJO).memberName("resourcesVpcConfig")
            .getter(getter(UpdateClusterConfigRequest::resourcesVpcConfig)).setter(setter(Builder::resourcesVpcConfig))
            .constructor(VpcConfigRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesVpcConfig").build())
            .build();

    private static final SdkField<Logging> LOGGING_FIELD = SdkField.<Logging> builder(MarshallingType.SDK_POJO)
            .memberName("logging").getter(getter(UpdateClusterConfigRequest::logging)).setter(setter(Builder::logging))
            .constructor(Logging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(UpdateClusterConfigRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RESOURCES_VPC_CONFIG_FIELD, LOGGING_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String name;

    private final VpcConfigRequest resourcesVpcConfig;

    private final Logging logging;

    private final String clientRequestToken;

    private UpdateClusterConfigRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.logging = builder.logging;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the Amazon EKS cluster to update.
     * </p>
     * 
     * @return The name of the Amazon EKS cluster to update.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the ResourcesVpcConfig property for this object.
     * 
     * @return The value of the ResourcesVpcConfig property for this object.
     */
    public final VpcConfigRequest resourcesVpcConfig() {
        return resourcesVpcConfig;
    }

    /**
     * <p>
     * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default,
     * cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control plane
     * logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <note>
     * <p>
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
     * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
     * </p>
     * </note>
     * 
     * @return Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
     *         default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster
     *         control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
     *         <p>
     *         CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs.
     *         For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
     *         </p>
     */
    public final Logging logging() {
        return logging;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterConfigRequest)) {
            return false;
        }
        UpdateClusterConfigRequest other = (UpdateClusterConfigRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(resourcesVpcConfig(), other.resourcesVpcConfig())
                && Objects.equals(logging(), other.logging()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterConfigRequest").add("Name", name()).add("ResourcesVpcConfig", resourcesVpcConfig())
                .add("Logging", logging()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resourcesVpcConfig":
            return Optional.ofNullable(clazz.cast(resourcesVpcConfig()));
        case "logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterConfigRequest, T> g) {
        return obj -> g.apply((UpdateClusterConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterConfigRequest> {
        /**
         * <p>
         * The name of the Amazon EKS cluster to update.
         * </p>
         * 
         * @param name
         *        The name of the Amazon EKS cluster to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the ResourcesVpcConfig property for this object.
         *
         * @param resourcesVpcConfig
         *        The new value for the ResourcesVpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig);

        /**
         * Sets the value of the ResourcesVpcConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link VpcConfigRequest.Builder} avoiding the need to
         * create one manually via {@link VpcConfigRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfigRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #resourcesVpcConfig(VpcConfigRequest)}.
         * 
         * @param resourcesVpcConfig
         *        a consumer that will call methods on {@link VpcConfigRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesVpcConfig(VpcConfigRequest)
         */
        default Builder resourcesVpcConfig(Consumer<VpcConfigRequest.Builder> resourcesVpcConfig) {
            return resourcesVpcConfig(VpcConfigRequest.builder().applyMutation(resourcesVpcConfig).build());
        }

        /**
         * <p>
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
         * default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control
         * plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <note>
         * <p>
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
         * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
         * </p>
         * </note>
         * 
         * @param logging
         *        Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
         *        default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster
         *        control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
         *        <p>
         *        CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane
         *        logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch
         *        Pricing</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(Logging logging);

        /**
         * <p>
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By
         * default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control
         * plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * <note>
         * <p>
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For
         * more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link Logging.Builder} avoiding the need to
         * create one manually via {@link Logging#builder()}.
         *
         * When the {@link Consumer} completes, {@link Logging.Builder#build()} is called immediately and its result is
         * passed to {@link #logging(Logging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link Logging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(Logging)
         */
        default Builder logging(Consumer<Logging.Builder> logging) {
            return logging(Logging.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String name;

        private VpcConfigRequest resourcesVpcConfig;

        private Logging logging;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterConfigRequest model) {
            super(model);
            name(model.name);
            resourcesVpcConfig(model.resourcesVpcConfig);
            logging(model.logging);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final VpcConfigRequest.Builder getResourcesVpcConfig() {
            return resourcesVpcConfig != null ? resourcesVpcConfig.toBuilder() : null;
        }

        public final void setResourcesVpcConfig(VpcConfigRequest.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final Logging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        @Transient
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterConfigRequest build() {
            return new UpdateClusterConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
