/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the health status of the node group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodegroupHealth implements SdkPojo, Serializable, ToCopyableBuilder<NodegroupHealth.Builder, NodegroupHealth> {
    private static final SdkField<List<Issue>> ISSUES_FIELD = SdkField
            .<List<Issue>> builder(MarshallingType.LIST)
            .memberName("issues")
            .getter(getter(NodegroupHealth::issues))
            .setter(setter(Builder::issues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Issue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Issue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Issue> issues;

    private NodegroupHealth(BuilderImpl builder) {
        this.issues = builder.issues;
    }

    /**
     * For responses, this returns true if the service returned a value for the Issues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIssues() {
        return issues != null && !(issues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any issues that are associated with the node group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssues} method.
     * </p>
     * 
     * @return Any issues that are associated with the node group.
     */
    public final List<Issue> issues() {
        return issues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIssues() ? issues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodegroupHealth)) {
            return false;
        }
        NodegroupHealth other = (NodegroupHealth) obj;
        return hasIssues() == other.hasIssues() && Objects.equals(issues(), other.issues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodegroupHealth").add("Issues", hasIssues() ? issues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "issues":
            return Optional.ofNullable(clazz.cast(issues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodegroupHealth, T> g) {
        return obj -> g.apply((NodegroupHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodegroupHealth> {
        /**
         * <p>
         * Any issues that are associated with the node group.
         * </p>
         * 
         * @param issues
         *        Any issues that are associated with the node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issues(Collection<Issue> issues);

        /**
         * <p>
         * Any issues that are associated with the node group.
         * </p>
         * 
         * @param issues
         *        Any issues that are associated with the node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issues(Issue... issues);

        /**
         * <p>
         * Any issues that are associated with the node group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Issue>.Builder} avoiding the need to create
         * one manually via {@link List<Issue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Issue>.Builder#build()} is called immediately and its result
         * is passed to {@link #issues(List<Issue>)}.
         * 
         * @param issues
         *        a consumer that will call methods on {@link List<Issue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issues(List<Issue>)
         */
        Builder issues(Consumer<Issue.Builder>... issues);
    }

    static final class BuilderImpl implements Builder {
        private List<Issue> issues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodegroupHealth model) {
            issues(model.issues);
        }

        public final List<Issue.Builder> getIssues() {
            List<Issue.Builder> result = IssueListCopier.copyToBuilder(this.issues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIssues(Collection<Issue.BuilderImpl> issues) {
            this.issues = IssueListCopier.copyFromBuilder(issues);
        }

        @Override
        @Transient
        public final Builder issues(Collection<Issue> issues) {
            this.issues = IssueListCopier.copy(issues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder issues(Issue... issues) {
            issues(Arrays.asList(issues));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder issues(Consumer<Issue.Builder>... issues) {
            issues(Stream.of(issues).map(c -> Issue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public NodegroupHealth build() {
            return new NodegroupHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
