/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAddonRequest extends EksRequest implements
        ToCopyableBuilder<UpdateAddonRequest.Builder, UpdateAddonRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(UpdateAddonRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonName").getter(getter(UpdateAddonRequest::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("addonName").build()).build();

    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonVersion").getter(getter(UpdateAddonRequest::addonVersion)).setter(setter(Builder::addonVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccountRoleArn").getter(getter(UpdateAddonRequest::serviceAccountRoleArn))
            .setter(setter(Builder::serviceAccountRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountRoleArn").build())
            .build();

    private static final SdkField<String> RESOLVE_CONFLICTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolveConflicts").getter(getter(UpdateAddonRequest::resolveConflictsAsString))
            .setter(setter(Builder::resolveConflicts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolveConflicts").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(UpdateAddonRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            ADDON_NAME_FIELD, ADDON_VERSION_FIELD, SERVICE_ACCOUNT_ROLE_ARN_FIELD, RESOLVE_CONFLICTS_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final String clusterName;

    private final String addonName;

    private final String addonVersion;

    private final String serviceAccountRoleArn;

    private final String resolveConflicts;

    private final String clientRequestToken;

    private UpdateAddonRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.addonName = builder.addonName;
        this.addonVersion = builder.addonVersion;
        this.serviceAccountRoleArn = builder.serviceAccountRoleArn;
        this.resolveConflicts = builder.resolveConflicts;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return The name of the cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the add-on. The name must match one of the names returned by <a
     * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.
     * </p>
     * 
     * @return The name of the add-on. The name must match one of the names returned by <a
     *         href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code>
     *         </a>.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * The version of the add-on. The version must match one of the versions returned by <a
     * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     * <code>DescribeAddonVersions</code> </a>.
     * </p>
     * 
     * @return The version of the add-on. The version must match one of the versions returned by <a
     *         href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     *         <code>DescribeAddonVersions</code> </a>.
     */
    public final String addonVersion() {
        return addonVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be
     * assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on
     * uses the permissions assigned to the node IAM role. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the
     * <i>Amazon EKS User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM
     * roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role
     *         must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role,
     *         then the add-on uses the permissions assigned to the node IAM role. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM
     *         role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>
     *         <p>
     *         To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your
     *         cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html"
     *         >Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.
     *         </p>
     */
    public final String serviceAccountRoleArn() {
        return serviceAccountRoleArn;
    }

    /**
     * <p>
     * How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolveConflicts}
     * will return {@link ResolveConflicts#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolveConflictsAsString}.
     * </p>
     * 
     * @return How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
     * @see ResolveConflicts
     */
    public final ResolveConflicts resolveConflicts() {
        return ResolveConflicts.fromValue(resolveConflicts);
    }

    /**
     * <p>
     * How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolveConflicts}
     * will return {@link ResolveConflicts#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolveConflictsAsString}.
     * </p>
     * 
     * @return How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
     * @see ResolveConflicts
     */
    public final String resolveConflictsAsString() {
        return resolveConflicts;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(resolveConflictsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAddonRequest)) {
            return false;
        }
        UpdateAddonRequest other = (UpdateAddonRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(addonName(), other.addonName())
                && Objects.equals(addonVersion(), other.addonVersion())
                && Objects.equals(serviceAccountRoleArn(), other.serviceAccountRoleArn())
                && Objects.equals(resolveConflictsAsString(), other.resolveConflictsAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAddonRequest").add("ClusterName", clusterName()).add("AddonName", addonName())
                .add("AddonVersion", addonVersion()).add("ServiceAccountRoleArn", serviceAccountRoleArn())
                .add("ResolveConflicts", resolveConflictsAsString()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "addonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "addonVersion":
            return Optional.ofNullable(clazz.cast(addonVersion()));
        case "serviceAccountRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccountRoleArn()));
        case "resolveConflicts":
            return Optional.ofNullable(clazz.cast(resolveConflictsAsString()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAddonRequest, T> g) {
        return obj -> g.apply((UpdateAddonRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAddonRequest> {
        /**
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the add-on. The name must match one of the names returned by <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.
         * </p>
         * 
         * @param addonName
         *        The name of the add-on. The name must match one of the names returned by <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html">
         *        <code>ListAddons</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * The version of the add-on. The version must match one of the versions returned by <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         * <code>DescribeAddonVersions</code> </a>.
         * </p>
         * 
         * @param addonVersion
         *        The version of the add-on. The version must match one of the versions returned by <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         *        <code>DescribeAddonVersions</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersion(String addonVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must
         * be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the
         * add-on uses the permissions assigned to the node IAM role. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in
         * the <i>Amazon EKS User Guide</i>.
         * </p>
         * <note>
         * <p>
         * To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your
         * cluster. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling
         * IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * </note>
         * 
         * @param serviceAccountRoleArn
         *        The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The
         *        role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM
         *        role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM
         *        role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>
         *        <p>
         *        To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your
         *        cluster. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html"
         *        >Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountRoleArn(String serviceAccountRoleArn);

        /**
         * <p>
         * How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
         * </p>
         * 
         * @param resolveConflicts
         *        How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
         * @see ResolveConflicts
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolveConflicts
         */
        Builder resolveConflicts(String resolveConflicts);

        /**
         * <p>
         * How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
         * </p>
         * 
         * @param resolveConflicts
         *        How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.
         * @see ResolveConflicts
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolveConflicts
         */
        Builder resolveConflicts(ResolveConflicts resolveConflicts);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String addonName;

        private String addonVersion;

        private String serviceAccountRoleArn;

        private String resolveConflicts;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAddonRequest model) {
            super(model);
            clusterName(model.clusterName);
            addonName(model.addonName);
            addonVersion(model.addonVersion);
            serviceAccountRoleArn(model.serviceAccountRoleArn);
            resolveConflicts(model.resolveConflicts);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        @Transient
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        @Transient
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getAddonVersion() {
            return addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        @Transient
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final String getServiceAccountRoleArn() {
            return serviceAccountRoleArn;
        }

        public final void setServiceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
        }

        @Override
        @Transient
        public final Builder serviceAccountRoleArn(String serviceAccountRoleArn) {
            this.serviceAccountRoleArn = serviceAccountRoleArn;
            return this;
        }

        public final String getResolveConflicts() {
            return resolveConflicts;
        }

        public final void setResolveConflicts(String resolveConflicts) {
            this.resolveConflicts = resolveConflicts;
        }

        @Override
        @Transient
        public final Builder resolveConflicts(String resolveConflicts) {
            this.resolveConflicts = resolveConflicts;
            return this;
        }

        @Override
        @Transient
        public final Builder resolveConflicts(ResolveConflicts resolveConflicts) {
            this.resolveConflicts(resolveConflicts == null ? null : resolveConflicts.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAddonRequest build() {
            return new UpdateAddonRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
