/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAddonRequest extends EksRequest implements
        ToCopyableBuilder<DeleteAddonRequest.Builder, DeleteAddonRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(DeleteAddonRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonName").getter(getter(DeleteAddonRequest::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("addonName").build()).build();

    private static final SdkField<Boolean> PRESERVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("preserve").getter(getter(DeleteAddonRequest::preserve)).setter(setter(Builder::preserve))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("preserve").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            ADDON_NAME_FIELD, PRESERVE_FIELD));

    private final String clusterName;

    private final String addonName;

    private final Boolean preserve;

    private DeleteAddonRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.addonName = builder.addonName;
        this.preserve = builder.preserve;
    }

    /**
     * <p>
     * The name of the cluster to delete the add-on from.
     * </p>
     * 
     * @return The name of the cluster to delete the add-on from.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the add-on. The name must match one of the names returned by <a
     * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.
     * </p>
     * 
     * @return The name of the add-on. The name must match one of the names returned by <a
     *         href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code>
     *         </a>.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings
     * for the add-on. If an IAM account is associated with the add-on, it is not removed.
     * </p>
     * 
     * @return Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any
     *         settings for the add-on. If an IAM account is associated with the add-on, it is not removed.
     */
    public final Boolean preserve() {
        return preserve;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(preserve());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAddonRequest)) {
            return false;
        }
        DeleteAddonRequest other = (DeleteAddonRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(addonName(), other.addonName())
                && Objects.equals(preserve(), other.preserve());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAddonRequest").add("ClusterName", clusterName()).add("AddonName", addonName())
                .add("Preserve", preserve()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "addonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "preserve":
            return Optional.ofNullable(clazz.cast(preserve()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAddonRequest, T> g) {
        return obj -> g.apply((DeleteAddonRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAddonRequest> {
        /**
         * <p>
         * The name of the cluster to delete the add-on from.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster to delete the add-on from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the add-on. The name must match one of the names returned by <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.
         * </p>
         * 
         * @param addonName
         *        The name of the add-on. The name must match one of the names returned by <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html">
         *        <code>ListAddons</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any
         * settings for the add-on. If an IAM account is associated with the add-on, it is not removed.
         * </p>
         * 
         * @param preserve
         *        Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any
         *        settings for the add-on. If an IAM account is associated with the add-on, it is not removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preserve(Boolean preserve);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String addonName;

        private Boolean preserve;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAddonRequest model) {
            super(model);
            clusterName(model.clusterName);
            addonName(model.addonName);
            preserve(model.preserve);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final Boolean getPreserve() {
            return preserve;
        }

        public final void setPreserve(Boolean preserve) {
            this.preserve = preserve;
        }

        @Override
        public final Builder preserve(Boolean preserve) {
            this.preserve = preserve;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAddonRequest build() {
            return new DeleteAddonRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
