/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAddonConfigurationRequest extends EksRequest implements
        ToCopyableBuilder<DescribeAddonConfigurationRequest.Builder, DescribeAddonConfigurationRequest> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonName").getter(getter(DescribeAddonConfigurationRequest::addonName))
            .setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("addonName").build()).build();

    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonVersion").getter(getter(DescribeAddonConfigurationRequest::addonVersion))
            .setter(setter(Builder::addonVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("addonVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD,
            ADDON_VERSION_FIELD));

    private final String addonName;

    private final String addonVersion;

    private DescribeAddonConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.addonName = builder.addonName;
        this.addonVersion = builder.addonVersion;
    }

    /**
     * <p>
     * The name of the add-on. The name must match one of the names returned by <a
     * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     * <code>DescribeAddonVersions</code> </a>.
     * </p>
     * 
     * @return The name of the add-on. The name must match one of the names returned by <a
     *         href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     *         <code>DescribeAddonVersions</code> </a>.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * The version of the add-on. The version must match one of the versions returned by <a
     * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     * <code>DescribeAddonVersions</code> </a>.
     * </p>
     * 
     * @return The version of the add-on. The version must match one of the versions returned by <a
     *         href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     *         <code>DescribeAddonVersions</code> </a>.
     */
    public final String addonVersion() {
        return addonVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(addonVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddonConfigurationRequest)) {
            return false;
        }
        DescribeAddonConfigurationRequest other = (DescribeAddonConfigurationRequest) obj;
        return Objects.equals(addonName(), other.addonName()) && Objects.equals(addonVersion(), other.addonVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAddonConfigurationRequest").add("AddonName", addonName())
                .add("AddonVersion", addonVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "addonVersion":
            return Optional.ofNullable(clazz.cast(addonVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddonConfigurationRequest, T> g) {
        return obj -> g.apply((DescribeAddonConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAddonConfigurationRequest> {
        /**
         * <p>
         * The name of the add-on. The name must match one of the names returned by <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         * <code>DescribeAddonVersions</code> </a>.
         * </p>
         * 
         * @param addonName
         *        The name of the add-on. The name must match one of the names returned by <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         *        <code>DescribeAddonVersions</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * The version of the add-on. The version must match one of the versions returned by <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         * <code>DescribeAddonVersions</code> </a>.
         * </p>
         * 
         * @param addonVersion
         *        The version of the add-on. The version must match one of the versions returned by <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         *        <code>DescribeAddonVersions</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersion(String addonVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String addonName;

        private String addonVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddonConfigurationRequest model) {
            super(model);
            addonName(model.addonName);
            addonVersion(model.addonVersion);
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getAddonVersion() {
            return addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAddonConfigurationRequest build() {
            return new DescribeAddonConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
