/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of your local Amazon EKS cluster on an Amazon Web Services Outpost. Before creating a cluster on an
 * Outpost, review <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-cluster-outpost.html">Creating a
 * local Amazon EKS cluster on an Amazon Web Services Outpost</a> in the <i>Amazon EKS User Guide</i>. This API isn't
 * available for Amazon EKS clusters on the Amazon Web Services cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutpostConfigRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<OutpostConfigRequest.Builder, OutpostConfigRequest> {
    private static final SdkField<List<String>> OUTPOST_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("outpostArns")
            .getter(getter(OutpostConfigRequest::outpostArns))
            .setter(setter(Builder::outpostArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outpostArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTROL_PLANE_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlPlaneInstanceType").getter(getter(OutpostConfigRequest::controlPlaneInstanceType))
            .setter(setter(Builder::controlPlaneInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlPlaneInstanceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ARNS_FIELD,
            CONTROL_PLANE_INSTANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> outpostArns;

    private final String controlPlaneInstanceType;

    private OutpostConfigRequest(BuilderImpl builder) {
        this.outpostArns = builder.outpostArns;
        this.controlPlaneInstanceType = builder.controlPlaneInstanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutpostArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutpostArns() {
        return outpostArns != null && !(outpostArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. Only a single Outpost
     * ARN is supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutpostArns} method.
     * </p>
     * 
     * @return The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. Only a single
     *         Outpost ARN is supported.
     */
    public final List<String> outpostArns() {
        return outpostArns;
    }

    /**
     * <p>
     * The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance
     * type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed
     * after cluster creation.
     * </p>
     * <p>
     * Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 1–20 nodes, then we recommend specifying a <code>large</code> instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * 21–100 nodes, then we recommend specifying an <code>xlarge</code> instance type.
     * </p>
     * </li>
     * <li>
     * <p>
     * 101–250 nodes, then we recommend specifying a <code>2xlarge</code> instance type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of the available Amazon EC2 instance types, see Compute and storage in <a
     * href="http://aws.amazon.com/outposts/rack/features/">Outposts rack features</a>. The control plane is not
     * automatically scaled by Amazon EKS.
     * </p>
     * 
     * @return The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The
     *         instance type that you specify is used for all Kubernetes control plane instances. The instance type
     *         can't be changed after cluster creation.</p>
     *         <p>
     *         Choose an instance type based on the number of nodes that your cluster will have. If your cluster will
     *         have:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         1–20 nodes, then we recommend specifying a <code>large</code> instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         21–100 nodes, then we recommend specifying an <code>xlarge</code> instance type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         101–250 nodes, then we recommend specifying a <code>2xlarge</code> instance type.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For a list of the available Amazon EC2 instance types, see Compute and storage in <a
     *         href="http://aws.amazon.com/outposts/rack/features/">Outposts rack features</a>. The control plane is not
     *         automatically scaled by Amazon EKS.
     */
    public final String controlPlaneInstanceType() {
        return controlPlaneInstanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOutpostArns() ? outpostArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(controlPlaneInstanceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutpostConfigRequest)) {
            return false;
        }
        OutpostConfigRequest other = (OutpostConfigRequest) obj;
        return hasOutpostArns() == other.hasOutpostArns() && Objects.equals(outpostArns(), other.outpostArns())
                && Objects.equals(controlPlaneInstanceType(), other.controlPlaneInstanceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutpostConfigRequest").add("OutpostArns", hasOutpostArns() ? outpostArns() : null)
                .add("ControlPlaneInstanceType", controlPlaneInstanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outpostArns":
            return Optional.ofNullable(clazz.cast(outpostArns()));
        case "controlPlaneInstanceType":
            return Optional.ofNullable(clazz.cast(controlPlaneInstanceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutpostConfigRequest, T> g) {
        return obj -> g.apply((OutpostConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutpostConfigRequest> {
        /**
         * <p>
         * The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. Only a single
         * Outpost ARN is supported.
         * </p>
         * 
         * @param outpostArns
         *        The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. Only a
         *        single Outpost ARN is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArns(Collection<String> outpostArns);

        /**
         * <p>
         * The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. Only a single
         * Outpost ARN is supported.
         * </p>
         * 
         * @param outpostArns
         *        The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. Only a
         *        single Outpost ARN is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArns(String... outpostArns);

        /**
         * <p>
         * The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance
         * type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed
         * after cluster creation.
         * </p>
         * <p>
         * Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 1–20 nodes, then we recommend specifying a <code>large</code> instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * 21–100 nodes, then we recommend specifying an <code>xlarge</code> instance type.
         * </p>
         * </li>
         * <li>
         * <p>
         * 101–250 nodes, then we recommend specifying a <code>2xlarge</code> instance type.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For a list of the available Amazon EC2 instance types, see Compute and storage in <a
         * href="http://aws.amazon.com/outposts/rack/features/">Outposts rack features</a>. The control plane is not
         * automatically scaled by Amazon EKS.
         * </p>
         * 
         * @param controlPlaneInstanceType
         *        The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The
         *        instance type that you specify is used for all Kubernetes control plane instances. The instance type
         *        can't be changed after cluster creation.</p>
         *        <p>
         *        Choose an instance type based on the number of nodes that your cluster will have. If your cluster will
         *        have:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        1–20 nodes, then we recommend specifying a <code>large</code> instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        21–100 nodes, then we recommend specifying an <code>xlarge</code> instance type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        101–250 nodes, then we recommend specifying a <code>2xlarge</code> instance type.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For a list of the available Amazon EC2 instance types, see Compute and storage in <a
         *        href="http://aws.amazon.com/outposts/rack/features/">Outposts rack features</a>. The control plane is
         *        not automatically scaled by Amazon EKS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPlaneInstanceType(String controlPlaneInstanceType);
    }

    static final class BuilderImpl implements Builder {
        private List<String> outpostArns = DefaultSdkAutoConstructList.getInstance();

        private String controlPlaneInstanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(OutpostConfigRequest model) {
            outpostArns(model.outpostArns);
            controlPlaneInstanceType(model.controlPlaneInstanceType);
        }

        public final Collection<String> getOutpostArns() {
            if (outpostArns instanceof SdkAutoConstructList) {
                return null;
            }
            return outpostArns;
        }

        public final void setOutpostArns(Collection<String> outpostArns) {
            this.outpostArns = StringListCopier.copy(outpostArns);
        }

        @Override
        public final Builder outpostArns(Collection<String> outpostArns) {
            this.outpostArns = StringListCopier.copy(outpostArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostArns(String... outpostArns) {
            outpostArns(Arrays.asList(outpostArns));
            return this;
        }

        public final String getControlPlaneInstanceType() {
            return controlPlaneInstanceType;
        }

        public final void setControlPlaneInstanceType(String controlPlaneInstanceType) {
            this.controlPlaneInstanceType = controlPlaneInstanceType;
        }

        @Override
        public final Builder controlPlaneInstanceType(String controlPlaneInstanceType) {
            this.controlPlaneInstanceType = controlPlaneInstanceType;
            return this;
        }

        @Override
        public OutpostConfigRequest build() {
            return new OutpostConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
