/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAddonConfigurationResponse extends EksResponse implements
        ToCopyableBuilder<DescribeAddonConfigurationResponse.Builder, DescribeAddonConfigurationResponse> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonName").getter(getter(DescribeAddonConfigurationResponse::addonName))
            .setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonName").build()).build();

    private static final SdkField<String> ADDON_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addonVersion").getter(getter(DescribeAddonConfigurationResponse::addonVersion))
            .setter(setter(Builder::addonVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonVersion").build()).build();

    private static final SdkField<String> CONFIGURATION_SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationSchema").getter(getter(DescribeAddonConfigurationResponse::configurationSchema))
            .setter(setter(Builder::configurationSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationSchema").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD,
            ADDON_VERSION_FIELD, CONFIGURATION_SCHEMA_FIELD));

    private final String addonName;

    private final String addonVersion;

    private final String configurationSchema;

    private DescribeAddonConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.addonName = builder.addonName;
        this.addonVersion = builder.addonVersion;
        this.configurationSchema = builder.configurationSchema;
    }

    /**
     * <p>
     * The name of the add-on.
     * </p>
     * 
     * @return The name of the add-on.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * The version of the add-on. The version must match one of the versions returned by <a
     * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     * <code>DescribeAddonVersions</code> </a>.
     * </p>
     * 
     * @return The version of the add-on. The version must match one of the versions returned by <a
     *         href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
     *         <code>DescribeAddonVersions</code> </a>.
     */
    public final String addonVersion() {
        return addonVersion;
    }

    /**
     * <p>
     * A JSON schema that's used to validate the configuration values you provide when an add-on is created or updated.
     * </p>
     * 
     * @return A JSON schema that's used to validate the configuration values you provide when an add-on is created or
     *         updated.
     */
    public final String configurationSchema() {
        return configurationSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(addonVersion());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddonConfigurationResponse)) {
            return false;
        }
        DescribeAddonConfigurationResponse other = (DescribeAddonConfigurationResponse) obj;
        return Objects.equals(addonName(), other.addonName()) && Objects.equals(addonVersion(), other.addonVersion())
                && Objects.equals(configurationSchema(), other.configurationSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAddonConfigurationResponse").add("AddonName", addonName())
                .add("AddonVersion", addonVersion()).add("ConfigurationSchema", configurationSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "addonVersion":
            return Optional.ofNullable(clazz.cast(addonVersion()));
        case "configurationSchema":
            return Optional.ofNullable(clazz.cast(configurationSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddonConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeAddonConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAddonConfigurationResponse> {
        /**
         * <p>
         * The name of the add-on.
         * </p>
         * 
         * @param addonName
         *        The name of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * The version of the add-on. The version must match one of the versions returned by <a
         * href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         * <code>DescribeAddonVersions</code> </a>.
         * </p>
         * 
         * @param addonVersion
         *        The version of the add-on. The version must match one of the versions returned by <a
         *        href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html">
         *        <code>DescribeAddonVersions</code> </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonVersion(String addonVersion);

        /**
         * <p>
         * A JSON schema that's used to validate the configuration values you provide when an add-on is created or
         * updated.
         * </p>
         * 
         * @param configurationSchema
         *        A JSON schema that's used to validate the configuration values you provide when an add-on is created
         *        or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSchema(String configurationSchema);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private String addonName;

        private String addonVersion;

        private String configurationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddonConfigurationResponse model) {
            super(model);
            addonName(model.addonName);
            addonVersion(model.addonVersion);
            configurationSchema(model.configurationSchema);
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getAddonVersion() {
            return addonVersion;
        }

        public final void setAddonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
        }

        @Override
        public final Builder addonVersion(String addonVersion) {
            this.addonVersion = addonVersion;
            return this;
        }

        public final String getConfigurationSchema() {
            return configurationSchema;
        }

        public final void setConfigurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
        }

        @Override
        public final Builder configurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
            return this;
        }

        @Override
        public DescribeAddonConfigurationResponse build() {
            return new DescribeAddonConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
