/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an Fargate profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FargateProfile implements SdkPojo, Serializable, ToCopyableBuilder<FargateProfile.Builder, FargateProfile> {
    private static final SdkField<String> FARGATE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fargateProfileName").getter(getter(FargateProfile::fargateProfileName))
            .setter(setter(Builder::fargateProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileName").build())
            .build();

    private static final SdkField<String> FARGATE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fargateProfileArn").getter(getter(FargateProfile::fargateProfileArn))
            .setter(setter(Builder::fargateProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateProfileArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(FargateProfile::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(FargateProfile::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> POD_EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("podExecutionRoleArn").getter(getter(FargateProfile::podExecutionRoleArn))
            .setter(setter(Builder::podExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podExecutionRoleArn").build())
            .build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(FargateProfile::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FargateProfileSelector>> SELECTORS_FIELD = SdkField
            .<List<FargateProfileSelector>> builder(MarshallingType.LIST)
            .memberName("selectors")
            .getter(getter(FargateProfile::selectors))
            .setter(setter(Builder::selectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FargateProfileSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(FargateProfileSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(FargateProfile::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(FargateProfile::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<FargateProfileHealth> HEALTH_FIELD = SdkField
            .<FargateProfileHealth> builder(MarshallingType.SDK_POJO).memberName("health").getter(getter(FargateProfile::health))
            .setter(setter(Builder::health)).constructor(FargateProfileHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARGATE_PROFILE_NAME_FIELD,
            FARGATE_PROFILE_ARN_FIELD, CLUSTER_NAME_FIELD, CREATED_AT_FIELD, POD_EXECUTION_ROLE_ARN_FIELD, SUBNETS_FIELD,
            SELECTORS_FIELD, STATUS_FIELD, TAGS_FIELD, HEALTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fargateProfileName;

    private final String fargateProfileArn;

    private final String clusterName;

    private final Instant createdAt;

    private final String podExecutionRoleArn;

    private final List<String> subnets;

    private final List<FargateProfileSelector> selectors;

    private final String status;

    private final Map<String, String> tags;

    private final FargateProfileHealth health;

    private FargateProfile(BuilderImpl builder) {
        this.fargateProfileName = builder.fargateProfileName;
        this.fargateProfileArn = builder.fargateProfileArn;
        this.clusterName = builder.clusterName;
        this.createdAt = builder.createdAt;
        this.podExecutionRoleArn = builder.podExecutionRoleArn;
        this.subnets = builder.subnets;
        this.selectors = builder.selectors;
        this.status = builder.status;
        this.tags = builder.tags;
        this.health = builder.health;
    }

    /**
     * <p>
     * The name of the Fargate profile.
     * </p>
     * 
     * @return The name of the Fargate profile.
     */
    public final String fargateProfileName() {
        return fargateProfileName;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the Fargate profile.
     * </p>
     * 
     * @return The full Amazon Resource Name (ARN) of the Fargate profile.
     */
    public final String fargateProfileArn() {
        return fargateProfileArn;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The Unix epoch timestamp at object creation.
     * </p>
     * 
     * @return The Unix epoch timestamp at object creation.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for any <code>Pod</code> that
     * matches the selectors in the Fargate profile. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html"> <code>Pod</code> execution
     * role</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for any <code>Pod</code>
     *         that matches the selectors in the Fargate profile. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html"> <code>Pod</code>
     *         execution role</a> in the <i>Amazon EKS User Guide</i>.
     */
    public final String podExecutionRoleArn() {
        return podExecutionRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of subnets to launch a <code>Pod</code> into.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The IDs of subnets to launch a <code>Pod</code> into.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Selectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSelectors() {
        return selectors != null && !(selectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selectors to match for a <code>Pod</code> to use this Fargate profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectors} method.
     * </p>
     * 
     * @return The selectors to match for a <code>Pod</code> to use this Fargate profile.
     */
    public final List<FargateProfileSelector> selectors() {
        return selectors;
    }

    /**
     * <p>
     * The current status of the Fargate profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FargateProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Fargate profile.
     * @see FargateProfileStatus
     */
    public final FargateProfileStatus status() {
        return FargateProfileStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Fargate profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FargateProfileStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Fargate profile.
     * @see FargateProfileStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You
     * define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that assists with categorization and organization. Each tag consists of a key and an optional
     *         value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The health status of the Fargate profile. If there are issues with your Fargate profile's health, they are listed
     * here.
     * </p>
     * 
     * @return The health status of the Fargate profile. If there are issues with your Fargate profile's health, they
     *         are listed here.
     */
    public final FargateProfileHealth health() {
        return health;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fargateProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(fargateProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(podExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectors() ? selectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(health());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FargateProfile)) {
            return false;
        }
        FargateProfile other = (FargateProfile) obj;
        return Objects.equals(fargateProfileName(), other.fargateProfileName())
                && Objects.equals(fargateProfileArn(), other.fargateProfileArn())
                && Objects.equals(clusterName(), other.clusterName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(podExecutionRoleArn(), other.podExecutionRoleArn()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && hasSelectors() == other.hasSelectors()
                && Objects.equals(selectors(), other.selectors()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(health(), other.health());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FargateProfile").add("FargateProfileName", fargateProfileName())
                .add("FargateProfileArn", fargateProfileArn()).add("ClusterName", clusterName()).add("CreatedAt", createdAt())
                .add("PodExecutionRoleArn", podExecutionRoleArn()).add("Subnets", hasSubnets() ? subnets() : null)
                .add("Selectors", hasSelectors() ? selectors() : null).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).add("Health", health()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fargateProfileName":
            return Optional.ofNullable(clazz.cast(fargateProfileName()));
        case "fargateProfileArn":
            return Optional.ofNullable(clazz.cast(fargateProfileArn()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "podExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(podExecutionRoleArn()));
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "selectors":
            return Optional.ofNullable(clazz.cast(selectors()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "health":
            return Optional.ofNullable(clazz.cast(health()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FargateProfile, T> g) {
        return obj -> g.apply((FargateProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FargateProfile> {
        /**
         * <p>
         * The name of the Fargate profile.
         * </p>
         * 
         * @param fargateProfileName
         *        The name of the Fargate profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfileName(String fargateProfileName);

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the Fargate profile.
         * </p>
         * 
         * @param fargateProfileArn
         *        The full Amazon Resource Name (ARN) of the Fargate profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateProfileArn(String fargateProfileArn);

        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The Unix epoch timestamp at object creation.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp at object creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for any <code>Pod</code> that
         * matches the selectors in the Fargate profile. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html"> <code>Pod</code> execution
         * role</a> in the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param podExecutionRoleArn
         *        The Amazon Resource Name (ARN) of the <code>Pod</code> execution role to use for any <code>Pod</code>
         *        that matches the selectors in the Fargate profile. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html"> <code>Pod</code>
         *        execution role</a> in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder podExecutionRoleArn(String podExecutionRoleArn);

        /**
         * <p>
         * The IDs of subnets to launch a <code>Pod</code> into.
         * </p>
         * 
         * @param subnets
         *        The IDs of subnets to launch a <code>Pod</code> into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of subnets to launch a <code>Pod</code> into.
         * </p>
         * 
         * @param subnets
         *        The IDs of subnets to launch a <code>Pod</code> into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The selectors to match for a <code>Pod</code> to use this Fargate profile.
         * </p>
         * 
         * @param selectors
         *        The selectors to match for a <code>Pod</code> to use this Fargate profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(Collection<FargateProfileSelector> selectors);

        /**
         * <p>
         * The selectors to match for a <code>Pod</code> to use this Fargate profile.
         * </p>
         * 
         * @param selectors
         *        The selectors to match for a <code>Pod</code> to use this Fargate profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(FargateProfileSelector... selectors);

        /**
         * <p>
         * The selectors to match for a <code>Pod</code> to use this Fargate profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.FargateProfileSelector.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.eks.model.FargateProfileSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.FargateProfileSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #selectors(List<FargateProfileSelector>)}.
         * 
         * @param selectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.FargateProfileSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectors(java.util.Collection<FargateProfileSelector>)
         */
        Builder selectors(Consumer<FargateProfileSelector.Builder>... selectors);

        /**
         * <p>
         * The current status of the Fargate profile.
         * </p>
         * 
         * @param status
         *        The current status of the Fargate profile.
         * @see FargateProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FargateProfileStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Fargate profile.
         * </p>
         * 
         * @param status
         *        The current status of the Fargate profile.
         * @see FargateProfileStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FargateProfileStatus
         */
        Builder status(FargateProfileStatus status);

        /**
         * <p>
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value.
         * You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        Metadata that assists with categorization and organization. Each tag consists of a key and an optional
         *        value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The health status of the Fargate profile. If there are issues with your Fargate profile's health, they are
         * listed here.
         * </p>
         * 
         * @param health
         *        The health status of the Fargate profile. If there are issues with your Fargate profile's health, they
         *        are listed here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder health(FargateProfileHealth health);

        /**
         * <p>
         * The health status of the Fargate profile. If there are issues with your Fargate profile's health, they are
         * listed here.
         * </p>
         * This is a convenience method that creates an instance of the {@link FargateProfileHealth.Builder} avoiding
         * the need to create one manually via {@link FargateProfileHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FargateProfileHealth.Builder#build()} is called immediately and
         * its result is passed to {@link #health(FargateProfileHealth)}.
         * 
         * @param health
         *        a consumer that will call methods on {@link FargateProfileHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #health(FargateProfileHealth)
         */
        default Builder health(Consumer<FargateProfileHealth.Builder> health) {
            return health(FargateProfileHealth.builder().applyMutation(health).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fargateProfileName;

        private String fargateProfileArn;

        private String clusterName;

        private Instant createdAt;

        private String podExecutionRoleArn;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<FargateProfileSelector> selectors = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private FargateProfileHealth health;

        private BuilderImpl() {
        }

        private BuilderImpl(FargateProfile model) {
            fargateProfileName(model.fargateProfileName);
            fargateProfileArn(model.fargateProfileArn);
            clusterName(model.clusterName);
            createdAt(model.createdAt);
            podExecutionRoleArn(model.podExecutionRoleArn);
            subnets(model.subnets);
            selectors(model.selectors);
            status(model.status);
            tags(model.tags);
            health(model.health);
        }

        public final String getFargateProfileName() {
            return fargateProfileName;
        }

        public final void setFargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
        }

        @Override
        public final Builder fargateProfileName(String fargateProfileName) {
            this.fargateProfileName = fargateProfileName;
            return this;
        }

        public final String getFargateProfileArn() {
            return fargateProfileArn;
        }

        public final void setFargateProfileArn(String fargateProfileArn) {
            this.fargateProfileArn = fargateProfileArn;
        }

        @Override
        public final Builder fargateProfileArn(String fargateProfileArn) {
            this.fargateProfileArn = fargateProfileArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getPodExecutionRoleArn() {
            return podExecutionRoleArn;
        }

        public final void setPodExecutionRoleArn(String podExecutionRoleArn) {
            this.podExecutionRoleArn = podExecutionRoleArn;
        }

        @Override
        public final Builder podExecutionRoleArn(String podExecutionRoleArn) {
            this.podExecutionRoleArn = podExecutionRoleArn;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final List<FargateProfileSelector.Builder> getSelectors() {
            List<FargateProfileSelector.Builder> result = FargateProfileSelectorsCopier.copyToBuilder(this.selectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectors(Collection<FargateProfileSelector.BuilderImpl> selectors) {
            this.selectors = FargateProfileSelectorsCopier.copyFromBuilder(selectors);
        }

        @Override
        public final Builder selectors(Collection<FargateProfileSelector> selectors) {
            this.selectors = FargateProfileSelectorsCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(FargateProfileSelector... selectors) {
            selectors(Arrays.asList(selectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Consumer<FargateProfileSelector.Builder>... selectors) {
            selectors(Stream.of(selectors).map(c -> FargateProfileSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FargateProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final FargateProfileHealth.Builder getHealth() {
            return health != null ? health.toBuilder() : null;
        }

        public final void setHealth(FargateProfileHealth.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        public final Builder health(FargateProfileHealth health) {
            this.health = health;
            return this;
        }

        @Override
        public FargateProfile build() {
            return new FargateProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
