/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how to configure IAM for an Addon.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddonPodIdentityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AddonPodIdentityConfiguration.Builder, AddonPodIdentityConfiguration> {
    private static final SdkField<String> SERVICE_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccount").getter(getter(AddonPodIdentityConfiguration::serviceAccount))
            .setter(setter(Builder::serviceAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccount").build()).build();

    private static final SdkField<List<String>> RECOMMENDED_MANAGED_POLICIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("recommendedManagedPolicies")
            .getter(getter(AddonPodIdentityConfiguration::recommendedManagedPolicies))
            .setter(setter(Builder::recommendedManagedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedManagedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_FIELD,
            RECOMMENDED_MANAGED_POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("serviceAccount", SERVICE_ACCOUNT_FIELD);
                    put("recommendedManagedPolicies", RECOMMENDED_MANAGED_POLICIES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String serviceAccount;

    private final List<String> recommendedManagedPolicies;

    private AddonPodIdentityConfiguration(BuilderImpl builder) {
        this.serviceAccount = builder.serviceAccount;
        this.recommendedManagedPolicies = builder.recommendedManagedPolicies;
    }

    /**
     * <p>
     * The Kubernetes Service Account name used by the addon.
     * </p>
     * 
     * @return The Kubernetes Service Account name used by the addon.
     */
    public final String serviceAccount() {
        return serviceAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendedManagedPolicies property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRecommendedManagedPolicies() {
        return recommendedManagedPolicies != null && !(recommendedManagedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A suggested IAM Policy for the addon.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendedManagedPolicies} method.
     * </p>
     * 
     * @return A suggested IAM Policy for the addon.
     */
    public final List<String> recommendedManagedPolicies() {
        return recommendedManagedPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendedManagedPolicies() ? recommendedManagedPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonPodIdentityConfiguration)) {
            return false;
        }
        AddonPodIdentityConfiguration other = (AddonPodIdentityConfiguration) obj;
        return Objects.equals(serviceAccount(), other.serviceAccount())
                && hasRecommendedManagedPolicies() == other.hasRecommendedManagedPolicies()
                && Objects.equals(recommendedManagedPolicies(), other.recommendedManagedPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddonPodIdentityConfiguration").add("ServiceAccount", serviceAccount())
                .add("RecommendedManagedPolicies", hasRecommendedManagedPolicies() ? recommendedManagedPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceAccount":
            return Optional.ofNullable(clazz.cast(serviceAccount()));
        case "recommendedManagedPolicies":
            return Optional.ofNullable(clazz.cast(recommendedManagedPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AddonPodIdentityConfiguration, T> g) {
        return obj -> g.apply((AddonPodIdentityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddonPodIdentityConfiguration> {
        /**
         * <p>
         * The Kubernetes Service Account name used by the addon.
         * </p>
         * 
         * @param serviceAccount
         *        The Kubernetes Service Account name used by the addon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccount(String serviceAccount);

        /**
         * <p>
         * A suggested IAM Policy for the addon.
         * </p>
         * 
         * @param recommendedManagedPolicies
         *        A suggested IAM Policy for the addon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedManagedPolicies(Collection<String> recommendedManagedPolicies);

        /**
         * <p>
         * A suggested IAM Policy for the addon.
         * </p>
         * 
         * @param recommendedManagedPolicies
         *        A suggested IAM Policy for the addon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedManagedPolicies(String... recommendedManagedPolicies);
    }

    static final class BuilderImpl implements Builder {
        private String serviceAccount;

        private List<String> recommendedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddonPodIdentityConfiguration model) {
            serviceAccount(model.serviceAccount);
            recommendedManagedPolicies(model.recommendedManagedPolicies);
        }

        public final String getServiceAccount() {
            return serviceAccount;
        }

        public final void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }

        @Override
        public final Builder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public final Collection<String> getRecommendedManagedPolicies() {
            if (recommendedManagedPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendedManagedPolicies;
        }

        public final void setRecommendedManagedPolicies(Collection<String> recommendedManagedPolicies) {
            this.recommendedManagedPolicies = StringListCopier.copy(recommendedManagedPolicies);
        }

        @Override
        public final Builder recommendedManagedPolicies(Collection<String> recommendedManagedPolicies) {
            this.recommendedManagedPolicies = StringListCopier.copy(recommendedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedManagedPolicies(String... recommendedManagedPolicies) {
            recommendedManagedPolicies(Arrays.asList(recommendedManagedPolicies));
            return this;
        }

        @Override
        public AddonPodIdentityConfiguration build() {
            return new AddonPodIdentityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
