/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAccessPolicyResponse extends EksResponse implements
        ToCopyableBuilder<AssociateAccessPolicyResponse.Builder, AssociateAccessPolicyResponse> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(AssociateAccessPolicyResponse::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(AssociateAccessPolicyResponse::principalArn))
            .setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()).build();

    private static final SdkField<AssociatedAccessPolicy> ASSOCIATED_ACCESS_POLICY_FIELD = SdkField
            .<AssociatedAccessPolicy> builder(MarshallingType.SDK_POJO).memberName("associatedAccessPolicy")
            .getter(getter(AssociateAccessPolicyResponse::associatedAccessPolicy))
            .setter(setter(Builder::associatedAccessPolicy)).constructor(AssociatedAccessPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAccessPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            PRINCIPAL_ARN_FIELD, ASSOCIATED_ACCESS_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clusterName", CLUSTER_NAME_FIELD);
                    put("principalArn", PRINCIPAL_ARN_FIELD);
                    put("associatedAccessPolicy", ASSOCIATED_ACCESS_POLICY_FIELD);
                }
            });

    private final String clusterName;

    private final String principalArn;

    private final AssociatedAccessPolicy associatedAccessPolicy;

    private AssociateAccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.associatedAccessPolicy = builder.associatedAccessPolicy;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The ARN of the IAM principal for the <code>AccessEntry</code>.
     * </p>
     * 
     * @return The ARN of the IAM principal for the <code>AccessEntry</code>.
     */
    public final String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * The <code>AccessPolicy</code> and scope associated to the <code>AccessEntry</code>.
     * </p>
     * 
     * @return The <code>AccessPolicy</code> and scope associated to the <code>AccessEntry</code>.
     */
    public final AssociatedAccessPolicy associatedAccessPolicy() {
        return associatedAccessPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(associatedAccessPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAccessPolicyResponse)) {
            return false;
        }
        AssociateAccessPolicyResponse other = (AssociateAccessPolicyResponse) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(principalArn(), other.principalArn())
                && Objects.equals(associatedAccessPolicy(), other.associatedAccessPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAccessPolicyResponse").add("ClusterName", clusterName())
                .add("PrincipalArn", principalArn()).add("AssociatedAccessPolicy", associatedAccessPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "associatedAccessPolicy":
            return Optional.ofNullable(clazz.cast(associatedAccessPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateAccessPolicyResponse, T> g) {
        return obj -> g.apply((AssociateAccessPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssociateAccessPolicyResponse> {
        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The ARN of the IAM principal for the <code>AccessEntry</code>.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the IAM principal for the <code>AccessEntry</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The <code>AccessPolicy</code> and scope associated to the <code>AccessEntry</code>.
         * </p>
         * 
         * @param associatedAccessPolicy
         *        The <code>AccessPolicy</code> and scope associated to the <code>AccessEntry</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAccessPolicy(AssociatedAccessPolicy associatedAccessPolicy);

        /**
         * <p>
         * The <code>AccessPolicy</code> and scope associated to the <code>AccessEntry</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociatedAccessPolicy.Builder} avoiding
         * the need to create one manually via {@link AssociatedAccessPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssociatedAccessPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #associatedAccessPolicy(AssociatedAccessPolicy)}.
         * 
         * @param associatedAccessPolicy
         *        a consumer that will call methods on {@link AssociatedAccessPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedAccessPolicy(AssociatedAccessPolicy)
         */
        default Builder associatedAccessPolicy(Consumer<AssociatedAccessPolicy.Builder> associatedAccessPolicy) {
            return associatedAccessPolicy(AssociatedAccessPolicy.builder().applyMutation(associatedAccessPolicy).build());
        }
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private String clusterName;

        private String principalArn;

        private AssociatedAccessPolicy associatedAccessPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAccessPolicyResponse model) {
            super(model);
            clusterName(model.clusterName);
            principalArn(model.principalArn);
            associatedAccessPolicy(model.associatedAccessPolicy);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final AssociatedAccessPolicy.Builder getAssociatedAccessPolicy() {
            return associatedAccessPolicy != null ? associatedAccessPolicy.toBuilder() : null;
        }

        public final void setAssociatedAccessPolicy(AssociatedAccessPolicy.BuilderImpl associatedAccessPolicy) {
            this.associatedAccessPolicy = associatedAccessPolicy != null ? associatedAccessPolicy.build() : null;
        }

        @Override
        public final Builder associatedAccessPolicy(AssociatedAccessPolicy associatedAccessPolicy) {
            this.associatedAccessPolicy = associatedAccessPolicy;
            return this;
        }

        @Override
        public AssociateAccessPolicyResponse build() {
            return new AssociateAccessPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
