/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An access policy association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedAccessPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociatedAccessPolicy.Builder, AssociatedAccessPolicy> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(AssociatedAccessPolicy::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<AccessScope> ACCESS_SCOPE_FIELD = SdkField.<AccessScope> builder(MarshallingType.SDK_POJO)
            .memberName("accessScope").getter(getter(AssociatedAccessPolicy::accessScope)).setter(setter(Builder::accessScope))
            .constructor(AccessScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessScope").build()).build();

    private static final SdkField<Instant> ASSOCIATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("associatedAt").getter(getter(AssociatedAccessPolicy::associatedAt))
            .setter(setter(Builder::associatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(AssociatedAccessPolicy::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            ACCESS_SCOPE_FIELD, ASSOCIATED_AT_FIELD, MODIFIED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("policyArn", POLICY_ARN_FIELD);
                    put("accessScope", ACCESS_SCOPE_FIELD);
                    put("associatedAt", ASSOCIATED_AT_FIELD);
                    put("modifiedAt", MODIFIED_AT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String policyArn;

    private final AccessScope accessScope;

    private final Instant associatedAt;

    private final Instant modifiedAt;

    private AssociatedAccessPolicy(BuilderImpl builder) {
        this.policyArn = builder.policyArn;
        this.accessScope = builder.accessScope;
        this.associatedAt = builder.associatedAt;
        this.modifiedAt = builder.modifiedAt;
    }

    /**
     * <p>
     * The ARN of the <code>AccessPolicy</code>.
     * </p>
     * 
     * @return The ARN of the <code>AccessPolicy</code>.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The scope of the access policy.
     * </p>
     * 
     * @return The scope of the access policy.
     */
    public final AccessScope accessScope() {
        return accessScope;
    }

    /**
     * <p>
     * The date and time the <code>AccessPolicy</code> was associated with an <code>AccessEntry</code>.
     * </p>
     * 
     * @return The date and time the <code>AccessPolicy</code> was associated with an <code>AccessEntry</code>.
     */
    public final Instant associatedAt() {
        return associatedAt;
    }

    /**
     * <p>
     * The Unix epoch timestamp for the last modification to the object.
     * </p>
     * 
     * @return The Unix epoch timestamp for the last modification to the object.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(accessScope());
        hashCode = 31 * hashCode + Objects.hashCode(associatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedAccessPolicy)) {
            return false;
        }
        AssociatedAccessPolicy other = (AssociatedAccessPolicy) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(accessScope(), other.accessScope())
                && Objects.equals(associatedAt(), other.associatedAt()) && Objects.equals(modifiedAt(), other.modifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedAccessPolicy").add("PolicyArn", policyArn()).add("AccessScope", accessScope())
                .add("AssociatedAt", associatedAt()).add("ModifiedAt", modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "accessScope":
            return Optional.ofNullable(clazz.cast(accessScope()));
        case "associatedAt":
            return Optional.ofNullable(clazz.cast(associatedAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedAccessPolicy, T> g) {
        return obj -> g.apply((AssociatedAccessPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedAccessPolicy> {
        /**
         * <p>
         * The ARN of the <code>AccessPolicy</code>.
         * </p>
         * 
         * @param policyArn
         *        The ARN of the <code>AccessPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The scope of the access policy.
         * </p>
         * 
         * @param accessScope
         *        The scope of the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessScope(AccessScope accessScope);

        /**
         * <p>
         * The scope of the access policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessScope.Builder} avoiding the need to
         * create one manually via {@link AccessScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessScope.Builder#build()} is called immediately and its result
         * is passed to {@link #accessScope(AccessScope)}.
         * 
         * @param accessScope
         *        a consumer that will call methods on {@link AccessScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessScope(AccessScope)
         */
        default Builder accessScope(Consumer<AccessScope.Builder> accessScope) {
            return accessScope(AccessScope.builder().applyMutation(accessScope).build());
        }

        /**
         * <p>
         * The date and time the <code>AccessPolicy</code> was associated with an <code>AccessEntry</code>.
         * </p>
         * 
         * @param associatedAt
         *        The date and time the <code>AccessPolicy</code> was associated with an <code>AccessEntry</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAt(Instant associatedAt);

        /**
         * <p>
         * The Unix epoch timestamp for the last modification to the object.
         * </p>
         * 
         * @param modifiedAt
         *        The Unix epoch timestamp for the last modification to the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);
    }

    static final class BuilderImpl implements Builder {
        private String policyArn;

        private AccessScope accessScope;

        private Instant associatedAt;

        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedAccessPolicy model) {
            policyArn(model.policyArn);
            accessScope(model.accessScope);
            associatedAt(model.associatedAt);
            modifiedAt(model.modifiedAt);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final AccessScope.Builder getAccessScope() {
            return accessScope != null ? accessScope.toBuilder() : null;
        }

        public final void setAccessScope(AccessScope.BuilderImpl accessScope) {
            this.accessScope = accessScope != null ? accessScope.build() : null;
        }

        @Override
        public final Builder accessScope(AccessScope accessScope) {
            this.accessScope = accessScope;
            return this;
        }

        public final Instant getAssociatedAt() {
            return associatedAt;
        }

        public final void setAssociatedAt(Instant associatedAt) {
            this.associatedAt = associatedAt;
        }

        @Override
        public final Builder associatedAt(Instant associatedAt) {
            this.associatedAt = associatedAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public AssociatedAccessPolicy build() {
            return new AssociatedAccessPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
