/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about clients using the deprecated resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientStat implements SdkPojo, Serializable, ToCopyableBuilder<ClientStat.Builder, ClientStat> {
    private static final SdkField<String> USER_AGENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userAgent").getter(getter(ClientStat::userAgent)).setter(setter(Builder::userAgent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgent").build()).build();

    private static final SdkField<Integer> NUMBER_OF_REQUESTS_LAST30_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfRequestsLast30Days")
            .getter(getter(ClientStat::numberOfRequestsLast30Days))
            .setter(setter(Builder::numberOfRequestsLast30Days))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRequestsLast30Days").build())
            .build();

    private static final SdkField<Instant> LAST_REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastRequestTime").getter(getter(ClientStat::lastRequestTime)).setter(setter(Builder::lastRequestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRequestTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_AGENT_FIELD,
            NUMBER_OF_REQUESTS_LAST30_DAYS_FIELD, LAST_REQUEST_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("userAgent", USER_AGENT_FIELD);
                    put("numberOfRequestsLast30Days", NUMBER_OF_REQUESTS_LAST30_DAYS_FIELD);
                    put("lastRequestTime", LAST_REQUEST_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String userAgent;

    private final Integer numberOfRequestsLast30Days;

    private final Instant lastRequestTime;

    private ClientStat(BuilderImpl builder) {
        this.userAgent = builder.userAgent;
        this.numberOfRequestsLast30Days = builder.numberOfRequestsLast30Days;
        this.lastRequestTime = builder.lastRequestTime;
    }

    /**
     * <p>
     * The user agent of the Kubernetes client using the deprecated resource.
     * </p>
     * 
     * @return The user agent of the Kubernetes client using the deprecated resource.
     */
    public final String userAgent() {
        return userAgent;
    }

    /**
     * <p>
     * The number of requests from the Kubernetes client seen over the last 30 days.
     * </p>
     * 
     * @return The number of requests from the Kubernetes client seen over the last 30 days.
     */
    public final Integer numberOfRequestsLast30Days() {
        return numberOfRequestsLast30Days;
    }

    /**
     * <p>
     * The timestamp of the last request seen from the Kubernetes client.
     * </p>
     * 
     * @return The timestamp of the last request seen from the Kubernetes client.
     */
    public final Instant lastRequestTime() {
        return lastRequestTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRequestsLast30Days());
        hashCode = 31 * hashCode + Objects.hashCode(lastRequestTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientStat)) {
            return false;
        }
        ClientStat other = (ClientStat) obj;
        return Objects.equals(userAgent(), other.userAgent())
                && Objects.equals(numberOfRequestsLast30Days(), other.numberOfRequestsLast30Days())
                && Objects.equals(lastRequestTime(), other.lastRequestTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientStat").add("UserAgent", userAgent())
                .add("NumberOfRequestsLast30Days", numberOfRequestsLast30Days()).add("LastRequestTime", lastRequestTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userAgent":
            return Optional.ofNullable(clazz.cast(userAgent()));
        case "numberOfRequestsLast30Days":
            return Optional.ofNullable(clazz.cast(numberOfRequestsLast30Days()));
        case "lastRequestTime":
            return Optional.ofNullable(clazz.cast(lastRequestTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClientStat, T> g) {
        return obj -> g.apply((ClientStat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientStat> {
        /**
         * <p>
         * The user agent of the Kubernetes client using the deprecated resource.
         * </p>
         * 
         * @param userAgent
         *        The user agent of the Kubernetes client using the deprecated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAgent(String userAgent);

        /**
         * <p>
         * The number of requests from the Kubernetes client seen over the last 30 days.
         * </p>
         * 
         * @param numberOfRequestsLast30Days
         *        The number of requests from the Kubernetes client seen over the last 30 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRequestsLast30Days(Integer numberOfRequestsLast30Days);

        /**
         * <p>
         * The timestamp of the last request seen from the Kubernetes client.
         * </p>
         * 
         * @param lastRequestTime
         *        The timestamp of the last request seen from the Kubernetes client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRequestTime(Instant lastRequestTime);
    }

    static final class BuilderImpl implements Builder {
        private String userAgent;

        private Integer numberOfRequestsLast30Days;

        private Instant lastRequestTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientStat model) {
            userAgent(model.userAgent);
            numberOfRequestsLast30Days(model.numberOfRequestsLast30Days);
            lastRequestTime(model.lastRequestTime);
        }

        public final String getUserAgent() {
            return userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final Integer getNumberOfRequestsLast30Days() {
            return numberOfRequestsLast30Days;
        }

        public final void setNumberOfRequestsLast30Days(Integer numberOfRequestsLast30Days) {
            this.numberOfRequestsLast30Days = numberOfRequestsLast30Days;
        }

        @Override
        public final Builder numberOfRequestsLast30Days(Integer numberOfRequestsLast30Days) {
            this.numberOfRequestsLast30Days = numberOfRequestsLast30Days;
            return this;
        }

        public final Instant getLastRequestTime() {
            return lastRequestTime;
        }

        public final void setLastRequestTime(Instant lastRequestTime) {
            this.lastRequestTime = lastRequestTime;
        }

        @Override
        public final Builder lastRequestTime(Instant lastRequestTime) {
            this.lastRequestTime = lastRequestTime;
            return this;
        }

        @Override
        public ClientStat build() {
            return new ClientStat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
