/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAddonResponse extends EksResponse implements
        ToCopyableBuilder<DeleteAddonResponse.Builder, DeleteAddonResponse> {
    private static final SdkField<Addon> ADDON_FIELD = SdkField.<Addon> builder(MarshallingType.SDK_POJO).memberName("addon")
            .getter(getter(DeleteAddonResponse::addon)).setter(setter(Builder::addon)).constructor(Addon::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("addon", ADDON_FIELD);
                }
            });

    private final Addon addon;

    private DeleteAddonResponse(BuilderImpl builder) {
        super(builder);
        this.addon = builder.addon;
    }

    /**
     * Returns the value of the Addon property for this object.
     * 
     * @return The value of the Addon property for this object.
     */
    public final Addon addon() {
        return addon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAddonResponse)) {
            return false;
        }
        DeleteAddonResponse other = (DeleteAddonResponse) obj;
        return Objects.equals(addon(), other.addon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAddonResponse").add("Addon", addon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addon":
            return Optional.ofNullable(clazz.cast(addon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAddonResponse, T> g) {
        return obj -> g.apply((DeleteAddonResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAddonResponse> {
        /**
         * Sets the value of the Addon property for this object.
         *
         * @param addon
         *        The new value for the Addon property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addon(Addon addon);

        /**
         * Sets the value of the Addon property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Addon.Builder} avoiding the need to
         * create one manually via {@link Addon#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Addon.Builder#build()} is called immediately and its result is
         * passed to {@link #addon(Addon)}.
         * 
         * @param addon
         *        a consumer that will call methods on {@link Addon.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addon(Addon)
         */
        default Builder addon(Consumer<Addon.Builder> addon) {
            return addon(Addon.builder().applyMutation(addon).build());
        }
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private Addon addon;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAddonResponse model) {
            super(model);
            addon(model.addon);
        }

        public final Addon.Builder getAddon() {
            return addon != null ? addon.toBuilder() : null;
        }

        public final void setAddon(Addon.BuilderImpl addon) {
            this.addon = addon != null ? addon.build() : null;
        }

        @Override
        public final Builder addon(Addon addon) {
            this.addon = addon;
            return this;
        }

        @Override
        public DeleteAddonResponse build() {
            return new DeleteAddonResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
