/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria to use for the insights.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightsFilter implements SdkPojo, Serializable, ToCopyableBuilder<InsightsFilter.Builder, InsightsFilter> {
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("categories")
            .getter(getter(InsightsFilter::categoriesAsStrings))
            .setter(setter(Builder::categoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> KUBERNETES_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("kubernetesVersions")
            .getter(getter(InsightsFilter::kubernetesVersions))
            .setter(setter(Builder::kubernetesVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statuses")
            .getter(getter(InsightsFilter::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORIES_FIELD,
            KUBERNETES_VERSIONS_FIELD, STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("categories", CATEGORIES_FIELD);
                    put("kubernetesVersions", KUBERNETES_VERSIONS_FIELD);
                    put("statuses", STATUSES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> categories;

    private final List<String> kubernetesVersions;

    private final List<String> statuses;

    private InsightsFilter(BuilderImpl builder) {
        this.categories = builder.categories;
        this.kubernetesVersions = builder.kubernetesVersions;
        this.statuses = builder.statuses;
    }

    /**
     * <p>
     * The categories to use to filter insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return The categories to use to filter insights.
     */
    public final List<Category> categories() {
        return CategoryListCopier.copyStringToEnum(categories);
    }

    /**
     * For responses, this returns true if the service returned a value for the Categories property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategories() {
        return categories != null && !(categories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categories to use to filter insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategories} method.
     * </p>
     * 
     * @return The categories to use to filter insights.
     */
    public final List<String> categoriesAsStrings() {
        return categories;
    }

    /**
     * For responses, this returns true if the service returned a value for the KubernetesVersions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKubernetesVersions() {
        return kubernetesVersions != null && !(kubernetesVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Kubernetes versions to use to filter the insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKubernetesVersions} method.
     * </p>
     * 
     * @return The Kubernetes versions to use to filter the insights.
     */
    public final List<String> kubernetesVersions() {
        return kubernetesVersions;
    }

    /**
     * <p>
     * The statuses to use to filter the insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return The statuses to use to filter the insights.
     */
    public final List<InsightStatusValue> statuses() {
        return InsightStatusValueListCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The statuses to use to filter the insights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return The statuses to use to filter the insights.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategories() ? categoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKubernetesVersions() ? kubernetesVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightsFilter)) {
            return false;
        }
        InsightsFilter other = (InsightsFilter) obj;
        return hasCategories() == other.hasCategories() && Objects.equals(categoriesAsStrings(), other.categoriesAsStrings())
                && hasKubernetesVersions() == other.hasKubernetesVersions()
                && Objects.equals(kubernetesVersions(), other.kubernetesVersions()) && hasStatuses() == other.hasStatuses()
                && Objects.equals(statusesAsStrings(), other.statusesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightsFilter").add("Categories", hasCategories() ? categoriesAsStrings() : null)
                .add("KubernetesVersions", hasKubernetesVersions() ? kubernetesVersions() : null)
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "categories":
            return Optional.ofNullable(clazz.cast(categoriesAsStrings()));
        case "kubernetesVersions":
            return Optional.ofNullable(clazz.cast(kubernetesVersions()));
        case "statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InsightsFilter, T> g) {
        return obj -> g.apply((InsightsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightsFilter> {
        /**
         * <p>
         * The categories to use to filter insights.
         * </p>
         * 
         * @param categories
         *        The categories to use to filter insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoriesWithStrings(Collection<String> categories);

        /**
         * <p>
         * The categories to use to filter insights.
         * </p>
         * 
         * @param categories
         *        The categories to use to filter insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoriesWithStrings(String... categories);

        /**
         * <p>
         * The categories to use to filter insights.
         * </p>
         * 
         * @param categories
         *        The categories to use to filter insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Collection<Category> categories);

        /**
         * <p>
         * The categories to use to filter insights.
         * </p>
         * 
         * @param categories
         *        The categories to use to filter insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(Category... categories);

        /**
         * <p>
         * The Kubernetes versions to use to filter the insights.
         * </p>
         * 
         * @param kubernetesVersions
         *        The Kubernetes versions to use to filter the insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesVersions(Collection<String> kubernetesVersions);

        /**
         * <p>
         * The Kubernetes versions to use to filter the insights.
         * </p>
         * 
         * @param kubernetesVersions
         *        The Kubernetes versions to use to filter the insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesVersions(String... kubernetesVersions);

        /**
         * <p>
         * The statuses to use to filter the insights.
         * </p>
         * 
         * @param statuses
         *        The statuses to use to filter the insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * The statuses to use to filter the insights.
         * </p>
         * 
         * @param statuses
         *        The statuses to use to filter the insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * The statuses to use to filter the insights.
         * </p>
         * 
         * @param statuses
         *        The statuses to use to filter the insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<InsightStatusValue> statuses);

        /**
         * <p>
         * The statuses to use to filter the insights.
         * </p>
         * 
         * @param statuses
         *        The statuses to use to filter the insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(InsightStatusValue... statuses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();

        private List<String> kubernetesVersions = DefaultSdkAutoConstructList.getInstance();

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightsFilter model) {
            categoriesWithStrings(model.categories);
            kubernetesVersions(model.kubernetesVersions);
            statusesWithStrings(model.statuses);
        }

        public final Collection<String> getCategories() {
            if (categories instanceof SdkAutoConstructList) {
                return null;
            }
            return categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
        }

        @Override
        public final Builder categoriesWithStrings(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoriesWithStrings(String... categories) {
            categoriesWithStrings(Arrays.asList(categories));
            return this;
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copyEnumToString(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category... categories) {
            categories(Arrays.asList(categories));
            return this;
        }

        public final Collection<String> getKubernetesVersions() {
            if (kubernetesVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return kubernetesVersions;
        }

        public final void setKubernetesVersions(Collection<String> kubernetesVersions) {
            this.kubernetesVersions = StringListCopier.copy(kubernetesVersions);
        }

        @Override
        public final Builder kubernetesVersions(Collection<String> kubernetesVersions) {
            this.kubernetesVersions = StringListCopier.copy(kubernetesVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kubernetesVersions(String... kubernetesVersions) {
            kubernetesVersions(Arrays.asList(kubernetesVersions));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = InsightStatusValueListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = InsightStatusValueListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<InsightStatusValue> statuses) {
            this.statuses = InsightStatusValueListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(InsightStatusValue... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        public InsightsFilter build() {
            return new InsightsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
