/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Kubernetes network configuration for the cluster. The response contains a value for <b>serviceIpv6Cidr</b> or
 * <b>serviceIpv4Cidr</b>, but not both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesNetworkConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesNetworkConfigResponse.Builder, KubernetesNetworkConfigResponse> {
    private static final SdkField<String> SERVICE_IPV4_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIpv4Cidr").getter(getter(KubernetesNetworkConfigResponse::serviceIpv4Cidr))
            .setter(setter(Builder::serviceIpv4Cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceIpv4Cidr").build()).build();

    private static final SdkField<String> SERVICE_IPV6_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIpv6Cidr").getter(getter(KubernetesNetworkConfigResponse::serviceIpv6Cidr))
            .setter(setter(Builder::serviceIpv6Cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceIpv6Cidr").build()).build();

    private static final SdkField<String> IP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipFamily").getter(getter(KubernetesNetworkConfigResponse::ipFamilyAsString))
            .setter(setter(Builder::ipFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipFamily").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_IPV4_CIDR_FIELD,
            SERVICE_IPV6_CIDR_FIELD, IP_FAMILY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("serviceIpv4Cidr", SERVICE_IPV4_CIDR_FIELD);
                    put("serviceIpv6Cidr", SERVICE_IPV6_CIDR_FIELD);
                    put("ipFamily", IP_FAMILY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String serviceIpv4Cidr;

    private final String serviceIpv6Cidr;

    private final String ipFamily;

    private KubernetesNetworkConfigResponse(BuilderImpl builder) {
        this.serviceIpv4Cidr = builder.serviceIpv4Cidr;
        this.serviceIpv6Cidr = builder.serviceIpv6Cidr;
        this.ipFamily = builder.ipFamily;
    }

    /**
     * <p>
     * The CIDR block that Kubernetes <code>Pod</code> and <code>Service</code> object IP addresses are assigned from.
     * Kubernetes assigns addresses from an <code>IPv4</code> CIDR block assigned to a subnet that the node is in. If
     * you didn't specify a CIDR block when you created the cluster, then Kubernetes assigns addresses from either the
     * <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. If this was specified, then it was
     * specified when the cluster was created and it can't be changed.
     * </p>
     * 
     * @return The CIDR block that Kubernetes <code>Pod</code> and <code>Service</code> object IP addresses are assigned
     *         from. Kubernetes assigns addresses from an <code>IPv4</code> CIDR block assigned to a subnet that the
     *         node is in. If you didn't specify a CIDR block when you created the cluster, then Kubernetes assigns
     *         addresses from either the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. If this
     *         was specified, then it was specified when the cluster was created and it can't be changed.
     */
    public final String serviceIpv4Cidr() {
        return serviceIpv4Cidr;
    }

    /**
     * <p>
     * The CIDR block that Kubernetes pod and service IP addresses are assigned from if you created a 1.21 or later
     * cluster with version 1.10.1 or later of the Amazon VPC CNI add-on and specified <code>ipv6</code> for
     * <b>ipFamily</b> when you created the cluster. Kubernetes assigns service addresses from the unique local address
     * range (<code>fc00::/7</code>) because you can't specify a custom IPv6 CIDR block when you create the cluster.
     * </p>
     * 
     * @return The CIDR block that Kubernetes pod and service IP addresses are assigned from if you created a 1.21 or
     *         later cluster with version 1.10.1 or later of the Amazon VPC CNI add-on and specified <code>ipv6</code>
     *         for <b>ipFamily</b> when you created the cluster. Kubernetes assigns service addresses from the unique
     *         local address range (<code>fc00::/7</code>) because you can't specify a custom IPv6 CIDR block when you
     *         create the cluster.
     */
    public final String serviceIpv6Cidr() {
        return serviceIpv6Cidr;
    }

    /**
     * <p>
     * The IP family used to assign Kubernetes <code>Pod</code> and <code>Service</code> objects IP addresses. The IP
     * family is always <code>ipv4</code>, unless you have a <code>1.21</code> or later cluster running version
     * <code>1.10.1</code> or later of the Amazon VPC CNI plugin for Kubernetes and specified <code>ipv6</code> when you
     * created the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipFamily} will
     * return {@link IpFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipFamilyAsString}.
     * </p>
     * 
     * @return The IP family used to assign Kubernetes <code>Pod</code> and <code>Service</code> objects IP addresses.
     *         The IP family is always <code>ipv4</code>, unless you have a <code>1.21</code> or later cluster running
     *         version <code>1.10.1</code> or later of the Amazon VPC CNI plugin for Kubernetes and specified
     *         <code>ipv6</code> when you created the cluster.
     * @see IpFamily
     */
    public final IpFamily ipFamily() {
        return IpFamily.fromValue(ipFamily);
    }

    /**
     * <p>
     * The IP family used to assign Kubernetes <code>Pod</code> and <code>Service</code> objects IP addresses. The IP
     * family is always <code>ipv4</code>, unless you have a <code>1.21</code> or later cluster running version
     * <code>1.10.1</code> or later of the Amazon VPC CNI plugin for Kubernetes and specified <code>ipv6</code> when you
     * created the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipFamily} will
     * return {@link IpFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipFamilyAsString}.
     * </p>
     * 
     * @return The IP family used to assign Kubernetes <code>Pod</code> and <code>Service</code> objects IP addresses.
     *         The IP family is always <code>ipv4</code>, unless you have a <code>1.21</code> or later cluster running
     *         version <code>1.10.1</code> or later of the Amazon VPC CNI plugin for Kubernetes and specified
     *         <code>ipv6</code> when you created the cluster.
     * @see IpFamily
     */
    public final String ipFamilyAsString() {
        return ipFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceIpv4Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(serviceIpv6Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(ipFamilyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesNetworkConfigResponse)) {
            return false;
        }
        KubernetesNetworkConfigResponse other = (KubernetesNetworkConfigResponse) obj;
        return Objects.equals(serviceIpv4Cidr(), other.serviceIpv4Cidr())
                && Objects.equals(serviceIpv6Cidr(), other.serviceIpv6Cidr())
                && Objects.equals(ipFamilyAsString(), other.ipFamilyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesNetworkConfigResponse").add("ServiceIpv4Cidr", serviceIpv4Cidr())
                .add("ServiceIpv6Cidr", serviceIpv6Cidr()).add("IpFamily", ipFamilyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceIpv4Cidr":
            return Optional.ofNullable(clazz.cast(serviceIpv4Cidr()));
        case "serviceIpv6Cidr":
            return Optional.ofNullable(clazz.cast(serviceIpv6Cidr()));
        case "ipFamily":
            return Optional.ofNullable(clazz.cast(ipFamilyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesNetworkConfigResponse, T> g) {
        return obj -> g.apply((KubernetesNetworkConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesNetworkConfigResponse> {
        /**
         * <p>
         * The CIDR block that Kubernetes <code>Pod</code> and <code>Service</code> object IP addresses are assigned
         * from. Kubernetes assigns addresses from an <code>IPv4</code> CIDR block assigned to a subnet that the node is
         * in. If you didn't specify a CIDR block when you created the cluster, then Kubernetes assigns addresses from
         * either the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. If this was specified, then
         * it was specified when the cluster was created and it can't be changed.
         * </p>
         * 
         * @param serviceIpv4Cidr
         *        The CIDR block that Kubernetes <code>Pod</code> and <code>Service</code> object IP addresses are
         *        assigned from. Kubernetes assigns addresses from an <code>IPv4</code> CIDR block assigned to a subnet
         *        that the node is in. If you didn't specify a CIDR block when you created the cluster, then Kubernetes
         *        assigns addresses from either the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR
         *        blocks. If this was specified, then it was specified when the cluster was created and it can't be
         *        changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIpv4Cidr(String serviceIpv4Cidr);

        /**
         * <p>
         * The CIDR block that Kubernetes pod and service IP addresses are assigned from if you created a 1.21 or later
         * cluster with version 1.10.1 or later of the Amazon VPC CNI add-on and specified <code>ipv6</code> for
         * <b>ipFamily</b> when you created the cluster. Kubernetes assigns service addresses from the unique local
         * address range (<code>fc00::/7</code>) because you can't specify a custom IPv6 CIDR block when you create the
         * cluster.
         * </p>
         * 
         * @param serviceIpv6Cidr
         *        The CIDR block that Kubernetes pod and service IP addresses are assigned from if you created a 1.21 or
         *        later cluster with version 1.10.1 or later of the Amazon VPC CNI add-on and specified
         *        <code>ipv6</code> for <b>ipFamily</b> when you created the cluster. Kubernetes assigns service
         *        addresses from the unique local address range (<code>fc00::/7</code>) because you can't specify a
         *        custom IPv6 CIDR block when you create the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIpv6Cidr(String serviceIpv6Cidr);

        /**
         * <p>
         * The IP family used to assign Kubernetes <code>Pod</code> and <code>Service</code> objects IP addresses. The
         * IP family is always <code>ipv4</code>, unless you have a <code>1.21</code> or later cluster running version
         * <code>1.10.1</code> or later of the Amazon VPC CNI plugin for Kubernetes and specified <code>ipv6</code> when
         * you created the cluster.
         * </p>
         * 
         * @param ipFamily
         *        The IP family used to assign Kubernetes <code>Pod</code> and <code>Service</code> objects IP
         *        addresses. The IP family is always <code>ipv4</code>, unless you have a <code>1.21</code> or later
         *        cluster running version <code>1.10.1</code> or later of the Amazon VPC CNI plugin for Kubernetes and
         *        specified <code>ipv6</code> when you created the cluster.
         * @see IpFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpFamily
         */
        Builder ipFamily(String ipFamily);

        /**
         * <p>
         * The IP family used to assign Kubernetes <code>Pod</code> and <code>Service</code> objects IP addresses. The
         * IP family is always <code>ipv4</code>, unless you have a <code>1.21</code> or later cluster running version
         * <code>1.10.1</code> or later of the Amazon VPC CNI plugin for Kubernetes and specified <code>ipv6</code> when
         * you created the cluster.
         * </p>
         * 
         * @param ipFamily
         *        The IP family used to assign Kubernetes <code>Pod</code> and <code>Service</code> objects IP
         *        addresses. The IP family is always <code>ipv4</code>, unless you have a <code>1.21</code> or later
         *        cluster running version <code>1.10.1</code> or later of the Amazon VPC CNI plugin for Kubernetes and
         *        specified <code>ipv6</code> when you created the cluster.
         * @see IpFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpFamily
         */
        Builder ipFamily(IpFamily ipFamily);
    }

    static final class BuilderImpl implements Builder {
        private String serviceIpv4Cidr;

        private String serviceIpv6Cidr;

        private String ipFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesNetworkConfigResponse model) {
            serviceIpv4Cidr(model.serviceIpv4Cidr);
            serviceIpv6Cidr(model.serviceIpv6Cidr);
            ipFamily(model.ipFamily);
        }

        public final String getServiceIpv4Cidr() {
            return serviceIpv4Cidr;
        }

        public final void setServiceIpv4Cidr(String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
        }

        @Override
        public final Builder serviceIpv4Cidr(String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
            return this;
        }

        public final String getServiceIpv6Cidr() {
            return serviceIpv6Cidr;
        }

        public final void setServiceIpv6Cidr(String serviceIpv6Cidr) {
            this.serviceIpv6Cidr = serviceIpv6Cidr;
        }

        @Override
        public final Builder serviceIpv6Cidr(String serviceIpv6Cidr) {
            this.serviceIpv6Cidr = serviceIpv6Cidr;
            return this;
        }

        public final String getIpFamily() {
            return ipFamily;
        }

        public final void setIpFamily(String ipFamily) {
            this.ipFamily = ipFamily;
        }

        @Override
        public final Builder ipFamily(String ipFamily) {
            this.ipFamily = ipFamily;
            return this;
        }

        @Override
        public final Builder ipFamily(IpFamily ipFamily) {
            this.ipFamily(ipFamily == null ? null : ipFamily.toString());
            return this;
        }

        @Override
        public KubernetesNetworkConfigResponse build() {
            return new KubernetesNetworkConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
