/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessEntriesResponse extends EksResponse implements
        ToCopyableBuilder<ListAccessEntriesResponse.Builder, ListAccessEntriesResponse> {
    private static final SdkField<List<String>> ACCESS_ENTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accessEntries")
            .getter(getter(ListAccessEntriesResponse::accessEntries))
            .setter(setter(Builder::accessEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAccessEntriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_ENTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accessEntries", ACCESS_ENTRIES_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<String> accessEntries;

    private final String nextToken;

    private ListAccessEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.accessEntries = builder.accessEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessEntries() {
        return accessEntries != null && !(accessEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of access entries that exist for the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessEntries} method.
     * </p>
     * 
     * @return The list of access entries that exist for the cluster.
     */
    public final List<String> accessEntries() {
        return accessEntries;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was
     * used and the results exceeded the value of that parameter. Pagination continues from the end of the previous
     * results that returned the <code>nextToken</code> value. This value is null when there are no more results to
     * return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated request, where
     *         <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is null when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessEntries() ? accessEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessEntriesResponse)) {
            return false;
        }
        ListAccessEntriesResponse other = (ListAccessEntriesResponse) obj;
        return hasAccessEntries() == other.hasAccessEntries() && Objects.equals(accessEntries(), other.accessEntries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessEntriesResponse").add("AccessEntries", hasAccessEntries() ? accessEntries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessEntries":
            return Optional.ofNullable(clazz.cast(accessEntries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessEntriesResponse, T> g) {
        return obj -> g.apply((ListAccessEntriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessEntriesResponse> {
        /**
         * <p>
         * The list of access entries that exist for the cluster.
         * </p>
         * 
         * @param accessEntries
         *        The list of access entries that exist for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEntries(Collection<String> accessEntries);

        /**
         * <p>
         * The list of access entries that exist for the cluster.
         * </p>
         * 
         * @param accessEntries
         *        The list of access entries that exist for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEntries(String... accessEntries);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code>
         * was used and the results exceeded the value of that parameter. Pagination continues from the end of the
         * previous results that returned the <code>nextToken</code> value. This value is null when there are no more
         * results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated request, where
         *        <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         *        continues from the end of the previous results that returned the <code>nextToken</code> value. This
         *        value is null when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<String> accessEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessEntriesResponse model) {
            super(model);
            accessEntries(model.accessEntries);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAccessEntries() {
            if (accessEntries instanceof SdkAutoConstructList) {
                return null;
            }
            return accessEntries;
        }

        public final void setAccessEntries(Collection<String> accessEntries) {
            this.accessEntries = StringListCopier.copy(accessEntries);
        }

        @Override
        public final Builder accessEntries(Collection<String> accessEntries) {
            this.accessEntries = StringListCopier.copy(accessEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEntries(String... accessEntries) {
            accessEntries(Arrays.asList(accessEntries));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAccessEntriesResponse build() {
            return new ListAccessEntriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
