/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summarized description of the association.
 * </p>
 * <p>
 * Each summary is simplified by removing these fields compared to the full <code> <a>PodIdentityAssociation</a> </code>
 * :
 * </p>
 * <ul>
 * <li>
 * <p>
 * The IAM role: <code>roleArn</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * The timestamp that the association was created at: <code>createdAt</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * The most recent timestamp that the association was modified at:. <code>modifiedAt</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * The tags on the association: <code>tags</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PodIdentityAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PodIdentityAssociationSummary.Builder, PodIdentityAssociationSummary> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(PodIdentityAssociationSummary::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(PodIdentityAssociationSummary::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccount").getter(getter(PodIdentityAssociationSummary::serviceAccount))
            .setter(setter(Builder::serviceAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccount").build()).build();

    private static final SdkField<String> ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationArn").getter(getter(PodIdentityAssociationSummary::associationArn))
            .setter(setter(Builder::associationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationArn").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationId").getter(getter(PodIdentityAssociationSummary::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()).build();

    private static final SdkField<String> OWNER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerArn").getter(getter(PodIdentityAssociationSummary::ownerArn)).setter(setter(Builder::ownerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NAMESPACE_FIELD, SERVICE_ACCOUNT_FIELD, ASSOCIATION_ARN_FIELD, ASSOCIATION_ID_FIELD, OWNER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clusterName", CLUSTER_NAME_FIELD);
                    put("namespace", NAMESPACE_FIELD);
                    put("serviceAccount", SERVICE_ACCOUNT_FIELD);
                    put("associationArn", ASSOCIATION_ARN_FIELD);
                    put("associationId", ASSOCIATION_ID_FIELD);
                    put("ownerArn", OWNER_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String clusterName;

    private final String namespace;

    private final String serviceAccount;

    private final String associationArn;

    private final String associationId;

    private final String ownerArn;

    private PodIdentityAssociationSummary(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.namespace = builder.namespace;
        this.serviceAccount = builder.serviceAccount;
        this.associationArn = builder.associationArn;
        this.associationId = builder.associationId;
        this.ownerArn = builder.ownerArn;
    }

    /**
     * <p>
     * The name of the cluster that the association is in.
     * </p>
     * 
     * @return The name of the cluster that the association is in.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the
     * pods that use the service account must be in this namespace.
     * </p>
     * 
     * @return The name of the Kubernetes namespace inside the cluster to create the association in. The service account
     *         and the pods that use the service account must be in this namespace.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     * </p>
     * 
     * @return The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     */
    public final String serviceAccount() {
        return serviceAccount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the association.
     */
    public final String associationArn() {
        return associationArn;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * If defined, the Pod Identity Association is owned by an Amazon EKS Addon.
     * </p>
     * 
     * @return If defined, the Pod Identity Association is owned by an Amazon EKS Addon.
     */
    public final String ownerArn() {
        return ownerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(associationArn());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PodIdentityAssociationSummary)) {
            return false;
        }
        PodIdentityAssociationSummary other = (PodIdentityAssociationSummary) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(serviceAccount(), other.serviceAccount())
                && Objects.equals(associationArn(), other.associationArn())
                && Objects.equals(associationId(), other.associationId()) && Objects.equals(ownerArn(), other.ownerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PodIdentityAssociationSummary").add("ClusterName", clusterName()).add("Namespace", namespace())
                .add("ServiceAccount", serviceAccount()).add("AssociationArn", associationArn())
                .add("AssociationId", associationId()).add("OwnerArn", ownerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "serviceAccount":
            return Optional.ofNullable(clazz.cast(serviceAccount()));
        case "associationArn":
            return Optional.ofNullable(clazz.cast(associationArn()));
        case "associationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "ownerArn":
            return Optional.ofNullable(clazz.cast(ownerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PodIdentityAssociationSummary, T> g) {
        return obj -> g.apply((PodIdentityAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PodIdentityAssociationSummary> {
        /**
         * <p>
         * The name of the cluster that the association is in.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster that the association is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the Kubernetes namespace inside the cluster to create the association in. The service account and
         * the pods that use the service account must be in this namespace.
         * </p>
         * 
         * @param namespace
         *        The name of the Kubernetes namespace inside the cluster to create the association in. The service
         *        account and the pods that use the service account must be in this namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         * </p>
         * 
         * @param serviceAccount
         *        The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccount(String serviceAccount);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the association.
         * </p>
         * 
         * @param associationArn
         *        The Amazon Resource Name (ARN) of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationArn(String associationArn);

        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param associationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * If defined, the Pod Identity Association is owned by an Amazon EKS Addon.
         * </p>
         * 
         * @param ownerArn
         *        If defined, the Pod Identity Association is owned by an Amazon EKS Addon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerArn(String ownerArn);
    }

    static final class BuilderImpl implements Builder {
        private String clusterName;

        private String namespace;

        private String serviceAccount;

        private String associationArn;

        private String associationId;

        private String ownerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PodIdentityAssociationSummary model) {
            clusterName(model.clusterName);
            namespace(model.namespace);
            serviceAccount(model.serviceAccount);
            associationArn(model.associationArn);
            associationId(model.associationId);
            ownerArn(model.ownerArn);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getServiceAccount() {
            return serviceAccount;
        }

        public final void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }

        @Override
        public final Builder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public final String getAssociationArn() {
            return associationArn;
        }

        public final void setAssociationArn(String associationArn) {
            this.associationArn = associationArn;
        }

        @Override
        public final Builder associationArn(String associationArn) {
            this.associationArn = associationArn;
            return this;
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getOwnerArn() {
            return ownerArn;
        }

        public final void setOwnerArn(String ownerArn) {
            this.ownerArn = ownerArn;
        }

        @Override
        public final Builder ownerArn(String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        @Override
        public PodIdentityAssociationSummary build() {
            return new PodIdentityAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
