/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the VPC configuration to use for an Amazon EKS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfigRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfigRequest.Builder, VpcConfigRequest> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(VpcConfigRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(VpcConfigRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENDPOINT_PUBLIC_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("endpointPublicAccess").getter(getter(VpcConfigRequest::endpointPublicAccess))
            .setter(setter(Builder::endpointPublicAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointPublicAccess").build())
            .build();

    private static final SdkField<Boolean> ENDPOINT_PRIVATE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("endpointPrivateAccess").getter(getter(VpcConfigRequest::endpointPrivateAccess))
            .setter(setter(Builder::endpointPrivateAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointPrivateAccess").build())
            .build();

    private static final SdkField<List<String>> PUBLIC_ACCESS_CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("publicAccessCidrs")
            .getter(getter(VpcConfigRequest::publicAccessCidrs))
            .setter(setter(Builder::publicAccessCidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccessCidrs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD,
            SECURITY_GROUP_IDS_FIELD, ENDPOINT_PUBLIC_ACCESS_FIELD, ENDPOINT_PRIVATE_ACCESS_FIELD, PUBLIC_ACCESS_CIDRS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("subnetIds", SUBNET_IDS_FIELD);
                    put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
                    put("endpointPublicAccess", ENDPOINT_PUBLIC_ACCESS_FIELD);
                    put("endpointPrivateAccess", ENDPOINT_PRIVATE_ACCESS_FIELD);
                    put("publicAccessCidrs", PUBLIC_ACCESS_CIDRS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final Boolean endpointPublicAccess;

    private final Boolean endpointPrivateAccess;

    private final List<String> publicAccessCidrs;

    private VpcConfigRequest(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.endpointPublicAccess = builder.endpointPublicAccess;
        this.endpointPrivateAccess = builder.endpointPrivateAccess;
        this.publicAccessCidrs = builder.publicAccessCidrs;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in these
     * subnets to allow communication between your nodes and the Kubernetes control plane.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in
     *         these subnets to allow communication between your nodes and the Kubernetes control plane.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to
     * use that allow communication between your nodes and the Kubernetes control plane. If you don't specify any
     * security groups, then familiarize yourself with the difference between Amazon EKS defaults for clusters deployed
     * with Kubernetes. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group
     * considerations</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS
     *         creates to use that allow communication between your nodes and the Kubernetes control plane. If you don't
     *         specify any security groups, then familiarize yourself with the difference between Amazon EKS defaults
     *         for clusters deployed with Kubernetes. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group
     *         considerations</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Set this value to <code>false</code> to disable public access to your cluster's Kubernetes API server endpoint.
     * If you disable public access, your cluster's Kubernetes API server can only receive requests from within the
     * cluster VPC. The default value for this parameter is <code>true</code>, which enables public access for your
     * Kubernetes API server. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access
     * control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * 
     * @return Set this value to <code>false</code> to disable public access to your cluster's Kubernetes API server
     *         endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests
     *         from within the cluster VPC. The default value for this parameter is <code>true</code>, which enables
     *         public access for your Kubernetes API server. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint
     *         access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     */
    public final Boolean endpointPublicAccess() {
        return endpointPublicAccess;
    }

    /**
     * <p>
     * Set this value to <code>true</code> to enable private access for your cluster's Kubernetes API server endpoint.
     * If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC
     * endpoint. The default value for this parameter is <code>false</code>, which disables private access for your
     * Kubernetes API server. If you disable private access and you have nodes or Fargate pods in the cluster, then
     * ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for communication with the nodes or
     * Fargate pods. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access
     * control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * 
     * @return Set this value to <code>true</code> to enable private access for your cluster's Kubernetes API server
     *         endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the
     *         private VPC endpoint. The default value for this parameter is <code>false</code>, which disables private
     *         access for your Kubernetes API server. If you disable private access and you have nodes or Fargate pods
     *         in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for
     *         communication with the nodes or Fargate pods. For more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint
     *         access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     */
    public final Boolean endpointPrivateAccess() {
        return endpointPrivateAccess;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublicAccessCidrs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPublicAccessCidrs() {
        return publicAccessCidrs != null && !(publicAccessCidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to
     * the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is
     * <code>0.0.0.0/0</code>. If you've disabled private endpoint access, make sure that you specify the necessary CIDR
     * blocks for every node and Fargate <code>Pod</code> in the cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access
     * control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublicAccessCidrs} method.
     * </p>
     * 
     * @return The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
     *         Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The
     *         default value is <code>0.0.0.0/0</code>. If you've disabled private endpoint access, make sure that you
     *         specify the necessary CIDR blocks for every node and Fargate <code>Pod</code> in the cluster. For more
     *         information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon
     *         EKS cluster endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
     */
    public final List<String> publicAccessCidrs() {
        return publicAccessCidrs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endpointPublicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(endpointPrivateAccess());
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicAccessCidrs() ? publicAccessCidrs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigRequest)) {
            return false;
        }
        VpcConfigRequest other = (VpcConfigRequest) obj;
        return hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(endpointPublicAccess(), other.endpointPublicAccess())
                && Objects.equals(endpointPrivateAccess(), other.endpointPrivateAccess())
                && hasPublicAccessCidrs() == other.hasPublicAccessCidrs()
                && Objects.equals(publicAccessCidrs(), other.publicAccessCidrs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConfigRequest").add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("EndpointPublicAccess", endpointPublicAccess()).add("EndpointPrivateAccess", endpointPrivateAccess())
                .add("PublicAccessCidrs", hasPublicAccessCidrs() ? publicAccessCidrs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "endpointPublicAccess":
            return Optional.ofNullable(clazz.cast(endpointPublicAccess()));
        case "endpointPrivateAccess":
            return Optional.ofNullable(clazz.cast(endpointPrivateAccess()));
        case "publicAccessCidrs":
            return Optional.ofNullable(clazz.cast(publicAccessCidrs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfigRequest, T> g) {
        return obj -> g.apply((VpcConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfigRequest> {
        /**
         * <p>
         * Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in
         * these subnets to allow communication between your nodes and the Kubernetes control plane.
         * </p>
         * 
         * @param subnetIds
         *        Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces
         *        in these subnets to allow communication between your nodes and the Kubernetes control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in
         * these subnets to allow communication between your nodes and the Kubernetes control plane.
         * </p>
         * 
         * @param subnetIds
         *        Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces
         *        in these subnets to allow communication between your nodes and the Kubernetes control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates
         * to use that allow communication between your nodes and the Kubernetes control plane. If you don't specify any
         * security groups, then familiarize yourself with the difference between Amazon EKS defaults for clusters
         * deployed with Kubernetes. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group
         * considerations</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param securityGroupIds
         *        Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS
         *        creates to use that allow communication between your nodes and the Kubernetes control plane. If you
         *        don't specify any security groups, then familiarize yourself with the difference between Amazon EKS
         *        defaults for clusters deployed with Kubernetes. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group
         *        considerations</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates
         * to use that allow communication between your nodes and the Kubernetes control plane. If you don't specify any
         * security groups, then familiarize yourself with the difference between Amazon EKS defaults for clusters
         * deployed with Kubernetes. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group
         * considerations</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param securityGroupIds
         *        Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS
         *        creates to use that allow communication between your nodes and the Kubernetes control plane. If you
         *        don't specify any security groups, then familiarize yourself with the difference between Amazon EKS
         *        defaults for clusters deployed with Kubernetes. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group
         *        considerations</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Set this value to <code>false</code> to disable public access to your cluster's Kubernetes API server
         * endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests from
         * within the cluster VPC. The default value for this parameter is <code>true</code>, which enables public
         * access for your Kubernetes API server. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint
         * access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param endpointPublicAccess
         *        Set this value to <code>false</code> to disable public access to your cluster's Kubernetes API server
         *        endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests
         *        from within the cluster VPC. The default value for this parameter is <code>true</code>, which enables
         *        public access for your Kubernetes API server. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
         *        endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPublicAccess(Boolean endpointPublicAccess);

        /**
         * <p>
         * Set this value to <code>true</code> to enable private access for your cluster's Kubernetes API server
         * endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the
         * private VPC endpoint. The default value for this parameter is <code>false</code>, which disables private
         * access for your Kubernetes API server. If you disable private access and you have nodes or Fargate pods in
         * the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for
         * communication with the nodes or Fargate pods. For more information, see <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint
         * access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param endpointPrivateAccess
         *        Set this value to <code>true</code> to enable private access for your cluster's Kubernetes API server
         *        endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the
         *        private VPC endpoint. The default value for this parameter is <code>false</code>, which disables
         *        private access for your Kubernetes API server. If you disable private access and you have nodes or
         *        Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary
         *        CIDR blocks for communication with the nodes or Fargate pods. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
         *        endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPrivateAccess(Boolean endpointPrivateAccess);

        /**
         * <p>
         * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
         * Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The
         * default value is <code>0.0.0.0/0</code>. If you've disabled private endpoint access, make sure that you
         * specify the necessary CIDR blocks for every node and Fargate <code>Pod</code> in the cluster. For more
         * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS
         * cluster endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param publicAccessCidrs
         *        The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
         *        Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied.
         *        The default value is <code>0.0.0.0/0</code>. If you've disabled private endpoint access, make sure
         *        that you specify the necessary CIDR blocks for every node and Fargate <code>Pod</code> in the cluster.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
         *        endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessCidrs(Collection<String> publicAccessCidrs);

        /**
         * <p>
         * The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
         * Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The
         * default value is <code>0.0.0.0/0</code>. If you've disabled private endpoint access, make sure that you
         * specify the necessary CIDR blocks for every node and Fargate <code>Pod</code> in the cluster. For more
         * information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS
         * cluster endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * </p>
         * 
         * @param publicAccessCidrs
         *        The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint.
         *        Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied.
         *        The default value is <code>0.0.0.0/0</code>. If you've disabled private endpoint access, make sure
         *        that you specify the necessary CIDR blocks for every node and Fargate <code>Pod</code> in the cluster.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
         *        endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessCidrs(String... publicAccessCidrs);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean endpointPublicAccess;

        private Boolean endpointPrivateAccess;

        private List<String> publicAccessCidrs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigRequest model) {
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            endpointPublicAccess(model.endpointPublicAccess);
            endpointPrivateAccess(model.endpointPrivateAccess);
            publicAccessCidrs(model.publicAccessCidrs);
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Boolean getEndpointPublicAccess() {
            return endpointPublicAccess;
        }

        public final void setEndpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
        }

        @Override
        public final Builder endpointPublicAccess(Boolean endpointPublicAccess) {
            this.endpointPublicAccess = endpointPublicAccess;
            return this;
        }

        public final Boolean getEndpointPrivateAccess() {
            return endpointPrivateAccess;
        }

        public final void setEndpointPrivateAccess(Boolean endpointPrivateAccess) {
            this.endpointPrivateAccess = endpointPrivateAccess;
        }

        @Override
        public final Builder endpointPrivateAccess(Boolean endpointPrivateAccess) {
            this.endpointPrivateAccess = endpointPrivateAccess;
            return this;
        }

        public final Collection<String> getPublicAccessCidrs() {
            if (publicAccessCidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return publicAccessCidrs;
        }

        public final void setPublicAccessCidrs(Collection<String> publicAccessCidrs) {
            this.publicAccessCidrs = StringListCopier.copy(publicAccessCidrs);
        }

        @Override
        public final Builder publicAccessCidrs(Collection<String> publicAccessCidrs) {
            this.publicAccessCidrs = StringListCopier.copy(publicAccessCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicAccessCidrs(String... publicAccessCidrs) {
            publicAccessCidrs(Arrays.asList(publicAccessCidrs));
            return this;
        }

        @Override
        public VpcConfigRequest build() {
            return new VpcConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
