/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEksAnywhereSubscriptionRequest extends EksRequest implements
        ToCopyableBuilder<CreateEksAnywhereSubscriptionRequest.Builder, CreateEksAnywhereSubscriptionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEksAnywhereSubscriptionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<EksAnywhereSubscriptionTerm> TERM_FIELD = SdkField
            .<EksAnywhereSubscriptionTerm> builder(MarshallingType.SDK_POJO).memberName("term")
            .getter(getter(CreateEksAnywhereSubscriptionRequest::term)).setter(setter(Builder::term))
            .constructor(EksAnywhereSubscriptionTerm::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("term").build()).build();

    private static final SdkField<Integer> LICENSE_QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("licenseQuantity").getter(getter(CreateEksAnywhereSubscriptionRequest::licenseQuantity))
            .setter(setter(Builder::licenseQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseQuantity").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseType").getter(getter(CreateEksAnywhereSubscriptionRequest::licenseTypeAsString))
            .setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()).build();

    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoRenew").getter(getter(CreateEksAnywhereSubscriptionRequest::autoRenew))
            .setter(setter(Builder::autoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRenew").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateEksAnywhereSubscriptionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateEksAnywhereSubscriptionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TERM_FIELD,
            LICENSE_QUANTITY_FIELD, LICENSE_TYPE_FIELD, AUTO_RENEW_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final EksAnywhereSubscriptionTerm term;

    private final Integer licenseQuantity;

    private final String licenseType;

    private final Boolean autoRenew;

    private final String clientRequestToken;

    private final Map<String, String> tags;

    private CreateEksAnywhereSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.term = builder.term;
        this.licenseQuantity = builder.licenseQuantity;
        this.licenseType = builder.licenseType;
        this.autoRenew = builder.autoRenew;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name for your subscription. It must be unique in your Amazon Web Services account in the Amazon Web
     * Services Region you're creating the subscription in. The name can contain only alphanumeric characters
     * (case-sensitive), hyphens, and underscores. It must start with an alphabetic character and can't be longer than
     * 100 characters.
     * </p>
     * 
     * @return The unique name for your subscription. It must be unique in your Amazon Web Services account in the
     *         Amazon Web Services Region you're creating the subscription in. The name can contain only alphanumeric
     *         characters (case-sensitive), hyphens, and underscores. It must start with an alphabetic character and
     *         can't be longer than 100 characters.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An object representing the term duration and term unit type of your subscription. This determines the term length
     * of your subscription. Valid values are MONTHS for term unit and 12 or 36 for term duration, indicating a 12 month
     * or 36 month subscription. This value cannot be changed after creating the subscription.
     * </p>
     * 
     * @return An object representing the term duration and term unit type of your subscription. This determines the
     *         term length of your subscription. Valid values are MONTHS for term unit and 12 or 36 for term duration,
     *         indicating a 12 month or 36 month subscription. This value cannot be changed after creating the
     *         subscription.
     */
    public final EksAnywhereSubscriptionTerm term() {
        return term;
    }

    /**
     * <p>
     * The number of licenses to purchase with the subscription. Valid values are between 1 and 100. This value can't be
     * changed after creating the subscription.
     * </p>
     * 
     * @return The number of licenses to purchase with the subscription. Valid values are between 1 and 100. This value
     *         can't be changed after creating the subscription.
     */
    public final Integer licenseQuantity() {
        return licenseQuantity;
    }

    /**
     * <p>
     * The license type for all licenses in the subscription. Valid value is CLUSTER. With the CLUSTER license type,
     * each license covers support for a single EKS Anywhere cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link EksAnywhereSubscriptionLicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license type for all licenses in the subscription. Valid value is CLUSTER. With the CLUSTER license
     *         type, each license covers support for a single EKS Anywhere cluster.
     * @see EksAnywhereSubscriptionLicenseType
     */
    public final EksAnywhereSubscriptionLicenseType licenseType() {
        return EksAnywhereSubscriptionLicenseType.fromValue(licenseType);
    }

    /**
     * <p>
     * The license type for all licenses in the subscription. Valid value is CLUSTER. With the CLUSTER license type,
     * each license covers support for a single EKS Anywhere cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link EksAnywhereSubscriptionLicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license type for all licenses in the subscription. Valid value is CLUSTER. With the CLUSTER license
     *         type, each license covers support for a single EKS Anywhere cluster.
     * @see EksAnywhereSubscriptionLicenseType
     */
    public final String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * A boolean indicating whether the subscription auto renews at the end of the term.
     * </p>
     * 
     * @return A boolean indicating whether the subscription auto renews at the end of the term.
     */
    public final Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata for a subscription to assist with categorization and organization. Each tag consists of a key and an
     * optional value. Subscription tags don't propagate to any other resources associated with the subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata for a subscription to assist with categorization and organization. Each tag consists of a
     *         key and an optional value. Subscription tags don't propagate to any other resources associated with the
     *         subscription.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(term());
        hashCode = 31 * hashCode + Objects.hashCode(licenseQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEksAnywhereSubscriptionRequest)) {
            return false;
        }
        CreateEksAnywhereSubscriptionRequest other = (CreateEksAnywhereSubscriptionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(term(), other.term())
                && Objects.equals(licenseQuantity(), other.licenseQuantity())
                && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString())
                && Objects.equals(autoRenew(), other.autoRenew())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEksAnywhereSubscriptionRequest").add("Name", name()).add("Term", term())
                .add("LicenseQuantity", licenseQuantity()).add("LicenseType", licenseTypeAsString())
                .add("AutoRenew", autoRenew()).add("ClientRequestToken", clientRequestToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "term":
            return Optional.ofNullable(clazz.cast(term()));
        case "licenseQuantity":
            return Optional.ofNullable(clazz.cast(licenseQuantity()));
        case "licenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "autoRenew":
            return Optional.ofNullable(clazz.cast(autoRenew()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("term", TERM_FIELD);
        map.put("licenseQuantity", LICENSE_QUANTITY_FIELD);
        map.put("licenseType", LICENSE_TYPE_FIELD);
        map.put("autoRenew", AUTO_RENEW_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEksAnywhereSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateEksAnywhereSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEksAnywhereSubscriptionRequest> {
        /**
         * <p>
         * The unique name for your subscription. It must be unique in your Amazon Web Services account in the Amazon
         * Web Services Region you're creating the subscription in. The name can contain only alphanumeric characters
         * (case-sensitive), hyphens, and underscores. It must start with an alphabetic character and can't be longer
         * than 100 characters.
         * </p>
         * 
         * @param name
         *        The unique name for your subscription. It must be unique in your Amazon Web Services account in the
         *        Amazon Web Services Region you're creating the subscription in. The name can contain only alphanumeric
         *        characters (case-sensitive), hyphens, and underscores. It must start with an alphabetic character and
         *        can't be longer than 100 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An object representing the term duration and term unit type of your subscription. This determines the term
         * length of your subscription. Valid values are MONTHS for term unit and 12 or 36 for term duration, indicating
         * a 12 month or 36 month subscription. This value cannot be changed after creating the subscription.
         * </p>
         * 
         * @param term
         *        An object representing the term duration and term unit type of your subscription. This determines the
         *        term length of your subscription. Valid values are MONTHS for term unit and 12 or 36 for term
         *        duration, indicating a 12 month or 36 month subscription. This value cannot be changed after creating
         *        the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(EksAnywhereSubscriptionTerm term);

        /**
         * <p>
         * An object representing the term duration and term unit type of your subscription. This determines the term
         * length of your subscription. Valid values are MONTHS for term unit and 12 or 36 for term duration, indicating
         * a 12 month or 36 month subscription. This value cannot be changed after creating the subscription.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksAnywhereSubscriptionTerm.Builder}
         * avoiding the need to create one manually via {@link EksAnywhereSubscriptionTerm#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksAnywhereSubscriptionTerm.Builder#build()} is called
         * immediately and its result is passed to {@link #term(EksAnywhereSubscriptionTerm)}.
         * 
         * @param term
         *        a consumer that will call methods on {@link EksAnywhereSubscriptionTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #term(EksAnywhereSubscriptionTerm)
         */
        default Builder term(Consumer<EksAnywhereSubscriptionTerm.Builder> term) {
            return term(EksAnywhereSubscriptionTerm.builder().applyMutation(term).build());
        }

        /**
         * <p>
         * The number of licenses to purchase with the subscription. Valid values are between 1 and 100. This value
         * can't be changed after creating the subscription.
         * </p>
         * 
         * @param licenseQuantity
         *        The number of licenses to purchase with the subscription. Valid values are between 1 and 100. This
         *        value can't be changed after creating the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseQuantity(Integer licenseQuantity);

        /**
         * <p>
         * The license type for all licenses in the subscription. Valid value is CLUSTER. With the CLUSTER license type,
         * each license covers support for a single EKS Anywhere cluster.
         * </p>
         * 
         * @param licenseType
         *        The license type for all licenses in the subscription. Valid value is CLUSTER. With the CLUSTER
         *        license type, each license covers support for a single EKS Anywhere cluster.
         * @see EksAnywhereSubscriptionLicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EksAnywhereSubscriptionLicenseType
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The license type for all licenses in the subscription. Valid value is CLUSTER. With the CLUSTER license type,
         * each license covers support for a single EKS Anywhere cluster.
         * </p>
         * 
         * @param licenseType
         *        The license type for all licenses in the subscription. Valid value is CLUSTER. With the CLUSTER
         *        license type, each license covers support for a single EKS Anywhere cluster.
         * @see EksAnywhereSubscriptionLicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EksAnywhereSubscriptionLicenseType
         */
        Builder licenseType(EksAnywhereSubscriptionLicenseType licenseType);

        /**
         * <p>
         * A boolean indicating whether the subscription auto renews at the end of the term.
         * </p>
         * 
         * @param autoRenew
         *        A boolean indicating whether the subscription auto renews at the end of the term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The metadata for a subscription to assist with categorization and organization. Each tag consists of a key
         * and an optional value. Subscription tags don't propagate to any other resources associated with the
         * subscription.
         * </p>
         * 
         * @param tags
         *        The metadata for a subscription to assist with categorization and organization. Each tag consists of a
         *        key and an optional value. Subscription tags don't propagate to any other resources associated with
         *        the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String name;

        private EksAnywhereSubscriptionTerm term;

        private Integer licenseQuantity;

        private String licenseType;

        private Boolean autoRenew;

        private String clientRequestToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEksAnywhereSubscriptionRequest model) {
            super(model);
            name(model.name);
            term(model.term);
            licenseQuantity(model.licenseQuantity);
            licenseType(model.licenseType);
            autoRenew(model.autoRenew);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EksAnywhereSubscriptionTerm.Builder getTerm() {
            return term != null ? term.toBuilder() : null;
        }

        public final void setTerm(EksAnywhereSubscriptionTerm.BuilderImpl term) {
            this.term = term != null ? term.build() : null;
        }

        @Override
        public final Builder term(EksAnywhereSubscriptionTerm term) {
            this.term = term;
            return this;
        }

        public final Integer getLicenseQuantity() {
            return licenseQuantity;
        }

        public final void setLicenseQuantity(Integer licenseQuantity) {
            this.licenseQuantity = licenseQuantity;
        }

        @Override
        public final Builder licenseQuantity(Integer licenseQuantity) {
            this.licenseQuantity = licenseQuantity;
            return this;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(EksAnywhereSubscriptionLicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEksAnywhereSubscriptionRequest build() {
            return new CreateEksAnywhereSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
